/*****************************************************************************
 *                                                                          
 * This software module was developed by 
 *
 *  Anthony Vetro  (MITSUBISHI ELECTRIC ITA)
 *  Huifang Sun    (MITSUBISHI ELECTRIC ITA)
 *  Hung-Ju Lee    (Sarnoff Corporation)
 *  Tihao Chiang   (Sarnoff Corporation)
 *                                                      
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4 
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free 
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original 
 * developer of this software module and his/her company, the subsequent 
 * editors and their companies, and ISO/IEC have no liability for use of this 
 * software module or modifications thereof in an implementation. Copyright is 
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming 
 * products. 
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own 
 * purpose, assign or donate the code to a third party and to inhibit third 
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works. 
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/

 /***************************************************************
  COPYRIGHT (1996)  DAVID SARNOFF RESEARCH CENTER, INC.
  ALL RIGHTS RESERVED
  SARNOFF PROPRIETARY INFORMATION
  PERMISSION IS GRANTED FOR USE WITHIN MPEG4 STANDARDIZATION PROCESS
 ****************************************************************/

#define Max(a,b)        ((a) < (b) ? (b) : (a))
#define Min(a,b)        ((a) > (b)?  (b) : (a))

#define RCQ2_MVO_DISABLED   0  /* hjlee */
#define RCQ2_MVO_ENABLED    1 
#define RCQ2_MVO_HVS        3  


/* distribution parameters for low and high bit-rate modes */
#define BETA_M_LOW		0.60
#define BETA_S_LOW		0.40
#define BETA_V_LOW		0.00
#define BETA_M_HIGH		0.25
#define BETA_S_HIGH		0.25
#define BETA_V_HIGH		0.50

/* shape rate control parameters */
#define ALPHA_MAX		16 /* very conservative value */
#define ALPHA_MIN		0
#define ALPHA_INC		4
#define ALPHA_DEC		4
int current_alpha_level;

typedef struct {
    long 	bit_rate;	/* in bits/second */
    int		numFrame;       /* # of frames remaining of each type in this GOP */
    int 	*numVOleft;	/* # of VOs remaining per VO */
    long 	*S;		/* number of bits generated by this picture */
    long 	*T;		/* target number of bits for the next corresponding VO */
    double 	*X;		/* global complexity measure for each VO */
    double 	*Q;		/* average q-parameter for each VO */
    long 	R;		/* remaining number of bits assigned to the GOP. */
    double 	Bpp;		/* bit_rate / (picture_rate * numVOs) */	
    long 	VBV_size;
    double 	VBV_fullness;	/* buffer occupancy */
    double 	*X1;		/* second order complexity measure */
    double 	*X2;		/* second order complexity measure */
    int 	*skip;
    int 	*totalskipped;
    int		*preskip;
    int		*codedVO;
    int         *dataNumber;
    int         *headerBitCount;
    int 	numVOs;
    int         first_vo;	/* bug fix: avetro 110399 */
    int 	alphath;
} RC_MVO;

int quant[256];

/* some parameters influencing bit distribution per VO */
double *SIZE;
double *VARIANCE;
double *MOTION;

int LB_FLAG;
int LOW_MODE;
