/******************************************************************************
 *                                                                          
 * This software module was originally developed by 
 *
 *   Fujitsu Laboratories Ltd. (contact: Eishi Morimatsu)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4 
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free 
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. THE ORIGINAL 
 * DEVELOPER OF THIS SOFTWARE MODULE AND HIS/HER COMPANY, THE SUBSEQUENT 
 * EDITORS AND THEIR COMPANIES, AND ISO/IEC HAVE NO LIABILITY FOR USE OF THIS 
 * SOFTWARE MODULE OR MODIFICATIONS THEREOF. No license to this software
 * module is granted for non MPEG-4 Video (ISO/IEC 14496-2) standard 
 * conforming products.
 *
 * Fujitsu Laboratories Ltd. retains full right to use the software module for 
 * his/her own purpose, assign or donate the software module to a third party 
 * and to inhibit third parties from using the code for non MPEG-4 Video 
 * (ISO/IEC 14496-2) standard conforming products. This copyright notice must 
 * be included in all copies or derivative works of the software module. 
 *
 * Copyright (c) 1999.  
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *
 * File:        drc_util_dec.c
 *
 * Author:      Fujitsu Laboratories - Eishi Morimatsu
 * Created:     06-SEP-1999
 *
 * Description: modules for DRC
 *
 * Notes:
 *
 * Modified:    
 *
 ***********************************************************HeaderEnd*********/


/************************    INCLUDE FILES    ********************************/

#include <stdlib.h>
#include <stdio.h>

#include "io_generic.h"
#include "text_decode.h"
#include "text_decode_mb.h"
#include "mot_decode.h"
#include "mot_comp.h"
#include "momusys.h"
#include "vm_common_defs.h"

/***********************************************************CommentBegin******
 *
 * -- MotionVectorScalingUp --
 *
 * Author :
 *      Fujitsu Laboratories - Eishi Morimatsu
 *
 * Created :
 *      06-SEP-1999
 *
 * Purpose :
 *	DRC - scaling up of motion vector data
 *
 * Arguments in :
 *	Image *mot_x - scaled up horizontal motion vector data
 *	Image *mot_y - scaled up vertical motion vector data
 *	Image *mot_x_lowres - horizontal motion vector data to be scaled up
 *	Image *mot_y_lowres - vertical motion vector data to be scaled up
 *
 * Arguments in/out :
 *
 * Arguments out :
 *
 * Return values :
 *
 * Side effects :
 *
 * Description :
 *
 * See also :
 *
 * Modified :
 *
 ***********************************************************CommentEnd********/
Void 
MotionVectorScalingUp(Image *mot_x, Image *mot_y, 
	Image *mot_x_lowres, Image *mot_y_lowres)
{
  Int sizex = GetImageSizeX(mot_x);
  Int sizey = GetImageSizeY(mot_y);
  float *Vec, *LowVec;
  Int i,j, cnt;
  float vec, lowvec;

  Vec = (float *)GetImageData(mot_x);
  LowVec = (float *)GetImageData(mot_x_lowres);

  for(i = 0, cnt = 0; i < sizey; i++){
    for(j = 0; j < sizex; j++, cnt++){
      lowvec = LowVec[cnt];
      if(lowvec == 0.0){
        vec = 0.0;
      }
      else if(lowvec > 0.0){
        vec = 2.0 * lowvec - 0.5;
      }  
      else{
	vec = 2.0 * lowvec + 0.5;
      }  
      Vec[cnt] = vec;
    }
  }
  
    
  Vec = (float *)GetImageData(mot_y);
  LowVec = (float *)GetImageData(mot_y_lowres);

  for(i = 0, cnt = 0; i < sizey; i++){
    for(j = 0; j < sizex; j++, cnt++){
      lowvec = LowVec[cnt];
      if(lowvec == 0.0){
        vec = 0.0;
      }
      else if(lowvec > 0.0){
        vec = 2.0 * lowvec - 0.5;
      }  
      else{
	vec = 2.0 * lowvec + 0.5;
      }  
      Vec[cnt] = vec;
    }
  }
  
}  

/***********************************************************CommentBegin******
 *
 * -- FilteredRRVopTrace --
 *
 * Author :
 *      Fujitsu Laboratories - Eishi Morimatsu
 *
 * Created :
 *      06-SEP-1999
 *
 * Purpose :
 *	DRC - output trace data for block boundary filtered reduced resolution vop
 *
 * Arguments in :
 *      Vop *curr_vop - current reconstructed vop
 *      Trace *trace - trace data
 *
 * Arguments in/out :
 *
 * Arguments out :
 *
 * Return values :
 *
 * Side effects :
 *
 * Description :
 *
 * See also :
 *
 * Modified :
 *
 ***********************************************************CommentEnd********/
Void 
FilteredRRVopTrace(Vop *curr_vop,Trace *trace)
{
  SInt mb_rec[6][256],mb_shape[6][256];
  Char level_3_trace=0;
  SInt *y_data,*u_data,*v_data;
  Int npix=GetVopWidth(curr_vop);
  Int nlin=GetVopHeight(curr_vop);
  Int sum,MB_nb=-1;
  Int i,j,k,i_mb,j_mb;
  Int MB_non_trans_count=0;

  SetTraceLevelsDefault(trace);
  if (GetVopPredictionType(curr_vop)!=I_VOP)
     level_3_trace = trace->MB_tdata_predicted||trace->MB_tdata_reconstructed;
  if (level_3_trace) {
     fprintf(trace->fp_trace,"\n\n **************************************************\n");  
     fprintf(trace->fp_trace,"\n\n *    Reconstructions of Reduced Resolution VOP   *\n");
     fprintf(trace->fp_trace,"\n\n **************************************************\n\n"); 
     if(GetVopReducedResolution(curr_vop)==0) {
     } else {
     for (i_mb=0;i_mb<nlin/32;i_mb++)
      for (j_mb=0;j_mb<npix/32;j_mb++) {
        if (MB_non_trans_count>=(MB_trace_thres/4)) break; 
        y_data = (SInt *)GetImageData(GetVopA(curr_vop));
        u_data = (SInt *)GetImageData(GetVopAuv(curr_vop));
        for (i=0;i<4;i++)
          for (j=0;j<16;j++)
            for (k=0;k<16;k++)
              mb_shape[i][j*16+k] = y_data[(i_mb*32+(i/2)*16+j)*npix+j_mb*32+(i%2)*16+k];
        sum=0;
        for (i=0;i<4;i++)
          for(j=0;j<256;j++) sum+=mb_shape[i][j];
        MB_nb++;
        if (sum==0) continue;
        MB_non_trans_count++;
         for (j=0;j<16;j++)
          for (k=0;k<16;k++)
            mb_shape[4][j*16+k]=mb_shape[5][j*16+k]
                = u_data[(i_mb*16+j)*npix/2+j_mb*16+k];

        y_data = (SInt *)GetImageData(GetVopY(curr_vop));
        u_data = (SInt *)GetImageData(GetVopU(curr_vop));
        v_data = (SInt *)GetImageData(GetVopV(curr_vop));
        for (i=0;i<4;i++)
          for (j=0;j<16;j++)
            for (k=0;k<16;k++)
              mb_rec[i][j*16+k] = y_data[(i_mb*32+(i/2)*16+j)*npix+j_mb*32+(i%2)*16+k];
         for (j=0;j<16;j++)
          for (k=0;k<16;k++) {
            mb_rec[4][j*16+k]= u_data[(i_mb*16+j)*npix/2+j_mb*16+k]; 
            mb_rec[5][j*16+k]= v_data[(i_mb*16+j)*npix/2+j_mb*16+k]; 
        }
        
     if (level_3_trace)
     fprintf(trace->fp_trace,"\n\n____MB%d_____ at (%d,%d)\n",MB_nb,j_mb*32,i_mb*32);
        PrintOutMBData_32("MB_filtered_reconstructed",mb_shape,mb_rec,trace->fp_trace);
     }
     }
   }
        
  return;
}





