/******************************************************************************
 *                                                                          
 * This software module was originally developed by 
 *
 *   Oki Electric Industry Co., Ltd. (contact: Shigeru Fukunaga)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4 
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free 
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original 
 * developer of this software module and his/her company, the subsequent 
 * editors and their companies, and ISO/IEC have no liability for use of this 
 * software module or modifications thereof. No license to this software
 * module is granted for non MPEG-4 Video (ISO/IEC 14496-2) standard 
 * conforming products.
 *
 * Oki Electric Industry Co., Ltd. retains full right to use the software 
 * module for his/her own purpose, assign or donate the software module to a 
 * third party and to inhibit third parties from using the code for non MPEG-4 
 * Video (ISO/IEC 14496-2) standard conforming products. This copyright notice 
 * must be included in all copies or derivative works of the software module. 
 *
 * Copyright (c) 1999  Oki Electric Industry Co., Ltd.  All rights reserved.
 *
 *****************************************************************************/


/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	newpred_d.h
 *
 * Author:	Oki - Shigeru Fukunaga
 * Created:	16-AUG-1999 
 *                                                                         
 * Description: Header file of NEWPRED (decoder)
 *
 * Notes: 	
 *
 * Modified:	
 *
 ***********************************************************HeaderEnd*********/

#ifndef _NEWPRED_D_H_
#define _NEWPRED_D_H_

#define	MAXREF		(5)	/** maximum size of reference memory */
/** This size depends on the frame rate and the round trip delay between the 
    encoder and the decoder. **/
#define	MAXNPSEG	(18)	/** maximum size of NEWPRED segment **/
/** This size is not limited and depends on the picture size. This size should be 
    same value to the number of np_vop_id_pred array in Vop structure defined 
    in mom_structs.h **/


struct _np_ref_mem_d
{
  Int		vop_id[MAXNPSEG];	/** vop_id **/
  Int		vop_id_pred[MAXNPSEG];	/** vop_id_for_prediction **/
  Vop		*vop;			/** VOP data **/
};
typedef struct _np_ref_mem_d RefVopD;	/** reference memory for NEWPRED **/

struct _np_ref_list
{
  Int		vop_id;			/** vop_id **/
  Int		mem_pointer;		/** pointer to reference memory **/
};
typedef struct _np_ref_list RefList;	/** list of reference memory for NEWPRED **/

struct _np_config
{
  RefVopD	*ref_vop[MAXREF];	/** reference memory **/
  RefList	*ref_list[MAXNPSEG];	/** list of reference memory **/
  Int		num_segments;		/** number of NEWPRED segments per VOP **/
  Int		mba_segment[MAXNPSEG];	/** first MBA of each NEWPRED segment **/
};
typedef struct _np_config NpConfig;	/** config structure for NEWPRED **/


#include "newpred_d.p"

#endif /* _NEWPRED_D_H_ */
