/************************************************************************/
/*                                                     			*/
/* This software module was originally developed by              	*/
/*                                                               	*/
/* Stefan Rauthenberg (HHI / ACTS-MoMuSys).     	              	*/
/*                                                               	*/
/* and edited by                                                	*/
/*                                                               	*/
/* Jan De Lameillieure (HHI / ACTS-MoMuSys).     	              	*/
/*                                                               	*/
/* in the course of development of the MPEG-4 Video (ISO/IEC 14496-2).	*/
/* This software module is an implementation of a part of one or 	*/
/* more MPEG-4 Video (ISO/IEC 14496-2) tools as specified by the        */
/* MPEG-4 Video (ISO/IEC 14496-2). ISO/IEC gives users of the MPEG-4    */
/* Video free license to this software module or modifications thereof 	*/
/* for use in hardware or software products claiming conformance to the */
/* MPEG-4 Video (ISO/IEC 14496-2). Those intending to use this software */
/* module in hardware or software products are advised that its use may */
/* infringe existing patents. The original developer of this software  	*/
/* module and his/her company, the subsequent editors and their     	*/
/* companies, and ISO/IEC have no liability for use of this software    */
/* module or modifications thereof in an implementation. Copyright is   */
/* not released for non MPEG-4 Video (ISO/IEC 14496-2) conforming 	*/
/* products. ACTS-MoMuSys partners retain full right to use  the code   */
/* for their own purposes, assign or donate the code to a third party   */
/* and to inhibit third parties from using the code for non MPEG-4    	*/
/* Video (ISO/IEC 14496-2) conforming products. This copyright notice 	*/
/* must be included in all copies or derivative works.                  */
/* Copyright (c)1997                                            	*/
/*                                                               	*/
/************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File: sadctq_blk.c
 * 
 * Author: Stefan Rauthenberg (HHI)
 *
 *	Heinrich-Hertz-Institut fuer Nachrichtentechnik GmbH
 *	Image Processing Department
 *	Einsteinufer 37
 *	D-10587 Berlin 
 *	Federal Republic of Germany
 *	Phone: 	+49-30-31002-615
 *	Fax:	+49-30-3927200
 *	email:	rauthenberg@HHI.DE
 *
 * Created: 21/02/95
 *                                                                         
 * Description: 
 *	The double precision output of the SADCT and inverse SADCT requires
 *	a postprocessing in order to produce #bit integer values suitable
 *	for a `real world' coding scheme.  
 *
 *	Both functions use NINT truncation to cast double's to short integers
 *	and clip the resulting integers to a user selectable range.
 *
 *	e.g.:	a MPEG like system would limit the output of the SADCT to
 *		-2048, 2047
 * 
 *	User callable functions:
 *
 *		sadctq_blk()
 *		saidctq_blk()
 *
 * Notes:  
 *
 * Modified: 
 *      20-MAR-97 Jan De Lameillieure (HHI) : adaptation to MoMuSys common
 *			rules
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#include "sadct.h"
/* #include <system.cfg>	*/	/* commented out by JDL 20-MAR-97 */

/*
 *	converts the output of the SADCT into 16bit integers.  These 
 *	integers will be clipped to `lower_limit'... `upper_limit'.
 *	The vector `lx' contains the row lengths which describe which
 *	part of `in' is really filled with frequency coefficients.
 */
Void sadctq_blk(Short **out, Double **in, Int *lx, Int bky, Int lower_limit, 
		Int upper_limit)
{
  Int iy, ix, ixmax, q;
  Short *row_dest;
  Double *row_src;

  for (iy=0; iy<bky && lx[iy]; iy++) {
    ixmax = lx[iy];
    row_dest = out[iy];
    row_src = in[iy];
    for (ix=0; ix<ixmax; ix++) {
      /* some people might use a macro to mimic a non-existing NINT() 
	 and this is likely to fail with a postincrement. */
      q = NINT(*row_src);
      row_src++;
      if ( q > upper_limit )
	*row_dest++ = (Short)upper_limit;
      else if ( q < lower_limit )
	*row_dest++ = (Short)lower_limit;
      else
	*row_dest++ = (Short)q;
    }
  }
}

/*
 * 	converts the output of the inverse SADCT into 16bit integers.  These 
 *	integers will be clipped to `lower_limit'... `upper_limit'.
 *	The binary mask `mask' defines which part of the rectangular 
 *	block `in' stores a valied coefficient.
 */	 
Void saidctq_blk(Short **out, Double **in, UChar **mask, Int bky, Int bkx,
		 Int lower_limit, Int upper_limit)
{
  Int iy, ix, q;
  Short *row_dest;
  Double *row_src;
  UChar *row_mask;

  for (iy=0; iy<bky; iy++) {
    row_dest = out[iy];
    row_src = in[iy];
    row_mask = mask[iy];
    for (ix=0; ix<bkx; ix++) {
      if ( *row_mask++) {
	q = NINT(*row_src);
	row_src++;
	if ( q > upper_limit )
	  *row_dest++ = (Short)upper_limit;
	else if ( q < lower_limit )
	  *row_dest++ = (Short)lower_limit;
	else
	  *row_dest++ = (Short)q;
      }
      else {
	row_dest++; row_src++; 
      }
    }
  }
}
