/************************************************************************/
/*                                                     			*/
/* This software module was originally developed by              	*/
/*                                                               	*/
/* Jan De Lameillieure (HHI / ACTS-MoMuSys).     	              	*/
/*                                                               	*/
/* in the course of development of the MPEG-4 Video (ISO/IEC 14496-2).	*/
/* This software module is an implementation of a part of one or 	*/
/* more MPEG-4 Video (ISO/IEC 14496-2) tools as specified by the        */
/* MPEG-4 Video (ISO/IEC 14496-2). ISO/IEC gives users of the MPEG-4    */
/* Video free license to this software module or modifications thereof 	*/
/* for use in hardware or software products claiming conformance to the */
/* MPEG-4 Video (ISO/IEC 14496-2). Those intending to use this software */
/* module in hardware or software products are advised that its use may */
/* infringe existing patents. The original developer of this software  	*/
/* module and his/her company, the subsequent editors and their     	*/
/* companies, and ISO/IEC have no liability for use of this software    */
/* module or modifications thereof in an implementation. Copyright is   */
/* not released for non MPEG-4 Video (ISO/IEC 14496-2) conforming 	*/
/* products. ACTS-MoMuSys partners retain full right to use  the code   */
/* for their own purposes, assign or donate the code to a third party   */
/* and to inhibit third parties from using the code for non MPEG-4    	*/
/* Video (ISO/IEC 14496-2) conforming products. This copyright notice 	*/
/* must be included in all copies or derivative works.                  */
/* Copyright (c)1997                                            	*/
/*                                                               	*/
/************************************************************************/
/***********************************************************HeaderBegin*******
 *                                                                         
 * File: block_sadct_s_k.c 
 * 
 * Author: Jan De Lameillieure (HHI)
 *
 * Created: 24-MAR-97
 *                                                                         
 * Description: 
 *
 * Notes:  
 *
 * Modified: 
 *     16-JUN-97 Jan De Lameillieure : renaming some include files to sadct_*
 *     12-AUG-97 Jan De Lameillieure : using m, in, out, out_short and lx from sadct_init.c
 *     10-Feb-97 Klaas Schueuer: changed to dDC-SA-DCT 	
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "momusys.h"
#include "vm_common_defs.h"	/* because of BINARY_ALPHA */
#include "sadct_momusys_s_k.h"

#include "sadct_bsnrmem.h"
#include "sadct.h"
#include "sadct_s_k.h"

  /* variables for SA-DCT `a la Kaup, declared globally in sadct_init.c */

extern UChar **m;
extern Double  **in, **out ;
extern Short **out_short;
extern Int *lx;
static Int length_x[6][8];

 
Void SADCT_Used_Decision(Int *sadct_used) {
 Int i,j;
     for (i=0;i<6;i++) 
        for (j=0;j<8;j++)
         if (length_x[i][j]!=8) sadct_used[i]=1;
  }

/* 08.02.99 HHI Schueuer */
Void SADCT_Used_Decision_alpha(Int *sadct_used) {
 Int i, j;
     for (i = 0; i < 4; i++) 
        for (j = 0; j < 8; j++)
         if (length_x[i][j] != 8)
	   sadct_used[i] = 1;
}
/* end HHI */

Void SADCT_Used_Decision_d(Int comp, Int *sadct_used) {
 Int j;   
          *sadct_used = 0;
          for (j=0;j<8;j++)
           if (length_x[comp][j]!=8) *sadct_used=1;
   }

Void  sadct_rowlength_out(Int k, Short alpha[8][8], Int x, Int y) {
  Int i,j;
   for (i=0;i< BLOCK_SIZE; i++)
    for (j=0;j< BLOCK_SIZE; j++) 
      m[i][j] = (UChar) alpha[i][j];
       sadct_rowlength(length_x[k], m, BLOCK_SIZE, BLOCK_SIZE);
}

Void SADCT_Scan(Int *coeff_in, Int *coeff, Int blk, Int sel)
    {
      Int i,j;
      UChar scany_zigzag[64] =
      {0, 0, 1, 2, 1, 0, 0, 1,
       2, 3, 4, 3, 2, 1, 0, 0,
       1, 2, 3, 4, 5, 6, 5, 4, 
       3, 2, 1, 0, 0, 1, 2, 3,
       4, 5, 6, 7, 7, 6, 5, 4, 
       3, 2, 1, 2, 3, 4, 5, 6,
       7, 7, 6, 5, 4, 3, 4, 5,
       6, 7, 7, 6, 5, 6, 7, 7};
      UChar scanx_zigzag[64] =
      {0, 1, 0, 0, 1, 2, 3, 2, 
       1, 0, 0, 1, 2, 3, 4, 5,
       4, 3, 2, 1, 0, 0, 1, 2, 
       3, 4, 5, 6, 7, 6, 5, 4,
       3, 2, 1, 0, 1, 2, 3, 4, 
       5, 6, 7, 7, 6, 5, 4, 3,
       2, 3, 4, 5, 6, 7, 7, 6,
       5, 4, 5, 6, 7, 7, 6, 7};
      

     UChar scany_hori[64] =
      {0, 0, 0, 0, 1, 1, 2, 2,
       1, 1, 0, 0, 0, 0, 1, 1,
       1, 1, 2, 2, 3, 3, 4, 4, 
       3, 3, 2, 2, 2, 2, 3, 3,
       3, 3, 4, 4, 5, 5, 6, 6, 
       5, 5, 4, 4, 4, 4, 5, 5,
       5, 5, 6, 6, 7, 7, 7, 7,
       6, 6, 6, 6, 7, 7, 7, 7};
    

      UChar scanx_hori[64] =
      {0, 1, 2, 3, 0, 1, 0, 1, 
       2, 3, 4, 5, 6, 7, 7, 6,
       5, 4, 3, 2, 0, 1, 0, 1,
       2, 3, 4, 5, 6, 7, 4, 5,
       6, 7, 2, 3, 0, 1, 0, 1,
       2, 3, 4, 5, 6, 7, 4, 5,
       6, 7, 2, 3, 0, 1, 2, 3,
       4, 5, 6, 7, 4, 5, 6, 7};
 
    UChar scany_ver[64] =
      {0, 1, 2, 3, 0, 1, 0, 1, 
       2, 3, 4, 5, 6, 7, 7, 6,
       5, 4, 3, 2, 0, 1, 0, 1,
       2, 3, 4, 5, 6, 7, 4, 5,
       6, 7, 2, 3, 0, 1, 0, 1,
       2, 3, 4, 5, 6, 7, 4, 5,
       6, 7, 2, 3, 0, 1, 2, 3,
       4, 5, 6, 7, 4, 5, 6, 7};
   
     UChar scanx_ver[64] =
      {0, 0, 0, 0, 1, 1, 2, 2,
       1, 1, 0, 0, 0, 0, 1, 1,
       1, 1, 2, 2, 3, 3, 4, 4, 
       3, 3, 2, 2, 2, 2, 3, 3,
       3, 3, 4, 4, 5, 5, 6, 6, 
       5, 5, 4, 4, 4, 4, 5, 5,
       5, 5, 6, 6, 7, 7, 7, 7,
       6, 6, 6, 6, 7, 7, 7, 7};
    


     


     UChar *scany,*scanx;
 
     if (sel ==0) {
       scany = scany_zigzag;
       scanx = scanx_zigzag;
   } else if (sel ==2) {
      scany = scany_hori;
      scanx = scanx_hori;
    } else if (sel ==1) {
      scany = scany_ver;
      scanx = scanx_ver;
    }




     for (i=0;i<BLOCK_SIZE;i++)
       for (j=0;j<BLOCK_SIZE;j++)
         out_short[i][j]=coeff_in[i*8+j];

     
      /* SADCT Scan */
   
  i=j=0;	/* i is pointer in FS, j is scan index in F */
  do {
    if (scanx[j]<length_x[blk][scany[j]]) {	/* only F[y][x] in FS that are SA-DCT output */
      *(coeff + i) = (Int)(out_short[scany[j]][scanx[j]]);
      i++; 
    }
    j++;
  } while (j < BLOCK_SIZE*BLOCK_SIZE);

  while (i < BLOCK_SIZE*BLOCK_SIZE) {	/* filling non-existent SA-DCT coefficients */
    *(coeff + i) = 0;
    i++;
  }
 coeff[0] = (Int)(out_short[0][0]);

}


Void SADCT_Inverse_Scan(Int *coeff_in, Int *coeff, Int blk, Int sel)
    {
      Int i,j;
      UChar scany_zigzag[64] =
      {0, 0, 1, 2, 1, 0, 0, 1,
       2, 3, 4, 3, 2, 1, 0, 0,
       1, 2, 3, 4, 5, 6, 5, 4, 
       3, 2, 1, 0, 0, 1, 2, 3,
       4, 5, 6, 7, 7, 6, 5, 4, 
       3, 2, 1, 2, 3, 4, 5, 6,
       7, 7, 6, 5, 4, 3, 4, 5,
       6, 7, 7, 6, 5, 6, 7, 7};
      UChar scanx_zigzag[64] =
      {0, 1, 0, 0, 1, 2, 3, 2, 
       1, 0, 0, 1, 2, 3, 4, 5,
       4, 3, 2, 1, 0, 0, 1, 2, 
       3, 4, 5, 6, 7, 6, 5, 4,
       3, 2, 1, 0, 1, 2, 3, 4, 
       5, 6, 7, 7, 6, 5, 4, 3,
       2, 3, 4, 5, 6, 7, 7, 6,
       5, 4, 5, 6, 7, 7, 6, 7};
      

     UChar scany_hori[64] =
      {0, 0, 0, 0, 1, 1, 2, 2,
       1, 1, 0, 0, 0, 0, 1, 1,
       1, 1, 2, 2, 3, 3, 4, 4, 
       3, 3, 2, 2, 2, 2, 3, 3,
       3, 3, 4, 4, 5, 5, 6, 6, 
       5, 5, 4, 4, 4, 4, 5, 5,
       5, 5, 6, 6, 7, 7, 7, 7,
       6, 6, 6, 6, 7, 7, 7, 7};
    

      UChar scanx_hori[64] =
      {0, 1, 2, 3, 0, 1, 0, 1, 
       2, 3, 4, 5, 6, 7, 7, 6,
       5, 4, 3, 2, 0, 1, 0, 1,
       2, 3, 4, 5, 6, 7, 4, 5,
       6, 7, 2, 3, 0, 1, 0, 1,
       2, 3, 4, 5, 6, 7, 4, 5,
       6, 7, 2, 3, 0, 1, 2, 3,
       4, 5, 6, 7, 4, 5, 6, 7};
 
    UChar scany_ver[64] =
      {0, 1, 2, 3, 0, 1, 0, 1, 
       2, 3, 4, 5, 6, 7, 7, 6,
       5, 4, 3, 2, 0, 1, 0, 1,
       2, 3, 4, 5, 6, 7, 4, 5,
       6, 7, 2, 3, 0, 1, 0, 1,
       2, 3, 4, 5, 6, 7, 4, 5,
       6, 7, 2, 3, 0, 1, 2, 3,
       4, 5, 6, 7, 4, 5, 6, 7};
   
     UChar scanx_ver[64] =
      {0, 0, 0, 0, 1, 1, 2, 2,
       1, 1, 0, 0, 0, 0, 1, 1,
       1, 1, 2, 2, 3, 3, 4, 4, 
       3, 3, 2, 2, 2, 2, 3, 3,
       3, 3, 4, 4, 5, 5, 6, 6, 
       5, 5, 4, 4, 4, 4, 5, 5,
       5, 5, 6, 6, 7, 7, 7, 7,
       6, 6, 6, 6, 7, 7, 7, 7};
    


     


     UChar *scany,*scanx;
 
    if (sel ==0) {
       scany = scany_zigzag;
       scanx = scanx_zigzag;
   } else if (sel ==2) {
      scany = scany_hori;
      scanx = scanx_hori;
    } else if (sel ==1) {
      scany = scany_ver;
      scanx = scanx_ver;
    }




         /* SADCT Scan */
   
  i=0;	/* i is pointer in FS, j is scan index in F */
  for(j=0;j<BLOCK_SIZE*BLOCK_SIZE;j++) {
    if (scanx[j]<length_x[blk][scany[j]]) {	/* only F[y][x] in FS that are SA-DCT output */
      out_short[scany[j]][scanx[j]] = *(coeff_in + i);
      i++;
    }
    else
      out_short[scany[j]][scanx[j]] = 0;
  }

    for (i=0; i<BLOCK_SIZE; i++)
        for (j=0; j<BLOCK_SIZE; j++)
          coeff[i*BLOCK_SIZE+j] =out_short[i][j]; 

    coeff[0] = coeff_in[0];


}


/***********************************************************CommentBegin******
 *
 * -- BlockSADCT_s_k -- 8x8 block SA-DCT `a la Kaup
 *
 * Author :		
 *	Jan De Lameillieure
 *
 * Created :		
 *	24-MAR-97
 *
 * Purpose :		
 *	8x8 block dDC-SA-DCT
 * 
 * Arguments in : 	
 *	Int block[][8]	8x8 data block
 *
 * Arguments in/out :	
 *
 * Arguments out :	
 *	Int *coeff	transform coefficients
 *
 * Return values :	
 *	Int		status (0 for OK only)
 *
 * Side effects :	
 *
 * Description :	
 *
 * See also :
 *
 * Modified :		
 *
 ***********************************************************CommentEnd********/


  

    

Int
BlockSADCT_s_k (Int block[8][8], Int *coeff, Short alpha_block[8][8])
{
Int i,j;
 

#ifdef SADCT_DEBUG
  for (i=0; i<BLOCK_SIZE; i++) {
    for (j=0; j<BLOCK_SIZE; j++) {
      printf("%3d ", alpha_block[i][j]);
    }
    printf("\n");
  }
  printf("\n"); fflush(stdout);
#endif

  for (i=0; i<BLOCK_SIZE; i++) {
    for (j=0; j<BLOCK_SIZE; j++) {
      m[i][j] = (alpha_block[i][j] == BINARY_ALPHA) ? 1 : 0;
      if (m[i][j])
	in[i][j] = (double) block[i][j];
      else
	in[i][j] = 0;
    }
  }

#ifdef SADCT_DEBUG
  for (i=0; i<BLOCK_SIZE; i++) {
    for (j=0; j<BLOCK_SIZE; j++) {
      if (m[i][j])
	printf("%5.1f ", in[i][j]);
      else
	printf("      ");
    }
    printf("\n");
  }
  printf("\n"); fflush(stdout);
#endif

  sadct_blk_s_k(out,lx,in,m,BLOCK_SIZE,BLOCK_SIZE);
  sadctq_blk(out_short,out,lx,BLOCK_SIZE,-2048,2047);

#ifdef SADCT_DEBUG
  for (i=0; i<BLOCK_SIZE; i++) {
    for (j=0; j<BLOCK_SIZE; j++) {
      if (j<lx[i])
	printf("%4d ", out_short[i][j]);
      else
	printf("     ");
    }
    printf("         %1d\n", lx[i]);
  }
  printf("\n");
#endif

 for (i=0; i<BLOCK_SIZE; i++) 
    for (j=0; j<BLOCK_SIZE; j++) {
       if (j<lx[i]) 
        coeff[i*BLOCK_SIZE+j] = (Int)out_short[i][j];
        else coeff[i*BLOCK_SIZE+j] =0;
  }   
 
#ifdef SADCT_DEBUG
  for (i = 0; i < 64; i++) 
    printf("%d ", *(coeff + i));
  printf("\n\n");
#endif
   
  return 0;
}

/***********************************************************CommentBegin******
 *
 * -- BlockSAIDCT_s_k -- 8x8 block Inverse SA-DCT `a la s_k
 *
 * Author :		
 *	Jan De Lameillieure (HHI)
 *
 * Created :		
 *	24-MAR-97
 *
 * Purpose :		
 *	8x8 block Inverse SA-DCT `a la s_k
 * 
 * Arguments in : 	
 *	Int *coeff	transform coefficients
 *
 * Arguments in/out :	
 *
 * Arguments out :	
 *	Int block[][8]	inverse transformed block data
 *
 * Return values :	
 *	Void
 *
 * Side effects :	
 *
 * Description :	
 *
 * See also :
 *
 * Modified :		
 *       15-APR-97 Jan De Lameillieure : added call to sadct_rowlength(), for 
 *                                       correct operation in decoder
 *
 ***********************************************************CommentEnd********/

Void 
BlockSAIDCT_s_k (Int *coeff, Int block[][8], Short alpha_block[8][8])
{
  Int i,j;
 
  for (i=0; i<BLOCK_SIZE; i++)
    for (j=0; j<BLOCK_SIZE; j++)
      m[i][j] = alpha_block[i][j];

  /* the call to sadct_rowlength is necessary in the decoder because lx is not set there */
  /* An encoder that calls BlockSAIDCT immediately after BlockSADCT still has the correct lx
     in memory; in that case this call to sadct_rowlength is superfluous */

  sadct_rowlength(lx, m, BLOCK_SIZE, BLOCK_SIZE);

  for (i=0; i<BLOCK_SIZE; i++)
    for (j=0; j<BLOCK_SIZE; j++)
      in[i][j] = coeff[i*BLOCK_SIZE+j];

#ifdef SAIDCT_DEBUG
  for (i=0; i<BLOCK_SIZE; i++) {
    for (j=0; j<BLOCK_SIZE; j++) {
      printf("%5.1f ", in[i][j]);
    }
    printf("\n");
  }
  printf("\n");
  fflush(stdout); fflush(stderr);
#endif

  saidct_blk_s_k(out,in,m,BLOCK_SIZE,BLOCK_SIZE);
  saidctq_blk(out_short,out,m,BLOCK_SIZE,BLOCK_SIZE,-256,255);

#ifdef SAIDCT_DEBUG
  for (i=0; i<BLOCK_SIZE; i++) {
    for (j=0; j<BLOCK_SIZE; j++) {
      if (alpha_block[i][j])
	printf("%4d ", out_short[i][j]);
      else
	printf("     ");
    }
    printf("\n");
  }
  printf("\n");
  fflush(stdout); fflush(stderr);
#endif

  for (i=0; i<BLOCK_SIZE; i++) 
    for (j=0; j<BLOCK_SIZE; j++) 
      block[i][j] = (Int) out_short[i][j];

}

/***********************************************************CommentBegin******
 *
 * -- Initialisations_for_SADCT_s_k
 *
 * Author :		
 *	Jan De Lameillieure
 *
 * Created :		
 *	20-MAR-97
 *
 * Purpose :		
 *	initialisations for 8x8 block SADCT and inverse SADCT `a la s_k
 * 
 * Arguments in : 	
 *
 * Arguments in/out :	
 *
 * Arguments out :	
 *
 * Return values :	
 *
 * Side effects :	
 *
 * Description :	
 *
 * See also :
 *
 * Modified :		
 *     12-AUG-97 Jan De Lameillieure : the variables m, in, out, out_short and lx from sadct_init.c
 *                                     => no deallocations necessary here
 *
 ***********************************************************CommentEnd********/
void
Initialisations_for_SADCT_s_k()
{
  sadct_init_s_k(BLOCK_SIZE, 2.0, 0.5);
}

/***********************************************************CommentBegin******
 *
 * -- Free_SADCT_s_k
 *
 * Author :		
 *	Jan De Lameillieure
 *
 * Created :		
 *	12-AUG-97
 *
 * Purpose :		
 *	frees allocated memory for 8x8 block SADCT and inverse SADCT `a la s_k
 * 
 * Arguments in : 	
 *
 * Arguments in/out :	
 *
 * Arguments out :	
 *
 * Return values :	
 *
 * Side effects :	
 *
 * Description :	
 *
 * See also :
 *
 * Modified :		
 *
 ***********************************************************CommentEnd********/
Void
Free_SADCT_s_k()
{
  sadct_free_s_k();
}

