/************************************************************************/
/*                                                     			*/
/* This software module was originally developed by              	*/
/*                                                               	*/
/* Jan De Lameillieure (HHI / ACTS-MoMuSys).     	              	*/
/*                                                               	*/
/* in the course of development of the MPEG-4 Video (ISO/IEC 14496-2).	*/
/* This software module is an implementation of a part of one or 	*/
/* more MPEG-4 Video (ISO/IEC 14496-2) tools as specified by the        */
/* MPEG-4 Video (ISO/IEC 14496-2). ISO/IEC gives users of the MPEG-4    */
/* Video free license to this software module or modifications thereof 	*/
/* for use in hardware or software products claiming conformance to the */
/* MPEG-4 Video (ISO/IEC 14496-2). Those intending to use this software */
/* module in hardware or software products are advised that its use may */
/* infringe existing patents. The original developer of this software  	*/
/* module and his/her company, the subsequent editors and their     	*/
/* companies, and ISO/IEC have no liability for use of this software    */
/* module or modifications thereof in an implementation. Copyright is   */
/* not released for non MPEG-4 Video (ISO/IEC 14496-2) conforming 	*/
/* products. ACTS-MoMuSys partners retain full right to use  the code   */
/* for their own purposes, assign or donate the code to a third party   */
/* and to inhibit third parties from using the code for non MPEG-4    	*/
/* Video (ISO/IEC 14496-2) conforming products. This copyright notice 	*/
/* must be included in all copies or derivative works.                  */
/* Copyright (c)1997                                            	*/
/*                                                               	*/
/************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File: sadct_momusys.c 
 * 
 * Author: Jan De Lameillieure (HHI)
 *
 * Created: 08-Nov-96
 *                                                                         
 * Description: 
 *
 * Notes:  
 *
 * Modified: 
 *     20-MAR-97 Jan De Lameillieure (HHI) : tighter coupling of SA-DCT software 
 *                                           with MoMuSys package software
 *     15-APR-97 Jan De Lameillieure : added call to sadct_rowlength(), for 
 *                                     correct operation in decoder
 *     16-JUN-97 Jan De Lameillieure : renaming some include files to sadct_*
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "momusys.h"
#include "vm_common_defs.h"	/* because of BINARY_ALPHA */
#include "sadct_momusys.h"

#include "sadct_bsnrmem.h"
#include "sadct.h"

  /* variables for SA-DCT, declared globally in init_sadct.c */

extern UChar **m;
extern Double  **in, **out ;
extern Short **out_short;
extern Int *lx;

/***********************************************************CommentBegin******
 *
 * -- BlockSADCT -- 8x8 block DCT
 *
 * Author :		
 *	Jan De Lameillieure
 *
 * Created :		
 *	25-SEP-96
 *
 * Purpose :		
 *	8x8 block SADCT
 * 
 * Arguments in : 	
 *	Int block[][8]	8x8 data block
 *
 * Arguments in/out :	
 *
 * Arguments out :	
 *	Int *coeff	transform coefficients
 *
 * Return values :	
 *	Int		status (0 for OK only)
 *
 * Side effects :	
 *
 * Description :	
 *
 * See also :
 *
 * Modified :		
 *
 ***********************************************************CommentEnd********/
Int BlockSADCT (Int block[8][8], Int *coeff, Short alpha_block[8][8])
{
  Int i,j;
 
#ifdef SADCT_DEBUG
  for (i=0; i<BLOCK_SIZE; i++) {
    for (j=0; j<BLOCK_SIZE; j++) {
      printf("%3d ", alpha_block[i][j]);
    }
    printf("\n");
  }
  printf("\n"); fflush(stdout);
#endif

  for (i=0; i<BLOCK_SIZE; i++) {
    for (j=0; j<BLOCK_SIZE; j++) {
      m[i][j] = (alpha_block[i][j] == BINARY_ALPHA) ? 1 : 0;
      if (m[i][j])
	in[i][j] = (Double) block[i][j];
      else
	in[i][j] = 0;
    }
  }

#ifdef SADCT_DEBUG
  for (i=0; i<BLOCK_SIZE; i++) {
    for (j=0; j<BLOCK_SIZE; j++) {
      if (m[i][j])
	printf("%5.1f ", in[i][j]);
      else
	printf("      ");
    }
    printf("\n");
  }
  printf("\n"); fflush(stdout);
#endif

  sadct_blk(out,lx,in,m,BLOCK_SIZE,BLOCK_SIZE);
  sadctq_blk(out_short,out,lx,BLOCK_SIZE,-2048,2047);

#ifdef SADCT_DEBUG
  for (i=0; i<BLOCK_SIZE; i++) {
    for (j=0; j<BLOCK_SIZE; j++) {
      if (j<lx[i])
	printf("%4d ", out_short[i][j]);
      else
	printf("     ");
    }
    printf("         %1d\n", lx[i]);
  }
  printf("\n");
#endif

  for (i=0; i<BLOCK_SIZE; i++) 
    for (j=0; j<BLOCK_SIZE; j++) {
       if (j<lx[i]) 
        coeff[i*BLOCK_SIZE+j] = (Int)out_short[i][j];
        else coeff[i*BLOCK_SIZE+j] =0;
  }   


#ifdef SADCT_DEBUG
  for (i = 0; i < 64; i++) 
    printf("%d ", *(coeff + i));
  printf("\n\n");
#endif
   
  return 0;
}

/***********************************************************CommentBegin******
 *
 * -- BlockSAIDCT -- 8x8 block Inverse SA-DCT
 *
 * Author :		
 *	Jan De Lameillieure (HHI)
 *
 * Created :		
 *	25-SEP-96
 *
 * Purpose :		
 *	8x8 block Inverse DCT
 * 
 * Arguments in : 	
 *	Int *coeff	transform coefficients
 *
 * Arguments in/out :	
 *
 * Arguments out :	
 *	Int block[][8]	inverse transformed block data
 *
 * Return values :	
 *	Void
 *
 * Side effects :	
 *
 * Description :	
 *
 * See also :
 *
 * Modified :		
 *       15-APR-97 Jan De Lameillieure : added call to sadct_rowlength(), for 
 *                                       correct operation in decoder
 *
 ***********************************************************CommentEnd********/

Void BlockSAIDCT (Int *coeff, Int block[][8], Short alpha_block[8][8])
{
  Int i,j;
 
  for (i=0; i<BLOCK_SIZE; i++)
    for (j=0; j<BLOCK_SIZE; j++)
      m[i][j] = alpha_block[i][j];

  /* the call to sadct_rowlength is necessary in the decoder because lx is not set there */
  /* An encoder that calls BlockSAIDCT immediately after BlockSADCT still has the correct lx
     in memory; in that case this call to sadct_rowlength is superfluous */

  sadct_rowlength(lx, m, BLOCK_SIZE, BLOCK_SIZE);

  for (i=0; i<BLOCK_SIZE; i++)
    for (j=0; j<BLOCK_SIZE; j++)
      in[i][j] = coeff[i*BLOCK_SIZE+j];

#ifdef SAIDCT_DEBUG
  for (i=0; i<BLOCK_SIZE; i++) {
    for (j=0; j<BLOCK_SIZE; j++)
      printf("%5.1f ", in[i][j]);
    printf("    ");
    for (j=0; j<BLOCK_SIZE; j++)
      printf("%3d ", m[i][j]);
    printf("\n");
  }
  printf("\n");
  fflush(stdout); fflush(stderr);
#endif

  saidct_blk(out,in,m,BLOCK_SIZE,BLOCK_SIZE);
  saidctq_blk(out_short,out,m,BLOCK_SIZE,BLOCK_SIZE,-256,255);

#ifdef SAIDCT_DEBUG
  for (i=0; i<BLOCK_SIZE; i++) {
    for (j=0; j<BLOCK_SIZE; j++) {
      if (alpha_block[i][j])
	printf("%4d ", out_short[i][j]);
      else
	printf("     ");
    }
    printf("\n");
  }
  printf("\n");
  fflush(stdout); fflush(stderr);
#endif

  for (i=0; i<BLOCK_SIZE; i++) 
    for (j=0; j<BLOCK_SIZE; j++) 
      block[i][j] = (Int) out_short[i][j];

}

