/************************************************************************/
/*                                                     			*/
/* This software module was originally developed by              	*/
/*                                                               	*/
/* Jan De Lameillieure (HHI / ACTS-MoMuSys).     	              	*/
/*                                                               	*/
/* in the course of development of the MPEG-4 Video (ISO/IEC 14496-2).	*/
/* This software module is an implementation of a part of one or 	*/
/* more MPEG-4 Video (ISO/IEC 14496-2) tools as specified by the        */
/* MPEG-4 Video (ISO/IEC 14496-2). ISO/IEC gives users of the MPEG-4    */
/* Video free license to this software module or modifications thereof 	*/
/* for use in hardware or software products claiming conformance to the */
/* MPEG-4 Video (ISO/IEC 14496-2). Those intending to use this software */
/* module in hardware or software products are advised that its use may */
/* infringe existing patents. The original developer of this software  	*/
/* module and his/her company, the subsequent editors and their     	*/
/* companies, and ISO/IEC have no liability for use of this software    */
/* module or modifications thereof in an implementation. Copyright is   */
/* not released for non MPEG-4 Video (ISO/IEC 14496-2) conforming 	*/
/* products. ACTS-MoMuSys partners retain full right to use  the code   */
/* for their own purposes, assign or donate the code to a third party   */
/* and to inhibit third parties from using the code for non MPEG-4    	*/
/* Video (ISO/IEC 14496-2) conforming products. This copyright notice 	*/
/* must be included in all copies or derivative works.                  */
/* Copyright (c)1997                                            	*/
/*                                                               	*/
/************************************************************************/


/***********************************************************HeaderBegin*******
 *                                                                         
 * File: sadct_init.c 
 * 
 * Author: Jan De Lameillieure (HHI)
 *
 * Created: 20-MAR-97
 *                                                                         
 * Description: 
 *
 * Notes:  
 *
 * Modified: 
 *     16-JUN-97 Jan De Lameillieure : renaming some include files to sadct_*
 *
 ***********************************************************HeaderEnd*********/

#include "sadct.h"
#include "sadct_bsnrmem.h"

#define BLOCK_SIZE 8

  /* variables for SA-DCT, declared globally here */

UChar **m;
Double  **in, **out ;
Short **out_short;
Int *lx;

/***********************************************************CommentBegin******
 *
 * -- Initialisations_for_SADCT
 *
 * Author :		
 *	Jan De Lameillieure
 *
 * Created :		
 *	20-MAR-97
 *
 * Purpose :		
 *	initialisations for 8x8 block SADCT and inverse SADCT
 * 
 * Arguments in : 	
 *
 * Arguments in/out :	
 *
 * Arguments out :	
 *
 * Return values :	
 *
 * Side effects :	
 *
 * Description :	
 *
 * See also :
 *
 * Modified :		
 *
 ***********************************************************CommentEnd********/
Void
Initialisations_for_SADCT()
{
  sadct_init(BLOCK_SIZE, 2.0, 0.5);
  m = (UChar **) cmatrix( 0, BLOCK_SIZE-1, 0, BLOCK_SIZE-1);
  in = (Double **) dmatrix_sadct( 0, BLOCK_SIZE-1, 0, BLOCK_SIZE-1);
  out = (Double **) dmatrix_sadct( 0, BLOCK_SIZE-1, 0, BLOCK_SIZE-1);
  out_short = (Short **) smatrix( 0, BLOCK_SIZE-1, 0, BLOCK_SIZE-1);
  lx = (Int *) ivector(0, BLOCK_SIZE-1);
}

/***********************************************************CommentBegin******
 *
 * -- Free_SADCT
 *
 * Author :		
 *	Jan De Lameillieure
 *
 * Created :		
 *	23-APR-97
 *
 * Purpose :		
 *	frees allocated memory for 8x8 block SADCT and inverse SADCT
 * 
 * Arguments in : 	
 *
 * Arguments in/out :	
 *
 * Arguments out :	
 *
 * Return values :	
 *
 * Side effects :	
 *
 * Description :	
 *
 * See also :
 *
 * Modified :		
 *
 ***********************************************************CommentEnd********/
Void
Free_SADCT()
{
  /* Do NOT change the order in which these functions are called -- JDL */

  free_ivector( (Int *) lx, 0, BLOCK_SIZE-1);
  free_smatrix( (SInt **) out_short, 0, BLOCK_SIZE-1, 0, BLOCK_SIZE-1);
  free_dmatrix_sadct( (Double **) out, 0, BLOCK_SIZE-1, 0, BLOCK_SIZE-1);
  free_dmatrix_sadct( (Double **) in, 0, BLOCK_SIZE-1, 0, BLOCK_SIZE-1);
  free_cmatrix( m, 0, BLOCK_SIZE-1, 0, BLOCK_SIZE-1);
  sadct_free();
}
