/* $Id: read_image.c,v 1.8 1998/05/14 21:40:25 hjlee Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*                                                                          */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "dataStruct.h"
#include "errorHandler.h"


/*--------------------------------------------------------------------
  read_image()
  
  Return Values
  -------------
  None.
  
  Comments
  --------
  Exits program if error occurs.
  --------------------------------------------------------------------*/

Void read_image(Char *img_path, Int img_width, Int img_height, 
		Int img_colors, Int img_bit_depth,
		PICTURE *img)
{
  File *infptr = NULL;
  Int  img_size;
   /* chroma  width and height  to handle odd image size */
  Int img_cwidth  = (img_width+1)/2, 
      img_cheight = (img_height+1)/2; 
  Int wordsize = (img_bit_depth>8)?2:1;
  UChar *srcimg; /* SL: to handle 1-16 bit */
  Int  i,k,status;
  
  if (img_colors==MONO) { /*SL: image size for mono */
     img_size = img_width*img_height; /* bit_depth>8 occupies 2 bytes */
  }
  else { /* only for 420 color for now */
    img_size = img_width*img_height+2*img_cwidth*img_cheight; 
  }
  
  if ((srcimg = (UChar *)malloc(sizeof(UChar)*
					img_size*wordsize)) == NULL) 
    errorHandler("Couldn't allocate memory to image\n");

  if ((infptr = fopen(img_path,"rb")) == NULL) 
    errorHandler("Unable to open image_file: %s\n",img_path);

  /* Read image */
  if ((status=fread(srcimg, sizeof(UChar)*wordsize, img_size, infptr))
       != img_size)
    errorHandler("Error in reading image file: %s\n",img_path);

  fclose(infptr);
  
  /* put Into VM structure */
  img[0].width  = img_width;
  img[0].height = img_height;
  if(img_colors != MONO) { /* SL: only for color image */
    img[1].width  = img_cwidth; /* to handle odd image size */
    img[1].height = img_cheight;
    img[2].width  = img_cwidth;
    img[2].height = img_cheight;
  }
  if ((img[0].data=(Void *)
       malloc(sizeof(UChar)*img_width*img_height*wordsize)) == NULL)
    errorHandler("Couldn't allocate memory to image->Y->data\n");
  img[0].mask = NULL;
  if (img_colors != MONO) { /* SL: only for color image */
    if ((img[1].data = (Void *)
	 malloc(sizeof(UChar)*img_cwidth*img_cheight*wordsize))==NULL) 
      errorHandler("Couldn't allocate memory to image->U->data\n");
    img[1].mask = NULL;
    if ((img[2].data = (Void *)
	 malloc(sizeof(UChar)*img_cwidth*img_cheight*wordsize))==NULL)
      errorHandler("Couldn't allocate memory to image->V->data\n");
    img[2].mask = NULL;
  }


  k=0;
  for (i=0; i<img_width*img_height*wordsize; i++) { 
    if (img_bit_depth > 8){ /* mask the input */
      if (i%2==0)
        ((UChar *)img[0].data)[i] =
	      (UChar) (srcimg[k++]&((1<<(img_bit_depth-8))-1));
      else
        ((UChar *)img[0].data)[i] = srcimg[k++];
    }
    else {
      ((UChar *)img[0].data)[i] = 
	(UChar) (srcimg[k++]&((1<<img_bit_depth)-1));
    }
  }
  if (img_colors != MONO) { /* SL: only for color image */
    for (i=0; i<img_cwidth*img_cheight*wordsize; i++) {
      if (img_bit_depth > 8) { /* mask the input */
        if (i%2==0) 
           ((UChar *)img[1].data)[i] = 
	     (UChar) (srcimg[k++]&((1<<(img_bit_depth-8))-1));
        else
           ((UChar *)img[1].data)[i] = srcimg[k++];
      }
      else {
        ((UChar *)img[1].data)[i] = 
	  (UChar) (srcimg[k++]&((1<<img_bit_depth)-1));
      }
    }
    for (i=0; i<img_cwidth*img_cheight*wordsize; i++){
      if (img_bit_depth > 8) { /* mask the input */
        if (i%2==0) 
           ((UChar *)img[2].data)[i] = 
	     (UChar) (srcimg[k++]&((1<<(img_bit_depth-8))-1));
        else
          ((UChar *)img[2].data)[i] = srcimg[k++];
      }
      else {
        ((UChar *)img[2].data)[i] = 
	  (UChar) (srcimg[k++]&((1<<img_bit_depth)-1));
      }
    }
  }
  if (srcimg) free(srcimg);

}

/*begin: added by Sharp (99/2/16)*/
Void init_tile(SOL_PARAMETERS *vm_param, SOL_PARAMETERS *vm_param_org,
	Int tile_width, Int tile_height)
{
  PICTURE *img;
  Int img_cwidth, img_cheight;
  Int wordsize;
  Int img_size;
  Int img_colors = vm_param->colors;
  Int img_bit_depth = vm_param->bit_depth;
  Int col;

  img_cwidth = (tile_width+1)/2;
  img_cheight = (tile_height+1)/2;
  wordsize = (img_bit_depth > 8) ? 2 : 1;

  if (img_colors==MONO) { /*SL: image size for mono */
    img_size = tile_width*tile_height; /* bit_depth>8 occupies 2 bytes */
  }
  else { /* only for 420 color for now */
    img_size = tile_width*tile_height+2*img_cwidth*img_cheight;
  }

  vm_param_org->Image = vm_param->Image;

  if ((img = (PICTURE *)malloc(sizeof(PICTURE)*img_colors))==NULL)
    errorHandler("error allocating memory \n");

  img[0].width = tile_width;
  img[0].height = tile_height;
  if(img_colors != MONO){
    img[1].width  = img_cwidth;
    img[1].height = img_cheight;
    img[2].width  = img_cwidth;
    img[2].height = img_cheight;
  }

  if ((img[0].data=(Void *)
      malloc(sizeof(UChar)*tile_width*tile_height*wordsize)) == NULL)
    errorHandler("Couldn't allocate memory to image->Y->data\n");
  if (img_colors != MONO) { /* SL: only for color image */
    if ((img[1].data = (Void *)
        malloc(sizeof(UChar)*img_cwidth*img_cheight*wordsize))==NULL)
      errorHandler("Couldn't allocate memory to image->U->data\n");
    if ((img[2].data = (Void *)
        malloc(sizeof(UChar)*img_cwidth*img_cheight*wordsize))==NULL)
      errorHandler("Couldn't allocate memory to image->V->data\n");
  }

/* FPDAM begin: modified by SAIT (99/09/03) */
#if 0
/*begin: deleted by Sharp (99/4/7)*/
  for(col=0; col<img_colors; col++){
    img[col].mask = (UChar *)malloc(sizeof(UChar)*tile_width*tile_height);
    if (img[col].mask == NULL)
      errorHandler("error allocating memory \n");
    memset(img[col].mask, 1, sizeof(UChar)*tile_width*tile_height);
  }
/*end: deleted by Sharp (99/4/7)*/
#endif
  for(col=0; col<img_colors; col++){
    if(col==0) {
      img[col].mask = (UChar *)malloc(sizeof(UChar)*tile_width*tile_height);
      if (img[col].mask == NULL)
        errorHandler("error allocating memory \n");
      memset(img[col].mask, 1, sizeof(UChar)*tile_width*tile_height);
    } else {
      img[col].mask=NULL;
    }
  }
/* FPDAM end: modified by SAIT (99/09/03) */

  vm_param->Image = img;

}

void read_tile(SOL_PARAMETERS *vm_param, PICTURE *srcImg, Int id, Int nTilesW, Int nTilesH, Int Flag)
{
  Int i, j, k, l;
  Int InDataType = ((vm_param->bit_depth>8) ? 1:0);
  Int TileHeight, TileWidth;
  Int Width, Height;
  Int h_pre, h_ape, w_pre, w_ape;
  Int col;
  UChar *p_src, *p_dst;
  UShort *p_srcs, *p_dsts;

  i = id/nTilesW;
  j = id%nTilesW;

  for (col=0; col<vm_param->colors; col++) {
    TileWidth  = vm_param->Image[col].width;
    TileHeight = vm_param->Image[col].height;
    Width = srcImg[col].width;
    Height = srcImg[col].height;

    h_pre = h_ape = TileHeight;
    w_pre = w_ape = TileWidth;
    if ((0x1&Flag)==0) {
      h_pre = 0;
      h_ape = 0;
    } else {
      if (i==0) {
        h_pre = 0;
      }
      if (i==(nTilesH-1)) {
        h_ape = 0;
      }
    }

    if ((0x2&Flag)==0) {
      w_pre = 0;
      w_ape = 0;
    } else {
      if (j==0) {
        w_pre = 0;
      }
      if (j==(nTilesW-1)) {
        w_ape = 0;
      }
    }

    /* copy source data */
    if ( InDataType == 0 ) {  /* BYTE */
      p_dst = (UChar *)(vm_param->Image[col].data);
      for(k=0; k<(TileHeight+h_pre+h_ape); k++) {
        p_src = (UChar *)(srcImg[col].data) + (TileHeight*i-h_pre)*Width + TileWidth*j-w_pre + Width* k;
        for(l=0; l<(TileWidth+w_pre+w_ape); l++) {
          *p_dst++ = (Int)(*p_src++);
        }
      }
    } else {    /* Unsigned Short */
      p_dsts = (UShort *)(vm_param->Image[col].data);
      for(k=0; k<(TileHeight+h_pre+h_ape); k++) {
        p_srcs = (UShort *)(srcImg[col].data) + (TileHeight*i-h_pre)*Width + TileWidth*j-w_pre + Width*k;
        for(l=0; l<(TileWidth+w_pre+w_ape); l++) {
          *p_dst++ = (Int)(*p_srcs++);
        }
      }
    }
  }
}
/*end: added by Sharp (99/2/16)*/
