/******************************************************************************
 *                                                                          
 * This software module was originally developed by 
 *
 *   Oki Electric Industry Co., Ltd. (contact: Shigeru Fukunaga)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4 
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free 
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original 
 * developer of this software module and his/her company, the subsequent 
 * editors and their companies, and ISO/IEC have no liability for use of this 
 * software module or modifications thereof. No license to this software
 * module is granted for non MPEG-4 Video (ISO/IEC 14496-2) standard 
 * conforming products.
 *
 * Oki Electric Industry Co., Ltd. retains full right to use the software 
 * module for his/her own purpose, assign or donate the software module to a 
 * third party and to inhibit third parties from using the code for non MPEG-4 
 * Video (ISO/IEC 14496-2) standard conforming products. This copyright notice 
 * must be included in all copies or derivative works of the software module. 
 *
 * Copyright (c) 1999  Oki Electric Industry Co., Ltd.  All rights reserved.
 *
 *****************************************************************************/


/***********************************************************HeaderBegin*******
 *
 * File:        newpred_common.c
 *
 * Author:      Oki - Shigeru Fukunaga
 * Created:     16-AUG-1999
 *
 * Description: modules for NEWPRED
 *
 * Notes:
 *
 * Modified:    
 *
 ***********************************************************HeaderEnd*********/


/************************    INCLUDE FILES    ********************************/

#include <stdio.h>
#include "momusys.h"
#include "newpred.h"
/*#define MB_SIZE	(16)  - always defined (SB) 17-Nov-99 */

/***********************************************************CommentBegin******
 *
 * -- CopyNPSeg --
 *
 * Author :
 *      Oki - Shigeru Fukunaga
 *
 * Created :
 *      16-AUG-1999
 *
 * Purpose :
 *	NEWPRED - copy of NEWPRED segment's picture
 *
 * Arguments in :
 *	Vop *in - source VOP
 *	Vop *out - new VOP
 *	Int begin - begining MBA
 *	Int end - ending MBA
 *	Int pad_size - padding size
 *
 * Arguments in/out :
 *
 * Arguments out :
 *
 * Return values :
 *
 * Side effects :
 *
 * Description :
 *
 * See also :
 *
 * Modified :
 *
 ***********************************************************CommentEnd********/
Void
CopyNPSeg(Vop *in, Vop *out, Int begin, Int end, Int pad_size)
{
  Image	*img_in,
        *img_out;

  /* Y channel */
  img_in = GetVopY(in);
  img_out = GetVopY(out);
  CopyNPSegImage(img_in, img_out, begin, end, pad_size, 1);
	
  /* U channel */
  img_in = GetVopU(in);
  img_out = GetVopU(out);
  CopyNPSegImage(img_in, img_out, begin, end, pad_size/2, 2);
	
  /* V channel */
  img_in = GetVopV(in);
  img_out = GetVopV(out);
  CopyNPSegImage(img_in, img_out, begin, end, pad_size/2, 2);
}
/* end of CopyNPSeg() */


/***********************************************************CommentBegin******
 *
 * -- CopyNPSegImage --
 *
 * Author :
 *      Oki - Shigeru Fukunaga
 *
 * Created :
 *      16-AUG-1999
 *
 * Purpose :
 *	NEWPRED - copy of NEWPRED segment's picture
 *
 * Arguments in :
 *	Image *image_in - source VOP
 *	Image *image_out - new VOP
 *	Int begin - begining MBA
 *	Int end - ending MBA
 *	Int pad_size - padding size
 *	Int flag
 *
 * Arguments in/out :
 *
 * Arguments out :
 *
 * Return values :
 *
 * Side effects :
 *
 * Description :
 *
 * See also :
 *
 * Modified :
 *
 ***********************************************************CommentEnd********/
Void
CopyNPSegImage(Image *image_in, Image *image_out, Int begin, Int end, 
	    Int pad_size, Int flag)
{
  switch(GetImageType(image_out)){
  case SHORT_TYPE:
    CopyNPSegImageI(image_in, image_out, begin, end, pad_size, flag);
    break;
    
  case FLOAT_TYPE:
    CopyNPSegImageF(image_in, image_out, begin, end, pad_size, flag);
    break;
    
  default:
    printf("Image type >>%d<< not supported\n",GetImageType(image_out));
    return;
  }
}
/* end of CopyNPSegImage() */


/***********************************************************CommentBegin******
 *
 * -- CopyNPSegImageI --
 *
 * Author :
 *      Oki - Shigeru Fukunaga
 *
 * Created :
 *      10-NOV-1998
 *
 * Purpose :
 *	NEWPRED - copy of NEWPRED segment's picture
 *
 * Arguments in :
 *	ImageI *image_in - source VOP
 *	ImageI *image_out - new VOP
 *	Int begin - begining MBA
 *	Int end - ending MBA
 *	Int pad_size - padding size
 *	Int flag
 *
 * Arguments in/out :
 *
 * Arguments out :
 *
 * Return values :
 *
 * Side effects :
 *
 * Description :
 *
 * See also :
 *
 * Modified :
 *    28.11.99 Shigeru Fukunaga (Oki): VP size can be smaller than 1 MB line
 *
 ***********************************************************CommentEnd********/
Void
CopyNPSegImageI(ImageI *image_in, ImageI *image_out, Int begin, Int end, 
	     Int pad_size, Int flag)
{
  SInt	*p_in  = GetImageIData(image_in),
        *p_out = GetImageIData(image_out);
        
  
  UInt	sx_in  = GetImageISizeX(image_in),
        sx_out = GetImageISizeX(image_out),
        sy_in  = GetImageISizeY(image_in),
        sy_out = GetImageISizeY(image_out);
    /*sxy_in = GetImageISize(image_in);*/

  Int	width, height;
  Int	num_mb_lines;
  Int	i;

  /** added for NEWPRED (Oki) 28-NOV-1999 **/
  Int   j;
  Int   org_begin = begin;
  Int   org_end = end;
  Int   one_line_size = 0;
  Int   offset_size = 0;
  /** end of NEWPRED (Oki) 28-NOV-1999 **/

#if 0
  fprintf(stdout, "(%u,%u)->(%u,%u)\n",sx_in,sy_in,sx_out,sy_out);
#endif

  if (GetImageType(image_in) != SHORT_TYPE)
    runerr("ERROR(CopyImageI): image not of expected type",1);
  
  if (GetImageType(image_out) != SHORT_TYPE)
    runerr("ERROR(CopyImageI): image not of expected type",1);
  
  if ((sx_in != sx_out) || (sy_in != sy_out))
    runerr("ERROR(CopyImageI): images are different sizes",1);

  width = sx_in - 2 * pad_size;
  height = sy_in - 2 * pad_size;
  
  /* A NEWPRED segment is constructed with several MB lines. */

  /** added for NEWPRED (Oki) 28-NOV-1999 **/
  if((end - begin) / (width / (MB_SIZE/flag)) < 1){  /* VP size is smaller than one MB line */
    num_mb_lines = 1;
    begin = (int)( begin / (width / (MB_SIZE/flag))) * (width / (MB_SIZE/flag));
    end = ((int)( begin / (width / (MB_SIZE/flag))) + 1) * (width / (MB_SIZE/flag));

    /* set begining pointer of image */
    p_in += sx_in * (pad_size + (MB_SIZE/flag) * begin / (width / (MB_SIZE/flag)));
    p_out += sx_in * (pad_size + (MB_SIZE/flag) * begin / (width / (MB_SIZE/flag)));
    one_line_size = (MB_SIZE/flag) * (org_end - org_begin);
    offset_size = width - one_line_size;

    if(begin != org_begin){
      p_in += pad_size + (MB_SIZE/flag) * (org_begin - begin);
      p_out += pad_size + (MB_SIZE/flag) * (org_begin - begin);
      offset_size += pad_size;
    }
    else
      one_line_size += pad_size;
    if(end != org_end)
      offset_size += pad_size;
    else
      one_line_size += pad_size;

    for(j = 0; j < MB_SIZE/flag; j++){
      for(i = 0; i < one_line_size; i++){
	*p_out = *p_in;
	p_in++;
	p_out++;
      }
      p_in += offset_size;
      p_out += offset_size;
    }

    /* copy upper padding */
    if(begin == 0){
      p_in  = GetImageIData(image_in);
      p_out = GetImageIData(image_out);
      if(begin != org_begin){
	p_in += pad_size + (MB_SIZE/flag) * (org_begin - begin);
	p_out += pad_size + (MB_SIZE/flag) * (org_begin - begin);
      }

      for(j = 0; j < pad_size; j++){
	for(i = 0; i < one_line_size; i++){
	  *p_out = *p_in;
	  p_in++;
	  p_out++;
	}
	p_in += offset_size;
	p_out += offset_size;
      }
    }

    /* copy lower padding */
    if(end == width / (MB_SIZE/flag) * height / (MB_SIZE/flag)){
      p_in  = GetImageIData(image_in) + sx_in * (height + pad_size);
      p_out = GetImageIData(image_out) + sx_in * (height + pad_size);
      if(begin != org_begin){
	p_in += pad_size + (MB_SIZE/flag) * (org_begin - begin);
	p_out += pad_size + (MB_SIZE/flag) * (org_begin - begin);
      }

      for(j = 0; j < pad_size; j++){
	for(i = 0; i < one_line_size; i++){
	  *p_out = *p_in;
	  p_in++;
	  p_out++;
	}
	p_in += offset_size;
	p_out += offset_size;
      }
    }
  }
  else{ /* VP size is equall to or larger than one MB line */
  /** end of NEWPRED (Oki) 28-NOV-1999 **/

    /* calculate the number of MB lines */
    num_mb_lines = (end - begin) / (width / (MB_SIZE/flag));

    /* set begining pointer of image */
    p_in = p_in + sx_in * (pad_size + (MB_SIZE/flag) * begin / (width / (MB_SIZE/flag)));
    p_out = p_out + sx_in * (pad_size + (MB_SIZE/flag) * begin / (width / (MB_SIZE/flag)));

    for(i = 0; i < num_mb_lines * sx_in * (MB_SIZE/flag); i++){
      *p_out = *p_in;
      p_in++;
      p_out++;
    }

    /* copy upper padding */
    if(begin == 0){
      p_in  = GetImageIData(image_in);
      p_out = GetImageIData(image_out);
      for(i = 0; i < sx_in * pad_size; i++){
	*p_out = *p_in;
	p_in++;
	p_out++;
      }
    }

    /* copy lower padding */
    if(end == width / (MB_SIZE/flag) * height / (MB_SIZE/flag)){
      p_in  = GetImageIData(image_in) + sx_in * (height + pad_size);
      p_out = GetImageIData(image_out) + sx_in * (height + pad_size);
      for(i = 0; i < sx_in * pad_size; i++){
	*p_out = *p_in;
	p_in++;
	p_out++;
      }
    }
  }  /** added for NEWPRED (Oki) 28-NOV-1999 **/
}
/* end of CopyNPSegImageI() */


/***********************************************************CommentBegin******
 *
 * -- CopyNPSegImageF --
 *
 * Author :
 *      Oki - Shigeru Fukunaga
 *
 * Created :
 *      10-NOV-1998
 *
 * Purpose :
 *	NEWPRED - copy of NEWPRED segment's picture
 *
 * Arguments in :
 *	ImageF *image_in - source VOP
 *	ImageF *image_out - new VOP
 *	Int begin - begining MBA
 *	Int end - ending MBA
 *	Int pad_size - padding size
 *	Int flag
 *
 * Arguments in/out :
 *
 * Arguments out :
 *
 * Return values :
 *
 * Side effects :
 *
 * Description :
 *
 * See also :
 *
 * Modified :
 *    28.11.99 Shigeru Fukunaga (Oki): VP size can be smaller than 1 MB line
 *
 ***********************************************************CommentEnd********/
Void
CopyNPSegImageF(ImageF *image_in, ImageF *image_out, Int begin, Int end, 
	     Int pad_size, Int flag)
{
  SInt	*p_in  = (SInt*) GetImageFData(image_in),
        *p_out = (SInt*) GetImageFData(image_out);

  
  UInt	sx_in  = GetImageFSizeX(image_in),
        sx_out = GetImageFSizeX(image_out),
        sy_in  = GetImageFSizeY(image_in),
        sy_out = GetImageFSizeY(image_out);


  Int	width, height;
  Int	num_mb_lines;
  Int	i;

  /** added for NEWPRED (Oki) 28-NOV-1999 **/
  Int   j;
  Int   org_begin = begin;
  Int   org_end = end;
  Int   one_line_size = 0;
  Int   offset_size = 0;
  /** end of NEWPRED (Oki) 28-NOV-1999 **/

  if (GetImageType(image_in) != SHORT_TYPE)
    runerr("ERROR(CopyImageF): image not of expected type",1);
  
  if (GetImageType(image_out) != SHORT_TYPE)
    runerr("ERROR(CopyImageF): image not of expected type",1);
  
  if ((sx_in != sx_out) || (sy_in != sy_out))
    runerr("ERROR(CopyImageF): images are different sizes",1);
  
  width = sx_in - 2 * pad_size;
  height = sy_in - 2 * pad_size;
  
  /* A NEWPRED segment is constructed with several MB lines. */

  /** added for NEWPRED (Oki) 28-NOV-1999 **/
  if((end - begin) / (width / (MB_SIZE/flag)) < 1){  /* VP size is smaller than one MB line */
    num_mb_lines = 1;
    begin = (int)( begin / (width / (MB_SIZE/flag))) * (width / (MB_SIZE/flag));
    end = ((int)( begin / (width / (MB_SIZE/flag))) + 1) * (width / (MB_SIZE/flag));

    /* set begining pointer of image */
    p_in += sx_in * (pad_size + (MB_SIZE/flag) * begin / (width / (MB_SIZE/flag)));
    p_out += sx_in * (pad_size + (MB_SIZE/flag) * begin / (width / (MB_SIZE/flag)));
    one_line_size = (MB_SIZE/flag) * (org_end - org_begin);
    offset_size = width - one_line_size;

    if(begin != org_begin){
      p_in += pad_size + (MB_SIZE/flag) * (org_begin - begin);
      p_out += pad_size + (MB_SIZE/flag) * (org_begin - begin);
      offset_size += pad_size;
    }
    else
      one_line_size += pad_size;
    if(end != org_end)
      offset_size += pad_size;
    else
      one_line_size += pad_size;

    for(j = 0; j < MB_SIZE/flag; j++){
      for(i = 0; i < one_line_size; i++){
	*p_out = *p_in;
	p_in++;
	p_out++;
      }
      p_in += offset_size;
      p_out += offset_size;
    }

    /* copy upper padding */
    if(begin == 0){
      p_in  = GetImageIData(image_in);
      p_out = GetImageIData(image_out);
      if(begin != org_begin){
	p_in += pad_size + (MB_SIZE/flag) * (org_begin - begin);
	p_out += pad_size + (MB_SIZE/flag) * (org_begin - begin);
      }

      for(j = 0; j < pad_size; j++){
	for(i = 0; i < one_line_size; i++){
	  *p_out = *p_in;
	  p_in++;
	  p_out++;
	}
	p_in += offset_size;
	p_out += offset_size;
      }
    }

    /* copy lower padding */
    if(end == width / (MB_SIZE/flag) * height / (MB_SIZE/flag)){
      p_in  = GetImageIData(image_in) + sx_in * (height + pad_size);
      p_out = GetImageIData(image_out) + sx_in * (height + pad_size);
      if(begin != org_begin){
	p_in += pad_size + (MB_SIZE/flag) * (org_begin - begin);
	p_out += pad_size + (MB_SIZE/flag) * (org_begin - begin);
      }

      for(j = 0; j < pad_size; j++){
	for(i = 0; i < one_line_size; i++){
	  *p_out = *p_in;
	  p_in++;
	  p_out++;
	}
	p_in += offset_size;
	p_out += offset_size;
      }
    }
  }
  else{ /* VP size is equall to or larger than one MB line */
    /** end of NEWPRED (Oki) 28-NOV-1999 **/

  /* calculate the number of MB lines */
    num_mb_lines = (end - begin) / (width / (MB_SIZE/flag));

    /* set begining pointer of image */
    p_in = p_in + sx_in * (pad_size + (MB_SIZE/flag) * begin / (width / (MB_SIZE/flag)));
    p_out = p_out + sx_in * (pad_size + (MB_SIZE/flag) * begin / (width / (MB_SIZE/flag)));

    for(i = 0; i < num_mb_lines * sx_in * (MB_SIZE/flag); i++){
      *p_out = *p_in;
      p_in++;
      p_out++;
    }

    /* copy upper padding */
    if(begin == 0){
      p_in  = GetImageIData(image_in);
      p_out = GetImageIData(image_out);
      for(i = 0; i < sx_in * pad_size; i++){
	*p_out = *p_in;
	p_in++;
	p_out++;
      }
    }

    /* copy lower padding */
    if(end == width / (MB_SIZE/flag) * height / (MB_SIZE/flag)){
      p_in  = GetImageIData(image_in) + sx_in * (height + pad_size);
      p_out = GetImageIData(image_out) + sx_in * (height + pad_size);
      for(i = 0; i < sx_in * pad_size; i++){
	*p_out = *p_in;
	p_in++;
	p_out++;
      }
    }
  }  /** added for NEWPRED (Oki) 28-NOV-1999 **/
}
/* end of CopyNPSegImageF() */


/***********************************************************CommentBegin******
 *
 * -- PadNPSeg -- 
 *
 * Author :		
 *	OKI - Shigeru Fukunaga
 *
 * Created :		
 *      10-NOV-1998
 *
 * Purpose :		
 *	padding NEWPRED segment (video packet) [unrestricted MV]
 * 
 * Arguments in : 	
 *	SInt *p_org - top left pointer of padded image
 *	SInt *p_segment - top left pointer of NEWPRED segment
 *	Int width - VOP width
 *	Int height - VOP height
 *	Int edge - padding size
 *	Int segment_pos - slice position
 *      Int segment_hegith - hight of NEWPRED segment
 *      Int mba_segment - begining MBA of NEWPRED segment    ** added for NEWPRED (Oki) 28-NOV-1999 **
 *      Int np_seg_id - NEWPRED segment ID                   ** added for NEWPRED (Oki) 28-NOV-1999 **
 *      Int mb_size - MB size
 *
 * Arguments in/out :	
 *
 * Arguments out :	
 *
 * Return values :	
 *
 * Side effects :	
 *
 * Description :	
 * 	A NEWPRED segment is constructed with several MB lines.
 * 	(The position of resync_marker is limited at the begining of first MB line.)
 *
 * See also :
 *
 * Modified :		
 *    28.11.99 Shigeru Fukunaga (Oki): VP size can be smaller than 1 MB line
 *
 ***********************************************************CommentEnd********/
Void PadNPSeg(SInt *p_org, SInt *p_segment, Int width, Int height, Int edge,
	      Int segment_pos, Int segment_height, 
	      Int *mba_segment, Int np_seg_id,  /** added for NEWPRED (Oki) 28-NOV-1999 **/
	      Int mb_size)
{
  Int i, j;
  SInt *p_in, *p_out;

  /** added for NEWPRED (Oki) 28-NOV-1999 **/
  Int small_vp_flag = 0;
  Int begin, end;
  /** end of NEWPRED (Oki) 28-NOV-1999 **/

  /* reset all picels (set gray) */
  p_out = (SInt *)(p_segment - edge - (width + 2*edge) * edge);
  for(i = 0; i < (width + 2*edge) * (height + 2*edge); i++){
    *p_out = (SInt)128;
    p_out++;
  }

  /** added for NEWPRED (Oki) 28-NOV-1999 **/
  if((mba_segment[np_seg_id] % (width/mb_size)) || (mba_segment[np_seg_id+1] % (width/mb_size))){
    segment_height = 1;
    small_vp_flag = 1;
  }  /** end of NEWPRED (Oki) 28-NOV-1999 **/

  /* slice copy */
  p_out = (SInt *)(p_segment - edge + segment_pos * (width + 2*edge) * mb_size);
  p_in = (SInt *)(p_org - edge + segment_pos * (width + 2*edge) * mb_size);
  for(i = 0; i < segment_height * mb_size; i++){
    for(j = 0; j < (width + 2*edge); j++){
      *p_out = *p_in;
      p_in++;
      p_out++;
    }
  }

  /** added for NEWPRED (Oki) 28-NOV-1999 **/
  if(small_vp_flag){
    begin = segment_pos * (width/mb_size);
    end = (segment_pos + 1) * (width/mb_size) -1;

    /** padding left edge of the slice **/
    if(begin != mba_segment[np_seg_id]){
      p_in = (SInt *)(p_segment + segment_pos * (width + 2*edge) * mb_size + (mba_segment[np_seg_id] - begin) * mb_size);
      for(i = 0; i < edge; i++){
	p_out = (SInt *)(p_in - 1);
	for(j = 0; j < edge; j++){
	  *p_out = *p_in;
	  p_out--;
	}
	p_in += (width + 2*edge);
      }
    }

    /** padding right edge of the slece **/
    if(end != mba_segment[np_seg_id+1] - 1){
      p_in = (SInt *)(p_segment + segment_pos * (width + 2*edge) * mb_size + (mba_segment[np_seg_id+1] - begin) * mb_size - 1);
      for(i = 0; i < edge; i++){
	p_out = (SInt *)(p_in + 1);
	for(j = 0; j < edge; j++){
	  *p_out = *p_in;
	  p_out++;
	}
	p_in += (width + 2*edge);
      }
    }
  }  /** end of NEWPRED (Oki) 28-NOV-1999 **/

  /* padding upper edge of the slice */
  p_out = (SInt *)(p_segment - edge + segment_pos * (width + 2*edge) * mb_size
    - edge * (width + 2*edge));
  for(i = 0; i < edge; i++){
    p_in = (SInt *)(p_segment - edge + segment_pos * (width + 2*edge) * mb_size); /** modified for NEWPRED (Oki) 14-NOV-1999 **/
    for(j = 0; j < (width + 2*edge); j++){
      *p_out = *p_in;
      p_in++;
      p_out++;
    }
  }

  /* padding lower edge of the slice */
  p_out = (SInt *)(p_segment - edge + (segment_pos + segment_height) * (width + 2*edge) * mb_size);
  for(i = 0; i < edge; i++){
    p_in = (SInt *)(p_segment - edge + (segment_pos + segment_height) * (width + 2*edge) * mb_size
		    - (width + 2*edge));	/** modified for NEWPRED (Oki) 14-NOV-1999 **/
    for(j = 0; j < (width + 2*edge); j++){
      *p_out = *p_in;
      p_in++;
      p_out++;
    }
  }
}
/* end of PadNPSeg() */


/***********************************************************CommentBegin******
 *
 * -- InterpolateSInt -- Interpolates a complete  (SInt)image
 *
 * Author :
 *      Oki - Shigeru Fukunaga
 *
 * Created :
 *      10-NOV-1998
 *
 * Purpose :
 *      Interpolates a complete  (SInt) image for easier half pel prediction
 *
 * Arguments in :
 *      SInt   *input    	pointer to input image structure
 *	Int    width, height	size of input image
 *      Int    rounding_control rounding control indicater
 *
 * Arguments in/out :
 *
 * Arguments out :
 *      SInt   *output    	pointer to interpolated image
 *
 * Return values :
 *      none
 *
 * Side effects :
 *      Allocates memory to interpolated image
 *
 * Description :
 *
 * See also :
 *
 * Modified :
 *
 ***********************************************************CommentEnd********/
Void
InterpolateSInt(
   SInt *input,		/* <-- image to interpolate (SInt) */
   SInt	*output,	/* --> interpolated image (SInt)  */
   Int	width,
   Int  height,
   Int	rounding_control)
{
  Int    i, j;

  /* main image */
  for (j = 0; j < height-1; j++){
    for (i = 0; i  < width-1; i++){
      *(input + (i<<1)) = *(output + i);
      *(input + (i<<1)+1) = (*(output + i) + *(output + i + 1) + 1 - rounding_control)>>1;
      *(input + (i<<1)+(width<<1)) 
	= (*(output + i) + *(output + i + width) + 1 - rounding_control)>>1;
      *(input + (i<<1)+1+(width<<1)) 
	= (*(output+i) + *(output+i+1) + *(output+i+width) + *(output+i+1+width) + 2
	   - rounding_control)>>2;
    }
    /* last pels on each line */
    *(input+ (width<<1) - 2) = *(output + width - 1);
    *(input+ (width<<1) - 1) = *(output + width - 1);
    *(input+ (width<<1)+ (width<<1)-2) = (*(output+width-1)+*(output+width+width-1)+1-
					  rounding_control)>>1;
    *(input+ (width<<1)+ (width<<1)-1) = (*(output+width-1)+*(output+width+width-1)+1-
					  rounding_control)>>1;
    input += (width<<2);
    output += width;
  }

  /* last lines */
  for (i = 0; i < width-1; i++){
    *(input+ (i<<1)) = *(output + i);
    *(input+ (i<<1)+1) = (*(output + i) + *(output + i + 1) + 1- rounding_control)>>1;
    *(input+ (width<<1)+ (i<<1)) = *(output + i);
    *(input+ (width<<1)+ (i<<1)+1) = (*(output + i) + *(output + i + 1) + 1-
				      rounding_control)>>1;
  }

  /* bottom right corner pels */
  *(input + (width<<1) - 2) = *(output + width -1);
  *(input + (width<<1) - 1) = *(output + width -1);
  *(input + (width<<2) - 2) = *(output + width -1);
  *(input + (width<<2) - 1) = *(output + width -1);

  return;
}
/* end of InterpolateSInt() */
