/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Robert Danielsen (Telenor / ACTS-MoMuSyS)
 *
 * and edited by
 * 
 *   Noel Brady (Teltec DCU / ACTS-MoMuSyS)        	                    
 *   Frederic Dufaux (Digital Equipment Corp.)        	                  
 *   Fernando Jaureguizar (UPM / ACTS-MoMuSyS)
 *   Cecile Dufour (Philips LEP / ACTS-MoMuSys)
 *   Minhua Zhou (HHI / ACTS-MoMuSys) 
 *   Bob Eifrig (NextLevel Systems)
 *   Jong Deuk Kim (HYUNDAI)
 *   Cheol Soo Park (HYUNDAI)
 *   Ji Heon Kweon (HYUNDAI)
 *   Seishi TAKAMURA (NTT)
 *   Oki Electric Industry Co., Ltd. (contact: Shigeru Fukunaga)                  	
 *   Fujitsu Laboratories Ltd. (contact: Eishi Morimatsu)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                          
 * File:	mot_comp.c
 *
 * Author:	Robert Danielsen <Robert.Danielsen@nta.no>
 * Created:	06.03.96
 *                                                                          
 * Description: Motion compensation functions for a Vop.
 *
 * Notes: 	
 *
 * Modified:	21.04.96 Robert Danielsen: Reformatted. New headers.
 *		28.05.96 Robert.Danielsen: Changed some naming, tidied up
 *			some functions. Changed from using tmn-style MODE
 *			defines to the same ones as in mot_est.h.
 *		28.11.96 Ferran Marques: modifications to introduce the
 *			new RepetitivePadding (22.10.96)
 *		20.12.96 Noel Brady: turned off the overlapped filtering when 
 *			 motion compensating binary alpha channels.
 * 	        04.02.97 Noel O'Connor: removed all calls to assert()
 *	        07-Feb-1997, M.Wollborn: changed in order to treat skipped MBs
 *			     correctly
 *		12-02-97 Cecile Dufour: inclusion for SPRITE (from F. Dufaux + 
R. Crinon)
 *		14-04-97  Minhua Zhou : Modifications for overlapped 
 *					motion compensation 
 *		09-05-97  Minhua Zhou : added unrestricted MC und solved
 *					BUG VM6-970425-02 
 *              13-05-97  Minhua Zhou : added obmc_disable 
 *    16.06.97 Angel Pacheco: unified the TRANSPARENT modes.
 *    01.08.97 Fernando Jaureguizar: added the printing of modes for
 *             B-VOPs in B_VopMotionCompensation(), like in
 *             VopMotionCompensate().   (SpSc)
 *    28.08.97 Osamu Sunohara(Sony): modified to set MV in spatial scalable
 *                                   enhancement B-VOP to zero
 *    07.05.98 Jong Deuk Kim (jdkim97@hei.co.kr, HYUNDAI),
 *             Cheol Soo Park (cspark@super5.hyundai.co.kr, HYUNDAI): 
 *             modified field-based MC in P- and B-VOP
 *    21.05.98 Ji Heon Kweon (HYUNDAI) : support for grayscale coding
 *    981209   Ulrich Benzler (University of Hannover) : added interlaced greyscale support
 *             removed BMBFieldMotComp and MotCompBRegion, added quarter pel MC
 *    03.03.99 Seishi TAKAMURA (NTT): added GMC coding 
 *    16.08.98 Shigeru Fukunaga (Oki): restricted motion compemsation 
 *				       within NEWPRED segment
 *    06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 *    14.12.99 Eishi Morimatsu (Fujitsu Labs.): deletion of unused variable in GetPred_Advanced
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#include <stdlib.h>
#include <stdio.h>
#include "momusys.h"
#include "mot_comp.h"
#include "vm_common_defs.h"
#include "mot_util.h"
#include "io_generic.h"
#include "mot_padding.h"
#include "vm_vop_bound.h"
#include "sprite_util.h"
#include "vm_compos.h"
#include "mot_est.h"
#include "globalMC.h"	/* modified by NTT for GMC coding */
#include "newpred.h"	/** added for NEWPRED (Oki) 16-AUG-1999 **/

/* For correct rounding of chrominance vectors */
static Int roundtab4[] = {0,1,1,1};
static Int roundtab8[] = {0,0,1,1,1,1,1,2};
/*** 10/30 for TPS */
static Int roundtab12[] = {0,0,0,1,1,1,1,1,1,1,2,2}; 
/* 10/30 for TPS ***/
static Int roundtab16[] = {0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2};

/***********************************************************CommentBegin******
 *
 * -- VopMotionCompensate -- Motion compensation for one Vop
 *
 * Author :		
 *	Robert Danielsen <Robert.Danielsen@nta.no>
 *
 * Created :		
 *	05.03.96
 *
 * Purpose :		
 *	Motion compensation for one Vop
 * 
 * Arguments in : 	
 *	
 *
 * Arguments in/out :	
 *	Vop *rec_prev		Previous reconstructed Vop
 *	Image *mot_x		Motion vectors, x components
 *      Image *mot_y		Motion vectors, y components
 *      Int quarter_pel         flag to indicate qurter pel MC
 *	Image *MB_decisions	Macroblock modes
 *	Vop *comp		Vop to be filled with compensated data
 *      Int obmc_disable 
 *
 * Arguments out :	
 *	
 *
 * Return values :	
 *	
 *
 * Side effects :	
 *	
 *
 * Description :	
 *	Always implements the extension of the Vop to allow unrestricted MVs
 *	if necessary.
 *	The motion vectors are always ordered in an Image structure,
 *	one entry for each 8x8 block. A 16x16 vector is repeated 4 times.
 *	structure is used for this.
 *	The MB_decisions are ordered in an Image-structure, one entry for
 *	each Macroblock.
 *
 * See also :
 *	
 *
 * Modified :		
 *	06.02.96 Various developments. Robert Danielsen
 *	12.04.96 Changing types, updating header texts. Robert Danielsen
 *  	25.04.96 Added repetitive padding of reference vop. Noel Brady
 *	14.06.96 Robert Danielsen: Added passing of alpha-information to
 *		Compensate_Chroma. 
 *	04.09.96 Robert Danielsen: Added compensation of alpha-plane
 *  	20.12.96 NOEL BRADY: Removed compensation of alpha plane. See
 *		 AlphaMotionCompensate().
 *	07-Feb-1997, M.Wollborn: changed in order to treat skipped MBs
 *		     correctly
 *	12-02-97 Cecile Dufour : for sprite capabilities
 *	14-04-97  Minhua Zhou : Modifications for overlapped 
 *				motion compensation 
 *      19.11.97 Noel Brady: modified to handle kipped remote MBs correctly
 *      11.12.97 Bob Eifrig: added field motion compensation
 *	07.05.98 Jong Deuk Kim, Cheol Soo Park (HYUNDAI): field-based MC
 *      21.05.98 Ji Heon Kweon (HYUNDAI) : support for grayscale coding
 *      31.08.98 Guido Heising: non version 1 items (dynamic, gmc sprites)
 *               deleted
 *      06.07.98 U. Benzler (TUH) : added quarter pel support
 *	03.03.99 Seishi TAKAMURA (NTT): added GMC coding
 *	16.08.99 Shigeru Fukunaga (Oki): restricted motion compemsation 
 *					 within NEWPRED segment
 *	06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 *	28.11.99 Shigeru Fukunaga (Oki): modified modules for NEWPRED
 *
 ***********************************************************CommentEnd********/
Void
VopMotionCompensate (Vop *rec_prev,
		     Image *mot_x,
		     Image *mot_y,
		     Int   quarter_pel,		/* MW QPEL 06-JUL-1998 */
		     Image *MB_decisions,
		     Image *alpha_decisions,
		     Vop *comp,
		     Int obmc_disable) 
		         
{
  Image	*pi;
  Image *g_pi[MAX_MAC]; 	/* HYUNDAI (Grayscale) */ /* MAC (SB) 12-Nov-99 */
  Vop* prev_recon=NULL;
  Vop* pr_edge=NULL;
  Int width = GetVopWidth(comp);
  Int height = GetVopHeight(comp);
  Int mode;
  Int mb_size = MB_SIZE;		
  Int i, j, x, y, n;		/* MW QPEL 06-JUL-1998 */
  Int edge, offset_x, offset_y, width_prev;
  SInt pred[16][16];		/* MW QPEL 06-JUL-1998 */
  SInt *prev_ipol;
  SInt *g_prev[MAX_MAC];	/* MW QPEL 06-JUL-1998 */ /* MAC (SB) 12-Nov-99 */
  SInt *g_prev_ipol[MAX_MAC];   /* HYUNDAI (Grayscale) */ /* MAC (SB) 12-Nov-99 */
  SInt overlap;	
  Int prev_x_min,prev_x_max,prev_y_min,prev_y_max;		
  Int subdim, subdim_shift;	/* MW QPEL 06-JUL-1998 */

  Int offset_mos_i0=0, offset_mos_j0=0;
  Int br_x=0, br_y=0;           /* absolute ref of current vop */
  Int imv, mvwidth = 2 * width / MB_SIZE;
  
  /** added for NEWPRED (Oki) 16-AUG-1999 **/
  Image *tmp_image_ipol;        /* image structure of NEWPRED segments for interpolated reference picture */
  Int	np_seg_id = 0;	        /* NEWPRED segment ID */
  Image *tmp_image;	        /* image structure of NEWPRED segments for reference picture */
  SInt	*prev_ipol2;	        /* interpolated NEWPRED segment's image */
  SInt	*prev2;		        /* reference image of NEWPRED segment */
  SInt	*prev_org;	        /* reference image */
  Int	segment_height;	        /* height of NEWPRED segment (MB_line) */
  Int	segment_pos;	        /* position of NEWPRED segment (MB_line) */
  Int	num_segments;	        /* number of NEWPRED segments per VOP */
  Int	mba_segment[MAXNPSEG];  /* MB address of each NEWPRED segment */
  /** end of NEWPRED (Oki) 16-AUG-1999 **/
  
  /* >>> added for DRC by Fujitsu (top)    <<< */
  SInt pred_rr[32][32];	
  SInt *pred_ptr0,*pred_ptr1,*pred_ptr2,*pred_ptr3;
  Int  mba_scale;
  /* >>> added for DRC by Fujitsu (bottom)    <<< */

  /* >>> added for DRC by Fujitsu (top)    <<< */
  if(GetVopReducedResolution(comp)) {
    mb_size = MB_SIZE * 2;		
    mvwidth = 2 * width / mb_size;
    mba_scale = 4;		
    pred_ptr0 = &pred_rr[0][0];
    pred_ptr1 = &pred_rr[0][16];
    pred_ptr2 = &pred_rr[16][0];
    pred_ptr3 = &pred_rr[16][16];
    for (j=0 ; j<32 ; j++)
      for (i=0 ; i<32 ; i++)
        pred_rr[j][i]=0;
  } else {
    mba_scale = 1;		
    pred_ptr0 = &pred[0][0];
    pred_ptr1 = &pred[0][8];
    pred_ptr2 = &pred[8][0];
    pred_ptr3 = &pred[8][8];
    /* >>> added for DRC by Fujitsu (bottom)    <<< */
    for (j=0 ; j<16 ; j++)
      for (i=0 ; i<16 ; i++)
        pred[j][i]=0;
    /* >>> added for DRC by Fujitsu (top)    <<< */
  }
  /* >>> added for DRC by Fujitsu (bottom)    <<< */

#define ALP_COMP 0

#ifdef _DEBUG_
  /* Check MB-modes */
  fprintf (stdout, "Checking MB-modes...\n");
  for (i = 0; i < height/mb_size; i++) {  /* >>> modified for DRC by Fujitsu <<< */
    for (j = 0; j < width/mb_size; j++) {  /* >>> modified for DRC by Fujitsu <<< */
      fprintf (stdout, "%d ", MB_decisions->data->s[i*width/mb_size+j]);  /* >>> modified for DRC by Fujitsu <<< */
    }
    fprintf (stdout, "\n");
  } 
  /* Check MB-modes */
  if (1){
    fprintf (stdout, "Checking B-modes...\n");
    for (i = 0; i < height/(mb_size/2); i++) {  /* >>> modified for DRC by Fujitsu <<< */
      for (j = 0; j < width/(mb_size/2); j++) {  /* >>> modified for DRC by Fujitsu <<< */
        fprintf (stdout, "%d ", alpha_decisions->data->s[i*width/(mb_size/2)+j]); /* >>> modified for DRC by Fujitsu <<< */
      }
      fprintf (stdout, "\n");
    } 
  }
#endif
  
  /* initialise the compensated vop */
  
  SetConstantImage (GetVopY (comp), 0);
  for(n=0;n<GetVopAuxCompCount(comp);n++) 	/* MAC (SB) 12-Nov-99 */
    SetConstantImage (GetVopG (n,comp), 0); 	/* HYUNDAI (Grayscale) */
  SetConstantImage (GetVopU (comp), 0);
  SetConstantImage (GetVopV (comp), 0);
  
  /* Extend and pad the reference Vop */
  
  /* Make padding witdh dependent on fcode; MW, 07-Feb-1997 */
  /* >>> added for DRC by Fujitsu (top)    <<< */
  if(GetVopReducedResolution(comp))
    edge = 32;
  else
    /* >>> added for DRC by Fujitsu (bottom)    <<< */
    edge = 16;
  
  pr_edge = rec_prev;

  /* modified by NTT for GMC coding : start */
  if (GetVopSpriteUsage(comp)==GMC_SPRITE) {
    offset_mos_i0 = GetVopHorSpatRef(rec_prev);
    offset_mos_j0 = GetVopVerSpatRef(rec_prev);
  }  
  /* modified by NTT for GMC coding : end */
  
  /* MW QPEL 06-JUL-1998 >> */
  if (quarter_pel) {
    subdim=4;
    subdim_shift=2;
  }
  else {
    /*
     * half-pel interpolation
     */
    
    subdim=2;
    subdim_shift=1;
    /* interpolate the Y component */
    
    pi = AllocImage(GetVopWidth(pr_edge)*2, GetVopHeight(pr_edge)*2, SHORT_TYPE);
    InterpolateImage(GetVopY(pr_edge), pi,GetVopRoundingType(comp));
    prev_ipol = (SInt *) GetImageData(pi) + GetImageSizeX(pi) * 2 * edge + 2 * edge;
    
    /* HYUNDAI (Grayscale) */
    if(GetVopShape(rec_prev) == GREY_SCALE) {
      for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
        g_pi[n] = AllocImage(GetVopWidth(pr_edge)*2, GetVopHeight(pr_edge)*2, SHORT_TYPE);          
        InterpolateImage(GetVopG(n,pr_edge), g_pi[n],GetVopRoundingType(comp));
        g_prev_ipol[n] = (SInt *) GetImageData(g_pi[n]) + GetImageSizeX(pi) * 2 * edge + 2 * edge;
      }
    }	/* << MW QPEL 06-JUL-1998 */
  }    
    
  /* The data pointers of prev_recon will point into the data
       areas of pr_edge */
  prev_recon = SallocVop ();
    
  PutVopY (GetVopY (pr_edge), prev_recon);
  PutVopU (GetVopU (pr_edge), prev_recon);
  PutVopV (GetVopV (pr_edge), prev_recon);
    
  prev_recon->y_chan->f += GetVopWidth(pr_edge) * edge + edge;
  prev_recon->u_chan->f += (GetVopWidth(pr_edge)/2) * (edge/2) 
    + (edge/2);
  prev_recon->v_chan->f += (GetVopWidth(pr_edge)/2) * (edge/2) 
    + (edge/2);
    
    /* HYUNDAI (Grayscale) */
  if(GetVopShape(rec_prev) == GREY_SCALE) {
    for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
      PutVopG (GetVopG (n,pr_edge), n, prev_recon);
      prev_recon->g_chan[n]->f += GetVopWidth(pr_edge) * edge + edge;
    }
  }
    
  /* Compensate for the offset in spatial references
       between comp and rec_prev. This is done offseting the pointers
       into the MC routines and hence tricking them.
       */
    
  offset_x = GetVopHorSpatRef(comp) - GetVopHorSpatRef(rec_prev)-edge;
  offset_y = GetVopVerSpatRef(comp) - GetVopVerSpatRef(rec_prev)-edge;
    
  prev_recon->y_chan->f += GetVopWidth(pr_edge) * offset_y + offset_x;
  prev_recon->u_chan->f += (GetVopWidth(pr_edge)/2) * (offset_y/2) 
    + (offset_x/2);
  prev_recon->v_chan->f += (GetVopWidth(pr_edge)/2) * (offset_y/2) 
    + (offset_x/2);
    
    /* HYUNDAI (Grayscale) */
  if(GetVopShape(rec_prev) == GREY_SCALE) {
    for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
      prev_recon->g_chan[n]->f += GetVopWidth(pr_edge) * offset_y + offset_x;
    }
  }
    
    
  /* Do the motion compensation */
    
    /* HYUNDAI (Grayscale) */
  if(GetVopShape(rec_prev) == GREY_SCALE) {
    for(n=0;n<GetVopAuxCompCount(comp);n++) 	/* MAC (SB) 12-Nov-99 */
      g_prev[n] = prev_recon->g_chan[n]->f;
  }
    
  if (quarter_pel) {
    /* for quarter pel the _not_ interpolated Vop is passed down */
    /* blockwise interpolation is carried out in GetPred_*       */
    prev_ipol   = prev_recon->y_chan->f; 
      
    /* HYUNDAI (Grayscale) */
    if(GetVopShape(rec_prev) == GREY_SCALE) {
      for(n=0;n<GetVopAuxCompCount(comp);n++) 	/* MAC (SB) 12-Nov-99 */
        g_prev_ipol[n] = g_prev[n]; 
    }
  }  /* << MW QPEL 06-JUL-1998 */
  else {
    prev_ipol += GetImageSizeX(pi) * 2 * offset_y + 2 * offset_x;
      
    /* HYUNDAI (Grayscale) */
    if(GetVopShape(rec_prev) == GREY_SCALE) {
      for(n=0;n<GetVopAuxCompCount(comp);n++) 	/* MAC (SB) 12-Nov-99 */
        g_prev_ipol[n] += GetImageSizeX(pi) * 2 * offset_y + 2 * offset_x;
    }
  }
    
  width_prev = GetImageSizeX(GetVopY(pr_edge));
    
  prev_x_min = 2*GetVopHorSpatRef(rec_prev)-2*GetVopHorSpatRef(comp)+2*edge;
  prev_y_min = 2*GetVopVerSpatRef(rec_prev)-2*GetVopVerSpatRef(comp)+2*edge;
  prev_x_max = prev_x_min + 2*width_prev-4*edge;
  prev_y_max = prev_y_min + 2*GetImageSizeY(GetVopY(pr_edge))-4*edge; 
    

    /* First we have to set all 4 vectors equal for
     the MBM_INTER16 case. This could/should have
     been done before entering this routine. */

  for (i = 0; i < height/mb_size; i++) {
    for (j = 0; j < width/mb_size; j++) {
      mode = ModeMB(MB_decisions, j, i);
      /*
       * Clip motion vectors. Note this clips the vector used in
       * B-vop direct mode too (is this reasonable?).
       */
/* >>> added for DRC by Fujitsu (top)    <<< */
/*      offset_x = MB_SIZE * j; */
/*      offset_y = MB_SIZE * i; */
      offset_x = mb_size * j;
      offset_y = mb_size * i;
/* >>> added for DRC by Fujitsu (bottom)    <<< */
      imv = 2 * (j + i * mvwidth);
      switch (mode) {

        case MBM_INTER16:

#if 0 /* taken out by U. Benzler, 990112 */
          if (GetVopInterlaced(comp)) {
            /* MW QPEL 06-JUL-1998 */
            /* x = offset_x + ((Int)(2 * mot_x->data->f[imv]) >> 1); */
            x = offset_x + ((Int)(subdim * mot_x->data->f[imv]) >> subdim_shift);
            if (x < -MB_SIZE) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (16 minus x)");
#endif
              mot_x->data->f[imv] = - MB_SIZE - offset_x;
            }
            if (x > width) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (16 plus x)");
#endif
              mot_x->data->f[imv] = width - offset_x;
            }
            /* MW QPEL 06-JUL-1998 */
            /* y = offset_y + ((Int)(2 * mot_y->data->f[imv]) >> 1); */
            y = offset_y + ((Int)(subdim * mot_y->data->f[imv]) >> subdim_shift);
            if (y < -MB_SIZE) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (16 minus y)");
#endif
              mot_y->data->f[imv] = - MB_SIZE - offset_y;
            }
            if (y > height) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (16 plus y)");
#endif
              mot_y->data->f[imv] = height - offset_y;
            }
          }
#endif /* #if 0 : taken out by U. Benzler, 990112 */

          mot_x->data->f[imv + 1] = mot_x->data->f[imv + mvwidth] =
            mot_x->data->f[imv + mvwidth + 1] = mot_x->data->f[imv];
          mot_y->data->f[imv + 1] = mot_y->data->f[imv + mvwidth] =
            mot_y->data->f[imv + mvwidth + 1] = mot_y->data->f[imv];
          break;
        
#if 0 /* taken out by U. Benzler, 990112 */
        case MBM_INTER8:

          if (GetVopInterlaced(comp))
          {
            /* MW QPEL 06-JUL-1998 */
            /* x = offset_x + ((Int)(2 * mot_x->data->f[imv]) >> 1); */
            x = offset_x + ((Int)(subdim * mot_x->data->f[imv]) >> subdim_shift);
            if (x < -MB_SIZE) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (8-1 minus x)");
#endif
              mot_x->data->f[imv] = - MB_SIZE - offset_x;
            }
            if (x > width) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (8-1 plus x)");
#endif
              mot_x->data->f[imv] = width - offset_x;
            }
            /* MW QPEL 06-JUL-1998 */
            /* y = offset_y + ((Int)(2 * mot_y->data->f[imv]) >> 1); */
            y = offset_y + ((Int)(subdim * mot_y->data->f[imv]) >> subdim_shift);
            if (y < -MB_SIZE) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (8-1 minus y)");
#endif
              mot_y->data->f[imv] = - MB_SIZE - offset_y;
            }
            if (y > height) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (8-1 plus y)");
#endif
              mot_y->data->f[imv] = height - offset_y;
            }

            imv++;
            /* MW QPEL 06-JUL-1998 */
            /* x = offset_x + ((Int)(2 * mot_x->data->f[imv]) >> 1); */
            x = offset_x + ((Int)(subdim * mot_x->data->f[imv]) >> subdim_shift);
            if (x < -MB_SIZE) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (8-2 minus x)");
#endif
              mot_x->data->f[imv] = - MB_SIZE - offset_x;
            }
            if (x > width) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (8-2 plus x)");
#endif
              mot_x->data->f[imv] = width - offset_x;
            }
            /* MW QPEL 06-JUL-1998 */
            /* y = offset_y + ((Int)(2 * mot_y->data->f[imv]) >> 1); */
            y = offset_y + ((Int)(subdim * mot_y->data->f[imv]) >> subdim_shift);
            if (y < -MB_SIZE) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (8-2 minus y)");
#endif
              mot_y->data->f[imv] = - MB_SIZE - offset_y;
            }
            if (y > height) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (8-2 plus y)");
#endif
              mot_y->data->f[imv] = height - offset_y;
            }

            imv += mvwidth;
            /* MW QPEL 06-JUL-1998 */
            /* x = offset_x + ((Int)(2 * mot_x->data->f[imv]) >> 1); */
            x = offset_x + ((Int)(subdim * mot_x->data->f[imv]) >> subdim_shift);
            if (x < -MB_SIZE) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (8-4 minus x)");
#endif
              mot_x->data->f[imv] = - MB_SIZE - offset_x;
            }
            if (x > width) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (8-4 plus x)");
#endif
              mot_x->data->f[imv] = width - offset_x;
            }
            /* MW QPEL 06-JUL-1998 */
            /* y = offset_y + ((Int)(2 * mot_y->data->f[imv]) >> 1); */
            y = offset_y + ((Int)(subdim * mot_y->data->f[imv]) >> subdim_shift);
            if (y < -MB_SIZE) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (8-4 minus y)");
#endif
              mot_y->data->f[imv] = - MB_SIZE - offset_y;
            }
            if (y > height) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (8-4 plus y)");
#endif
              mot_y->data->f[imv] = height - offset_y;
            }

            imv--;
            /* MW QPEL 06-JUL-1998 */
            /* x = offset_x + ((Int)(2 * mot_x->data->f[imv]) >> 1); */
            x = offset_x + ((Int)(subdim * mot_x->data->f[imv]) >> subdim_shift);
            if (x < -MB_SIZE) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (8-3 minus x)");
#endif
              mot_x->data->f[imv] = - MB_SIZE - offset_x;
            }
            if (x > width) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (8-3 plus x)");
#endif
              mot_x->data->f[imv] = width - offset_x;
            }
            /* MW QPEL 06-JUL-1998 */
            /* y = offset_y + ((Int)(2 * mot_y->data->f[imv]) >> 1);*/
            y = offset_y + ((Int)(subdim * mot_y->data->f[imv]) >> subdim_shift);
            if (y < -MB_SIZE) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (8-3 minus y)");
#endif
              mot_y->data->f[imv] = - MB_SIZE - offset_y;
            }
            if (y > height) {
#ifdef _DEBUG_
              printf("Warning (VopMotionCompensate) : Vectors clipped (8-3 plus y)");
#endif
              mot_y->data->f[imv] = height - offset_y;
            }
          }
          break;

        case MBM_FIELD00:
        case MBM_FIELD01:
        case MBM_FIELD10:
        case MBM_FIELD11:
          /* MW QPEL 06-JUL-1998 */
          /* x = offset_x + ((Int)(2 * mot_x->data->f[imv]) >> 1); */
          x = offset_x + ((Int)(subdim * mot_x->data->f[imv]) >> subdim_shift);
          if (x < -MB_SIZE) {
#ifdef _DEBUG_
            printf("Warning (VopMotionCompensate) : Vectors clipped (fi1 minus x)");
#endif
            mot_x->data->f[imv] = - MB_SIZE - offset_x;
          }
          if (x > width) {
#ifdef _DEBUG_
            printf("Warning (VopMotionCompensate) : Vectors clipped (fi1 plus x)");
#endif
            mot_x->data->f[imv] = width - offset_x;
          }
          /* MW QPEL 06-JUL-1998 */
          /* y = offset_y + ((Int)(2 * mot_y->data->f[imv]) >> 1); */
          y = offset_y + ((Int)(subdim * mot_y->data->f[imv]) >> subdim_shift);
          if (y < -MB_SIZE) {
#ifdef _DEBUG_
            printf("Warning (VopMotionCompensate) : Vectors clipped (fi1 minus y)");
#endif
            mot_y->data->f[imv] = - MB_SIZE - offset_y;
          }
          if (y > height) {
#ifdef _DEBUG_
            printf("Warning (VopMotionCompensate) : Vectors clipped (fi1 plus y)");
#endif
            mot_y->data->f[imv] = height - offset_y;
          }
          mot_x->data->f[imv + mvwidth] = mot_x->data->f[imv];
          mot_y->data->f[imv + mvwidth] = mot_y->data->f[imv];

          imv++;
          /* MW QPEL 06-JUL-1998 */
          /* x = offset_x + ((Int)(2 * mot_x->data->f[imv]) >> 1); */
          x = offset_x + ((Int)(subdim * mot_x->data->f[imv]) >> subdim_shift);
          if (x < -MB_SIZE) {
#ifdef _DEBUG_
            printf("Warning (VopMotionCompensate) : Vectors clipped (fi2 minus x)");
#endif
            mot_x->data->f[imv] = - MB_SIZE - offset_x;
          }
          if (x > width) {
#ifdef _DEBUG_
            printf("Warning (VopMotionCompensate) : Vectors clipped (fi2 plus x)");
#endif
            mot_x->data->f[imv] = width - offset_x;
          }
          /* MW QPEL 06-JUL-1998 */
          /* y = offset_y + ((Int)(2 * mot_y->data->f[imv]) >> 1); */
          y = offset_y + ((Int)(subdim * mot_y->data->f[imv]) >> subdim_shift);
          if (y < -MB_SIZE) {
#ifdef _DEBUG_
            printf("Warning (VopMotionCompensate) : Vectors clipped (fi2 minus y)");
#endif
            mot_y->data->f[imv] = - MB_SIZE - offset_y;
          }
          if (y > height) {
#ifdef _DEBUG_
            printf("Warning (VopMotionCompensate) : Vectors clipped (1fi2 plus y)");
#endif
            mot_y->data->f[imv] = height - offset_y;
          }
          mot_x->data->f[imv + mvwidth] = mot_x->data->f[imv];
          mot_y->data->f[imv + mvwidth] = mot_y->data->f[imv];
          break;
#endif /* if 0 : taken out by U. Benzler, 990112 */

        default: break;
      }
    }
  }	    

#ifdef _DEBUG_  
  /* CHECK THE VECTORS */
  fprintf(stdout,"Spat(%d,%d)\n",GetVopHorSpatRef(comp),GetVopVerSpatRef(comp));
 
  for (i = 0; i < height/mb_size; i++) {
    for (j = 0; j < width/mb_size; j++) {
      mode = ModeMB(MB_decisions, j, i);
      /* MW QPEL 06-JUL-1998 */
      /* if (mode == MBM_INTER8 || mode == MBM_INTER16) */
      if (mode != MBM_INTRA) {
        /* if (mode == MBM_INTER8) */
        /* 	  fprintf(stdout, "mode(%d,%d) = MBM_INTER8\n",j,i); */
        /* else */
        /* 	  fprintf(stdout, "mode(%d,%d) = MBM_INTER16\n",j,i); */
        fprintf(stdout, "mode(%d,%d) = %d\n",j,i,mode);

        fprintf(stdout, "X: %5.2f %5.2f %5.2f %5.2f  ",
                mot_x->data->f[4*i*width/mb_size+j*2],
                mot_x->data->f[4*i*width/mb_size+j*2+1],
                mot_x->data->f[(2*i+1)*2*width/mb_size+j*2],
                mot_x->data->f[(2*i+1)*2*width/mb_size+j*2+1]);  /* >>> modified for DRC by Fujitsu <<< */
        fprintf(stdout, "\n");
        fprintf(stdout, "Y: %5.2f %5.2f %5.2f %5.2f  ",
                mot_y->data->f[4*i*width/mb_size+j*2],
                mot_y->data->f[4*i*width/mb_size+j*2+1],
                mot_y->data->f[(2*i+1)*2*width/mb_size+j*2],
                mot_y->data->f[(2*i+1)*2*width/mb_size+j*2+1]); /* >>> modified for DRC by Fujitsu <<< */


      }
      fprintf(stdout, "\n\n"); 
    }
  } 
#endif	  

  /* MW QPEL 06-JUL-1998 */
  overlap = (obmc_disable)?0:1;

  /** added for NEWPRED (Oki) 16-AUG-1999 **/
  if(GetVopNewpredEnable(comp)){
    /* allocate memory for interpolated reference NEWPRED segment (padded size) */
    tmp_image_ipol = AllocImage(2*(width + 2*edge), 2*(height + 2*edge), SHORT_TYPE);
    prev_ipol2 = (SInt*)((SInt*)GetImageData(tmp_image_ipol)
                         + 2*(width + 2*edge) * 2*edge + 2*edge);

    /* allocate memory for reference NEWPRED segment (padded size) */
    tmp_image = AllocImage((width + 2*edge), (height + 2*edge), SHORT_TYPE);
    prev2 = (SInt*)((SInt*)GetImageData(tmp_image)
                    + (width + 2*edge) * edge + edge);
    prev_org = (SInt*)((SInt*)GetImageData(GetVopY(pr_edge))
                       + (width + 2*edge) * edge + edge);

    num_segments = GetVopNewpredNumVps(comp);
    for(i = 0; i <= num_segments; i++)
      mba_segment[i] = GetVopNewpredMbaVp(comp, i)/mba_scale; /* >>> modified for DRC by Fujitsu <<< */

  }
  else{
    prev_ipol2 = prev_ipol;
  }
  /** end of NEWPRED (Oki) 16-AUG-1999 **/

  for (i = 0; i < height/mb_size; i++) {
    for (j = 0; j < width/mb_size; j++) {
      /** added for NEWPRED (Oki) 16-AUG-1999 **/
      if(GetVopNewpredEnable(comp)){
        /* interpolating recerence NEWPRED segment after padding */
        if(np_seg_id < num_segments){
          if(i * (width/mb_size) + j == mba_segment[np_seg_id]){
	    segment_pos = (Int)(mba_segment[np_seg_id]/(width/mb_size)); /** modified for NEWPRED (Oki) 28-NOV-1999 **/
            segment_height = (Int)((mba_segment[np_seg_id+1] - mba_segment[np_seg_id])/(width/mb_size));
	    
            /* padding NEWPRED segment */
            PadNPSeg(prev_org,          /* top left pointer of reference frame */
                     prev2,	        /* top left pointer of reference segment */
                     width, 	        /* Vop width */
                     height,  	        /* Vop height */
                     edge,	        /* padding size */
                     segment_pos,	/* position of NEWPRED segment */
                     segment_height,    /* height of NEWPRED segment */
		     mba_segment,       /* MBA */         /** added for NEWPRED (Oki) 28-NOV-1999 **/
		     np_seg_id,         /* segment No. */ /** added for NEWPRED (Oki) 28-NOV-1999 **/
                     mb_size);	        /* MB size */
	    
            /* interpolating NEWPRED segment */
            InterpolateSInt(prev_ipol2 - (2*(width+2*edge)*2*edge+2*edge),
                            prev2 - ((width+2*edge)*edge+edge), 
                            width + 2*edge,
                            height + 2*edge,
                            GetVopRoundingType(comp));
	    
            np_seg_id++;	/* NEWPRED segment ID increment */
          }
        }
      }
      /** end of NEWPRED (Oki) 16-AUG-1999 **/

      mode = ModeMB(MB_decisions, j, i);
      if (mode == MBM_INTER16 || 
          mode == MBM_INTER8 || 
          ((mode >= MBM_FIELD00) && (mode <= MBM_FIELD11)) ||
          mode == MBM_SPRITE ||	/* modified by NTT for GMC coding */
          mode == MBM_SKIPPED) {		
        x = j * mb_size;
        y = i * mb_size;
				
        /* modified by NTT for GMC coding : start */
        if ((mode==MBM_SPRITE || mode == MBM_SKIPPED) &&
            GetVopPredictionType(comp) == SPRITE_VOP &&
            GetVopSpriteUsage(comp) == GMC_SPRITE) {
          if (! GetPred_GMC(&pred[0], x, y, comp, GetVopY(rec_prev),
                            GetVopHorSpatRef(rec_prev), GetVopVerSpatRef(rec_prev))) {
            fprintf(stderr, "GMC warping error\n");
            exit(-1);
          }
          PutMB (x, y, pred, comp->y_chan, width, mb_size); 

          if(GetVopShape(rec_prev) == GREY_SCALE) {
            for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */

              if (! GetPred_GMC(&pred[0], x, y, comp, GetVopG(n,rec_prev),
                                GetVopHorSpatRef(rec_prev), GetVopVerSpatRef(rec_prev))) {
                fprintf(stderr, "GMC warping error\n");
                exit(-1);
              }
              PutMB (x, y, pred, comp->g_chan[n], width, mb_size);
            }
          }
        } else 
          /* modified by NTT for GMC coding : end */
          /* MW QPEL 06-JUL-1998 */
          /* if (mode == MBM_INTER8 || mode == MBM_INTER16 */ 
          /* 	  || mode == MBM_SKIPPED)  */
          /* 	{ */
          if (mode == MBM_INTER8 || ((mode == MBM_INTER16 || mode == MBM_SKIPPED) && (overlap || !quarter_pel)) ) {
	  
            /* Do overlapped motion compensation 8x8 */
		
            /* Do Y-component first */

            /* MW QPEL 06-JUL-1998 */
            /* overlap = (obmc_disable)?0:1; */
                
            /* Minhua Zhou 14.04.97 -- added alpha_decisions */
            GetPred_Advanced (x, y, 
                              prev_x_min,prev_y_min,prev_x_max,prev_y_max,
                              mot_x, mot_y, quarter_pel, MB_decisions,/* MW QPEL 06-JUL-1998 */
                              alpha_decisions,
                              prev_ipol2, /** modified for NEWPRED (Oki) 16-AUG-1999 **/
                              pred_ptr0, 0, width,  /* >>> modified for DRC by Fujitsu <<< */
                              width_prev, mb_size,overlap,GetVopRoundingType(comp),
                              GetVopBrightWhite(comp), edge,/* MW QPEL 06-JUL-1998 */
                              GetVopInterlaced(comp),       /* HYUNDAI 980507 */
                              GetVopPredictionType(comp),   /* NTT for GMC coding */
                              GetVopReducedResolution(comp), /* >>> added for DRC by Fujitsu <<< */
                                /** added for NEWPRED (Oki) 16-AUG-1999 **/
                              GetVopNewpredEnable(comp),	/* NEWPRED enable flag */
                              num_segments,			/* number of NEWPRED segments per VOP */
                              mba_segment);			/* MB address of each NEWPRED segment */
            /** end of NEWPRED (Oki) 16-AUG-1999 **/
            GetPred_Advanced (x, y, 
                              prev_x_min,prev_y_min,prev_x_max,prev_y_max,
                              mot_x, mot_y, quarter_pel, MB_decisions,/* MW QPEL 06-JUL-1998 */
                              alpha_decisions,
                              prev_ipol2, /** modified for NEWPRED (Oki) 16-AUG-1999 **/
                              pred_ptr1, 1, width,  /* >>> modified for DRC by Fujitsu <<< */
                              width_prev, mb_size, overlap,GetVopRoundingType(comp),
                              GetVopBrightWhite(comp), edge,/* MW QPEL 06-JUL-1998 */
                              GetVopInterlaced(comp),       /* HYUNDAI 980507 */
                              GetVopPredictionType(comp),   /* NTT for GMC coding */
                              GetVopReducedResolution(comp), /* >>> added for DRC by Fujitsu <<< */
                                /** added for NEWPRED (Oki) 16-AUG-1999 **/
                              GetVopNewpredEnable(comp),	/* NEWPRED enable flag */
                              num_segments,			/* number of NEWPRED segments VOP */
                              mba_segment);			/* MB address of each NEWPRED segment */
            /** end of NEWPRED (Oki) 16-AUG-1999 **/
            GetPred_Advanced (x, y, 
                              prev_x_min,prev_y_min,prev_x_max,prev_y_max,
                              mot_x, mot_y, quarter_pel, MB_decisions,/* MW QPEL 06-JUL-1998 */
                              alpha_decisions,
                              prev_ipol2, /** modified for NEWPRED (Oki) 16-AUG-1999 **/
                              pred_ptr2, 2, width, /* >>> modified for DRC by Fujitsu <<< */
                              width_prev, mb_size, overlap,GetVopRoundingType(comp),
                              GetVopBrightWhite(comp), edge,/* MW QPEL 06-JUL-1998 */
                              GetVopInterlaced(comp),       /* HYUNDAI 980507 */
                              GetVopPredictionType(comp),   /* NTT for GMC coding */
                              GetVopReducedResolution(comp), /* >>> added for DRC by Fujitsu <<< */
                                /** added for NEWPRED (Oki) 16-AUG-1999 **/
                              GetVopNewpredEnable(comp),	/* NEWPRED enable flag */
                              num_segments,			/* number of NEWPRED segments per VOP */
                              mba_segment);			/* MB address of each NEWPRED segment */
            /** end of NEWPRED (Oki) 16-AUG-1999 **/
            GetPred_Advanced (x, y, 
                              prev_x_min,prev_y_min,prev_x_max,prev_y_max,
                              mot_x, mot_y, quarter_pel, MB_decisions,/* MW QPEL 06-JUL-1998 */
                              alpha_decisions,
                              prev_ipol2, /** modified for NEWPRED (Oki) 16-AUG-1999 **/
                              pred_ptr3, 3, width,  /* >>> modified for DRC by Fujitsu <<< */
                              width_prev, mb_size, overlap,GetVopRoundingType(comp),
                              GetVopBrightWhite(comp), edge,/* MW QPEL 06-JUL-1998 */
                              GetVopInterlaced(comp),       /* HYUNDAI 980507 */
                              GetVopPredictionType(comp),   /* NTT for GMC coding */
                              GetVopReducedResolution(comp), /* >>> added for DRC by Fujitsu <<< */
                                /** added for NEWPRED (Oki) 16-AUG-1999 **/
                              GetVopNewpredEnable(comp),	/* NEWPRED enable flag */
                              num_segments,			/* number of NEWPRED segments per VOP */
                              mba_segment);			/* MB address of each NEWPRED segment */
            /** end of NEWPRED (Oki) 16-AUG-1999 **/
/* >>> added for DRC by Fujitsu (top)    <<< */
            if(GetVopReducedResolution(comp))
              PutMB_RR (x, y, pred_rr, comp->y_chan, width, mb_size); 
            else
/* >>> added for DRC by Fujitsu (bottom)    <<< */
              PutMB (x, y, pred, comp->y_chan, width, mb_size); 

            /* HYUNDAI (Grayscale) */
            if(GetVopShape(rec_prev) == GREY_SCALE) {

              for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */

                if (mode == MBM_INTER8) { /* MW QPEL 06-JUL-1998 */
                  GetPred_Advanced (x, y,
                                    prev_x_min,prev_y_min,prev_x_max,prev_y_max,
                                    mot_x, mot_y, quarter_pel, MB_decisions,/* MW QPEL 06-JUL-1998 */
                                    alpha_decisions,
                                    g_prev_ipol[n], &pred[0][0], 0, width,
                                    width_prev, mb_size,0,GetVopRoundingType(comp), 255, edge,
                                    GetVopInterlaced(comp),/* MW QPEL 06-JUL-1998 */
                                    GetVopPredictionType(comp),  /* NTT for GMC coding */
                                    0, /* >>> added for DRC by Fujitsu <<< */
                                    0,1,NULL);	/** modified for NEWPRED (Oki) 16-AUG-1999 **/
                  GetPred_Advanced (x, y,
                                    prev_x_min,prev_y_min,prev_x_max,prev_y_max,
                                    mot_x, mot_y, quarter_pel, MB_decisions,/* MW QPEL 06-JUL-1998 */
                                    alpha_decisions,
                                    g_prev_ipol[n], &pred[0][8], 1, width,
                                    width_prev, mb_size,0,GetVopRoundingType(comp), 255, edge,
                                    GetVopInterlaced(comp),/* MW QPEL 06-JUL-1998 */
                                    GetVopPredictionType(comp),  /* NTT for GMC coding */
                                    0, /* >>> added for DRC by Fujitsu <<< */
                                    0,1,NULL);	/** modified for NEWPRED (Oki) 16-AUG-1999 **/
                  GetPred_Advanced (x, y,
                                    prev_x_min,prev_y_min,prev_x_max,prev_y_max,
                                    mot_x, mot_y, quarter_pel, MB_decisions,/* MW QPEL 06-JUL-1998 */
                                    alpha_decisions,
                                    g_prev_ipol[n], &pred[8][0], 2, width,
                                    width_prev, mb_size,0,GetVopRoundingType(comp), 255, edge,
                                    GetVopInterlaced(comp),/* MW QPEL 06-JUL-1998 */
                                    GetVopPredictionType(comp),  /* NTT for GMC coding */
                                    0, /* >>> added for DRC by Fujitsu <<< */
                                    0,1,NULL);	/** modified for NEWPRED (Oki) 16-AUG-1999 **/
                  GetPred_Advanced (x, y,
                                    prev_x_min,prev_y_min,prev_x_max,prev_y_max,
                                    mot_x, mot_y, quarter_pel, MB_decisions,/* MW QPEL 06-JUL-1998 */
                                    alpha_decisions,
                                    g_prev_ipol[n], &pred[8][8], 3, width,
                                    width_prev, mb_size,0,GetVopRoundingType(comp), 255, edge,
                                    GetVopInterlaced(comp),/* MW QPEL 06-JUL-1998 */
                                    GetVopPredictionType(comp),  /* NTT for GMC coding */
                                    0, /* >>> added for DRC by Fujitsu <<< */
                                    0,1,NULL);	/** modified for NEWPRED (Oki) 16-AUG-1999 **/
                  PutMB (x, y, pred, comp->g_chan[n], width, mb_size);
                  /* MW QPEL 06-JUL-1998 >>*/
                } else {
                  GetPred_Default (x, y, mot_x, mot_y, quarter_pel, g_prev_ipol[n], &pred[0], &pred_rr[0], 
                                   width, width_prev,/* MW QPEL 06-JUL-1998 */ /* >>> added for DRC by Fujitsu <<< */
                                   mb_size,GetVopRoundingType(comp), 255, /* MW QPEL 06-JUL-1998 */
                                   0, /* >>> added for DRC by Fujitsu <<< */
                                   prev_x_min,prev_y_min,prev_x_max,prev_y_max);/* MW QPEL 06-JUL-1998 */
                  PutMB (x, y, pred, comp->g_chan[n], width, mb_size);
                }
                /* << MW QPEL 06-JUL-1998 */
              }
            }
          }
          else if ((mode >= MBM_FIELD00) && (mode <= MBM_FIELD11)) {
            /* HYUNDAI 980507 :  start*/
            GetPred_Field(j, i, mot_x, mot_y, edge, prev_recon->y_chan, comp->y_chan,
                          mode - MBM_FIELD00, comp->rounding_type,
                          prev_x_min/2,prev_y_min/2,prev_x_max/2,prev_y_max/2,quarter_pel, GetVopBrightWhite(comp));/* MW QPEL 06-JUL-1998 */
            /* HYUNDAI (Grayscale) */
            if(GetVopShape(rec_prev) == GREY_SCALE) {
              for(n=0;n<GetVopAuxCompCount(comp);n++) {/* MAC (SB) 12-Nov-99 */
                GetPred_Field(j, i, mot_x, mot_y, edge, prev_recon->g_chan[n], comp->g_chan[n],
                              mode - MBM_FIELD00, comp->rounding_type,
                              prev_x_min/2,prev_y_min/2,prev_x_max/2,prev_y_max/2,quarter_pel, 255);/* MW QPEL 06-JUL-1998 */
              }
            }
            /* HYUNDAI 980507 :  end*/
          }
          else if (GetVopSpriteUsage(comp) == STATIC_SPRITE 
                   || GetVopSpriteUsage(comp) == GMC_SPRITE	/* NTT for GMC coding */
                   || GetVopSpriteUsage(comp) == SPRITE_NOT_USED) {		
            /* Do default motion compensation 16x16 */
            GetPred_Default (x, y, mot_x, mot_y, quarter_pel, 
                             prev_ipol2,	/** modified for NEWPRED (Oki) 16-AUG-1999 **/
                             &pred[0],/* MW QPEL 06-JUL-1998 */
                             &pred_rr[0],/* >>> added for DRC by Fujitsu <<< */
                             width, width_prev, mb_size,GetVopRoundingType(comp), GetVopBrightWhite(comp), /* MW QPEL 06-JUL-1998 */
                             GetVopReducedResolution(comp), /* >>> added for DRC by Fujitsu <<< */
                             prev_x_min,prev_y_min,prev_x_max,prev_y_max);/* MW QPEL 06-JUL-1998 */
/* >>> added for DRC by Fujitsu (top)    <<< */
            if(GetVopReducedResolution(comp))
              PutMB_RR (x, y, pred_rr, comp->y_chan, width, mb_size); 
            else
/* >>> added for DRC by Fujitsu (bottom)    <<< */
              PutMB (x, y, pred, comp->y_chan, width, mb_size); 

            /* HYUNDAI (Grayscale) */
            if(GetVopShape(rec_prev) == GREY_SCALE) {
              for(n=0;n<GetVopAuxCompCount(comp);n++) {/* MAC (SB) 12-Nov-99 */
                GetPred_Default (x, y, mot_x, mot_y, quarter_pel, g_prev_ipol[n], &pred[0], &pred_rr[0],
                                 width, width_prev,/* MW QPEL 06-JUL-1998 */ /* >>> added for DRC by Fujitsu <<< */
                                 mb_size,GetVopRoundingType(comp), 255, /* MW QPEL 06-JUL-1998 */
                                 0, /* >>> added for DRC by Fujitsu <<< */
                                 prev_x_min,prev_y_min,prev_x_max,prev_y_max);/* MW QPEL 06-JUL-1998 */
                PutMB (x, y, pred, comp->g_chan[n], width, mb_size);
              }
            }
          }	  
          else {
            /* Incorrect mode, give error message */
            printf("VopMotionCompensate: Incorrect motion mode %d\n",
                   (int)mode);
          }
      }               
    }
  }

  /* Do the Chrominance compensation */
  Compensate_Chroma (width_prev, mb_size, prev_recon, mot_x, mot_y,
                     prev_x_min/4,prev_y_min/4,prev_x_max/4,prev_y_max/4,
                     offset_mos_i0,offset_mos_j0, br_x, br_y,
                     MB_decisions, alpha_decisions, comp, edge);

/* MW QPEL 06-JUL-1998 >> */
#ifdef _DEBUG_PRED_
  if(up_cnt==0) {
    WriteVopGeneric(comp,"pred_mc.yuv","pred_mc.yuv","pred_mc.yuv","pred_mc.seg",
                    0, IO_FORMAT, IO_OVERWRITE, 1);
  } else {
    WriteVopGeneric(comp,"pred_mc.yuv","pred_mc.yuv","pred_mc.yuv","pred_mc.seg",
                    up_cnt, IO_FORMAT, IO_APPEND, 1);
  }
  up_cnt++;
#endif

  /* MW QPEL 06-JUL-1998 */
  if (!quarter_pel)
    FreeImage (pi);

    /* HYUNDAI (Grayscale) */ /* MW QPEL 06-JUL-1998 */
  if(GetVopShape(rec_prev)==GREY_SCALE && !quarter_pel)
    for(n=0;n<GetVopAuxCompCount(comp);n++) 	/* MAC (SB) 12-Nov-99 */
      FreeImage (g_pi[n]);

  SfreeVop (prev_recon);  
    
  /** added for NEWPRED (Oki) 16-AUG-1999 **/
  if(GetVopNewpredEnable(comp)){
    FreeImage(tmp_image_ipol);
    FreeImage(tmp_image);
  }
  /** end of NEWPRED (Oki) 16-AUG-1999 **/
}




Void Equalise1MVMBs(Image *MB_decisions, Image *mot_x, Image *mot_y)
{
  Int width = GetImageSizeX(MB_decisions),
    height = GetImageSizeY(MB_decisions),
    i,j;
	
  SInt mode;
					
  for (i = 0; i < height; i++)
  {
      for (j = 0; j < width; j++)
      {
	  mode = ModeMB(MB_decisions, j, i);
	  if (mode == MBM_INTER16)
	  {
	      mot_x->data->f[4*i*width+j*2+1] =
		  mot_x->data->f[4*i*width+j*2];
	      mot_x->data->f[(2*i+1)*2*width+j*2] =
		  mot_x->data->f[4*i*width+j*2];
	      mot_x->data->f[(2*i+1)*2*width+j*2+1] =
		  mot_x->data->f[4*i*width+j*2]; 

	      mot_y->data->f[4*i*width+j*2+1] =
		  mot_y->data->f[4*i*width+j*2]; 
	      mot_y->data->f[(2*i+1)*2*width+j*2] =
		  mot_y->data->f[4*i*width+j*2]; 
	      mot_y->data->f[(2*i+1)*2*width+j*2+1] =
		  mot_y->data->f[4*i*width+j*2]; 
	  }
      }
  }	    
}


Void MotionCompensateMB(
  Vop *rec_prev,
  Image *pi,
  Image *pi_g[MAX_MAC],/* U. Benzler 981209 : added interlaced greyscale support */ /* MAC (SB) 12-Nov-99 */
  Image *mot_x,
  Image *mot_y,
  Int	j, 
  Int   i,
  Int   obmc_disable,
  Image *alpha_decisions, 
  Image *MB_decisions,
  Vop *comp)
{
  Vop *pr_edge;
  
  Int width = GetVopWidth(comp);
  
  SInt pred[16][16];
  
  SInt *prev_ipol,
    *prev_g[MAX_MAC],/* U. Benzler 981209 : added interlaced greyscale support */ /* MAC (SB) 12-Nov-99 */
    *prev_u,
    *prev_v;
  
  Int x,y,overlap,edge, offset_x, offset_y, width_prev, mb_size=MB_SIZE, n;
  
  Int prev_x_min,prev_x_max,prev_y_min,prev_y_max;	
  
  SInt mode;	
  
  Int dx=0, dy=0;
  Int cols;
  Int xsum, ysum, divider;
  
  Int bmode;
  
  SInt *alpha;
  Float *xvec;
  Float *yvec;

  /* MW QPEL 09-JUL-1998 */
  Int quarter_pel = GetVopQuarterPel(comp);

  Int offset_mos_i0=0, offset_mos_j0=0;		/* NTT for GMC coding */

  for (y=0 ; y<16 ; y++)
    for (x=0 ; x<16 ; x++)
      /* Corrected for the 2nd time now, hope it stays MW 19-MAY-1998 */  
      /* pred[j][i]=0; */
      pred[y][x]=0;

  edge = 16;
  
  pr_edge = rec_prev;

  /* MW QPEL 09-JUL-1998 >> */
  if(quarter_pel)
    prev_ipol = (SInt *) GetImageData(GetVopY(rec_prev)) + 
      GetImageSizeX(GetVopY(rec_prev)) * edge + edge;
  else
  /* << MW QPEL 09-JUL-1998 */
    prev_ipol = (SInt *) GetImageData(pi) + GetImageSizeX(pi) * 2 * edge  
      + 2 * edge;

  /* The data pointers of prev_recon will point into the data
     areas of pr_edge */

	prev_u = (SInt *) GetImageData(GetVopU(pr_edge));
	prev_v = (SInt *) GetImageData(GetVopV(pr_edge));

  prev_u += (GetVopWidth(pr_edge)/2) * (edge/2) 
    + (edge/2);
  prev_v += (GetVopWidth(pr_edge)/2) * (edge/2) 
    + (edge/2);

  /* Compensate for the offset in spatial references
     between comp and rec_prev. This is done offseting the pointers
     into the MC routines and hence tricking them.
     */

  offset_x = GetVopHorSpatRef(comp) - GetVopHorSpatRef(rec_prev)-edge;
  offset_y = GetVopVerSpatRef(comp) - GetVopVerSpatRef(rec_prev)-edge;

  /* MW QPEL 09-JUL-1998 >> */
  if(quarter_pel)
    {
      prev_ipol += GetImageSizeX(GetVopY(rec_prev)) * offset_y + offset_x;
      if (GetVopShape(comp) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support */
        {
          for(n=0;n<GetVopAuxCompCount(comp);n++) {/* MAC (SB) 12-Nov-99 */
            prev_g[n] = (SInt *) GetImageData(GetVopG(n,rec_prev)) + 
              GetImageSizeX(GetVopG(n,rec_prev)) * (edge + offset_y) + edge + offset_x;
          }
	}
    }
  else
    {
      /* << MW QPEL 09-JUL-1998 */
      prev_ipol += GetImageSizeX(pi) * 2 * offset_y + 2 * offset_x;
      if (GetVopShape(comp) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support */
	{
          for(n=0;n<GetVopAuxCompCount(comp);n++) {/* MAC (SB) 12-Nov-99 */
            prev_g[n] = (SInt *) GetImageData(pi_g[n]) + GetImageSizeX(pi_g[n]) * 2 * (edge + offset_y) + 2 * (edge + offset_x);
          }
	}
    }
  prev_u += (GetVopWidth(pr_edge)/2) * (offset_y/2) 
    + (offset_x/2);
  prev_v += (GetVopWidth(pr_edge)/2) * (offset_y/2) 
    + (offset_x/2);

  /* Do the motion compensation */
  
  width_prev = GetImageSizeX(GetVopY(pr_edge));

  prev_x_min = 2*GetVopHorSpatRef(rec_prev)-2*GetVopHorSpatRef(comp)+2*edge;
  prev_y_min = 2*GetVopVerSpatRef(rec_prev)-2*GetVopVerSpatRef(comp)+2*edge;
  prev_x_max = prev_x_min + 2*width_prev-4*edge;
  prev_y_max = prev_y_min + 2*GetImageSizeY(GetVopY(pr_edge))-4*edge; 

  /* modified by NTT for GMC coding : start */
  if (GetVopSpriteUsage(comp)==GMC_SPRITE) {
      offset_mos_i0 = GetVopHorSpatRef(rec_prev);
      offset_mos_j0 = GetVopVerSpatRef(rec_prev);
  }  
  /* modified by NTT for GMC coding : end */

  mode = ModeMB(MB_decisions, j, i);

  /* MW QPEL 09-JUL-1998 */
  overlap = (obmc_disable)?0:1;

  if (mode == MBM_INTER16 || mode == MBM_INTER8 ||
      mode == MBM_SPRITE ||	/* modified by NTT for GMC coding */
      mode == MBM_SKIPPED)
    {		
      x = j * mb_size;
      y = i * mb_size;
      
/* modified by NTT for GMC coding : start */
      if ((mode==MBM_SPRITE || mode == MBM_SKIPPED) &&
	  GetVopPredictionType(comp) == SPRITE_VOP && GetVopSpriteUsage(comp) == GMC_SPRITE) {
	  if (! GetPred_GMC(&pred[0], x, y, comp, GetVopY(rec_prev),
			    GetVopHorSpatRef(rec_prev), GetVopVerSpatRef(rec_prev))) {
	      fprintf(stderr, "GMC warping error\n");
	      exit(-1);
	  }
	  PutMB (x, y, pred, comp->y_chan, width, mb_size); 

	  if(GetVopShape(rec_prev) == GREY_SCALE) {
            for(n=0;n<GetVopAuxCompCount(comp);n++) {/* MAC (SB) 12-Nov-99 */
	      if (! GetPred_GMC(&pred[0], x, y, comp, GetVopG(n,rec_prev),
				GetVopHorSpatRef(rec_prev), GetVopVerSpatRef(rec_prev))) {
                fprintf(stderr, "GMC warping error\n");
                exit(-1);
	      }
	      PutMB (x, y, pred, comp->g_chan[n], width, mb_size);
            }
	  }
      } else 
/* modified by NTT for GMC coding : end */
      /* MW QPEL 09-JUL-1998 */
      /* if (mode == MBM_INTER8 || mode == MBM_INTER16  */
      /*   || mode== MBM_SKIPPED)   */
      if (mode == MBM_INTER8 || ((mode == MBM_INTER16 ||mode == MBM_SKIPPED) && overlap)) 
	{
	  /* Do overlapped motion compensation 8x8 */
	  /* Do Y-component first */

	  /* MW QPEL 09-JUL-1998 */
	  /* overlap =  */
	  /*   (obmc_disable)?0:1; */
	  
	  /* Minhua Zhou 14.04.97 -- added 
	     alpha_decisions */
	  GetPred_Advanced (x, y, 
			    prev_x_min,prev_y_min,prev_x_max,prev_y_max,
			    mot_x, mot_y, quarter_pel /* MW QPEL 09-JUL-1998 */, MB_decisions,
			    alpha_decisions,
			    prev_ipol, &pred[0][0], 0, width,
			    width_prev, 
			    mb_size,overlap, GetVopRoundingType(comp), GetVopBrightWhite(comp), edge/* MW QPEL 06-JUL-1998 */,
			    GetVopInterlaced(comp), /* HYUNDAI 980507 */
			    GetVopPredictionType(comp), /* NTT for GMC coding */
                            0, /* >>> added for DRC by Fujitsu <<< */
			    0,1,NULL);	/** added for NEWPRED (Oki) 16-AUG-1999 **/
	  GetPred_Advanced (x, y, 
			    prev_x_min,prev_y_min,prev_x_max,prev_y_max,
			    mot_x, mot_y, quarter_pel /* MW QPEL 09-JUL-1998 */, 
			    MB_decisions,
			    alpha_decisions,
			    prev_ipol, 
			    &pred[0][8], 1, width,
			    width_prev, 
			    mb_size, overlap, GetVopRoundingType(comp), GetVopBrightWhite(comp), edge/* MW QPEL 06-JUL-1998 */,
			    GetVopInterlaced(comp), /* HYUNDAI 980507 */
			    GetVopPredictionType(comp), /* NTT for GMC coding */
                            0, /* >>> added for DRC by Fujitsu <<< */
			    0,1,NULL);	/** added for NEWPRED (Oki) 16-AUG-1999 **/
	  GetPred_Advanced (x, y, 
			    prev_x_min,prev_y_min,prev_x_max,prev_y_max,
			    mot_x, mot_y, quarter_pel /* MW QPEL 09-JUL-1998 */, MB_decisions,
			    alpha_decisions,
			    prev_ipol, 
			    &pred[8][0], 2, width,
			    width_prev, 
			    mb_size, overlap, GetVopRoundingType(comp), GetVopBrightWhite(comp), edge/* MW QPEL 06-JUL-1998 */,
			    GetVopInterlaced(comp), /* HYUNDAI 980507 */
			    GetVopPredictionType(comp), /* NTT for GMC coding */
                            0, /* >>> added for DRC by Fujitsu <<< */
			    0,1,NULL);	/** added for NEWPRED (Oki) 16-AUG-1999 **/
	  GetPred_Advanced (x, y, 
			    prev_x_min,prev_y_min,prev_x_max,prev_y_max,
			    mot_x, mot_y, quarter_pel /* MW QPEL 09-JUL-1998 */, MB_decisions,
			    alpha_decisions,
			    prev_ipol, 
			    &pred[8][8], 3, width,
			    width_prev, 
			    mb_size, overlap, GetVopRoundingType(comp), GetVopBrightWhite(comp), edge/* MW QPEL 06-JUL-1998 */,
			    GetVopInterlaced(comp), /* HYUNDAI 980507 */
			    GetVopPredictionType(comp), /* NTT for GMC coding */
                            0, /* >>> added for DRC by Fujitsu <<< */
			    0,1,NULL);	/** added for NEWPRED (Oki) 16-AUG-1999 **/
	  PutMB (x, y, pred, comp->y_chan, width, 
		 mb_size); 
	  if (GetVopShape(comp) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support */
	    {
              for(n=0;n<GetVopAuxCompCount(comp);n++) {/* MAC (SB) 12-Nov-99 */
                GetPred_Advanced (x, y, 
                                  prev_x_min,prev_y_min,prev_x_max,prev_y_max,
                                  mot_x, mot_y, quarter_pel /* MW QPEL 09-JUL-1998 */, MB_decisions,
                                  alpha_decisions,
                                  prev_g[n], &pred[0][0], 0, width,
                                  width_prev, 
                                  mb_size,0, GetVopRoundingType(comp), 255, edge/* MW QPEL 06-JUL-1998 */,
                                  GetVopInterlaced(comp), /* HYUNDAI 980507 */
                                  GetVopPredictionType(comp), /* NTT for GMC coding */
                                  0, /* >>> added for DRC by Fujitsu <<< */
                                  0,1,NULL);	/** added for NEWPRED (Oki) 16-AUG-1999 **/
                GetPred_Advanced (x, y, 
                                  prev_x_min,prev_y_min,prev_x_max,prev_y_max,
                                  mot_x, mot_y, quarter_pel /* MW QPEL 09-JUL-1998 */, 
                                  MB_decisions,
                                  alpha_decisions,
                                  prev_g[n], 
                                  &pred[0][8], 1, width,
                                  width_prev, 
                                  mb_size, 0, GetVopRoundingType(comp), 255, edge/* MW QPEL 06-JUL-1998 */,
                                  GetVopInterlaced(comp), /* HYUNDAI 980507 */
                                  GetVopPredictionType(comp), /* NTT for GMC coding */
                                  0, /* >>> added for DRC by Fujitsu <<< */
                                  0,1,NULL);	/** added for NEWPRED (Oki) 16-AUG-1999 **/
                GetPred_Advanced (x, y, 
                                  prev_x_min,prev_y_min,prev_x_max,prev_y_max,
                                  mot_x, mot_y, quarter_pel /* MW QPEL 09-JUL-1998 */, MB_decisions,
                                  alpha_decisions,
                                  prev_g[n], 
                                  &pred[8][0], 2, width,
                                  width_prev, 
                                  mb_size, 0, GetVopRoundingType(comp), 255, edge/* MW QPEL 06-JUL-1998 */,
                                  GetVopInterlaced(comp), /* HYUNDAI 980507 */
                                  GetVopPredictionType(comp), /* NTT for GMC coding */
                                  0, /* >>> added for DRC by Fujitsu <<< */
                                  0,1,NULL);	/** added for NEWPRED (Oki) 16-AUG-1999 **/
                GetPred_Advanced (x, y, 
                                  prev_x_min,prev_y_min,prev_x_max,prev_y_max,
                                  mot_x, mot_y, quarter_pel /* MW QPEL 09-JUL-1998 */, MB_decisions,
                                  alpha_decisions,
                                  prev_g[n], 
                                  &pred[8][8], 3, width,
                                  width_prev, 
                                  mb_size, 0, GetVopRoundingType(comp), 255, edge/* MW QPEL 06-JUL-1998 */,
                                  GetVopInterlaced(comp), /* HYUNDAI 980507 */
                                  GetVopPredictionType(comp), /* NTT for GMC coding */
                                  0, /* >>> added for DRC by Fujitsu <<< */
                                  0,1,NULL);	/** added for NEWPRED (Oki) 16-AUG-1999 **/
                PutMB (x, y, pred, comp->g_chan[n], width, mb_size ); 
              }
	    }
	}
      else if  (GetVopSpriteUsage(comp) == STATIC_SPRITE ||
		GetVopSpriteUsage(comp) == GMC_SPRITE ||	/* NTT for GMC coding */
		GetVopSpriteUsage(comp) == SPRITE_NOT_USED)  
	{		
	  /* Do default motion compensation 16x16 */
	  GetPred_Default (x, y, mot_x, mot_y, quarter_pel /* MW QPEL 09-JUL-1998 */, prev_ipol, 
			   &pred[0],
                           NULL, /* >>> added for DRC by Fujitsu <<< */
			   width, 
			   width_prev, mb_size, GetVopRoundingType(comp), GetVopBrightWhite(comp), /* MW QPEL 06-JUL-1998 */
                           0, /* >>> added for DRC by Fujitsu <<< */
			   prev_x_min,prev_y_min,prev_x_max,prev_y_max/* MW QPEL 06-JUL-1998 */);
	  PutMB (x, y, pred, comp->y_chan, width, 
		 mb_size); 
	  if (GetVopShape(comp) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support */
	    {
              for(n=0;n<GetVopAuxCompCount(comp);n++) {/* MAC (SB) 12-Nov-99 */
                GetPred_Default (x, y, mot_x, mot_y, quarter_pel /* MW QPEL 09-JUL-1998 */, prev_g[n], 
                                 &pred[0],
                                 NULL, /* >>> added for DRC by Fujitsu <<< */
                                 width,width_prev, mb_size,
                                 GetVopRoundingType(comp), 255, /* MW QPEL 06-JUL-1998 */
                                 0, /* >>> added for DRC by Fujitsu <<< */
                                 prev_x_min,prev_y_min,prev_x_max,prev_y_max/* MW QPEL 06-JUL-1998 */);
                PutMB (x, y, pred, comp->g_chan[n], width, mb_size); 
              }
	    }
	}	  
      else
	{
		  		/* Incorrect mode, give error message */
	  printf("VopMotionCompensate: Incorrect motion mode %d\n",(int)mode);
	}
    }
  
  xvec = (Float *) GetImageData (mot_x);
  yvec = (Float *) GetImageData (mot_y);
  
  alpha = (SInt *) GetImageData (alpha_decisions);
  
  cols = width/mb_size;
  
/* modified by NTT for GMC coding : start */
  if ((MB_decisions->data->s[i*cols+j] == MBM_SPRITE ||
       MB_decisions->data->s[i*cols+j] == MBM_SKIPPED) &&
      GetVopPredictionType(comp) == SPRITE_VOP &&
      GetVopSpriteUsage(comp) == GMC_SPRITE) {
      GetPred_GMC_Chrom(j*mb_size, i*mb_size, rec_prev, comp, offset_mos_i0, offset_mos_j0);
  } else
/* modified by NTT for GMC coding : end */
  /* 16 by 16 vectors or skipped MBs */
  if (MB_decisions->data->s[i*cols+j] == MBM_INTER16 ||
      MB_decisions->data->s[i*cols+j] == MBM_SKIPPED)
    {
      dx = 2 * xvec[(i*2)*cols*2+j*2];
      dy = 2 * yvec[(i*2)*cols*2+j*2];
      dx = ( dx % 4 == 0 ? dx >> 1 : (dx>>1)|1 );
      dy = ( dy % 4 == 0 ? dy >> 1 : (dy>>1)|1 );
      GetPred_Chroma1 (j*mb_size, i*mb_size, dx, dy, prev_u, prev_v,
		       comp, width, width_prev,
		       prev_x_min/4,prev_y_min/4,prev_x_max/4,prev_y_max/4,
		       GetVopInterlaced(comp) /* HYUNDAI 980507 */);
    }
  /* 8 by 8 vectors */
  else if (MB_decisions->data->s[i*cols+j] == MBM_INTER8)
    {
      divider = xsum = ysum = 0;
      bmode = alpha[i*4*cols+2*j];
      if (bmode == 1 || bmode == 3 || bmode == 4 || bmode == 5)
	{
	  xsum += (Int)(2 * xvec[(i*2)*cols*2+j*2]); /* MW 06-JUL-1998 */
	  ysum += (Int)(2 * yvec[(i*2)*cols*2+j*2]); /* MW 06-JUL-1998 */
	  divider++;
	}
      
      bmode = alpha[i*4*cols+2*j+1];
      if (bmode == 1 || bmode == 3 || bmode == 4 || bmode == 5)
	{
	  xsum += (Int)(2 * xvec[(i*2)*cols*2+j*2+1]); /* MW 06-JUL-1998 */
	  ysum += (Int)(2 * yvec[(i*2)*cols*2+j*2+1]); /* MW 06-JUL-1998 */
	  divider++;
	}
      
      bmode = alpha[(i*2+1)*2*cols+2*j];
      if (bmode == 1 || bmode == 3 || bmode == 4 || bmode == 5)
	{
	  xsum += (Int)(2 * xvec[(i*2+1)*cols*2+j*2]); /* MW 06-JUL-1998 */
	  ysum += (Int)(2 * yvec[(i*2+1)*cols*2+j*2]); /* MW 06-JUL-1998 */
	  divider++;
	}
      
      bmode = alpha[(i*2+1)*2*cols+2*j+1];
      if (bmode == 1 || bmode == 3 || bmode == 4 || bmode == 5)
	{
	  xsum += (Int)(2 * xvec[(i*2+1)*cols*2+j*2+1]); /* MW 06-JUL-1998 */
	  ysum += (Int)(2 * yvec[(i*2+1)*cols*2+j*2+1]); /* MW 06-JUL-1998 */
	  divider++;
	}
      
      switch (divider)
	{
	case 1:
	  dx = SIGN (xsum) * (roundtab4[ABS (xsum) % 4]
			      + (ABS (xsum) / 4) * 2);
	  dy = SIGN (ysum) * (roundtab4[ABS (ysum) % 4]
			      + (ABS (ysum) / 4) * 2);
	  break;
	case 2:
	  dx = SIGN (xsum) * (roundtab8[ABS (xsum) % 8]
			      + (ABS (xsum) / 8) * 2);
	  dy = SIGN (ysum) * (roundtab8[ABS (ysum) % 8]
			      + (ABS (ysum) / 8) * 2);
	  break;
	case 3:
	  dx = SIGN (xsum) * (roundtab12[ABS (xsum) % 12]
			      + (ABS (xsum) / 12) * 2);
	  dy = SIGN (ysum) * (roundtab12[ABS (ysum) % 12]
			      + (ABS (ysum) / 12) * 2);
	  break;
	case 4:
	  dx = SIGN (xsum) * (roundtab16[ABS (xsum) % 16]
			      + (ABS (xsum) / 16) * 2);
	  dy = SIGN (ysum) * (roundtab16[ABS (ysum) % 16]
			      + (ABS (ysum) / 16) * 2);
	  break;
	default:
	  fprintf (stderr, "Error in Compensate_Chroma (): No blocks inside the Vop for this macroblock %d,%d\n", (int)j, (int)i);
	  exit (-1);
	  break;
	}
      GetPred_Chroma1 (j*mb_size, i*mb_size, dx, dy, prev_u, prev_v,
		       comp, width, 
		       width_prev,prev_x_min/4,prev_y_min/4,prev_x_max/4,prev_y_max/4,
		       GetVopInterlaced(comp) /* HYUNDAI 980507 */);
    }
  
#ifdef _DEBUG_  
  mode = ModeMB(MB_decisions, j, i);
  if (mode == MBM_INTER8 || mode == MBM_INTER16)
    {
      if (mode == MBM_INTER8)
      fprintf(stdout, "mode(%d,%d) = MBM_INTER8\n",j,i);
      else
      fprintf(stdout, "mode(%d,%d) = MBM_INTER16\n",j,i);
      
      fprintf(stdout, "X: %5.2f %5.2f %5.2f %5.2f  ",
	      mot_x->data->f[4*i*width/MB_SIZE+j*2],
	      mot_x->data->f[4*i*width/MB_SIZE+j*2+1],
	      mot_x->data->f[(2*i+1)*2*width/MB_SIZE+j*2],
	      mot_x->data->f[(2*i+1)*2*width/MB_SIZE+j*2+1]);
      fprintf(stdout, "\n");
      fprintf(stdout, "Y: %5.2f %5.2f %5.2f %5.2f  ",
	      mot_y->data->f[4*i*width/MB_SIZE+j*2],
	      mot_y->data->f[4*i*width/MB_SIZE+j*2+1],
	      mot_y->data->f[(2*i+1)*2*width/MB_SIZE+j*2],
	      mot_y->data->f[(2*i+1)*2*width/MB_SIZE+j*2+1]);
      
      
    }
  fprintf(stdout, "\n\n"); 
#endif
}

Void FillErrorMB(Vop *curr, Vop *rec_curr, Vop *pred, Vop *error, Int i, Int j)
{
  Int n;
  Image *currMB = AllocImage(MB_SIZE,MB_SIZE,SHORT_TYPE),
    *predMB = AllocSameImage(currMB),
    *errorMB = AllocSameImage(currMB),
    *currCMB = AllocImage(MB_SIZE/2,MB_SIZE/2,SHORT_TYPE),
    *predCMB = AllocSameImage(currCMB),
    *errorCMB = AllocSameImage(currCMB);

  GetSubImage(GetVopY(curr),currMB,i*MB_SIZE,j*MB_SIZE);
  GetSubImage(GetVopY(pred),predMB,i*MB_SIZE,j*MB_SIZE);
  SubImage(currMB,predMB,errorMB);
  PutSubImage(GetVopY(error),errorMB,i*MB_SIZE,j*MB_SIZE);
  /* U. Benzler 981209 : added interlaced greyscale support >>*/
  if(GetVopShape(curr) == GREY_SCALE)
  {
    for(n=0;n<GetVopAuxCompCount(curr);n++) {/* MAC (SB) 12-Nov-99 */
      GetSubImage(GetVopG(n,curr),currMB,i*MB_SIZE,j*MB_SIZE);
      GetSubImage(GetVopG(n,pred),predMB,i*MB_SIZE,j*MB_SIZE);
      SubImage(currMB,predMB,errorMB);
      PutSubImage(GetVopG(n,error),errorMB,i*MB_SIZE,j*MB_SIZE);
    }
  }
  /* U. Benzler 981209 : added interlaced greyscale support <<*/
  
  FreeImage(currMB);
  FreeImage(predMB);
  FreeImage(errorMB);
  
  GetSubImage(GetVopU(curr),currCMB,i*MB_SIZE/2,j*MB_SIZE/2);
  GetSubImage(GetVopU(pred),predCMB,i*MB_SIZE/2,j*MB_SIZE/2);
  SubImage(currCMB,predCMB,errorCMB);
  PutSubImage(GetVopU(error),errorCMB,i*MB_SIZE/2,j*MB_SIZE/2);
  
  GetSubImage(GetVopV(curr),currCMB,i*MB_SIZE/2,j*MB_SIZE/2);
  GetSubImage(GetVopV(pred),predCMB,i*MB_SIZE/2,j*MB_SIZE/2);
  SubImage(currCMB,predCMB,errorCMB);
  PutSubImage(GetVopV(error),errorCMB,i*MB_SIZE/2,j*MB_SIZE/2);
  FreeImage(currCMB);
  FreeImage(predCMB);
  FreeImage(errorCMB);
}

/***********************************************************CommentBegin******
 *
 * -- PutMB -- Puts a MB prediction into the compensated image 
 *
 * Author :		
 *	Robert Danielsen <Robert.Danielsen@nta.no>
 *
 * Created :		
 *	06.03.96
 *
 * Purpose :		
 *	Puts a MB prediction into the compensated image 
 * 
 * Arguments in : 	
 *	
 *
 * Arguments in/out :	
 *	
 *
 * Arguments out :	
 *	
 *
 * Return values :	
 *	
 *
 * Side effects :	
 *	
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :	06.09.99 Eishi Morimatsu (Fujitsu Labs.): created PutMB_RR for DRC
 *	
 *
 ***********************************************************CommentEnd********/

Void
PutMB (Int x,
       Int y,
       SInt pred[][16],
       Image *comp_image,
       Int width,
       Int mb_size)
{
  Int m, n;

  for (m = 0; m < mb_size; m++)
    for (n = 0; n < mb_size; n++)
      comp_image->f[(y+m)*width+x+n] = (SInt) pred[m][n];
}

/* >>> added for DRC by Fujitsu (top)    <<< */
Void
PutMB_RR (Int x,
       Int y,
       SInt pred[][32],
       Image *comp_image,
       Int width,
       Int mb_size)
{
  Int m, n;

  for (m = 0; m < mb_size; m++)
    for (n = 0; n < mb_size; n++)
      comp_image->f[(y+m)*width+x+n] = (SInt) pred[m][n];
}
/* >>> added for DRC by Fujitsu (bottom) <<< */

/***********************************************************CommentBegin******
 *
 * -- Compensate_Chroma -- Does motion compensation for chrominance components
 *
 * Author :		
 *	Robert Danielsen <Robert.Danielsen@nta.no>
 *
 * Created :		
 *	06.03.96
 *
 * Purpose :		
 *	Does motion compensation for chrominance components
 * 
 * Arguments in : 	
 *	Int width_prev		Width of previous Vop instance
 *	Int mb_size		Macroblock size (usually 16)
 *	Int offset_i0, 
 *	Int offset_j0 		Change coordinates between sprite and VOP 
 *
 * Arguments in/out :	
 *	Vop *prev_image		Previous reconstructed image
 *	Image *mot_x		Motion vectors, x component
 *	Image *mot_y		Motion vectors, y component
 *	Image *MB_decisions	Macroblock modes
 *
 * Arguments out :	
 *	Vop *comp_Vop		Vop to be filled with compensated data
 *
 * Return values :	
 *	
 *
 * Side effects :	
 *	
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *	25.04.96 Added extra parameter 'width_prev' to allow operation
 *		when the compensated vop and the reference vop are of different
 *						sizes. Noel Brady.
 *	28.05.96 Robert Danielsen: Removed half_pel variable. Doubling the
 *		float vector directly instead.
 *	14.06.96: Robert Danielsen: Added alpha_information for correct
 *		calculation of the chroma vector in advanced motion mode.
 *		Also did a workaround for the mismatch in encoder and decoder
 *		macroblock and block modes.
 *	07-Feb-1997, M.Wollborn: changed in order to treat skipped MBs
 *		     correctly 
 *  11.12.97  Bob Eifrig  Added field motion compensation
 *	07.05.98 Jong Deuk Kim (HYUNDAI): field-based MC  
 *      31.08.98 Guido Heising GMC-, ONLINE_SPRITE deleted for version 1 
 *	03.03.99 Seishi TAKAMURA (NTT): added GMC coding
 *
 ***********************************************************CommentEnd********/

Void
Compensate_Chroma (Int width_prev,
		   Int mb_size,
		   Vop *prev_image,
		   Image *mot_x,
		   Image *mot_y,
		   Int prev_x_min,
		   Int prev_y_min,
		   Int prev_x_max,
		   Int prev_y_max,
		   Int offset_i0,
		   Int offset_j0,
		   Int br_x, Int br_y,
		   Image *MB_decisions,
		   Image *alpha_decisions,
		   Vop *comp_Vop,
           Int edge)
{

  struct mvector {
    Int x;
    Int y;
  };

  Int i, j;
  Int dx=0, dy=0;
  Int cols;
  Int xsum, ysum, divider;

  Int bmode;
  
  SInt *alpha;
  Float *xvec;
  Float *yvec;
  
  Int width = GetVopWidth (comp_Vop);
  Int height = GetVopHeight (comp_Vop);

  xvec = (Float *) GetImageData (mot_x);
  yvec = (Float *) GetImageData (mot_y);
  
  alpha = (SInt *) GetImageData (alpha_decisions);
  
  cols = width/mb_size;
  
  for (i = 0; i < height/mb_size; i++)
    {
      for (j = 0; j < cols; j++)
	{

/* modified by NTT for GMC coding : start */
	if ((MB_decisions->data->s[i*cols+j] == MBM_SPRITE ||
	     MB_decisions->data->s[i*cols+j] == MBM_SKIPPED) &&
	    GetVopPredictionType(comp_Vop) == SPRITE_VOP &&
	    GetVopSpriteUsage(comp_Vop) == GMC_SPRITE) {
	    GetPred_GMC_Chrom(j*mb_size, i*mb_size, prev_image, comp_Vop, offset_i0, offset_j0);
	} else
/* modified by NTT for GMC coding : end */
	  /* 16 by 16 vectors or skipped MBs */
	  if (MB_decisions->data->s[i*cols+j] == MBM_INTER16 ||
	      MB_decisions->data->s[i*cols+j] == MBM_SKIPPED)
	    {
	      dx = 2 * xvec[(i*2)*cols*2+j*2];
	      dy = 2 * yvec[(i*2)*cols*2+j*2];
	      dx = ( dx % 4 == 0 ? dx >> 1 : (dx>>1)|1 );
	      dy = ( dy % 4 == 0 ? dy >> 1 : (dy>>1)|1 );
	      GetPred_Chroma (j*mb_size, i*mb_size, dx, dy, prev_image,
			      comp_Vop, width, width_prev,
                              prev_x_min,prev_y_min,prev_x_max,prev_y_max,
                              GetVopInterlaced(comp_Vop) /* HYUNDAI 980507 */);
	    }
        else if ((MB_decisions->data->s[i*cols+j] >= MBM_FIELD00) &&
                   (MB_decisions->data->s[i*cols+j] <= MBM_FIELD11)) {
/* HYUNDAI 980507 : start */
                GetPred_Field_Chroma(j,i,xvec,yvec,prev_image,comp_Vop,
                                MB_decisions->data->s[i*cols+j]-MBM_FIELD00,
                                edge, prev_x_min,prev_y_min,prev_x_max,prev_y_max);
/* HYUNDAI 980507 : end */

        }
	  /* 8 by 8 vectors */
	  else if (MB_decisions->data->s[i*cols+j] == MBM_INTER8)
	    {
	      divider = xsum = ysum = 0;
	      bmode = alpha[i*4*cols+2*j];
	      if (bmode == 1 || bmode == 3 || bmode == 4 || bmode == 5)
		{
		  xsum += (Int)(2 * xvec[(i*2)*cols*2+j*2]); /* MW 06-JUL-1998 */
		  ysum += (Int)(2 * yvec[(i*2)*cols*2+j*2]); /* MW 06-JUL-1998 */
		  divider++;
		}

	      bmode = alpha[i*4*cols+2*j+1];
	      if (bmode == 1 || bmode == 3 || bmode == 4 || bmode == 5)
		{
		  xsum += (Int)(2 * xvec[(i*2)*cols*2+j*2+1]); /* MW 06-JUL-1998 */
		  ysum += (Int)(2 * yvec[(i*2)*cols*2+j*2+1]); /* MW 06-JUL-1998 */
		  divider++;
		}

	      bmode = alpha[(i*2+1)*2*cols+2*j];
	      if (bmode == 1 || bmode == 3 || bmode == 4 || bmode == 5)
		{
		  xsum += (Int)(2 * xvec[(i*2+1)*cols*2+j*2]); /* MW 06-JUL-1998 */
		  ysum += (Int)(2 * yvec[(i*2+1)*cols*2+j*2]); /* MW 06-JUL-1998 */
		  divider++;
		}

	      bmode = alpha[(i*2+1)*2*cols+2*j+1];
	      if (bmode == 1 || bmode == 3 || bmode == 4 || bmode == 5)
		{
		  xsum += (Int)(2 * xvec[(i*2+1)*cols*2+j*2+1]); /* MW 06-JUL-1998 */
		  ysum += (Int)(2 * yvec[(i*2+1)*cols*2+j*2+1]); /* MW 06-JUL-1998 */
		  divider++;
		}

	      switch (divider)
		{
		case 1:
		  dx = SIGN (xsum) * (roundtab4[ABS (xsum) % 4]
				     + (ABS (xsum) / 4) * 2);
		  dy = SIGN (ysum) * (roundtab4[ABS (ysum) % 4]
				     + (ABS (ysum) / 4) * 2);
		  break;
		case 2:
		  dx = SIGN (xsum) * (roundtab8[ABS (xsum) % 8]
				     + (ABS (xsum) / 8) * 2);
		  dy = SIGN (ysum) * (roundtab8[ABS (ysum) % 8]
				     + (ABS (ysum) / 8) * 2);
		  break;
		case 3:
		  dx = SIGN (xsum) * (roundtab12[ABS (xsum) % 12]
				     + (ABS (xsum) / 12) * 2);
		  dy = SIGN (ysum) * (roundtab12[ABS (ysum) % 12]
				     + (ABS (ysum) / 12) * 2);
		  break;
		case 4:
		  dx = SIGN (xsum) * (roundtab16[ABS (xsum) % 16]
				     + (ABS (xsum) / 16) * 2);
		  dy = SIGN (ysum) * (roundtab16[ABS (ysum) % 16]
				     + (ABS (ysum) / 16) * 2);
		  break;
		default:
		  fprintf (stderr, "Error in Compensate_Chroma (): No blocks inside the Vop for this macroblock %d,%d\n", (int)j, (int)i);
		  exit (-1);
		  break;
		}
	      GetPred_Chroma (j*mb_size, i*mb_size, dx, dy, prev_image,
			      comp_Vop, width, 
width_prev,prev_x_min,prev_y_min,prev_x_max,prev_y_max,
                              GetVopInterlaced(comp_Vop) /* HYUNDAI 980507 */);
	    }
	}
    }
}  

/***********************************************************CommentBegin******
 *
 * -- ModeMB -- Get the MB mode 
 *
 * Author :		
 *	Noel Brady 
 *
 * Created :		
 *	
 *
 * Purpose :		
 *	Get the MB mode 
 * 
 * Arguments in : 	
 *	
 *
 * Arguments in/out :	
 *	
 *
 * Arguments out :	
 *	
 *
 * Return values :	
 *	
 *
 * Side effects :	
 *	
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *	
 *
 ***********************************************************CommentEnd********/

SInt ModeMB (Image *MB_decision, Int i, Int j)
{
  Int	width = MB_decision->x;
  SInt	*p = (SInt *)GetImageData(MB_decision);

  return p[width*j+i];
}

/***********************************************************CommentBegin******
 *
 * unrestricted_MC 
 *
 * Author :		
 *	Minhua Zhou 
 *
 * Created :		
 *	06.05.97
 *
 * Purpose :		
 *	To make unrestricted MC 
 *       
 * 
 * Arguments in : 	
 *	
 *
 * Arguments in/out :	
 *	
 *
 * Arguments out :	
 *	
 *
 * Return values :	
 *	
 *
 * Side effects :	
 *	
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *	07.05.98 Jond Deuk Kim (HYUNDAI): modified for field-based MC
 *	
 *
 ***********************************************************CommentEnd********/
Int unrestricted_MC(Int x,Int y, Int npix,
                           Int prev_x_min,Int prev_y_min,
                           Int prev_x_max, Int prev_y_max,
			   Int interlaced /* HYUNDAI 980507 */)
{
   
       if (x < prev_x_min) x = prev_x_min;
        else if (x >=prev_x_max-1) x = prev_x_max-2;

/* HYUNDAI (jdkim) start : 981020 */
       if (y < prev_y_min) y = prev_y_min;
          else if (y >=prev_y_max-1) y = prev_y_max-2;
        return(x+y*npix);
/* HYUNDAI (jdkim) end : 981020 */


/* HYUNDAI 980507 : start */
/* HYUNDAI (jdkim) deleted : 981020 */
#if 0
        if( interlaced )    
        {
            Int out_point = 0;

            if ( y < prev_y_min) 
            {
                out_point = abs(prev_y_min -y) % 4;
                switch(out_point)
                {
                    case 0 : y = prev_y_min; break;
                    case 1 :
                    case 3 : y = prev_y_min+1; break;
                    case 2 : y = prev_y_min+2; break;
                }
            }
            else if (y >=prev_y_max-1) 
            {
                out_point = (y-(prev_y_max-2))%4;
                switch(out_point)
                {
                    case 1 : if( (y-(prev_y_max-2)) == 33 )
                             {
                                y = prev_y_max-2;
                                break;
                             }
                    case 3 : y = prev_y_max-2-1; break;
                    case 2 : y = prev_y_max-2-2; break;
                    case 0 : y = prev_y_max-2;
                }
             }
             return(x+y*npix);
        }
        else
        {
             if (y < prev_y_min) y = prev_y_min;
             else if (y >=prev_y_max-1) y = prev_y_max-2;
             return(x+y*npix);
        }
 
#endif
/* HYUNDAI (jdkim)  end : 981020 */ 
/* HYUNDAI 980507 : end */
}

/* MW QPEL 06-JUL-1998 */
Void MakeUnrestricted_MC_QuarterPel(Int* x,Int *y,
                           Int prev_x_min,Int prev_y_min,
                           Int prev_x_max, Int prev_y_max) {
   
       if (*x < 2*prev_x_min) *x = 2*prev_x_min;
        else if (*x >2*prev_x_max) *x = 2*prev_x_max;
       if (*y < 2*prev_y_min) *y = 2*prev_y_min;
        else if (*y >2*prev_y_max) *y = 2*prev_y_max;
   }
/* MW QPEL 06-JUL-1998 */

Int unrestricted_MC_chro(Int x,Int y, Int npix,
                           Int prev_x_min,Int prev_y_min,
                           Int prev_x_max, Int prev_y_max,
			   Int interlaced /* HYUNDAI 980507 */) {
   
       if (x < prev_x_min) x = prev_x_min;
        else if (x >=prev_x_max) x = prev_x_max-1;


/* HYUNDAI (jdkim) start : 981020 */
       if (y < prev_y_min) y = prev_y_min;
        else if (y >=prev_y_max) y = prev_y_max-1;
/* HYUNDAI (jdkim) end : 981020 */


/* HYUNDAI 980507 : start */
/* HYUNDAI (jdkim) start : 981020 */
#if 0
        if( interlaced )
        {
           Int top_field=0;
           if (y < prev_y_min)
           {
                top_field = (prev_y_min-y)%2;
                if(!top_field) y=prev_y_min;
                else           y=prev_y_min+1;
            }
            else if (y >=prev_y_max)
            {
                top_field = (y-(prev_y_max-1))%2;
                if(top_field) y=prev_y_max-2;
                else           y=prev_y_max-1;
            }
        }
        else
        {
           if (y < prev_y_min) y = prev_y_min;
            else if (y >=prev_y_max) y = prev_y_max-1;
        }
#endif
/* HYUNDAI (jdkim) end : 981020 */
/* HYUNDAI 980507 : end */
        return(x+y*npix);
   }

/***********************************************************CommentBegin******
 *
 * unrestricted_MC_field
 *
 * Author :
 *      HYUNDAI - Jong Deuk Kim 
 *
 * Created :
 *      07.05.98
 *
 * Purpose :
 *      To make unrestricted MC for field-based MC
 *
 *
 * Arguments in :
 *
 *
 * Arguments in/out :
 *
 *
 * Arguments out :
 *
 *
 * Return values :
 *
 *
 * Side effects :
 *
 *
 * Description :
 *
 *
 * See also :
 *
 ***********************************************************CommentEnd********/

Int unrestricted_MC_field(Int x,Int y, Int npix,
                           Int prev_x_min,Int prev_y_min,
                           Int prev_x_max, Int prev_y_max)
{
 /*       prev_y_max --;  */   	/* HYUNDAI (jdkim) 981020 */
 
       if (x < prev_x_min) x = prev_x_min;
        else if (x >=prev_x_max) x = prev_x_max-1;
       if (y < prev_y_min) y = prev_y_min;
        else if (y >=prev_y_max) y = prev_y_max-1;
        return(x+y*npix);
}

/***********************************************************CommentBegin******
 *
 * unrestricted_MC_chro_field
 *
 * Author :
 *      HYUNDAI - Jong Deuk Kim
 *
 * Created :
 *      07.05.98
 *
 * Purpose :
 *      To make unrestricted MC for field-based MC
 *
 *
 * Arguments in :
 *
 *
 * Arguments in/out :
 *
 *
 * Arguments out :
 *
 *
 * Return values :
 *
 *
 * Side effects :
 *
 *
 * Description :
 *
 *
 * See also :
 *
 ***********************************************************CommentEnd********/

Int unrestricted_MC_chro_field(Int x,Int y, Int npix,
                           Int prev_x_min,Int prev_y_min,
                           Int prev_x_max, Int prev_y_max) {

/*        prev_y_max--; */    /* HYUNDAI (jdkim) 981020 */                                        
 
       if (x < prev_x_min) x = prev_x_min;
        else if (x >=prev_x_max) x = prev_x_max-1;
       if (y < prev_y_min) y = prev_y_min;
        else if (y >=prev_y_max) y = prev_y_max-1;
        return(x+y*npix);
   }


/***********************************************************CommentBegin******
 *
 * -- GetPred_Advanced -- Performs overlapped block motion compensation
 *
 * Author :		
 *	Robert Danielsen <Robert.Danielsen@nta.no>
 *	Based on the correesponding function in the
 *	Telenor H.263 software by Karl Olav Lillevold.
 *
 * Created :		
 *	11.02.96 
 *
 * Purpose :		
 *	Performs overlapped block motion compensation for an 8x8
 *	block of the given macroblock.
 *	This is conditional on the macroblock coding modes.
 * 
 * Arguments in : 	
 *	Int x,y  - the address of top-left corner pixel of the MB
 *	Int prev_x_min,  
 *	Int prev_y_min,
 *	Int prev_x_max,
 *	Int prev_y_max, reference area
 *	Image *mot_x,mot_y  - images storing the floating point
 *		motion vectors for each block.
 *      Int quarter pel, flag to indicate quarter pel MC
 *	Image *MB_decisions  - image storing the MB modes.
 *	SInt *prev  - pointer into the previous interpolated image.
 *	SInt comp  - number to indicate which block of the MB is
 *		to be processed.
 *		MB = 0 1
 *		     2 3
 *	Int width  - width of the current image/vop e.g 176,352.
 *	Int width_prev  - width of the previous image/vop (not the interpolated
 *											
 image/vop
 *	SInt mb_size  - the MB width/height e.g. 16. 
 *      SInt overlap - a flag which can be used to disable the overlapped 
 *	Int reduced_resolution - vop reduced resolution flag for DRC
 *      Int newpred_enable - NEWPRED enable flag (Oki)
 *      Int num_segments - number of NEWPRED segments per VOP (Oki)
 *      Int mba_segment[] - MB address of each NEWPRED segment (Oki)
 *										
filtering
 *
 * Arguments in/out :	
 *	
 *
 * Arguments out :	
 *	SInt *pred  - array of size 64 for storing the
 *		prediction block	
 *
 * Return values :	
 *	none
 *
 * Side effects :	
 *	
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *	12.04.96 Descriptive text from Noel Brady.
 *  	25.04.96 Extra parameter 'width_prev' added to enable operation when
 *			current and previous images/vops are not the same size.
 *	28.05.96 Robert Danielsen: Removed half_pel variable, doubling the
 *		float vector directly instead.
 *		Changed 'xmb' to 'xmb+1' in assignment of r8.
 *	10.06.96 Robert Danielsen: Included more correct treatment of
 *		surrounding Intra and Transparent macroblocks.
 *	14.06.96 Robert Danielsen: Workaround for mismatch in encoder
 *		and decoder macroblock and block modes.
 *      14.04.97 Minhua Zhou: Corrections of remote vector selections 
 *                (top/left/right/bottom) for overlapped MC 
 *	06.05.97 Minhua Zhou: added "unstricted motion compensation" of VM7.0
 *      06.05.97 Minhua zhou: BUG VM6-970425-02 solved
 *	19.11.97 Noel Brady: modified to handle skipped remote MBs correctly
 *      11.12.97 Bob Eifrig Added code to compute the rounded average of field
 *      motion vectors if an adjanct MB is field predicted.
 *	07.05.98 Jong Deuk Kim (HYUNDAI): modified for interlaced
 *      06.07.98 U. Benzler (TUH) : added quarter pel support
 *	03.03.99 Seishi TAKAMURA (NTT): added GMC coding
 *	16.08.99 Shigeru Fukunaga (Oki): restricted motion compensation 
 *				 	 within NEWPRED segment
 *	06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 *	28.11.99 Shigeru Fukunaga (Oki): modified modules for NEWPRED
 *	14.12.99 Eishi Morimatsu (Fujitsu Labs.): deletion of unused variable
 *
 ***********************************************************CommentEnd********/


Void
GetPred_Advanced (Int x,
		  Int y,
		  Int prev_x_min,  /* Added by Minhua Zhou 14.04.97 */
		  Int prev_y_min,
		  Int prev_x_max,
		  Int prev_y_max,
		  Image *mot_x,
		  Image *mot_y,
		  Int quarter_pel,			/* MW QPEL 06-JUL-1998 */
		  Image *MB_decisions, 
                  Image *alpha_decisions,
		  SInt* prev,
		  SInt* pred,
		  SInt comp,
		  Int width,
		  Int width_prev, 
		  SInt mb_size,
	          SInt overlap,
		  Int rounding_control,          	/* MW QPEL 06-JUL-1998 */
		  Int bright_white,          	/* MW QPEL 06-JUL-1998 */
		  Int edge,                     	/* MW QPEL 06-JUL-1998 */
                  Int interlaced, /* HYUNDAI 980507 */
		  Int vop_prediction_type,	/* modified by NTT for GMC coding */
		  Int reduced_resolution,	/* >>> added for DRC by Fujitsu <<< */
		  Int newpred_enable,	/** added for NEWPRED (Oki) 16-AUG-1999 **/
		  Int num_segments,	/** added for NEWPRED (Oki) 16-AUG-1999 **/
		  Int mba_segment[])	/** added for NEWPRED (Oki) 16-AUG-1999 **/
{
  struct mvector {
    Int x;
    Int y;
  };

  Int m, n;
  Int pc,pt,pb,pr,pl;
  Int nxc,nxt,nxb,nxr,nxl;
  Int nyc,nyt,nyb,nyr,nyl;
  Int xit,xib,xir,xil;
  Int yit,yib,yir,yil;
  Int vecc,vect,vecb,vecr,vecl;
  Int c8,t8,l8,r8;
  Int xmb, ymb, lx, subdimension;		/* MW QPEL 06-JUL-1998 */
  struct mvector fc, ft, fb, fr, fl;
  Int cols, a, b, i, j;
  SInt ipol_c[8][8],ipol_t[8][8],ipol_b[8][8],ipol_l[8][8],ipol_r[8][8];	/* MW QPEL 06-JUL-1998 */
  Int np_seg_id;	/** added for NEWPRED (Oki) 16-AUG-1999 **/

  /* In the following variable names, the letters c,t,b,r and l stand for
     center, top, bottom, right and left. This reflects the overlapped
     compensation process. */
  
  Int Mc[8][8] = {
    {4,5,5,5,5,5,5,4},
    {5,5,5,5,5,5,5,5},
    {5,5,6,6,6,6,5,5},
    {5,5,6,6,6,6,5,5},
    {5,5,6,6,6,6,5,5},
    {5,5,6,6,6,6,5,5},
    {5,5,5,5,5,5,5,5},
    {4,5,5,5,5,5,5,4},
  };
  Int Mt[8][8] = {
    {2,2,2,2,2,2,2,2},
    {1,1,2,2,2,2,1,1},
    {1,1,1,1,1,1,1,1},
    {1,1,1,1,1,1,1,1},
    {0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0},
  };
  Int Mb[8][8] = {
    {0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,1,1},
    {1,1,1,1,1,1,1,1},
    {1,1,2,2,2,2,1,1},
    {2,2,2,2,2,2,2,2},
  };
  Int Mr[8][8] = {
    {0,0,0,0,1,1,1,2},
    {0,0,0,0,1,1,2,2},
    {0,0,0,0,1,1,2,2},
    {0,0,0,0,1,1,2,2},
    {0,0,0,0,1,1,2,2},
    {0,0,0,0,1,1,2,2},
    {0,0,0,0,1,1,2,2},
    {0,0,0,0,1,1,1,2},
  };
  Int Ml[8][8] = {
    {2,1,1,1,0,0,0,0},
    {2,2,1,1,0,0,0,0},
    {2,2,1,1,0,0,0,0},
    {2,2,1,1,0,0,0,0},
    {2,2,1,1,0,0,0,0},
    {2,2,1,1,0,0,0,0},
    {2,2,1,1,0,0,0,0},
    {2,1,1,1,0,0,0,0},
  };
/* >>> added for DRC by Fujitsu (top)       <<< */
  Int Mc_rr[16][16] = {
    {4,4,5,5,5,5,5,5,5,5,5,5,5,5,4,4},
    {4,4,5,5,5,5,5,5,5,5,5,5,5,5,4,4},
    {5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5},
    {5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5},
    {5,5,5,5,6,6,6,6,6,6,6,6,5,5,5,5},
    {5,5,5,5,6,6,6,6,6,6,6,6,5,5,5,5},
    {5,5,5,5,6,6,6,6,6,6,6,6,5,5,5,5},
    {5,5,5,5,6,6,6,6,6,6,6,6,5,5,5,5},
    {5,5,5,5,6,6,6,6,6,6,6,6,5,5,5,5},
    {5,5,5,5,6,6,6,6,6,6,6,6,5,5,5,5},
    {5,5,5,5,6,6,6,6,6,6,6,6,5,5,5,5},
    {5,5,5,5,6,6,6,6,6,6,6,6,5,5,5,5},
    {5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5},
    {5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5},
    {4,4,5,5,5,5,5,5,5,5,5,5,5,5,4,4},
    {4,4,5,5,5,5,5,5,5,5,5,5,5,5,4,4},
  };
  Int Mt_rr[16][16] = {
    {2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},
    {2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},
    {1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1},
    {1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1},
    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  };
  Int Mb_rr[16][16] = {
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
    {1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1},
    {1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1},
    {2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},
    {2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},
  };
  Int Mr_rr[16][16] = {
    {0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2},
    {0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2},
    {0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2},
    {0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2},
    {0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2},
    {0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2},
    {0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2},
    {0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2},
    {0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2},
    {0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2},
    {0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2},
    {0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2},
    {0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2},
    {0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2},
    {0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2},
    {0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2},
  };
  Int Ml_rr[16][16] = {
    {2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0},
    {2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0},
    {2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0},
    {2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0},
    {2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0},
    {2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0},
    {2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0},
    {2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0},
    {2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0},
    {2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0},
    {2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0},
    {2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0},
    {2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0},
    {2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0},
    {2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0},
    {2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0},
  };
/*  Int  mba_scale, mba_segment_variable; */ /* DRC 1999.12.14 */
  Int  mba_scale; /* DRC 1999.12.14 */
/* >>> added for DRC by Fujitsu (bottom)    <<< */

/* >>> added for DRC by Fujitsu (bottom)    <<< */
  if(reduced_resolution)
      mba_scale = 4;
  else
      mba_scale = 1;
/* >>> added for DRC by Fujitsu (bottom)    <<< */

  xmb = x/mb_size;
  ymb = y/mb_size;

  /* MW QPEL 06-JUL-1998 >> */
  /* Set correct value for subdimension */
  if (quarter_pel) {
    subdimension=4;
  }
  else {
    subdimension=2;
  }
  /* << MW QPEL 06-JUL-1998 */

  cols = width/mb_size;

  lx = width_prev;

  if(!((xmb >= 0) && (ymb >= 0)))
	{
		fprintf(stderr,"ERROR : xmb < 0 or ymb <0\n");
		exit(1);
	}
  
  c8 = t8 = l8 = r8 = 0;

  /** added for NEWPRED (Oki) 16-AUG-1999 **/
  if(newpred_enable){
    for(np_seg_id = num_segments - 1; np_seg_id >= 0; np_seg_id--){
      if(ymb*cols+xmb >= mba_segment[np_seg_id])
	break;
    }
    /*    mba_segment_variable = mba_segment[np_seg_id]; */ /* >>> added for DRC by Fujitsu <<< */ /** deleted for NEWPRED (Oki) 28-NOV-1999 **/
  }
  /** end of NEWPRED (Oki) 16-AUG-1999 **/

  /* Set flags for the center, top, left and right positions to indicate
     whether they contain 8x8 vectors or not. */

  /* Center */
  switch (MB_decisions->data->s[ymb*cols+xmb])
    {
    case MBM_INTER8:
      c8 = 2; break;
    case MBM_INTER16:
      c8 = 2; break;
    case MBM_SKIPPED:
      c8 = 2; break;
    default:
      /* Should always be in Inter-mode for the block to be coded in
	 advanced mode. */
      fprintf (stderr, "Error, non-inter MB in GetPred_Advanced ()\n");
      exit (-1);
      break;
    }

  /* A workaround for the difference in the assignation of transparent
     mode on encoder and decoder is that I take both MBM_TRANSPARENT
     (which equals 2) and the number 6 (which is transparent for decoder)
     to mean the same below. */

  /* Top */
  if (ymb > 0)
    {
      /** added for NEWPRED (Oki) 16-AUG-1999 **/
      if(newpred_enable){
	if((ymb*cols+xmb >= mba_segment[np_seg_id]) && 
	   (ymb*cols+xmb < mba_segment[np_seg_id] + cols)) /* >>> modified for DRC by Fujitsu <<< */ /** modified for NEWPRED (Oki) 28-NOV-1999 **/
	  t8 = 1;	/* upper MB is out of NEWPRED segment */
	else{
	  switch (MB_decisions->data->s[(ymb-1)*cols+xmb])
	    {
	    case MBM_INTRA:
	      t8 = 1; break;
	    case MBM_TRANSPARENT:
	      t8 = 1; break;
	    case 6:
	      /* modified by NTT for GMC coding : start
		 t8 = 2; break;
		 */
	      t8 = (vop_prediction_type == SPRITE_VOP) ? 1 : 2; break;
	    case MBM_SPRITE:
	      t8 = 1; break;
	      /* modified by NTT for GMC coding : end */
	    case MBM_INTER8:
	      t8 = 2; break;
	    case MBM_INTER16:
	      t8 = 2; break;
	    case MBM_FIELD00:
	    case MBM_FIELD01:
	    case MBM_FIELD10:
	    case MBM_FIELD11:
	      t8 = 3; break;
	    default:
	      t8 = 0; break;
	    }
	}
      }
      else{	/** end of NEWPRED (Oki) 16-AUG-1999 **/
	switch (MB_decisions->data->s[(ymb-1)*cols+xmb])
	  {
	  case MBM_INTRA:
	    t8 = 1; break;
	  case MBM_TRANSPARENT:
	    t8 = 1; break;
	  case 6:
	    /* modified by NTT for GMC coding : start
	       t8 = 2; break;
	       */
	    t8 = (vop_prediction_type == SPRITE_VOP) ? 1 : 2; break;
	  case MBM_SPRITE:
	    t8 = 1; break;
	    /* modified by NTT for GMC coding : end */
	  case MBM_INTER8:
	    t8 = 2; break;
	  case MBM_INTER16:
	    t8 = 2; break;
	  case MBM_FIELD00:
	  case MBM_FIELD01:
	  case MBM_FIELD10:
	  case MBM_FIELD11:
	    t8 = 3; break;
	  default:
	    t8 = 0; break;
	  }
      }	/** added for NEWPRED (Oki) 16-AUG-1999 **/
    }
  else
    {
      t8 = 1;
    }


  /* Left */
  if (xmb > 0)
    {
      /** added for NEWPRED (Oki) 16-AUG-1999 **/
      if(newpred_enable){
	if(ymb*cols+xmb == mba_segment[np_seg_id]) /* >>> modified for DRC by Fujitsu <<< */ /** modified for NEWPRED (Oki) 28-NOV-1999 **/
	  l8 = 1;		/* left MB is out of NEWPRED segment */
	else{
	  switch (MB_decisions->data->s[ymb*cols+xmb-1])
	    {
	    case MBM_INTRA:
	      l8 = 1; break;
	    case MBM_TRANSPARENT:
	      l8 = 1; break;
	    case 6:
	      /* modified by NTT for GMC coding : start
		 l8 = 2; break;
		 */
	      l8 = (vop_prediction_type == SPRITE_VOP) ? 1 : 2; break;
	    case MBM_SPRITE:
	      l8 = 1; break;
	      /* modified by NTT for GMC coding : end */
	    case MBM_INTER8:
	      l8 = 2; break;
	    case MBM_INTER16:
	      l8 = 2; break;
	    case MBM_FIELD00:
	    case MBM_FIELD01:
	    case MBM_FIELD10:
	    case MBM_FIELD11:
	      l8 = 3; break;
	    default:
	      l8 = 0; break;
	    }
	}
      }
      else{	/** end of NEWPRED (Oki) 16-AUG-1999 **/
	switch (MB_decisions->data->s[ymb*cols+xmb-1])
	  {
	  case MBM_INTRA:
	    l8 = 1; break;
	  case MBM_TRANSPARENT:
	    l8 = 1; break;
	  case 6:
	    /* modified by NTT for GMC coding : start
	       l8 = 2; break;
	       */
	    l8 = (vop_prediction_type == SPRITE_VOP) ? 1 : 2; break;
	  case MBM_SPRITE:
	    l8 = 1; break;
	    /* modified by NTT for GMC coding : end */
	  case MBM_INTER8:
	    l8 = 2; break;
	  case MBM_INTER16:
	    l8 = 2; break;
	  case MBM_FIELD00:
	  case MBM_FIELD01:
	  case MBM_FIELD10:
	  case MBM_FIELD11:
	    l8 = 3; break;
	  default:
	    l8 = 0; break;
	  }
      }	/** added for NEWPRED (Oki) 16-AUG-1999 **/
    }
  else
    {
      l8 = 1;
    }

  /* Right */
  if (xmb < (cols - 1))
    {
      /** added for NEWPRED (Oki) 16-AUG-1999 **/
      if(newpred_enable){
	if((np_seg_id < num_segments - 1) &&
	   (ymb*cols+xmb + 1 == mba_segment[np_seg_id+1])) /* >>> modified for DRC by Fujitsu <<< */ /**modified for NEWPRED (Oki) 28-NOV-1999 **/
	  r8 = 1;		/* right MB is out of NEWPRED segment */
	else{
	  switch (MB_decisions->data->s[ymb*cols+xmb+1])
	    {
	    case MBM_INTRA:
	      r8 = 1; break;
	    case MBM_TRANSPARENT:
	      r8 = 1; break;
	    case 6:
	      /* modified by NTT for GMC coding : start
		 r8 = 2; break;
		 */
	      r8 = (vop_prediction_type == SPRITE_VOP) ? 1 : 2; break;
	    case MBM_SPRITE:
	      r8 = 1; break;
	      /* modified by NTT for GMC coding : end */
	    case MBM_INTER8:
	      r8 = 2; break;
	    case MBM_INTER16:
	      r8 = 2; break;
	    case MBM_FIELD00:
	    case MBM_FIELD01:
	    case MBM_FIELD10:
	    case MBM_FIELD11:
	      r8 = 3; break;
	    default:
	      r8 = 0; break;
	    }
	}
      }
      else{	/** end of NEWPRED (Oki) 16-AUG-1999 **/
	switch (MB_decisions->data->s[ymb*cols+xmb+1])
	  {
	  case MBM_INTRA:
	    r8 = 1; break;
	  case MBM_TRANSPARENT:
	    r8 = 1; break;
	  case 6:
	    /* modified by NTT for GMC coding : start
	       r8 = 2; break;
	       */
	    r8 = (vop_prediction_type == SPRITE_VOP) ? 1 : 2; break;
	  case MBM_SPRITE:
	    r8 = 1; break;
	    /* modified by NTT for GMC coding : end */
	  case MBM_INTER8:
	    r8 = 2; break;
	  case MBM_INTER16:
	    r8 = 2; break;
	  case MBM_FIELD00:
	  case MBM_FIELD01:
	  case MBM_FIELD10:
	  case MBM_FIELD11:
	    r8 = 3; break;
	  default:
	    r8 = 0; break;
	  }
      }	/** added for NEWPRED (Oki) 16-AUG-1999 **/
    }
  else
    {
      r8 = 1;
    }

  /* Find the correct positions to get the vectors from for the
     surrounding blocks. (Which 8x8 vector in a 16x16 block etc.) */

  vecc = comp;			/* Central position same as comp */
  
  switch (comp)
    {
    case 0:
      /* Top */
      if (t8 == 0)
	{
	  vect = 0;
	  yit = ymb-1; xit = xmb;
	}
      else if (t8 == 1)
	{
	  vect = vecc;
	  yit = ymb; xit = xmb;
	}
      else
	{
	  vect = 2;
	  yit = ymb-1; xit = xmb;
	}
      
      /* Bottom */
      if (c8 == 0)
	vecb = 0;
      else if (c8 == 1)
	vecb = vecc;
      else
	vecb = 2;
      yib = ymb   ; xib = xmb;

      /* Left */
      if (l8 == 0)
	{
	  vecl = 0;
	  yil = ymb   ; xil = xmb-1;
	}
      else if (l8 == 1)
	{
	  vecl = vecc;
	  yil = ymb   ; xil = xmb;
	}
      else
	{
	  vecl = 1;
	  yil = ymb   ; xil = xmb-1;
	}

      /* Right */
      if (c8 == 0)
	vecr = 0;
      else if (c8 == 1)
	vecr = vecc;
      else
	vecr = 1;
      yir = ymb   ; xir = xmb;
      r8 = c8;
      break;

    case 1:
      /* Top */
      if (t8 == 0)
	{
	  vect = 0;
	  yit = ymb-1 ; xit = xmb;
	}
      else if (t8 == 1)
	{
	  vect = vecc;
	  yit = ymb; xit = xmb;
	}
      else
	{
	  vect = 3;
	  yit = ymb-1 ; xit = xmb;
	}

      /* Bottom */
      if (c8 == 0)
	vecb = 0;
      else if (c8 == 1)
	vecb = vecc;
      else
	vecb = 3;
      yib = ymb   ; xib = xmb;

      /* Left */
      if (c8 == 0)
	vecl = 0;
      else if (c8 == 1)
	vecl = vecc;
      else
	vecl = 0;
      yil = ymb   ; xil = xmb;
      l8 = c8;

      /* Right */
      if (r8 == 0)
	{
	  vecr = 0;
	  yir = ymb   ; xir = xmb+1;
	}
      else if (r8 == 1)
	{
	  vecr = vecc;
	  yir = ymb   ; xir = xmb;
	}
      else
	{
	  vecr = 0;
	  yir = ymb   ; xir = xmb+1;
	}
      break;

    case 2:
      /* Top */
      if (c8 == 0)
	vect = 0;
      else if (c8 == 1)
	vect = vecc;
      else
	vect = 0;
      yit = ymb ; xit = xmb;
      t8 = c8;

      /* Bottom */
      if (c8 == 0)
	vecb = 0;
      else if (c8 == 1)
	vecb = vecc;
      else
	vecb = 2;
      yib = ymb   ; xib = xmb;

      /* Left */
      if (l8 == 0)
	{
	  vecl = 0;
	  yil = ymb   ; xil = xmb-1;
	}
      else if (l8 == 1)
	{
	  vecl = vecc;
	  yil = ymb   ; xil = xmb;
	}
      else
	{
	  vecl = 3;
	  yil = ymb   ; xil = xmb-1;
	}

      /* Right */
      if (c8 == 0)
	vecr = 0;
      else if (c8 == 1)
	vecr = vecc;
      else
	vecr = 3;
      yir = ymb   ; xir = xmb;
      r8 = c8;
      break;

    case 3:
      /* Top */
      if (c8 == 0)
	vect = 0;
      else if (c8 == 1)
	vect = vecc;
      else
	vect = 1;
      yit = ymb ; xit = xmb;
      t8 = c8;

      /* Bottom */
      if (c8 == 0)
	vecb = 0;
      else if (c8 == 1)
	vecb = vecc;
      else
	vecb = 3;
      yib = ymb   ; xib = xmb;

      /* Left */
      if (c8 == 0)
	vecl = 0;
      else if (c8 == 1)
	vecl = vecc;
      else
	vecl = 2;
      yil = ymb   ; xil = xmb;
      l8 = c8;

      /* Right */
      if (r8 == 0)
	{
	  vecr = 0;
	  yir = ymb   ; xir = xmb+1;
	}
      else if (r8 == 1)
	{
	  vecr = vecc;
	  yir = ymb   ; xir = xmb;
	}
      else
	{
	  vecr = 2;
	  yir = ymb   ; xir = xmb+1;
	}
      break;

    default:
      fprintf(stderr,"Illegal block number in GetPred_Advanced (pred.c)\n");
      exit(1);
      break;
    }

  /* Get the correct vector components from the surrounding blocks,
     to be used for the overlapped compensation calculation.
     The 8x8 vector to get depends on the positions found above. */

  /* Center position first */
  i = ymb;
  j = xmb;

  switch (vecc)
    {
    case 0: a = 0; b = 0; break;
    case 1: a = 0; b = 1; break;
    case 2: a = 1; b = 0; break;
    case 3: a = 1; b = 1; break;
    default:
      fprintf (stderr, "Error in GetPred_Advanced. Exiting...\n");
      exit (-1);
    }

  /* Minhua ZHOU (HHI) 14.04.97  ; Angel Pacheco (UPM): 09:06:97 */
  if ((alpha_decisions->data->s[(i*2+a)*cols*2+j*2+b]==0)||
      (alpha_decisions->data->s[(i*2+a)*cols*2+j*2+b]==MBM_TRANSPARENT)) 
    return;
 
  /* MW QPEL 06-JUL-1998 */ 
  /* fc.x = 2 * mot_x->data->f[(i*2+a)*cols*2+j*2+b]; */ 
  /* fc.y = 2 * mot_y->data->f[(i*2+a)*cols*2+j*2+b]; */ 
  fc.x = subdimension * mot_x->data->f[(i*2+a)*cols*2+j*2+b];	/* MW QPEL 06-JUL-1998 */
  fc.y = subdimension * mot_y->data->f[(i*2+a)*cols*2+j*2+b];	/* MW QPEL 06-JUL-1998 */

  /* Top */
  i = yit;
  j = xit;

  switch (vect)
    {
    case 0: a = 0; b = 0; break;
    case 1: a = 0; b = 1; break;
    case 2: a = 1; b = 0; break;
    case 3: a = 1; b = 1; break;
    default: fprintf (stderr, "Error in GetPred_Advanced. Exiting...\n"); exit 
(-1);
    }
	
 
  /* Minhua ZHOU (HHI) 14.04.97  Angel Pacheco (UPM) 09.06.97 */
  if((alpha_decisions->data->s[(i*2+a)*cols*2+j*2+b]!=0)&&
     (alpha_decisions->data->s[(i*2+a)*cols*2+j*2+b]!=MBM_TRANSPARENT)) {
    if (t8 == 3) {              /* Neighbor is interlaced; average two field vectors */
      /* MW QPEL 06-JUL-1998 */
      /* ft.x = 2 * (mot_x->data->f[4*i*cols + 2*j] + mot_x->data->f[4*i*cols + 2*j + 1]); */
      /* ft.y = 2 * (mot_y->data->f[4*i*cols + 2*j] + mot_y->data->f[4*i*cols + 2*j + 1]); */
      ft.x = subdimension * (mot_x->data->f[4*i*cols + 2*j] + mot_x->data->f[4*i*cols + 2*j + 1]);
      ft.y = subdimension * (mot_y->data->f[4*i*cols + 2*j] + mot_y->data->f[4*i*cols + 2*j + 1]); 
      ft.x = (ft.x & 3) ? ((ft.x | 2) >> 1) : (ft.x >> 1);
      ft.y = (ft.y & 3) ? ((ft.y | 2) >> 1) : (ft.y >> 1);
    } else {
      /* MW QPEL 06-JUL-1998 */
      /* ft.x = 2 * mot_x->data->f[(i*2+a)*cols*2+j*2+b]; */
      /* ft.y = 2 * mot_y->data->f[(i*2+a)*cols*2+j*2+b]; */
      ft.x = subdimension * mot_x->data->f[(i*2+a)*cols*2+j*2+b];	/* MW QPEL 06-JUL-1998 */
      ft.y = subdimension * mot_y->data->f[(i*2+a)*cols*2+j*2+b];	/* MW QPEL 06-JUL-1998 */
    }
  } else {
    ft.x = fc.x;
    ft.y = fc.y;
  } 
 
  /* Bottom */
  i = yib;
  j = xib;

  switch (vecb)
    {
    case 0: a = 0; b = 0; break;
    case 1: a = 0; b = 1; break;
    case 2: a = 1; b = 0; break;
    case 3: a = 1; b = 1; break;
    default: fprintf (stderr, "Error in GetPred_Advanced. Exiting...\n"); exit (-1);
    }
  /* Minhua ZHOU (HHI) 14.04.97  Angel Pacheco (UPM) 09.06.97 */
   if ((alpha_decisions->data->s[(i*2+a)*cols*2+j*2+b]!=0)&&
       (alpha_decisions->data->s[(i*2+a)*cols*2+j*2+b]!=MBM_TRANSPARENT)){
     /* MW QPEL 06-JUL-1998 */
     /* fb.x = 2 * mot_x->data->f[(i*2+a)*cols*2+j*2+b]; */
     /* fb.y = 2 * mot_y->data->f[(i*2+a)*cols*2+j*2+b]; */
     fb.x = subdimension * mot_x->data->f[(i*2+a)*cols*2+j*2+b];		/* MW QPEL 06-JUL-1998 */
     fb.y = subdimension * mot_y->data->f[(i*2+a)*cols*2+j*2+b];		/* MW QPEL 06-JUL-1998 */
  } else {
    fb.x = fc.x;
    fb.y = fc.y;
  } 
  
  /* Right */
  i = yir;
  j = xir;
  
  switch (vecr)
    {
    case 0: a = 0; b = 0; break;
    case 1: a = 0; b = 1; break;
    case 2: a = 1; b = 0; break;
    case 3: a = 1; b = 1; break;
    default: fprintf (stderr, "Error in GetPred_Advanced. Exiting...\n"); exit 
(-1);
    }
  /* Minhua ZHOU (HHI) 14.04.97  Angel Pacheco (UPM) 09.06.97 */
   if ((alpha_decisions->data->s[(i*2+a)*cols*2+j*2+b]!=0)&&
       (alpha_decisions->data->s[(i*2+a)*cols*2+j*2+b]!=MBM_TRANSPARENT)) {
    if (r8 == 3) {              /* Neighbor is interlaced; average two field vectors */
      /* MW QPEL 06-JUL-1998 */
      /* fr.x = 2 * (mot_x->data->f[4*i*cols + 2*j] + mot_x->data->f[4*i*cols + 2*j + 1]); */
      /* fr.y = 2 * (mot_y->data->f[4*i*cols + 2*j] + mot_y->data->f[4*i*cols + 2*j + 1]); */
      fr.x = subdimension * (mot_x->data->f[4*i*cols + 2*j] + mot_x->data->f[4*i*cols + 2*j + 1]);
      fr.y = subdimension * (mot_y->data->f[4*i*cols + 2*j] + mot_y->data->f[4*i*cols + 2*j + 1]);
      fr.x = (fr.x & 3) ? ((fr.x | 2) >> 1) : (fr.x >> 1);
      fr.y = (fr.y & 3) ? ((fr.y | 2) >> 1) : (fr.y >> 1);
    } else {
      /* MW QPEL 06-JUL-1998 */
      /* fr.x = 2 * mot_x->data->f[(i*2+a)*cols*2+j*2+b]; */
      /* fr.y = 2 * mot_y->data->f[(i*2+a)*cols*2+j*2+b]; */
      fr.x = subdimension * mot_x->data->f[(i*2+a)*cols*2+j*2+b];
      fr.y = subdimension * mot_y->data->f[(i*2+a)*cols*2+j*2+b];
    }
  } else {
    fr.x = fc.x;
    fr.y = fc.y;
  } 

  /* Left */
  i = yil;
  j = xil;

  switch (vecl)
    {
    case 0: a = 0; b = 0; break;
    case 1: a = 0; b = 1; break;
    case 2: a = 1; b = 0; break;
    case 3: a = 1; b = 1; break;
    default: fprintf (stderr, "Error in GetPred_Advanced. Exiting...\n"); exit 
(-1);
    }
  /* Minhua ZHOU (HHI) 14.04.97 Angel Pacheco (UPM) 09.06.97 */
  if ((alpha_decisions->data->s[(i*2+a)*cols*2+j*2+b]!=0)&&
      (alpha_decisions->data->s[(i*2+a)*cols*2+j*2+b]!=MBM_TRANSPARENT)) {
    if (l8 == 3) {              /* Neighbor is interlaced; average two field vectors */
      /* MW QPEL 06-JUL-1998 */
      /* fl.x = 2 * (mot_x->data->f[4*i*cols + 2*j] + mot_x->data->f[4*i*cols + 2*j + 1]); */
      /* fl.y = 2 * (mot_y->data->f[4*i*cols + 2*j] + mot_y->data->f[4*i*cols + 2*j + 1]); */
      fl.x = subdimension * (mot_x->data->f[4*i*cols + 2*j] + mot_x->data->f[4*i*cols + 2*j + 1]);
      fl.y = subdimension * (mot_y->data->f[4*i*cols + 2*j] + mot_y->data->f[4*i*cols + 2*j + 1]);
      fl.x = (fl.x & 3) ? ((fl.x | 2) >> 1) : (fl.x >> 1);
      fl.y = (fl.y & 3) ? ((fl.y | 2) >> 1) : (fl.y >> 1);
    } else {
      /* MW QPEL 06-JUL-1998 */
      /* fl.x = 2 * mot_x->data->f[(i*2+a)*cols*2+j*2+b]; */
      /* fl.y = 2 * mot_y->data->f[(i*2+a)*cols*2+j*2+b]; */
      fl.x = subdimension * mot_x->data->f[(i*2+a)*cols*2+j*2+b];		/* MW QPEL 06-JUL-1998 */
      fl.y = subdimension * mot_y->data->f[(i*2+a)*cols*2+j*2+b];		/* MW QPEL 06-JUL-1998 */
    }
  } else {
    fl.x = fc.x;
    fl.y = fc.y;
  } 
  
  /* Set the initial positions for the vectors
     (center, top, bottom, right, left) */
  
  /* MW QPEL 06-JUL-1998 >> */
  /* nxc = 2*x + ((comp&1)<<4); nyc = 2*y + ((comp&2)<<3); */
  if (quarter_pel || reduced_resolution) { /* >>> added for DRC by Fujitsu <<< */
    nxc = subdimension*x + ((comp&1)<<5); nyc = subdimension*y + ((comp&2)<<4);
  }
  else {
    nxc = subdimension*x + ((comp&1)<<4); nyc = subdimension*y + ((comp&2)<<3);
  }
  /* << MW QPEL 06-JUL-1998 */
   
  nxt = nxb = nxr = nxl = nxc;
  nyt = nyb = nyr = nyl = nyc;

  /* Now add the vector components to the initial positions to get the
     target positions */
  
  nxc += fc.x; nyc += fc.y;
  nxt += ft.x; nyt += ft.y;
  nxb += fb.x; nyb += fb.y;
  nxr += fr.x; nyr += fr.y;
  nxl += fl.x; nyl += fl.y;
 
  /* MW QPEL 06-JUL-1998 >> */
  if (quarter_pel) {
  /* Interpolate all 5 8x8 block */
    prev_x_min -= 2*B_SIZE; /* Allow the top left corner of the Block to point into the top and left edge. */
    prev_y_min -= 2*B_SIZE; /* But the corner is only allowed to point to the first pel of the edge on the bottom and right, */
                                        /* so prev_x/y_max are not changed */
    
    MakeUnrestricted_MC_QuarterPel(&nxc, &nyc, prev_x_min, prev_y_min, prev_x_max, prev_y_max);
    InterpolateBlock(prev,width_prev,nxc,nyc,subdimension,8,8,(SInt *)ipol_c,8,rounding_control,bright_white);
    if (overlap) {
      MakeUnrestricted_MC_QuarterPel(&nxt, &nyt, prev_x_min, prev_y_min, prev_x_max, prev_y_max);
      InterpolateBlock(prev,width_prev,nxt,nyt,subdimension,8,8,(SInt *)ipol_t,8,rounding_control,bright_white);
      MakeUnrestricted_MC_QuarterPel(&nxb, &nyb, prev_x_min, prev_y_min, prev_x_max, prev_y_max);
      InterpolateBlock(prev,width_prev,nxb,nyb,subdimension,8,8,(SInt *)ipol_b,8,rounding_control,bright_white);
      MakeUnrestricted_MC_QuarterPel(&nxr, &nyr, prev_x_min, prev_y_min, prev_x_max, prev_y_max);
      InterpolateBlock(prev,width_prev,nxr,nyr,subdimension,8,8,(SInt *)ipol_r,8,rounding_control,bright_white);
      MakeUnrestricted_MC_QuarterPel(&nxl, &nyl, prev_x_min, prev_y_min, prev_x_max, prev_y_max);
      InterpolateBlock(prev,width_prev,nxl,nyl,subdimension,8,8,(SInt *)ipol_l,8,rounding_control,bright_white);
#ifdef _DEBUG_BENZ_MC_
      printf("OBMC (%2d,%2d) :\n",xmb,ymb);
      printf("nxc,nyc : %3d, %3d \n",nxc,nyc);
      printf("nxt,nyt : %3d, %3d \n",nxt,nyt);
      printf("nxb,nyb : %3d, %3d \n",nxb,nyb);
      printf("nxr,nyr : %3d, %3d \n",nxr,nyr);
      printf("nxl,nyl : %3d, %3d \n",nxl,nyl);
#endif
    }
  }
  /* << MW QPEL 06-JUL-1998 */

  /* Calculate and fill in the prediction data for this 8x8 block */
  for (n = 0; n < (mb_size/2); n++) /* >>> modified for DRC by Fujitsu <<< */
    {
      for (m = 0; m < (mb_size/2); m++) /* >>> modified for DRC by Fujitsu <<< */
	{
	  /* Find interpolated pixel-values corresponding to the
	     central and surrounding positions. Use the weighting tables. */

	  /* MW QPEL 06-JUL-1998 */
	  if (quarter_pel) {
	    if (overlap) {
	      /* changed by Minhua Zhou 14.04.1997 */
	      if (Mc[n][m])
	        pc = ipol_c[n][m] * Mc[n][m];
	      else pc =0;
	      if (Mt[n][m])
	        pt = ipol_t[n][m] * Mt[n][m];
	      else pt =0;
	      if (Mb[n][m])
	        pb = ipol_b[n][m] * Mb[n][m];
	      else pb =0;
	      if (Mr[n][m])
	        pr = ipol_r[n][m] * Mr[n][m];
	      else pr =0;
	      if (Ml[n][m])
	        pl = ipol_l[n][m] * Ml[n][m];
	      else pl =0;
	      /* Calculate the overlapped compensated values based on the
		 above weighted values. Fill pred with these. */
	      *(pred + m + n * mb_size) = (pc+pt+pb+pr+pl+4)>>3;
	    }
	    else *(pred + m + n * mb_size) = ipol_c[n][m];
	  } else { /* half pel MC */
	    if (overlap) {
	      /* changed by Minhua Zhou 14.04.1997 */
/* >>> added for DRC by Fujitsu (top)       <<< */
	      if(reduced_resolution) {
	        if (Mc_rr[n][m]) 
	          pc = *(prev + unrestricted_MC(nxc+2*m,nyc+2*n,lx*2, 
					      prev_x_min,prev_y_min,prev_x_max,prev_y_max,
					      interlaced /* HYUNDAI 980507 */)) * Mc_rr[n][m];
	        else pc =0;
	        if (Mt_rr[n][m])
	          pt = *(prev + unrestricted_MC(nxt+2*m,nyt+2*n,lx*2,
					      prev_x_min,prev_y_min,prev_x_max,prev_y_max,
					      interlaced /* HYUNDAI 980507 */)) * Mt_rr[n][m];
	        else pt =0;
	        if (Mb_rr[n][m]) 
	          pb = *(prev + unrestricted_MC(nxb+2*m,nyb+2*n,lx*2,
					      prev_x_min,prev_y_min,prev_x_max,prev_y_max,
					      interlaced /* HYUNDAI 980507 */)) * Mb_rr[n][m];
	        else pb =0;
	        if (Mr_rr[n][m])
	          pr = *(prev + unrestricted_MC(nxr+2*m,nyr+2*n,lx*2,
					      prev_x_min,prev_y_min,prev_x_max,prev_y_max,
					      interlaced /* HYUNDAI 980507 */)) * Mr_rr[n][m];
	        else pr =0;
	        if (Ml_rr[n][m])
	        pl = *(prev + unrestricted_MC(nxl+2*m,nyl+2*n,lx*2,
					    prev_x_min,prev_y_min,prev_x_max,prev_y_max,
					    interlaced /* HYUNDAI 980507 */)) * Ml_rr[n][m];
	        else pl =0;
	      } else {
/* >>> added for DRC by Fujitsu (bottom)    <<< */
	      if (Mc[n][m]) 
	        pc = *(prev + unrestricted_MC(nxc+2*m,nyc+2*n,lx*2, 
					      prev_x_min,prev_y_min,prev_x_max,prev_y_max,
					      interlaced /* HYUNDAI 980507 */)) * Mc[n][m];
	      else pc =0;
	      if (Mt[n][m])
	        pt = *(prev + unrestricted_MC(nxt+2*m,nyt+2*n,lx*2,
					      prev_x_min,prev_y_min,prev_x_max,prev_y_max,
					      interlaced /* HYUNDAI 980507 */)) * Mt[n][m];
	      else pt =0;
	      if (Mb[n][m]) 
	        pb = *(prev + unrestricted_MC(nxb+2*m,nyb+2*n,lx*2,
					      prev_x_min,prev_y_min,prev_x_max,prev_y_max,
					      interlaced /* HYUNDAI 980507 */)) * Mb[n][m];
	      else pb =0;
	      if (Mr[n][m])
	        pr = *(prev + unrestricted_MC(nxr+2*m,nyr+2*n,lx*2,
					      prev_x_min,prev_y_min,prev_x_max,prev_y_max,
					      interlaced /* HYUNDAI 980507 */)) * Mr[n][m];
	      else pr =0;
	      if (Ml[n][m])
	      pl = *(prev + unrestricted_MC(nxl+2*m,nyl+2*n,lx*2,
					    prev_x_min,prev_y_min,prev_x_max,prev_y_max,
					    interlaced /* HYUNDAI 980507 */)) * Ml[n][m];
	      else pl =0;
/* >>> added for DRC by Fujitsu (top)       <<< */
	      } 
/* >>> added for DRC by Fujitsu (bottom)    <<< */
	      
	      /* Calculate the overlapped compensated values based on the
		 above weighted values. Fill pred with these. */
	      *(pred + m + n * mb_size) = (pc+pt+pb+pr+pl+4)>>3;
	    }
	    else *(pred + m + n * mb_size) = 
		   *(prev + unrestricted_MC(nxc+2*m,nyc+2*n,lx*2,
					    prev_x_min,prev_y_min,prev_x_max,prev_y_max,
					    interlaced /* HYUNDAI 980507 */));
	  }
	} /* for(m=...) */
    } /* for(n=...) */

  return;
}


/***********************************************************CommentBegin******
 *
 * -- GetPred_Default -- Find the prediction block
 *
 * Author :		
 *	Karl.Lillevold@nta.no
 *
 * Created :		
 *	930126
 *
 * Purpose :		
 *	Find the prediction block
 * 
 * Arguments in : 	
 *	position, vector, array for prediction
 *	pointer to previous interpolated luminance,
 *
 * Arguments in/out :	
 *	
 *
 * Arguments out :	
 *	
 *
 * Return values :	
 *	
 *
 * Side effects :	
 *	fills array with prediction
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *	950208    Mod: Karl.Lillevold@nta.no
 *	960502	Modified to Momusys-structures. Robert Danielsen
 *	980706	Modified for quarter pel support. Michael Wollborn & Ulrich Benzler
 *	06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 *
 ***********************************************************CommentEnd********/

Void
GetPred_Default (Int x, Int y, Image *mot_x, Image *mot_y, 
		 Int quarter_pel, SInt *prev, /* MW QPEL 06-JUL-1998 */
		 SInt pred[][16], SInt pred_rr[][32], Int width, Int width_prev, Int mb_size, /* >>> added for DRC by Fujitsu <<< */
		 Int rounding_control, Int bright_white, /* MW QPEL 06-JUL-1998 */
		 Int reduced_resolution, /* >>> added for DRC by Fujitsu <<< */
		 Int prev_x_min, Int prev_y_min, Int prev_x_max, Int prev_y_max /* MW QPEL 06-JUL-1998 */)
{
  Int m, n;
  Int new_x, new_y;		/* MC pel position in sub-pixels */
  Int lx;
  Int cols;
  Int mx, my, subdimension;     /* MW QPEL 06-JUL-1998 */
  Float	dx_hp,dy_hp;		/* MV in sub-pixels */


  lx = width_prev;

  mx = x / mb_size;
  my = y / mb_size;

  /* MW QPEL 06-JUL-1998 >> */
  /* Set correct value for subdimension */
  if (quarter_pel) {
    subdimension=4;
  }
  else {
    subdimension=2;
  }
  /* << MW QPEL 06-JUL-1998 */
  
  cols = width / mb_size;
  
  /* MW QPEL 06-JUL-1998 */
  /* dx_hp = mot_x->data->f[my*2*cols*2 + mx*2] * 2; */
  /* dy_hp = mot_y->data->f[my*2*cols*2 + mx*2] * 2; */
  /* new_x = 2*x + dx_hp; */
  /* new_y = 2*y + dy_hp; */

  dx_hp = (Int)(mot_x->data->f[my*2*cols*2 + mx*2] * (Float)(subdimension));	/* MW QPEL 06-JUL-1998 */
  dy_hp = (Int)(mot_y->data->f[my*2*cols*2 + mx*2] * (Float)(subdimension));	/* MW QPEL 06-JUL-1998 */

  new_x = subdimension*x + dx_hp;	/* MW QPEL 06-JUL-1998 */
  new_y = subdimension*y + dy_hp;	/* MW QPEL 06-JUL-1998 */

  /* MW QPEL 06-JUL-1998 >> */
  /* Interpolate the 16x16 block */
  if (quarter_pel) {
    MakeUnrestricted_MC_QuarterPel(&new_x, &new_y, prev_x_min-(MB_SIZE<<1), prev_y_min-(MB_SIZE<<1), prev_x_max, prev_y_max);
    InterpolateBlock(prev,width_prev,new_x,new_y,subdimension,MB_SIZE,MB_SIZE,(SInt *)pred,MB_SIZE,rounding_control, bright_white);
  } else {
  /* Fill pred. data for half pel mode from interpolated image */
   for (n = 0; n < mb_size; n++)
    {
      for (m = 0; m < mb_size; m++)
	{
	  /* Find interpolated pixel-value */
/* >>> added for DRC by Fujitsu (top)    <<< */
          if(reduced_resolution)
	    pred_rr[n][m] = *(prev + unrestricted_MC(new_x+2*m,new_y+2*n,lx*2,
					    prev_x_min,prev_y_min,prev_x_max,prev_y_max,0));
          else
/* >>> added for DRC by Fujitsu (bottom)    <<< */
	  pred[n][m] = *(prev + unrestricted_MC(new_x+2*m,new_y+2*n,lx*2,
					    prev_x_min,prev_y_min,prev_x_max,prev_y_max,0));
	}	
    }
  }

  return;
}

/***********************************************************CommentBegin******
 *
 * -- GetPred_Field -- Find the prediction block
 *
 * Author :
 *  Bob Eifrig
 *
 * Created :
 *  21-jan-97
 *
 * Purpose :
 *  Find the prediction for a field
 *
 * Arguments in :
 *  position, vector, array for prediction
 *  pointer to previous interpolated luminance,
 *
 * Arguments in/out :
 *
 *
 * Arguments out :
 *
 *
 * Return values :
 *
 *
 * Side effects :
 *  fills array with prediction
 *
 * Description :
 *
 *
 * See also :
 *
 *
 * Modified :
 *	07.05.98 Jong Deuk Kim, Cheol Soo Park (HYUNDAI): revised
 *      06.07.98 U. Benzler (TUH) : added quarter pel support
 *
 ***********************************************************CommentEnd********/
 
Void
GetPred_Field(Int mbx,
                Int mby,
                Image *mot_x,
                Image *mot_y,
                Int edge,
                Image *ref,
                Image *pred,
                Int how,
                Int rounding_control,
/* HYUNDAI 980507 : start */
                Int prev_x_min,  
                Int prev_y_min,
                Int prev_x_max,
                Int prev_y_max, Int quarter_pel, Int bright_white /* MW QPEL 06-JUL-1998 */)
/* HYUNDAI 980507 : end */
{
    Int code, k, dx, dy, x, y, round;
    Int rwidth, pwidth, rwidth2, pwidth2;
    SInt *pRef, *pPred;
    Float *mvx, *mvy;
    Int subdim = (quarter_pel) ? 4:2;	/* MW QPEL 06-JUL-1998 */
    SInt vx, vy;	/* MW QPEL 06-JUL-1998 */
 
    /* HYUNDAI 980507 */
    Int  pred1=0, pred2=0, pred3=0, pred4=0, ref_off;

    k = 2*mbx + 2*mby*GetImageSizeX(mot_x);
    mvx = (Float *)GetImageData(mot_x) + k;
    mvy = (Float *)GetImageData(mot_y) + k;

#ifdef _DEBUG_BENZ_MC_
  printf("Motion Vector of MB %2d/%2d :\n",mbx,mby);
#endif
 
    mbx *= MB_SIZE;
    mby *= MB_SIZE;
 
    pwidth  = GetImageSizeX(pred);
    pwidth2 = pwidth << 1;
    rwidth  = GetImageSizeX(ref);
    rwidth2 = rwidth << 1;
 
    /*
     * Motion compensate the top field
     */
 
    /* MW QPEL 06-JUL-1998 */
    /* dx = (Int)(2*mvx[0]); */
    /* dy = (Int)(2*mvy[0]); */
    dx = (Int)(subdim*mvx[0]);
    dy = (Int)(subdim*mvy[0]);

    if (dy & 1)
       fprintf(stderr, "Top Field MV[%d %d] (ref=%s) Y is odd: %d\n",
            mbx, mby, (how & 2) ? "Bot" : "Top", dy);

    /* MW QPEL 06-JUL-1998 */
    if (quarter_pel) {
#ifdef _DEBUG_BENZ_MV_
      if (how&2) {
	printf("bot\n%5d/%5d\n%5d/%5d\n",mbx,mby,dx,dy);
      } else {
	printf("top\n%5d/%5d\n%5d/%5d\n",mbx,mby,dx,dy);
      }
#endif
      rwidth2 = (how & 2) ? rwidth : 0; /* line offset for bottom field in ref. picture*/
      vx = dx;
      vy = dy;
      ClipMV(mbx - prev_x_min, mby - prev_y_min, GetImageSizeX(ref), GetImageSizeY(ref), edge, &vx, &vy, 4);
      InterpolateBlock((SInt *)ref->f + mbx + mby*rwidth + rwidth2, rwidth,
		       vx, vy, subdim, 16, 8, (SInt *)GetImageData(pred) + mbx + mby*pwidth, pwidth2,
		       rounding_control, bright_white);
    } else { /* halfpel MC */
      code = (dx & 1) | (dy & 2);
      dx >>= 1;
      dy = (dy >> 1) & ~1;

      /* HYUNDAI 980507 : start */
      if (how & 2)
	{
	  ref_off = 1;
	  dy++;
	}
      else ref_off = 0;
      
      pPred = (SInt *)pred->f + mbx + mby*pwidth;
      pRef = (SInt *)ref->f ;
      /* HYUNDAI 980507 : end */
 
      switch (code) {
	
      case 0:                                         /* no interp */
        for (y = 0; y < MB_SIZE; y += 2) {
          for (x = 0; x < MB_SIZE; x++)
	    /* HYUNDAI 980507 : start */
#if 0
          pPred[x] = *(pRef + unrestricted_MC_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
#endif
/* HYUNDAI (jdkim) end : 981020 */
/* HYUNDAI 980507 : end */

/* HYUNDAI (jdkim) 981020 : start */
          pPred[x] = *(pRef + unrestricted_MC_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
/* HYUNDAI (jdkim) 981020 : end */
          pPred += pwidth2;
        }
        break;
 
      case 1:                                         /* horizontal interp */
        round = 1 - rounding_control;
        for (y = 0; y < MB_SIZE; y += 2) {
          for (x = 0; x < MB_SIZE; x++)
	  /* HYUNDAI 980507 : start */
/* HYUNDAI (jdkim) start : 981020 */
#if 0
	    {
	      pred1 = *(pRef + unrestricted_MC_field(mbx+dx+x,  (mby+dy+y), rwidth,
						     prev_x_min,prev_y_min+ref_off,
						     prev_x_max,prev_y_max+ref_off));
	      pred2 = *(pRef + unrestricted_MC_field(mbx+dx+x+1,(mby+dy+y), rwidth,
						     prev_x_min,prev_y_min+ref_off,
						     prev_x_max,prev_y_max+ref_off)); 
	      pPred[x] = (pred1 + pred2 + round) >> 1;
	    }
#endif
/* HYUNDAI (jdkim) end : 981020 */
	  /* HYUNDAI 980507 : end */

/* HYUNDAI (jdkim) 981020 : start */
{
            pred1 = *(pRef + unrestricted_MC_field(mbx+dx+x,  (mby+dy+y), rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred2 = *(pRef + unrestricted_MC_field(mbx+dx+x+1,(mby+dy+y), rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max)); 
            pPred[x] = (pred1 + pred2 + round) >> 1;
}
/* HYUNDAI (jdkim) 981020 : end */
          pPred += pwidth2;
        }
        break;
	
      case 2:                                         /* vertical interp */
        round = 1 - rounding_control;
        for (y = 0; y < MB_SIZE; y += 2) {
          for (x = 0; x < MB_SIZE; x++)
	  /* HYUNDAI 980507 : start */
/* HYUNDAI (jdkim) start : 981020 */
#if 0
	    {
	      pred1 = *(pRef + unrestricted_MC_field(mbx+dx+x, mby+dy+y, rwidth,
						     prev_x_min,prev_y_min+ref_off,
						     prev_x_max,prev_y_max+ref_
off));
	      pred2 = *(pRef + unrestricted_MC_field(mbx+dx+x, mby+dy+y+2, rwidth,
						     prev_x_min,prev_y_min+ref_off,
						     prev_x_max,prev_y_max+ref_off));
	      
	      pPred[x] = (pred1+pred2 + round) >> 1;                             
	    }
#endif
/* HYUNDAI (jdkim) end : 981020 */
	  /* HYUNDAI 980507 : end */

/* HYUNDAI (jdkim) 981020 : start */
{
            pred1 = *(pRef + unrestricted_MC_field(mbx+dx+x, mby+dy+y, rwidth,
                                prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred2 = *(pRef + unrestricted_MC_field(mbx+dx+x, mby+dy+y+2, rwidth,
                                prev_x_min,prev_y_min,prev_x_max,prev_y_max));

            pPred[x] = (pred1+pred2 + round) >> 1;                             
}
/* HYUNDAI (jdkim) 981020 : end */
          pPred += pwidth2;
        }
        break;
	
      case 3:                                         /* horiz & vert interp */
        round = 2 - rounding_control;
        for (y = 0; y < MB_SIZE; y += 2) {
          for (x = 0; x < MB_SIZE; x++)
/* HYUNDAI (jdkim) start : 981020 */
#if 0
	  /* HYUNDAI 980507 : start */
	    {
	      pred1 = *(pRef + unrestricted_MC_field(mbx+dx+x, mby+dy+y, rwidth,
						     prev_x_min,prev_y_min+ref_off,
						     prev_x_max,prev_y_max+ref_off));
	      pred2 = *(pRef + unrestricted_MC_field(mbx+dx+x+1, mby+dy+y, rwidth,
						     prev_x_min,prev_y_min+ref_off,
						     prev_x_max,prev_y_max+ref_off));                
	      pred3 = *(pRef + unrestricted_MC_field(mbx+dx+x,   mby+dy+y+2, rwidth,
						     prev_x_min,prev_y_min+ref_off,
						     prev_x_max,prev_y_max+ref_off));
	      pred4 = *(pRef + unrestricted_MC_field(mbx+dx+x+1, mby+dy+y+2, rwidth,
						     prev_x_min,prev_y_min+ref_off,
						     prev_x_max,prev_y_max+ref_off));
	      pPred[x] = (pred1 + pred2 + pred3 + pred4 + round) >> 2;
	    }
#endif
/* HYUNDAI (jdkim) end : 981020 */
	  /* HYUNDAI 980507 : end */

/* HYUNDAI (jdkim) 981020 : start */
{
                pred1 = *(pRef + unrestricted_MC_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
                pred2 = *(pRef + unrestricted_MC_field(mbx+dx+x+1, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));                
	        pred3 = *(pRef + unrestricted_MC_field(mbx+dx+x,   mby+dy+y+2, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
                pred4 = *(pRef + unrestricted_MC_field(mbx+dx+x+1, mby+dy+y+2, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pPred[x] = (pred1 + pred2 + pred3 + pred4 + round) >> 2;
}
/* HYUNDAI (jdkim) 981020 : end */
          pPred += pwidth2;
        }
        break;
      }
    } /* if(quarter_pel) else ... */

 
    /*
     * Motion compensate the bottom field
     */
 
    /* MW QPEL 06-JUL-1998 */
    /* dx = (Int)(2*mvx[1]); */
    /* dy = (Int)(2*mvy[1]); */
    dx = (Int)(subdim*mvx[1]);
    dy = (Int)(subdim*mvy[1]);

    if (dy & 1)
       fprintf(stderr, "Bottom Field MV[%d %d] (ref=%s) Y is odd: %d\n",
            mbx, mby, (how & 1) ? "Bot" : "Top", dy);

    /* MW QPEL 06-JUL-1998 */
    if (quarter_pel) {
#ifdef _DEBUG_BENZ_MV_
      if (how&1) {
	printf("bot\n%5d/%5d\n%5d/%5d\n",mbx,mby,dx,dy);
      } else {
	printf("top\n%5d/%5d\n%5d/%5d\n",mbx,mby,dx,dy);
      }
#endif
      rwidth2 = (how & 1) ? rwidth : 0; /* line offset for bottom field in ref. picture*/
      vx = dx;
      vy = dy;
      ClipMV(mbx - prev_x_min, mby - prev_y_min, GetImageSizeX(ref), GetImageSizeY(ref), edge, &vx, &vy, 4);
      InterpolateBlock((SInt *)ref->f + mbx + mby*rwidth + rwidth2, rwidth,
		       vx, vy, subdim, 16, 8, (SInt *)GetImageData(pred) + mbx + (mby+1)*pwidth, 
		       pwidth2,rounding_control, bright_white);
    } else { /* halfpel MC */
      code = (dx & 1) | (dy & 2);
      dx >>= 1;
      dy = (dy >> 1) & ~1;
 
      /* HYUNDAI 980507 : start */
      if (how & 1)
	{
	  ref_off = 1;
	  dy++;
	}
      else ref_off = 0;
      
      pPred = (SInt *)pred->f + mbx + (mby+1)*pwidth;
      pRef = (SInt *)ref->f ;
      /* HYUNDAI 980507 : end */
 
      switch (code) {
	
      case 0:                                         /* no interp */
        for (y = 0; y < MB_SIZE; y += 2) {
	  for (x = 0; x < MB_SIZE; x++)
	    /* HYUNDAI 980507 : start */
/* HYUNDAI (jdkim) start : 981020 */
#if 0
	    pPred[x] = *(pRef + unrestricted_MC_field(mbx+dx+x, mby+dy+y, rwidth,
						      prev_x_min,prev_y_min+ref_off,
						      prev_x_max,prev_y_max+ref_off));
#endif
/* HYUNDAI (jdkim) end : 981020 */
	    /* HYUNDAI 980507 : end */

/* HYUNDAI (jdkim) 981020 : start */
                pPred[x] = *(pRef + unrestricted_MC_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
/* HYUNDAI (jdkim) 981020 : end */
	  pPred += pwidth2;
        }
        break;
 
      case 1:                                         /* horizontal interp */
        round = 1 - rounding_control;
        for (y = 0; y < MB_SIZE; y += 2) {
          for (x = 0; x < MB_SIZE; x++)
	  /* HYUNDAI 980507 : start */
/* HYUNDAI (jdkim) start : 981020 */
#if 0
	    {
	      
	      pred1 = *(pRef + unrestricted_MC_field(mbx+dx+x, mby+dy+y, rwidth,
						     prev_x_min,prev_y_min+ref_off,
						     prev_x_max,prev_y_max+ref_off));
	      pred2 = *(pRef + unrestricted_MC_field(mbx+dx+x+1, mby+dy+y, rwidth,
						     prev_x_min,prev_y_min+ref_off,
						     prev_x_max,prev_y_max+ref_off));
	      pPred[x] = (pred1+pred2 + round) >> 1;
	    }
#endif
/* HYUNDAI (jdkim) end : 981020 */
	  /* HYUNDAI 980507 : end */

/* HYUNDAI (jdkim) 981020 : start */
{

            pred1 = *(pRef + unrestricted_MC_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred2 = *(pRef + unrestricted_MC_field(mbx+dx+x+1, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pPred[x] = (pred1+pred2 + round) >> 1;
}
/* HYUNDAI (jdkim) 981020 : end */
	  pPred += pwidth2;
        }
        break;
	
      case 2:                                         /* vertical interp */
        round = 1 - rounding_control;
        for (y = 0; y < MB_SIZE; y += 2) {
          for (x = 0; x < MB_SIZE; x++)
	  /* HYUNDAI 980507 : start */
/* HYUNDAI (jdkim) start : 981020 */
#if 0
	    {
	      pred1 = *(pRef + unrestricted_MC_field(mbx+dx+x, mby+dy+y, rwidth,
						     prev_x_min,prev_y_min+ref_off,
						     prev_x_max,prev_y_max+ref_off));
	      pred2 = *(pRef + unrestricted_MC_field(mbx+dx+x, mby+dy+y+2, rwidth,
						     prev_x_min,prev_y_min+ref_off,
						     prev_x_max,prev_y_max+ref_off));
	      pPred[x] = (pred1+pred2 + round) >> 1;
	    }
#endif
/* HYUNDAI (jdkim) end : 981020 */
	  /* HYUNDAI 980507 : end */

/* HYUNDAI (jdkim) 981020 : start */
{
            pred1 = *(pRef + unrestricted_MC_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred2 = *(pRef + unrestricted_MC_field(mbx+dx+x, mby+dy+y+2, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pPred[x] = (pred1+pred2 + round) >> 1;
}
/* HYUNDAI (jdkim) 981020 : end */
          pPred += pwidth2;
        }
        break;
 
      case 3:                                         /* horiz & vert interp */
        round = 2 - rounding_control;
        for (y = 0; y < MB_SIZE; y += 2) {
          for (x = 0; x < MB_SIZE; x++)
	  /* HYUNDAI 980507 : start */
/* HYUNDAI (jdkim) : start : 981020 */
#if 0
	    {
	      pred1 = *(pRef + unrestricted_MC_field(mbx+dx+x,   mby+dy+y, rwidth,
						     prev_x_min,prev_y_min+ref_off,
						     prev_x_max,prev_y_max+ref_off));
	      pred2 = *(pRef + unrestricted_MC_field(mbx+dx+x+1, mby+dy+y, rwidth,
						     prev_x_min,prev_y_min+ref_off,
						     prev_x_max,prev_y_max+ref_off));
	      pred3 = *(pRef + unrestricted_MC_field(mbx+dx+x,   mby+dy+y+2, rwidth,
						     prev_x_min,prev_y_min+ref_off,
						     prev_x_max,prev_y_max+ref_off));
	      pred4 = *(pRef + unrestricted_MC_field(mbx+dx+x+1, mby+dy+y+2, rwidth,
						     prev_x_min,prev_y_min+ref_off,
						     prev_x_max,prev_y_max+ref_off));
	      pPred[x] = (pred1 + pred2 + pred3 + pred4 + round) >> 2;
	    }
#endif
/* HYUNDAI (jdkim) end : 981020 */
	  /* HYUNDAI 980507 : end */

/* HYUNDAI (jdkim) 981020 : start */
{
                pred1 = *(pRef + unrestricted_MC_field(mbx+dx+x,   mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
                pred2 = *(pRef + unrestricted_MC_field(mbx+dx+x+1, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
                pred3 = *(pRef + unrestricted_MC_field(mbx+dx+x,   mby+dy+y+2, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
                pred4 = *(pRef + unrestricted_MC_field(mbx+dx+x+1, mby+dy+y+2, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
                pPred[x] = (pred1 + pred2 + pred3 + pred4 + round) >> 2;
}
/* HYUNDAI (jdkim) 981020 : end */
	  pPred += pwidth2;
        }
        break;
      }
    } /* if(quarter_pel) else ... */
}

/***********************************************************CommentBegin******
 *
 * -- GetPred_Chroma -- Predicts chrominance macroblock 
 *
 * Author :		
 *	Robert Danielsen <Robert.Danielsen@nta.no>
 *
 * Created :		
 *	11.02.96, based on tmn-function
 *	930211, original author Karl.Lillevold@nta.no
 *
 * Purpose :		
 *	Does the chrominance prediction for P-frames
 * 
 * Arguments in : 	
 *	current position in image,
 *	motionvectors,
 *	pointers to compensated and previous Vops,
 *	width of the compensated Vop
 *  width of the previous/reference Vop
 *
 * Arguments in/out :	
 *	
 *
 * Arguments out :	
 *	
 *
 * Return values :	
 *	
 *
 * Side effects :	
 *	
 *
 * Description :	
 *	Based on rutine from tmn-software (Karl Olav Lillevold)
 *
 * See also :
 *	
 *
 * Modified :28.08.97 Minhua Zhou: added unrestricted MC in Chrominance			
 *	07.05.98 Jong Deuk Kim (HYUNDAI): modified for field MC
 *	16.08.99 Shigeru Fukunaga (Oki): restricted motion compensation 
 *					 within NEWPRED segment
 *	06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 *	28.11.99 Shigeru Fukunaga (Oki): modified modules for NEWPRED
 *	
 *
 ***********************************************************CommentEnd********/

Void
GetPred_Chroma (Int x_curr,
	       Int y_curr,
	       Int dx,
	       Int dy,
	       Vop *prev,
	       Vop *comp_Vop,
	       Int width,
	       Int width_prev,
               Int prev_x_min,
               Int prev_y_min,
               Int prev_x_max,
               Int prev_y_max,
               Int interlaced /* HYUNDAI 980507 */)
{
  Int m,n;

  Int x, y, ofx, ofy, lx;
  Int xint, yint;
  Int xh, yh;
  Int rounding_control;
  Int index1,index2,index3,index4;

  /** added for NEWPRED (Oki) 16-AUG-1999 **/
  Int np_seg_id;		/* NEWPRED segment ID */
  Int num_segments;		/* number of NEWPRED segments per VOP */
  Int mba_segment[MAXNPSEG];	/* MB address of each NEWPRED segment */
  /** end of NEWPRED (Oki) 16-AUG-1999 **/

/* >>> added for DRC by Fujitsu (top)    <<< */
  Int b_size, mba_scale;
/* >>> added for DRC by Fujitsu (bottom) <<< */

/* >>> added for DRC by Fujitsu (top)    <<< */
  if(GetVopReducedResolution(comp_Vop)) {
    b_size = 16;
    mba_scale = 4;
  } else {
    b_size = 8;
    mba_scale = 1;
  }
/* >>> added for DRC by Fujitsu (bottom) <<< */
  /** added for NEWPRED (Oki) 16-AUG-1999 **/
  if(GetVopNewpredEnable(comp_Vop)){
    /* set number & MB address of NEWPRED segment */
    num_segments = GetVopNewpredNumVps(comp_Vop);
    for(np_seg_id = 0; np_seg_id <= num_segments; np_seg_id++)
      mba_segment[np_seg_id] = GetVopNewpredMbaVp(comp_Vop, np_seg_id)/mba_scale; /* >>> modified for DRC by Fujitsu <<< */

    /* searching NEWPRED segment number which the MB includes */
    for(np_seg_id = num_segments - 1; np_seg_id >= 0; np_seg_id--){
      if(y_curr/(b_size*2) * width/(b_size*2) + x_curr/(b_size*2) >= mba_segment[np_seg_id]) /* >>> modified for DRC by Fujitsu <<< */
	break;
    }

    /* restricting Ymax/min within NEWPRED segment */
    if(np_seg_id > 0)
      prev_y_min = (Int)(mba_segment[np_seg_id]/(width/(b_size*2))) * (b_size); /* >>> modified for DRC by Fujitsu <<< *//** modified for NEWPRED (Oki) 28-NOV-1999 **/
    /** modified for NEWPRED (Oki) 28-NOV-1999 **/
    if(np_seg_id < num_segments - 1){  
      if((mba_segment[np_seg_id+1] - mba_segment[np_seg_id] < (width/(b_size*2))) && (mba_segment[np_seg_id+1] % (width/(b_size*2))) > 0){
	prev_y_max = (Int)(mba_segment[np_seg_id + 1]/(width/(b_size*2)) + 1) * (b_size); /* >>> modified for DRC by Fujitsu <<< */
      }
      else
	prev_y_max = mba_segment[np_seg_id + 1]/(width/(b_size*2)) * (b_size); /* >>> modified for DRC by Fujitsu <<< */
    }

    /* restricting Xmax/min within NEWPRED segment */
    if(mba_segment[np_seg_id+1] - mba_segment[np_seg_id] < (width/(b_size*2))){ /* small VP case */
      if(mba_segment[np_seg_id] % (width/(b_size*2))){
	prev_x_min = (mba_segment[np_seg_id] % (width/(b_size*2))) * (b_size);
      }
      if(mba_segment[np_seg_id+1] % (width/(b_size*2))){
	prev_x_max = (mba_segment[np_seg_id+1] % (width/(b_size*2))) * (b_size);
      }
    }
    /** end of NEWPRED (Oki) 28-NOV-1999 **/
  }
  /** end of NEWPRED (Oki) 16-AUG-1999 **/

  lx = width_prev/2;

  x = x_curr>>1;
  y = y_curr>>1;

  xint = dx>>1;
  xh = dx & 1;
  yint = dy>>1;
  yh = dy & 1;
  rounding_control = GetVopRoundingType(comp_Vop);

  if (!xh && !yh)
    {
      for (n = 0; n < b_size; n++) /* >>> modified for DRC by Fujitsu <<< */
	{
	  for (m = 0; m < b_size; m++) /* >>> modified for DRC by Fujitsu <<< */
	    {
	      ofx = x + xint + m;
	      ofy = y + yint + n;
              index1 = unrestricted_MC_chro(ofx,ofy,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);
              comp_Vop->v_chan->f[(y+n)*width/2+x+m] 
		= *(prev->v_chan->f+ index1);
              comp_Vop->u_chan->f[(y+n)*width/2+x+m]
		= *(prev->u_chan->f+index1);
	    }
	}
    }
  else if (!xh && yh)
    {
      for (n = 0; n < b_size; n++) /* >>> modified for DRC by Fujitsu <<< */
	{
	  for (m = 0; m < b_size; m++) /* >>> modified for DRC by Fujitsu <<< */
	    {
	      ofx = x + xint + m;
	      ofy = y + yint + n;
              index1 =  unrestricted_MC_chro(ofx,ofy,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);
              index2 =  unrestricted_MC_chro(ofx,ofy+yh,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);

	      comp_Vop->v_chan->f[(y+n)*width/2+x+m]
		= (*(prev->v_chan->f+index1) +
		   *(prev->v_chan->f+index2) + 1- rounding_control)>>1;

	      comp_Vop->u_chan->f[(y+n)*width/2+x+m]
		= (*(prev->u_chan->f+index1) +
		   *(prev->u_chan->f+index2) + 1- rounding_control)>>1;
	    }
	}
    }
  else if (xh && !yh)
    {
      for (n = 0; n < b_size; n++) /* >>> modified for DRC by Fujitsu <<< */
	{
	  for (m = 0; m < b_size; m++) /* >>> modified for DRC by Fujitsu <<< */
	    {
	      ofx = x + xint + m;
	      ofy = y + yint + n;
              index1 =  unrestricted_MC_chro(ofx,ofy,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);
              index2 =  unrestricted_MC_chro(ofx+xh,ofy,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);

	      comp_Vop->v_chan->f[(y+n)*width/2+x+m]
		= (*(prev->v_chan->f+index1) +
		   *(prev->v_chan->f+index2) + 1- rounding_control)>>1;

	      comp_Vop->u_chan->f[(y+n)*width/2+x+m]
		= (*(prev->u_chan->f+index1) +
		   *(prev->u_chan->f+index2) + 1- rounding_control)>>1;
	    }
	}
    }
  else
    { /* xh && yh */
      for (n = 0; n < b_size; n++) /* >>> modified for DRC by Fujitsu <<< */
	{
	  for (m = 0; m < b_size; m++) /* >>> modified for DRC by Fujitsu <<< */
	    {
	      ofx = x + xint + m;
	      ofy = y + yint + n;
              index1 =  unrestricted_MC_chro(ofx,ofy,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);
              index2 =  unrestricted_MC_chro(ofx+xh,ofy,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);
              index3 =  unrestricted_MC_chro(ofx,ofy+yh,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);
              index4 =  unrestricted_MC_chro(ofx+xh,ofy+yh,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);


	      comp_Vop->v_chan->f[(y+n)*width/2+x+m]
		= (*(prev->v_chan->f+index1)+
		   *(prev->v_chan->f+index2)+
		   *(prev->v_chan->f+index3)+
		   *(prev->v_chan->f+index4)+
		   2- rounding_control)>>2;

	      comp_Vop->u_chan->f[(y+n)*width/2+x+m]
		= (*(prev->u_chan->f+index1)+
		   *(prev->u_chan->f+index2)+
		   *(prev->u_chan->f+index3)+
		   *(prev->u_chan->f+index4)+
		   2- rounding_control)>>2;
	    }
	}
    }
  return;
}

Void
GetPred_Chroma1 (Int x_curr,
	       Int y_curr,
	       Int dx,
	       Int dy,
	       SInt *prev_u,
	       SInt *prev_v,
				 Vop *comp_Vop,
	       Int width,
	       Int width_prev,
               Int prev_x_min,
               Int prev_y_min,
               Int prev_x_max,
               Int prev_y_max,
               Int interlaced /* HYUNDAI 980507 */)
{
  Int m,n;

  Int x, y, ofx, ofy, lx;
  Int xint, yint;
  Int xh, yh;
  Int rounding_control;
  Int index1,index2,index3,index4;

  lx = width_prev/2;

  x = x_curr>>1;
  y = y_curr>>1;

  xint = dx>>1;
  xh = dx & 1;
  yint = dy>>1;
  yh = dy & 1;
  rounding_control = GetVopRoundingType(comp_Vop);

  if (!xh && !yh)
    {
      for (n = 0; n < 8; n++)
	{
	  for (m = 0; m < 8; m++)
	    {
	      ofx = x + xint + m;
	      ofy = y + yint + n;
              index1 = unrestricted_MC_chro(ofx,ofy,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);
              comp_Vop->v_chan->f[(y+n)*width/2+x+m] 
		= *(prev_v + index1);
              comp_Vop->u_chan->f[(y+n)*width/2+x+m]
		= *(prev_u + index1);
	    }
	}
    }
  else if (!xh && yh)
    {
      for (n = 0; n < 8; n++)
	{
	  for (m = 0; m < 8; m++)
	    {
	      ofx = x + xint + m;
	      ofy = y + yint + n;
              index1 =  unrestricted_MC_chro(ofx,ofy,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);
              index2 =  unrestricted_MC_chro(ofx,ofy+yh,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);

	      comp_Vop->v_chan->f[(y+n)*width/2+x+m]
		= (*(prev_v+index1) +
		   *(prev_v+index2) + 1- rounding_control)>>1;

	      comp_Vop->u_chan->f[(y+n)*width/2+x+m]
		= (*(prev_u+index1) +
		   *(prev_u+index2) + 1- rounding_control)>>1;
	    }
	}
    }
  else if (xh && !yh)
    {
      for (n = 0; n < 8; n++)
	{
	  for (m = 0; m < 8; m++)
	    {
	      ofx = x + xint + m;
	      ofy = y + yint + n;
              index1 =  unrestricted_MC_chro(ofx,ofy,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);
              index2 =  unrestricted_MC_chro(ofx+xh,ofy,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);

	      comp_Vop->v_chan->f[(y+n)*width/2+x+m]
		= (*(prev_v+index1) +
		   *(prev_v+index2) + 1- rounding_control)>>1;

	      comp_Vop->u_chan->f[(y+n)*width/2+x+m]
		= (*(prev_u+index1) +
		   *(prev_u+index2) + 1- rounding_control)>>1;
	    }
	}
    }
  else
    { /* xh && yh */
      for (n = 0; n < 8; n++)
	{
	  for (m = 0; m < 8; m++)
	    {
	      ofx = x + xint + m;
	      ofy = y + yint + n;
              index1 =  unrestricted_MC_chro(ofx,ofy,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);
              index2 =  unrestricted_MC_chro(ofx+xh,ofy,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);
              index3 =  unrestricted_MC_chro(ofx,ofy+yh,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);
              index4 =  unrestricted_MC_chro(ofx+xh,ofy+yh,lx,prev_x_min,
                                  prev_y_min,prev_x_max,prev_y_max,
                                  interlaced /* HYUNDAI 980507 */);


	      comp_Vop->v_chan->f[(y+n)*width/2+x+m]
		= (*(prev_v+index1)+
		   *(prev_v+index2)+
		   *(prev_v+index3)+
		   *(prev_v+index4)+
		   2- rounding_control)>>2;

	      comp_Vop->u_chan->f[(y+n)*width/2+x+m]
		= (*(prev_u+index1)+
		   *(prev_u+index2)+
		   *(prev_u+index3)+
		   *(prev_u+index4)+
		   2- rounding_control)>>2;
	    }
	}
    }
  return;
}

/***********************************************************CommentBegin******
 *
 * -- GetPred_Field_Chroma -- Find the prediction block
 *
 * Author :
 *  Bob Eifrig
 *
 * Created :
 *  21-jan-97
 *
 * Purpose :
 *  Find the chrominance prediction for a field
 *
 * Arguments in :
 *  Macroblock coordinates,
 *  motion vector,
 *  reference images,
 *  perimeter expansion value
 *  reference field selection code
 *
 * Arguments in/out :
 *
 *
 * Arguments out :
 *  chrominace prediction block the component images
 *
 * Return values :
 *
 *
 * Side effects :
 *
 * Description :
 *
 *
 * See also :
 *
 *
 * Modified :
 *	07.05.98 Jong Deuk Kim, Cheol Soo Park (HYUNDAI): modified for filed-based prediction
 *
 ***********************************************************CommentEnd********/
void
GetPred_Field_Chroma(Int mbx,
                        Int mby,
                        Float *xvec,
                        Float *yvec,
                        Vop *ref,
                        Vop *pred,
                        Int how,
                        Int edge,
/* HYUNDAI 980507 : start */
                        Int prev_x_min,
                        Int prev_y_min,
                        Int prev_x_max,
                        Int prev_y_max)
/* HYUNDAI 980507 : end */
{
    Int x, y, dx, dy, k, code, round;
    SInt *pURef, *pUPred, *pVRef, *pVPred;
    Int rwidth, rwidth2, pwidth, pwidth2;

/* HYUNDAI 980507 : start */
    Int  pred1_u=0, pred2_u=0, pred3_u=0, pred4_u=0;
    Int  pred1_v=0, pred2_v=0, pred3_v=0, pred4_v=0;
    Int  ref_off;
/* HYUNDAI 980507 : end */
 
    pwidth = GetImageSizeX(pred->u_chan);
    pwidth2 = pwidth << 1;
    rwidth = GetImageSizeX(ref->u_chan);
    rwidth2 = rwidth << 1;
 
    k = 2*mbx + 4*mby*pwidth2/MB_SIZE;
    xvec += k;
    yvec += k;
 
    mbx *= MB_SIZE/2;
    mby *= MB_SIZE/2;
 
    /*
     * Motion compensate the top chroma field
     */
 
    dx = (Int)(2*xvec[0]);      /* half luma pel units */
    dy = (Int)(2*yvec[0]);
 
/* HYUNDAI 980507 : start */
    dx = ((dx & 3) ? ((dx >> 1) | 1) : (dx >> 1)) ;
    dy = ((dy & 6) ? ((dy >> 1) | 2) : (dy >> 1)) ;
/* HYUNDAI 980507 : end */

    code = (dx & 1) | (dy & 2);
    dx >>= 1;
    dy = (dy >> 1) & ~1;
 
/* HYUNDAI 980507 : start */
    if (how & 2)
    {
         ref_off = 1;
         dy++;
    }
    else ref_off = 0;

    k = mbx + mby * pwidth;
    pUPred = (SInt *)pred->u_chan->f + k;
    pVPred = (SInt *)pred->v_chan->f + k;
 
    pURef = (SInt *)ref->u_chan->f ;
    pVRef = (SInt *)ref->v_chan->f ;
/* HYUNDAI 980507 : end */
 
    switch (code) {
 
    case 0:                                         /* no interp */
        for (y = 0; y < MB_SIZE/2; y += 2) {
          for (x = 0; x < MB_SIZE/2; x++) {
/* HYUNDAI 980507 : start 
            pred1_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred1_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off)); 
            pUPred[x] = pred1_u ;
            pVPred[x] = pred1_v ;
   HYUNDAI 980507 : end */
/* HYUNDAI 981019 : start */
            pred1_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred1_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max)); 
            pUPred[x] = pred1_u ;
            pVPred[x] = pred1_v ;
/* HYUNDAI 981019 : end */

          }
          pUPred += pwidth2;
          pVPred += pwidth2;
        }
        break;
 
    case 1:                                         /* horizontal interp */
        round = 1 - pred->rounding_type;
        for (y = 0; y < MB_SIZE/2; y += 2) {
          for (x = 0; x < MB_SIZE/2; x++) {
/* HYUNDAI 980507 : start 
            pred1_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred2_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x+1, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred1_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred2_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x+1, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pUPred[x] = (pred1_u+pred2_u + round) >> 1;
            pVPred[x] = (pred1_v+pred2_v + round) >> 1;
   HYUNDAI 980507 : end */
/* HYUNDAI 981019 : start */
            pred1_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred2_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x+1, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred1_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred2_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x+1, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pUPred[x] = (pred1_u+pred2_u + round) >> 1;
            pVPred[x] = (pred1_v+pred2_v + round) >> 1;
/* HYUNDAI 981019 : end */

          }
          pUPred += pwidth2;
          pVPred += pwidth2;
        }
        break;
 
    case 2:                                         /* vertical interp */
        round = 1 - pred->rounding_type;
        for (y = 0; y < MB_SIZE/2; y += 2) {
          for (x = 0; x < MB_SIZE/2; x++) {
/* HYUNDAI 980507 : start 
            pred1_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred2_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y+2, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred1_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred2_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y+2, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pUPred[x] = (pred1_u + pred2_u + round) >> 1;
            pVPred[x] = (pred1_v + pred2_v + round) >> 1;
   HYUNDAI 980507 : end */
/* HYUNDAI 981019 : start */
            pred1_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred2_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y+2, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred1_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred2_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y+2, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pUPred[x] = (pred1_u + pred2_u + round) >> 1;
            pVPred[x] = (pred1_v + pred2_v + round) >> 1;
/* HYUNDAI 981019 : end */
          }
          pUPred += pwidth2;
          pVPred += pwidth2;
        }
        break;
 
    case 3:                                         /* horiz & vert interp */
        round = 2 - pred->rounding_type;
        for (y = 0; y < MB_SIZE/2; y += 2) {
          for (x = 0; x < MB_SIZE/2; x++) {
/* HYUNDAI 980507 : start 
            pred1_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x,  mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred2_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x+1,mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred3_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x,  mby+dy+y+2,rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred4_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x+1,mby+dy+y+2,rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred1_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x,  mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred2_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x+1,mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred3_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x,  mby+dy+y+2,rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred4_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x+1,mby+dy+y+2,rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off)); 
            pUPred[x] = (pred1_u+pred2_u+pred3_u+pred4_u + round) >> 2 ;
            pVPred[x] = (pred1_v+pred2_v+pred3_v+pred4_v + round) >> 2 ;
   HYUNDAI 980507 : end */
/* HYUNDAI 981019 : start */
            pred1_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x,  mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred2_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x+1,mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred3_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x,  mby+dy+y+2,rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred4_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x+1,mby+dy+y+2,rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred1_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x,  mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred2_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x+1,mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred3_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x,  mby+dy+y+2,rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred4_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x+1,mby+dy+y+2,rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max)); 
            pUPred[x] = (pred1_u+pred2_u+pred3_u+pred4_u + round) >> 2 ;
            pVPred[x] = (pred1_v+pred2_v+pred3_v+pred4_v + round) >> 2 ;
/* HYUNDAI 981019 : end */
            }
            pUPred += pwidth2;
            pVPred += pwidth2;
        }
        break;
    }
 
    /*
     * Motion compensate the bottom chroma field
     */
 
    dx = (Int)(2*xvec[1]);
    dy = (Int)(2*yvec[1]);
 
/* HYUNDAI 980507 : start */
    dx = ((dx & 3) ? ((dx >> 1) | 1) : (dx >> 1)) ;
    dy = ((dy & 6) ? ((dy >> 1) | 2) : (dy >> 1)) ;
/* HYUNDAI 980507 : end */

    code = (dx & 1) | (dy & 2);
    dx >>= 1;
    dy = (dy >> 1) & ~1;
 
/* HYUNDAI 980507 : start */
    if (how & 1)
    {
           ref_off = 1;
           dy++;
    }
    else   ref_off = 0;

    k = mbx + (mby + 1) * pwidth;
    pUPred = (SInt *)pred->u_chan->f + k;
    pVPred = (SInt *)pred->v_chan->f + k;
 
    pURef = (SInt *)ref->u_chan->f ;
    pVRef = (SInt *)ref->v_chan->f ;
/* HYUNDAI 980507 : end */

 
    switch (code) {

    case 0:                                         /* no interp */
        for (y = 0; y < MB_SIZE/2; y += 2) {
            for (x = 0; x < MB_SIZE/2; x++) {
/* HYUNDAI 980507 : start 
            pred1_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred1_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pUPred[x] = pred1_u ;
            pVPred[x] = pred1_v ;
   HYUNDAI 980507 : end */
/* HYUNDAI 981019 : start */
            pred1_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred1_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pUPred[x] = pred1_u ;
            pVPred[x] = pred1_v ;
/* HYUNDAI 981019 : end */
            }
            pUPred += pwidth2;
            pVPred += pwidth2;
        }
        break;
 
    case 1:                                         /* horizontal interp */
        round = 1 - pred->rounding_type;
        for (y = 0; y < MB_SIZE/2; y += 2) {
          for (x = 0; x < MB_SIZE/2; x++) {
/* HYUNDAI 980507 : start 
            pred1_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred2_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x+1, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred1_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred2_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x+1, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pUPred[x] = (pred1_u+pred2_u + round) >> 1;
            pVPred[x] = (pred1_v+pred2_v + round) >> 1;
   HYUNDAI 980507 : end */
/* HYUNDAI 981019 : start */
            pred1_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred2_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x+1, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred1_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred2_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x+1, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pUPred[x] = (pred1_u+pred2_u + round) >> 1;
            pVPred[x] = (pred1_v+pred2_v + round) >> 1;
/* HYUNDAI 981019 : end */
          }
          pUPred += pwidth2;
          pVPred += pwidth2;
        }
        break;
 
    case 2:                                         /* vertical interp */
        round = 1 - pred->rounding_type;
        for (y = 0; y < MB_SIZE/2; y += 2) {
          for (x = 0; x < MB_SIZE/2; x++) {
/* HYUNDAI 980507 : start 
            pred1_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred2_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y+2, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred1_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred2_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y+2, rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pUPred[x] = (pred1_u + pred2_u + round) >> 1;
            pVPred[x] = (pred1_v + pred2_v + round) >> 1;
   HYUNDAI 980507 : end */
/* HYUNDAI 981019 : start */
            pred1_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred2_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y+2, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred1_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred2_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x, mby+dy+y+2, rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pUPred[x] = (pred1_u + pred2_u + round) >> 1;
            pVPred[x] = (pred1_v + pred2_v + round) >> 1;
/* HYUNDAI 981019 : end */
          }
          pUPred += pwidth2;
          pVPred += pwidth2;
        }
        break;
 
    case 3:                                         /* horiz & vert interp */
        round = 2 - pred->rounding_type;
        for (y = 0; y < MB_SIZE/2; y += 2) {
          for (x = 0; x < MB_SIZE/2; x++) {
/* HYUNDAI 980507 : start 
            pred1_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x,  mby+dy+y,rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred2_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x+1,mby+dy+y,rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred3_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x,  mby+dy+y+2,rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred4_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x+1,mby+dy+y+2,rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred1_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x,  mby+dy+y,rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred2_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x+1,mby+dy+y,rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred3_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x,  mby+dy+y+2,rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off));
            pred4_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x+1,mby+dy+y+2,rwidth,
                                        prev_x_min,prev_y_min+ref_off,prev_x_max,prev_y_max+ref_off)); 
            pUPred[x] = (pred1_u+pred2_u+pred3_u+pred4_u + round) >> 2 ;
            pVPred[x] = (pred1_v+pred2_v+pred3_v+pred4_v + round) >> 2 ;
 HYUNDAI 980507 : end */
/* HYUNDAI 981019 : start */
            pred1_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x,  mby+dy+y,rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred2_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x+1,mby+dy+y,rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred3_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x,  mby+dy+y+2,rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred4_u = *(pURef + unrestricted_MC_chro_field(mbx+dx+x+1,mby+dy+y+2,rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred1_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x,  mby+dy+y,rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred2_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x+1,mby+dy+y,rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred3_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x,  mby+dy+y+2,rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max));
            pred4_v = *(pVRef + unrestricted_MC_chro_field(mbx+dx+x+1,mby+dy+y+2,rwidth,
                                        prev_x_min,prev_y_min,prev_x_max,prev_y_max)); 
            pUPred[x] = (pred1_u+pred2_u+pred3_u+pred4_u + round) >> 2 ;
            pVPred[x] = (pred1_v+pred2_v+pred3_v+pred4_v + round) >> 2 ;
/* HYUNDAI 981019 : end */
          }
          pUPred += pwidth2;
          pVPred += pwidth2;
        }
        break;
    }
}

/***********************************************************CommentBegin******
 *  ----  B_VopMotionCompensation ---- Motion compensation for a B-VOP
 *
 * Author :
 *   HHI -- Minhua Zhou
 *
 * Created :
 *   07.03.97
 *
 * Purpose :
 *   Generation of motion-compensated prediction for a B-VOP 
 *
 * Arguments in :
 *   Vop *prev_rec_vop, previous reconstructed VOP
 *   Vop *next_rec_vop, next reconstructed VOP
 *   Image *mot_xi,  horizontal MV coordinates for the B-VOP
 *   Image   *mot_yi,  vertical MV coordinates for the B-VOP
 *   Image *mot_x_Pi, horizontal MV coordinates for the next P-VOP
 *   Image *mot_y_Pi, vertical MV coordinates for the next P-VOP
 *   Image  *modei,  MB prediction modes(forward/backward/interpolative/direct) 
 *   Image  *sub_alphai, sub-sampled alpha plane of the current VOP
 *   Int TRB,  forward temporal distance
 *   Int TRD,  temporal distance between two consecutive P-VOPs
 *  Arguments in/out :
 *
 *
 * Arguments out :
 *   Vop *comp   motion-compensated prediction for the B_VOP
 *
 * Return values :
 *   none
 *
 * Side effects :
 *
 *
 * Description :
 *   The defintion of "co-located macroblock" is not clear in the current VM6.0,
 *   Here, if a block of the co-located macroblock is transparent or
 *   INTRA-coded, the corresponding motion vector for direct mode are set to
 *   zero and the direct mode is still enabled !!!!
 *
 * See also :
 *
 *
 * Modified :
 *   01.08.97 Fernando Jaureguizar: added the printing of modes for
 *            B-VOPs in B_VopMotionCompensation(), like in
 *            VopMotionCompensate().   (SpSc)
 *   28.08.97 Osamu Sunohara: modified to set MV in spatial scalable
 *                            enhancement B-VOP to zero
 *   11.12.97 Bob Eifrig: added code for field motion compensation and
 *            interlaced direct mode.
 *	07.05.98 Jong Deuk Kim (HYUNDAI): revised
 *      21.05.98 Ji Heon Kweon (HYUNDAI) : support for grayscale coding
 *      06.07.98 U. Benzler (TUH) : added quarter pel support
 *
 ************************************************************CommentEnd********/            
Void  B_VopMotionCompensation(
      Vop *curr,
      Vop *prev_rec_vop,
      Vop *next_rec_vop,
      Image *mot_xi,
      Image *mot_yi,
      Image *mot_x_Pi,
      Image *mot_y_Pi,
      Image *mode_Pi,
      Image *modei,
      Image *sub_alphai,
      Int TRB,Int TRD,
      Vop *comp,
      Int quarter_pel, Int edge /* MW QPEL 06-JUL-1998 */)
{
  Vop *prev_rec_vop_padded,*next_rec_vop_padded;
  Int curr_vop_width = GetVopWidth(comp);
  Int curr_vop_height = GetVopHeight(comp);
  Int i,j,MB_num_x,MB_num_y;
           
  /* Padding of VOPs */
  prev_rec_vop_padded = prev_rec_vop;
  next_rec_vop_padded = next_rec_vop;

  /* Motion Compensation for B-VOPs */

  MB_num_x = curr_vop_width/16;
  MB_num_y = curr_vop_height/16;
   
  for (i=0;i<MB_num_y;i++) 
    for (j=0;j<MB_num_x;j++) 
      B_MotionCompensateMB(
	j,
	i,
	curr,
	prev_rec_vop_padded,
	next_rec_vop_padded,
	mot_xi,
	mot_yi,
	mot_x_Pi,
	mot_y_Pi,
	mode_Pi,
	modei,
	sub_alphai,
	TRB,
	TRD,
	comp,
	quarter_pel /* MW QPEL 06-JUL-1998 */,
	edge /* MW QPEL 06-JUL-1998 */);
}
       

Void  B_MotionCompensateMB(
			Int j,
			Int i,
      Vop *curr,
      Vop *prev_rec_vop,
      Vop *next_rec_vop,
      Image *mot_xi,
      Image *mot_yi,
      Image *mot_x_Pi,
      Image *mot_y_Pi,
      Image *mode_Pi,
      Image *modei,
      Image *sub_alphai,
      Int TRB,Int TRD,
      Vop *comp,
      Int quarter_pel /* MW QPEL 06-JUL-1998 */,
      Int edge /* MW QPEL 06-JUL-1998 */)
{
  Vop *prev_rec_vop_padded,*next_rec_vop_padded;
  Int curr_vop_width = GetVopWidth(comp);
  Int curr_vop_height = GetVopHeight(comp);
  Int k,l,col,row,count,MB_num_x,MB_num_y,n;
  SInt MVD_x,MVD_y,vx,vy,vx_f,vy_f,vx_b,vy_b;
  SInt pred_for[6*64],pred_back[6*64], pred_for_g[MAX_MAC][6*64],pred_back_g[MAX_MAC][6*64];
  Int yoff, coff, ewidth=0, pmode, trb_field=0, trd_field=0;
  static int frame_period = 0x7fffffff;     /* a big number */
  SInt sign[4],vx_P[4],vy_P[4],Mode;
  Float *mot_x,*mot_y,*mot_x_P,*mot_y_P,subdim;	/* MW QPEL 06-JUL-1998 */
  Int prev_x_ref, prev_y_ref, prev_x_ref_edge, prev_y_ref_edge, prev_width, prev_height;	/* UB QPEL 20-AUG-1998 */
  Int next_x_ref, next_y_ref, next_x_ref_edge, next_y_ref_edge, next_width, next_height;	/* UB QPEL 20-AUG-1998 */
  SInt *prev_rec_padded,*next_rec_padded,*prev_rec_g_padded[MAX_MAC],*next_rec_g_padded[MAX_MAC];/* UB QPEL 20-AUG-1998 */
  SInt *prev_rec_u_padded,*next_rec_u_padded,*prev_rec_v_padded,*next_rec_v_padded;	/* UB QPEL 20-AUG-1998 */
  SInt  *mode,*sub_alpha,*mode_P;

/* HYUNDAI 980507 : start */
  SInt  vx_top, vy_top, vx_bot, vy_bot;
  SInt  vx_for_top, vy_for_top, vx_for_bot, vy_for_bot;
  SInt  vx_bak_top, vy_bak_top, vx_bak_bot, vy_bak_bot;
/* HYUNDAI 980507 : end */

/* added to set MV in spatial scalable enhancement B-VOP to zero */
/*                                      by Sony 280897 */
  Float MV_x,MV_y;
  Int  spatial_scalability=0;
/* 280897 */

  /* MW QPEL 06-JUL-1998 */
  /* Int edge=16,index;  */
  Int index; 

  mot_x = (Float *)GetImageData(mot_xi);
  mot_y = (Float *)GetImageData(mot_yi);
  mot_x_P = (Float *)GetImageData(mot_x_Pi);
  mot_y_P = (Float *)GetImageData(mot_y_Pi);
  mode = (SInt *)GetImageData(modei);
  mode_P = (SInt *)GetImageData(mode_Pi);
  sub_alpha = (SInt *)GetImageData(sub_alphai);
  /* MW QPEL 06-JUL-1998 */
  if (quarter_pel)
    subdim = 4.0;
  else
    subdim = 2.0;    

  if (GetVopInterlaced(curr)) {
      ewidth = 2*edge + curr_vop_width;
      if (TRB < frame_period)
          frame_period = TRB;
/* HYUNDAI 980507 : start */
      trb_field = 2 * TRB;
      trd_field = 2 * TRD;
/* HYUNDAI 980507 : end */

      if ((trb_field <= 0) || (trd_field <= 0) || (trd_field <= trb_field)) {
          fprintf(stderr, "Negative times: trd=%d, trb=%d\n", trd_field, 
trb_field);
          exit(1);
      }
  }

  /*>SpSc*/
/* added to set spatial scalability flag by Sony 280897 */
 if(GetVopScalability(curr) == 1 &&
    GetVopRefSelCode(curr) == 0){
   spatial_scalability = 1;
 }
/* 280897 */

  /* Padding of VOPs */
  prev_rec_vop_padded = prev_rec_vop;
  next_rec_vop_padded = next_rec_vop;

  
/*  Motion Compensation for B-VOPs */

  MB_num_x=curr_vop_width/16;
  MB_num_y=curr_vop_height/16;
  
  row=i*16;
  col = j*16;
  Mode= mode[i*MB_num_x+j];
  index = 4*i*MB_num_x+j+j;

  /* >> UB QPEL 20-AUG-1998 */
  prev_width = GetVopWidth(prev_rec_vop_padded);
  prev_height = GetVopHeight(prev_rec_vop_padded);

  next_width = GetVopWidth(next_rec_vop_padded);
  next_height = GetVopHeight(next_rec_vop_padded);

  prev_x_ref = col + comp->hor_spat_ref - prev_rec_vop_padded->hor_spat_ref;
  prev_y_ref = row + comp->ver_spat_ref - prev_rec_vop_padded->ver_spat_ref;
  prev_x_ref_edge = col + comp->hor_spat_ref - prev_rec_vop_padded->hor_spat_ref - edge;
  prev_y_ref_edge = row + comp->ver_spat_ref - prev_rec_vop_padded->ver_spat_ref - edge;

  prev_rec_padded = (SInt*)GetImageData(GetVopY(prev_rec_vop_padded)) + prev_x_ref + prev_y_ref*prev_width;
  for(n=0;n<GetVopAuxCompCount(comp);n++) /* MAC (SB) 12-Nov-99 */
    prev_rec_g_padded[n] = (SInt*)GetImageData(GetVopG(n,prev_rec_vop_padded)) + prev_x_ref + prev_y_ref*prev_width;
  prev_rec_u_padded = (SInt*)GetImageData(GetVopU(prev_rec_vop_padded)) + prev_x_ref/2 + prev_y_ref*prev_width/4;
  prev_rec_v_padded = (SInt*)GetImageData(GetVopV(prev_rec_vop_padded)) + prev_x_ref/2 + prev_y_ref*prev_width/4;

  if (GetVopCoded(next_rec_vop) ) 
  { 
    next_x_ref = col + comp->hor_spat_ref - next_rec_vop_padded->hor_spat_ref;
    next_y_ref = row + comp->ver_spat_ref - next_rec_vop_padded->ver_spat_ref;
    next_x_ref_edge = col + comp->hor_spat_ref - next_rec_vop_padded->hor_spat_ref - edge;
    next_y_ref_edge = row + comp->ver_spat_ref - next_rec_vop_padded->ver_spat_ref - edge;
  
    next_rec_padded = (SInt*)GetImageData(GetVopY(next_rec_vop_padded)) + next_x_ref + next_y_ref*next_width;
    for(n=0;n<GetVopAuxCompCount(comp);n++) /* MAC (SB) 12-Nov-99 */
      next_rec_g_padded[n] = (SInt*)GetImageData(GetVopG(n,next_rec_vop_padded)) + next_x_ref + next_y_ref*next_width;
    next_rec_u_padded = (SInt*)GetImageData(GetVopU(next_rec_vop_padded)) + next_x_ref/2 + next_y_ref*next_width/4;
    next_rec_v_padded = (SInt*)GetImageData(GetVopV(next_rec_vop_padded)) + next_x_ref/2 + next_y_ref*next_width/4;
    /* << UB QPEL 20-AUG-1998 */
  }

  switch (Mode) {

  case -1:    /* Transparent */
    break;

  case 0 :    /* forward  */
  case 4 :

#ifdef _DEBUG_BENZ_
    fprintf(stdout, "mode(%d,%d) = forward\n",j,i);
    fprintf(stdout, "X: %5.2f\n",mot_x[index]);
    fprintf(stdout, "Y: %5.2f\n",mot_y[index]);
#endif
    
    if (quarter_pel)	/* MW QPEL 06-JUL-1998 */
      {
	vx = 4.0 * mot_x[index];
	vy = 4.0 * mot_y[index];
	ClipMV(prev_x_ref_edge, prev_y_ref_edge, prev_width, prev_height, edge, &vx, &vy, 4);
	InterpolateBlock(prev_rec_padded, prev_width, vx, vy, 4, 16, 16, pred_for, 16, GetVopRoundingType(curr), GetVopBrightWhite(curr));
	Putblock(col, row, pred_for, comp->y_chan,curr_vop_width,16);
	
	/* HYUNDAI (Grayscale) */
	if(GetVopShape(curr) == GREY_SCALE) {
          for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
            InterpolateBlock(prev_rec_g_padded[n], prev_width, vx, vy, 4, 16, 16, pred_for, 16, GetVopRoundingType(curr), 255);
            Putblock(col, row, pred_for, comp->g_chan[n],curr_vop_width,16);
          }
	}
      }
    else
      {
	halfpel_motion_compensation (
	  (SInt*)GetImageData(GetVopY(prev_rec_vop_padded)),
	  (SInt)(2.0*mot_x[index]),(SInt)(2.0*mot_y[index]),
	  col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref,
	  row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref,
	  GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
	  16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_for,
	  GetVopInterlaced(curr) /* HYUNDAI 980507 */);
	Putblock(col, row, pred_for, comp->y_chan,curr_vop_width,16);
	
	/* HYUNDAI (Grayscale) */
	if(GetVopShape(curr) == GREY_SCALE) {
          for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
            halfpel_motion_compensation (
              (SInt*)GetImageData(GetVopG(n,prev_rec_vop_padded)),
              (SInt)(2.0*mot_x[index]),(SInt)(2.0*mot_y[index]),
              col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref,
              row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref,
              GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
              16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_for,0);
            Putblock(col, row, pred_for, comp->g_chan[n],curr_vop_width,16);
          }
	}
      }
    
    
    halfpel_motion_compensation (
      (SInt*)GetImageData(GetVopU(prev_rec_vop_padded)),
      (SInt)(2.0*mot_x[index]),(SInt)(2.0*mot_y[index]),
      (col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
      (row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
      GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
      8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for,
      GetVopInterlaced(curr) /* HYUNDAI 980507 */);
    Putblock(col/2, row/2, pred_for, comp->u_chan,curr_vop_width/2,8); 
    
    halfpel_motion_compensation (
      (SInt*)GetImageData(GetVopV(prev_rec_vop_padded)),
      (SInt)(2.0*mot_x[index]),(SInt)(2.0*mot_y[index]),
      (col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
      (row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
      GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
      8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for,
      GetVopInterlaced(curr) /* HYUNDAI 980507 */);
    Putblock(col/2, row/2, pred_for, comp->v_chan,curr_vop_width/2,8); 
    
    break;
    
  case 1 :    /* backward  */
    /* added to set MV to zero by Sony 280897 */
    if(spatial_scalability){
      MV_x = 0.0;MV_y=0.0;
    }else{
      MV_x = mot_x[index+1];
      MV_y = mot_y[index+1];          
    }
    /* 280897 */
    
    /* MW QPEL 06-JUL-1998 */
#ifdef _DEBUG_BENZ_
    fprintf(stdout, "mode(%d,%d) = backward\n",j,i);
    fprintf(stdout, "X: %5.2f\n",MV_x);
    fprintf(stdout, "Y: %5.2f\n",MV_y);
#endif
    if (quarter_pel)
      {
	vx = 4.0 * MV_x;
	vy = 4.0 * MV_y;
	ClipMV(next_x_ref_edge, next_y_ref_edge, next_width, next_height, edge, &vx, &vy, 4);
	InterpolateBlock(next_rec_padded, next_width, vx, vy, 4, 16, 16, pred_back, 16, GetVopRoundingType(curr), GetVopBrightWhite(curr));
	Putblock(col, row, pred_back, comp->y_chan,curr_vop_width,16);

	/* HYUNDAI (Grayscale) */ 
	if(GetVopShape(curr) == GREY_SCALE) {
          for(n=0;n<GetVopAuxCompCount(comp);n++) {/* MAC (SB) 12-Nov-99 */
            InterpolateBlock(next_rec_g_padded[n], next_width, vx, vy, 4, 16, 16, pred_back, 16, GetVopRoundingType(curr), 255);
            Putblock(col, row, pred_back, comp->g_chan[n],curr_vop_width,16);
          }
	}
      }
    else
      {
	halfpel_motion_compensation (
	  (SInt*)GetImageData(GetVopY(next_rec_vop_padded)),
	  (SInt)(2.0*MV_x),(SInt)(2.0*MV_y),                /* <-modified!! */
	  col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref,
	  row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref,
	  GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
	  16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_back,
	  GetVopInterlaced(curr) /* HYUNDAI 980507 */);
	Putblock(col, row, pred_back, comp->y_chan,curr_vop_width,16);

	/* HYUNDAI (Grayscale) */ 
	if(GetVopShape(curr) == GREY_SCALE) {
          for(n=0;n<GetVopAuxCompCount(comp);n++) {/* MAC (SB) 12-Nov-99 */
            halfpel_motion_compensation (
              (SInt*)GetImageData(GetVopG(n,next_rec_vop_padded)),
              (SInt)(2.0*MV_x),(SInt)(2.0*MV_y),                /* <-modified!! */
              col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref,
              row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref,
              GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
              16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_back,0);
            Putblock(col, row, pred_back, comp->g_chan[n],curr_vop_width,16);
          }
	}
      }
 	
    
    halfpel_motion_compensation (
      (SInt*)GetImageData(GetVopU(next_rec_vop_padded)),
      (SInt)(2.0*MV_x),(SInt)(2.0*MV_y),                /* <-modified!! */
      (col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
      (row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
      GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
      8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back,
      GetVopInterlaced(curr) /* HYUNDAI 980507 */);
    Putblock(col/2, row/2, pred_back, comp->u_chan,curr_vop_width/2,8); 
    
    halfpel_motion_compensation (
      (SInt*)GetImageData(GetVopV(next_rec_vop_padded)),
      (SInt)(2.0*MV_x),(SInt)(2.0*MV_y),                /* <-modified!! */
      (col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
      (row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
      GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
      8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back,
      GetVopInterlaced(curr) /* HYUNDAI 980507 */);
    Putblock(col/2, row/2, pred_back, comp->v_chan,curr_vop_width/2,8); 
    
    break;
  
  case 2 :   /* interpolative */
    /* added to set MV to zero by Sony 280897 */
    if(spatial_scalability){
      MV_x = 0.0;MV_y=0.0;
    }else{
      MV_x = mot_x[index+1];
      MV_y = mot_y[index+1]; 
    }
    /* 280897 */ 

#ifdef _DEBUG_BENZ_
    fprintf(stdout, "mode(%d,%d) = interpolative\n",j,i);
    fprintf(stdout, "fw X: %5.2f\n",mot_x[index]);
    fprintf(stdout, "fw Y: %5.2f\n",mot_y[index]);
    fprintf(stdout, "bw X: %5.2f\n",MV_x );
    fprintf(stdout, "bw Y: %5.2f\n",MV_y );
#endif

    /* MW QPEL 06-JUL-1998 */
    if (quarter_pel)
      {
	vx = 4.0 * mot_x[index];
	vy = 4.0 * mot_y[index];
	ClipMV(prev_x_ref_edge, prev_y_ref_edge, prev_width, prev_height, edge, &vx, &vy, 4);
	InterpolateBlock(prev_rec_padded, prev_width, vx, vy, 4, 16, 16, pred_for, 16, GetVopRoundingType(curr), GetVopBrightWhite(curr));
	vx = 4.0 * MV_x;
	vy = 4.0 * MV_y;
	ClipMV(next_x_ref_edge, next_y_ref_edge, next_width, next_height, edge, &vx, &vy, 4);
	InterpolateBlock(next_rec_padded, next_width, vx, vy, 4, 16, 16, pred_back, 16, GetVopRoundingType(curr), GetVopBrightWhite(curr));
	for (k=0;k<256;k++) 
	  pred_for[k] = (pred_for[k]+pred_back[k]+1)>>1;
	Putblock(col, row, pred_for, comp->y_chan,curr_vop_width,16);

	/* HYUNDAI (Grayscale) */ 
	if(GetVopShape(curr) == GREY_SCALE) {
          for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
            InterpolateBlock(next_rec_g_padded[n], next_width, vx, vy, 4, 16, 16, pred_back, 16, GetVopRoundingType(curr), 255);
            vx = 4.0 * mot_x[index];
            vy = 4.0 * mot_y[index];
            ClipMV(prev_x_ref_edge, prev_y_ref_edge, prev_width, prev_height, edge, &vx, &vy, 4);
            InterpolateBlock(prev_rec_g_padded[n], prev_width, vx, vy, 4, 16, 16, pred_for, 16, GetVopRoundingType(curr), 255);
            for (k=0;k<256;k++) 
              pred_for[k] = (pred_for[k]+pred_back[k]+1)>>1;
            Putblock(col, row, pred_for, comp->g_chan[n],curr_vop_width,16);
          }
	}
      }
    else
      {
	halfpel_motion_compensation (
	  (SInt*)GetImageData(GetVopY(prev_rec_vop_padded)),
	  (SInt)(2.0*mot_x[index]),(SInt)(2.0*mot_y[index]),
	  col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref,
	  row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref,
	  GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
	  16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_for,
	  GetVopInterlaced(curr) /* HYUNDAI 980507 */);
          
	halfpel_motion_compensation (
	  (SInt*)GetImageData(GetVopY(next_rec_vop_padded)),
	  (SInt)(2.0*MV_x),(SInt)(2.0*MV_y),                /* <-modified!! */
	  col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref,
	  row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref,
	  GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
	  16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_back,
	  GetVopInterlaced(curr) /* HYUNDAI 980507 */);
	for (k=0;k<256;k++) 
	  pred_for[k] = (pred_for[k]+pred_back[k]+1)>>1;
	Putblock(col, row, pred_for, comp->y_chan,curr_vop_width,16);

	/* HYUNDAI (Grayscale) */ 
	if(GetVopShape(curr) == GREY_SCALE) {
          for(n=0;n<GetVopAuxCompCount(comp);n++) {/* MAC (SB) 12-Nov-99 */
            halfpel_motion_compensation (
              (SInt*)GetImageData(GetVopG(n,prev_rec_vop_padded)),
              (SInt)(2.0*mot_x[index]),(SInt)(2.0*mot_y[index]),
              col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref,
              row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref,
              GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
              16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_for,0);
            
            halfpel_motion_compensation (
              (SInt*)GetImageData(GetVopG(n,next_rec_vop_padded)),
              (SInt)(2.0*MV_x),(SInt)(2.0*MV_y),                /* <-modified!! */
              col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref,
              row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref,
              GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
              16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_back,0);
            for (k=0;k<256;k++) 
              pred_for[k] = (pred_for[k]+pred_back[k]+1)>>1;
            Putblock(col, row, pred_for, comp->g_chan[n],curr_vop_width,16);
          }
	}
      }
    
    halfpel_motion_compensation (
      (SInt*)GetImageData(GetVopU(prev_rec_vop_padded)),
      (SInt)(2.0*mot_x[index]),(SInt)(2.0*mot_y[index]),
      (col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
      (row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
      GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
      8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for,
      GetVopInterlaced(curr) /* HYUNDAI 980507 */);

    halfpel_motion_compensation (
      (SInt*)GetImageData(GetVopU(next_rec_vop_padded)),
      (SInt)(2.0*MV_x),(SInt)(2.0*MV_y),                /* <-modified!! */
      (col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
      (row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
      GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
      8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back,
      GetVopInterlaced(curr) /* HYUNDAI 980507 */);
    
    for (k=0;k<64;k++) 
      pred_for[k] = (pred_for[k]+pred_back[k]+1)>>1;
    Putblock(col/2, row/2, pred_for, comp->u_chan,curr_vop_width/2,8); 
    
    halfpel_motion_compensation (
      (SInt*)GetImageData(GetVopV(prev_rec_vop_padded)),
      (SInt)(2.0*mot_x[index]),(SInt)(2.0*mot_y[index]),
      (col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
      (row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
      GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
      8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for,
      GetVopInterlaced(curr) /* HYUNDAI 980507 */);

    halfpel_motion_compensation (
      (SInt*)GetImageData(GetVopV(next_rec_vop_padded)),
      (SInt)(2.0*MV_x),(SInt)(2.0*MV_y),                /* <-modified!! */
      (col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
      (row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
      GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
      8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back,
      GetVopInterlaced(curr) /* HYUNDAI 980507 */);
    
    for (k=0;k<64;k++) 
      pred_for[k] = (pred_for[k]+pred_back[k]+1)>>1;
    Putblock(col/2, row/2, pred_for, comp->v_chan,curr_vop_width/2,8); 

    break;

  case 3:    /*  direct mode */
    pmode = serach_for_vectors_of_co_located_MB
      (mot_x_P,mot_y_P,mode_P,
       col/*+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref-edge*/,
       row/*+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref-edge*/,
       GetVopWidth(next_rec_vop_padded)-2*edge,
       GetVopHeight(next_rec_vop_padded)-2*edge,
       vx_P,vy_P,subdim /* MW QPEL 06-JUL-1998 */);
    
    /* MW QPEL 06-JUL-1998 */
    /* MVD_x = (SInt)(2.0*mot_x[index+2*MB_num_x+1]); */
    /* MVD_y = (SInt)(2.0*mot_y[index+2*MB_num_x+1]); */
    MVD_x = (SInt)(subdim*mot_x[index+2*MB_num_x+1]);
    MVD_y = (SInt)(subdim*mot_y[index+2*MB_num_x+1]);


    if ((pmode >= MBM_FIELD00) && (pmode <= MBM_FIELD11)) {
      /* MW QPEL 06-JUL-1998 */
      static Int dtrt[] = {  0, 0,  1, 1, 0, 0, -1, -1 }; /* char->Int: SGI-fix 03.11.98, SB */
      static Int dtrb[] = { -1, 0, -1, 0, 1, 0,  1,  0 }; /* char->Int: SGI-fix 03.11.98, SB */
      
      SInt ftx, fty, btx, bty, trbt, trdt;
      SInt fbx, fby, bbx, bby, trbb, trdb;
      Int code = pmode - MBM_FIELD00;

      /* HYUNDAI 980507 : start */
      Int top_off, bot_off;
      top_off = (code & 2) ? 1 : 0;
      bot_off = (code & 1) ? 1 : 0;
      /* HYUNDAI 980507 : end */
#ifdef _DEBUG_BENZ_
      printf("Direct Field MV (mode %3d) Mblk. (%2d,%2d) : mvdx= %5.2f mvdy= %5.2f\n",pmode,j,i,MVD_x / subdim, MVD_y / subdim);
#endif

      if (GetVopTopFieldFirst(curr)) code += 4;
      trdt = trd_field + dtrt[code];
      trbt = trb_field + dtrt[code];
      trdb = trd_field + dtrb[code];
      trbb = trb_field + dtrb[code];

      /* Find MVs for the top field */
      ftx = (SInt)((trbt * vx_P[0]) / trdt + MVD_x);
      fty = (SInt)((trbt * vy_P[0]) / trdt + MVD_y);
      btx = MVD_x ? (ftx - vx_P[0]) : (SInt)(((trbt - trdt) * vx_P[0]) / trdt);
      bty = MVD_y ? (fty - vy_P[0]) : (SInt)(((trbt - trdt) * vy_P[0]) / trdt);

      /* MW QPEL 06-JUL-1998: clip no longer necessary??? */
      /* ClipMV(col, row, curr_vop_width, curr_vop_height, edge, &ftx, &fty, (Int)subdim); */
      /* ClipMV(col, row, curr_vop_width, curr_vop_height, edge, &btx, &bty, (Int)subdim); */
      
      /* Find MVs for the bottom field */
      fbx = (SInt)((trbb * vx_P[1]) / trdb + MVD_x);
      fby = (SInt)((trbb * vy_P[1]) / trdb + MVD_y);
      bbx = MVD_x ? (fbx - vx_P[1]) : (SInt)(((trbb - trdb) * vx_P[1]) / trdb);
      bby = MVD_y ? (fby - vy_P[1]) : (SInt)(((trbb - trdb) * vy_P[1]) / trdb);
#ifdef _DEBUG_BENZ_
      printf("      Forw. Top : %5.2f/%5.2f ; Bot : %5.2f/%5.2f\n",ftx/subdim,fty/subdim,fbx/subdim,fby/subdim);
      printf("      Back. Top : %5.2f/%5.2f ; Bot : %5.2f/%5.2f\n",btx/subdim,bty/subdim,bbx/subdim,bby/subdim);
#endif

      yoff =  (col + edge) + (row + edge) *  ewidth;
      coff = ((col + edge) + (row + edge) * (ewidth >> 1)) >> 1;

      /* MW QPEL 06-JUL-1998 */
      if(quarter_pel)
	{
	  /* Obtain the forward and backward parts of the top field */

	  vx = ftx ; vy = fty;
	  ClipMV(prev_x_ref_edge, prev_y_ref_edge, prev_width, prev_height, edge, &vx, &vy, 4);
	  
	  InterpolateBlock(prev_rec_padded + (top_off ? prev_width : 0), prev_width , vx, (vy&~1)/*no LSB for vertical field vectors*/,
			   4 , 16 , 8 , pred_for , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
	  if(GetVopShape(curr) == GREY_SCALE) { /* U. Benzler 981209 : added interlaced greyscale support */
            for(n=0;n<GetVopAuxCompCount(comp);n++) {/* MAC (SB) 12-Nov-99 */
              InterpolateBlock(prev_rec_g_padded[n] + (top_off ? prev_width : 0), prev_width ,
                               vx, (vy&~1)/*no LSB for vertical field vectors*/,
                               4 , 16 , 8 , pred_for_g[n] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
            }
	  }

	  vx = btx ; vy = bty;
	  ClipMV(next_x_ref_edge, next_y_ref_edge, next_width, next_height, edge, &vx, &vy, 4);
	  InterpolateBlock(next_rec_padded, next_width , vx, (vy&~1)/*no LSB for vertical field vectors*/,
			   4 , 16 , 8 , pred_back , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
	  if(GetVopShape(curr) == GREY_SCALE) { /* U. Benzler 981209 : added interlaced greyscale support */
            for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
              InterpolateBlock(next_rec_g_padded[n], next_width , vx, (vy&~1)/*no LSB for vertical field vectors*/,
                               4 , 16 , 8 , pred_back_g[n] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
            }
	  }

	  /* Obtain the forward and backward parts of the bottom field */

	  vx = fbx ; vy = fby;
	  ClipMV(prev_x_ref_edge, prev_y_ref_edge, prev_width, prev_height, edge, &vx, &vy, 4);
	  InterpolateBlock(prev_rec_padded + (bot_off ? prev_width : 0), prev_width , vx, (vy&~1)/*no LSB for vertical field vectors*/,
			   4 , 16 , 8 , &pred_for[16] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
	  if(GetVopShape(curr) == GREY_SCALE) { /* U. Benzler 981209 : added interlaced greyscale support */
            for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
              InterpolateBlock(prev_rec_g_padded[n] + (bot_off ? prev_width : 0), prev_width ,
                               vx, (vy&~1)/*no LSB for vertical field vectors*/,
                               4 , 16 , 8 , &pred_for_g[n][16] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
            }
	  }

	  vx = bbx ; vy = bby;
	  ClipMV(next_x_ref_edge, next_y_ref_edge, next_width, next_height, edge, &vx, &vy, 4);
	  InterpolateBlock(next_rec_padded + next_width, next_width , vx, (vy&~1)/*no LSB for vertical field vectors*/,
			   4 , 16 , 8 , &pred_back[16] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
	  if(GetVopShape(curr) == GREY_SCALE) { /* U. Benzler 981209 : added interlaced greyscale support */
            for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
              InterpolateBlock(next_rec_g_padded[n] + next_width, next_width , vx, (vy&~1)/*no LSB for vertical field vectors*/,
                               4 , 16 , 8 , &pred_back_g[n][16] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
            }
	  }

	  ftx /=2; /* scale 1/4 pel vectors down to half pel for chroma compensation */
	  fty /=2;
	  btx /=2; /* scale 1/4 pel vectors down to half pel for chroma compensation */
	  bty /=2;
	  fbx /=2; /* scale 1/4 pel vectors down to half pel for chroma compensation */
	  fby /=2;
	  bbx /=2; /* scale 1/4 pel vectors down to half pel for chroma compensation */
	  bby /=2;
	  
	}
      else
	{
	  /* HYUNDAI 980507 : start */

	  /* Luminance Compensation..... */

	  /* Forward Top */
	  halfpel_field_compensation (
	    (SInt*)GetImageData(GetVopY(prev_rec_vop_padded)),
	    ftx,fty,
	    col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref,
	    row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref,
	    GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
	    16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_for,1, top_off);

	  /* Backward Top */
	  halfpel_field_compensation (
	    (SInt*)GetImageData(GetVopY(next_rec_vop_padded)),
	    btx,bty,
	    col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref,
	    row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref,
	    GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
	    16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_back,1, 0);

	  /* Forward Bottom */
	  halfpel_field_compensation (
	    (SInt*)GetImageData(GetVopY(prev_rec_vop_padded)),
	    fbx,fby,
	    col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref,
	    row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref,
	    GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
	    16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_for,0, bot_off);
	  
	  /* Backward Bottom */
	  halfpel_field_compensation (
	    (SInt*)GetImageData(GetVopY(next_rec_vop_padded)),
	    bbx,bby,
	    col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref,
	    row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref,
	    GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
	    16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_back,0, 1);
	if(GetVopShape(curr) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support >>*/
	  {
        /* Greyscale Compensation..... */
        /* Forward Top */
            for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
              halfpel_field_compensation (
                (SInt*)GetImageData(GetVopG(n,prev_rec_vop_padded)),
                ftx,fty,
                col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref,
                row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref,
                GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
                16,16,2,0,edge,pred_for_g[n],1, top_off);
              /* Backward Top */
              halfpel_field_compensation (
                (SInt*)GetImageData(GetVopG(n,next_rec_vop_padded)),
                btx,bty,
                col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref,
                row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref,
                GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
                16,16,2,0,edge,pred_back_g[n],1, 0);

              /* Forward Bottom */
              halfpel_field_compensation (
                (SInt*)GetImageData(GetVopG(n,prev_rec_vop_padded)),
                fbx,fby,
                col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref,
                row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref,
                GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
                16,16,2,0,edge,pred_for_g[n],0, bot_off);
              /* Backward Bottom */
              halfpel_field_compensation (
                (SInt*)GetImageData(GetVopG(n,next_rec_vop_padded)),
                bbx,bby,
                col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref,
                row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref,
                GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
                16,16,2,0,edge,pred_back_g[n],0, 1);
            }
          } /* U. Benzler 981209 : added interlaced greyscale support <<*/
	}
	  
	  for (k=0;k<256;k++) 
	    pred_for[k] = (pred_for[k]+pred_back[k]+1)>>1;
	  Putblock(col, row, pred_for, comp->y_chan,curr_vop_width,16);

	if(GetVopShape(curr) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support >>*/
	  {
            for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
              for (k=0;k<256;k++) pred_for_g[n][k] = (pred_for_g[n][k]+pred_back_g[n][k]+1)>>1;
              Putblock(col, row, pred_for_g[n], comp->g_chan[n],curr_vop_width,16);
            }
	  }
 
	  /* Chrominance Compensation..... */
              
	  /* Forward Top */
	  halfpel_field_compensation (
	    (SInt*)GetImageData(GetVopU(prev_rec_vop_padded)),
	    ftx, fty,
	    (col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
	    (row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
	    GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
	    8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for, 1, top_off);
	  
	  /* Backward Top */                             
	  halfpel_field_compensation (
	    (SInt*)GetImageData(GetVopU(next_rec_vop_padded)),
	    btx, bty,
	    (col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
	    (row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
	    GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
	    8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back, 1, 0);
	  
	  /* Forward Bottom */                      
	  halfpel_field_compensation (
	    (SInt*)GetImageData(GetVopU(prev_rec_vop_padded)),
	    fbx, fby,
	    (col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
	    (row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
	    GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
	    8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for, 0, bot_off);
	  
	  /* Backward Bottom */                          
	  halfpel_field_compensation (
	    (SInt*)GetImageData(GetVopU(next_rec_vop_padded)),
	    bbx, bby,
	    (col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
	    (row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
	    GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
	    8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back, 0, 1);
	  
	  for (k=0;k<64;k++) 
	    pred_for[k] = (pred_for[k]+pred_back[k]+1)>>1;
	  Putblock(col/2, row/2, pred_for, comp->u_chan,curr_vop_width/2,8);

	  /* Forward Top */                                                       
	  halfpel_field_compensation (
	    (SInt*)GetImageData(GetVopV(prev_rec_vop_padded)),
	    ftx, fty,
	    (col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
	    (row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
	    GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
	    8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for, 1, top_off);
            
	  /* Backward Top */
	  halfpel_field_compensation (
	    (SInt*)GetImageData(GetVopV(next_rec_vop_padded)),
	    btx, bty,
	    (col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
	    (row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
	    GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
	    8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back, 1, 0);
	  
	  /* Forward Bottom */
	  halfpel_field_compensation (
	    (SInt*)GetImageData(GetVopV(prev_rec_vop_padded)),
	    fbx, fby,
	    (col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
	    (row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
	    GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
	    8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for, 0,bot_off );
	  
	  /* Backward Bottom */                          
	  halfpel_field_compensation (
	    (SInt*)GetImageData(GetVopV(next_rec_vop_padded)),
	    bbx, bby,
	    (col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
	    (row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
	    GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
	    8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back, 0, 1);

	  for (k=0;k<64;k++) 
	    pred_for[k] = (pred_for[k]+pred_back[k]+1)>>1;
	  Putblock(col/2, row/2, pred_for, comp->v_chan,curr_vop_width/2,8);
 
	  /* HYUNDAI 980507 : end */
         
      break;
    } /* if ((pmode >= MBM_FIELD00) && (pmode <= MBM_FIELD11)) */
    
    vx_f=vy_f=vx_b=vy_b=count=0;
    sign[0] = sub_alpha[index];
    sign[1] = sub_alpha[index+1];
    sign[2] = sub_alpha[index+2*MB_num_x];
    sign[3] = sub_alpha[index+1+2*MB_num_x];
    
#ifdef _DEBUG_BENZ_
      printf("Direct Frame MV (mode %d) Mblk. (%2d,%2d) : mvdx= %5.2f mvdy= %5.2f\n",pmode,j,i,MVD_x/subdim,MVD_y/subdim);
#endif
    for (k=0;k<4;k++) if (sign[k]!=MBM_TRANSPARENT) {
      count+=4; 
      vx = (TRB*vx_P[k])/TRD+ MVD_x;
      vy = (TRB*vy_P[k])/TRD+ MVD_y;

#ifdef _DEBUG_BENZ_MC_
      printf("direct fwd.Blk. %1d  fvy= %5.2f fvx= %5.2f\n",k,vy/subdim,vx/subdim);
#endif
      
      /* MW QPEL 06-JUL-1998 */
      if (quarter_pel) {

	vx_f+=(Int)(vx/2); vy_f+=(Int)(vy/2);

	vx_top = vx ; vy_top = vy;

	ClipMV(prev_x_ref_edge + (k%2)*8, prev_y_ref_edge + (k/2)*8, prev_width, prev_height, edge, &vx_top, &vy_top, 4);

	InterpolateBlock((SInt *)prev_rec_padded + (k%2)*8 + (k/2)*8*prev_width, prev_width, vx_top, vy_top, 4, 8, 8, pred_for, 8,
			 GetVopRoundingType(curr), GetVopBrightWhite(curr));
      } else {
	vx_f+=vx; vy_f+=vy; 
	halfpel_motion_compensation (
	  (SInt*)GetImageData(GetVopY(prev_rec_vop_padded)),
	  vx,vy,
	  col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref+(k%2)*8,
	  row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref+(k/2)*8,
	  GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
	  8,8,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_for,
	  GetVopInterlaced(curr) /* HYUNDAI 980507 */);
      }
      vx = (MVD_x)? vx-vx_P[k]:((TRB-TRD)*vx_P[k])/TRD;
      vy = (MVD_y)? vy-vy_P[k]:((TRB-TRD)*vy_P[k])/TRD;

#ifdef _DEBUG_BENZ_MC_
      printf("direct bak.Blk. %1d  bvy= %5.2f bvx= %5.2f\n",k,vy/subdim,vx/subdim);
#endif
      
      /* MW QPEL 06-JUL-1998 */
      if (quarter_pel) {

	vx_b += (Int)(vx/2); vy_b +=(Int)(vy/2);

	ClipMV(next_x_ref_edge + (k%2)*8, next_y_ref_edge + (k/2)*8, next_width, next_height, edge, &vx, &vy, 4);

	InterpolateBlock((SInt *)next_rec_padded + (k%2)*8 + (k/2)*8*next_width, next_width, vx, vy, 4, 8, 8, pred_back, 8,
			 GetVopRoundingType(curr), GetVopBrightWhite(curr));
      } else {
	vx_b += vx; vy_b +=vy;
	halfpel_motion_compensation (
	  (SInt*)GetImageData(GetVopY(next_rec_vop_padded)),
	  vx,vy,                         	 
	  col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref+(k%2)*8,
	  row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref+(k/2)*8,
	  GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
	  8,8,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_back,
	  GetVopInterlaced(curr) /* HYUNDAI 980507 */);
      }
	
      for (l=0;l<64;l++) 
        pred_for[l] = (pred_for[l]+pred_back[l]+1)>>1;
      Putblock(col+(k%2)*8, row+(k/2)*8, pred_for, comp->y_chan,curr_vop_width,8);

      /* HYUNDAI (Grayscale) */ 
      if(GetVopShape(curr) == GREY_SCALE) {

        for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */

          vx = (TRB*vx_P[k])/TRD+ MVD_x;
          vy = (TRB*vy_P[k])/TRD+ MVD_y;
	
          /* MW QPEL 06-JUL-1998 */
          if (quarter_pel) {
            vx_top = vx ; vy_top = vy;

            ClipMV(prev_x_ref_edge + (k%2)*8, prev_y_ref_edge + (k/2)*8, prev_width, prev_height, edge, &vx_top, &vy_top, 4);

            InterpolateBlock((SInt *)prev_rec_g_padded[n] + (k%2)*8 + (k/2)*8*prev_width, prev_width, vx_top, vy_top, 
                             4, 8, 8, pred_for, 8,
                             GetVopRoundingType(curr), 255);
          } else {
            halfpel_motion_compensation (
              (SInt*)GetImageData(GetVopG(n,prev_rec_vop_padded)),
              vx,vy,
              col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref+(k%2)*8,
              row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref+(k/2)*8,
              GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
              8,8,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_for,0);
          }
          vx = (MVD_x)? vx-vx_P[k]:((TRB-TRD)*vx_P[k])/TRD;
          vy = (MVD_y)? vy-vy_P[k]:((TRB-TRD)*vy_P[k])/TRD;

          /* MW QPEL 06-JUL-1998 */
          if (quarter_pel) {
            ClipMV(next_x_ref_edge + (k%2)*8, next_y_ref_edge + (k/2)*8, next_width, next_height, edge, &vx, &vy, 4);

            InterpolateBlock((SInt *)next_rec_g_padded[n] + (k%2)*8 + (k/2)*8*next_width, next_width, vx, vy, 4, 8, 8, pred_back, 8,
			 GetVopRoundingType(curr), 255);
          } else {
            halfpel_motion_compensation (
              (SInt*)GetImageData(GetVopG(n,next_rec_vop_padded)),
              vx,vy,
              col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref+(k%2)*8,
              row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref+(k/2)*8,
              GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
              8,8,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_back,0);
          }
          
          for (l=0;l<64;l++) 
            pred_for[l] = (pred_for[l]+pred_back[l]+1)>>1;
          Putblock(col+(k%2)*8, row+(k/2)*8, pred_for, comp->g_chan[n],curr_vop_width,8);           
        }
      }
    }

#ifdef _DEBUG_MV_
    printf("--- MV for Chroma : MVf = (%3d,%3d), MVb = (%3d,%3d)\n", vx_f, vy_f, vx_b, vy_b);
#endif

    /* Chroma MC */
    halfpel_motion_compensation (
      (SInt*)GetImageData(GetVopU(prev_rec_vop_padded)),
      vx_f,vy_f,
      (col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
      (row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
      GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
      8,8,count,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for,
      GetVopInterlaced(curr) /* HYUNDAI 980507 */);

    halfpel_motion_compensation (
      (SInt*)GetImageData(GetVopU(next_rec_vop_padded)),
      vx_b,vy_b,
      (col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
      (row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
      GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
      8,8,count,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back,
      GetVopInterlaced(curr) /* HYUNDAI 980507 */);

    for (k=0;k<64;k++) 
      pred_for[k] = (pred_for[k]+pred_back[k]+1)>>1;
    Putblock(col/2, row/2, pred_for, comp->u_chan,curr_vop_width/2,8); 

    halfpel_motion_compensation (
      (SInt*)GetImageData(GetVopV(prev_rec_vop_padded)),
      vx_f,vy_f,
      (col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
      (row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
      GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
      8,8,count,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for,
      GetVopInterlaced(curr) /* HYUNDAI 980507 */);
      
    halfpel_motion_compensation (
      (SInt*)GetImageData(GetVopV(next_rec_vop_padded)),
      vx_b,vy_b,
      (col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
      (row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
      GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
      8,8,count,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back,
      GetVopInterlaced(curr) /* HYUNDAI 980507 */);
    
    for (k=0;k<64;k++) 
      pred_for[k] = (pred_for[k]+pred_back[k]+1)>>1;
    Putblock(col/2, row/2, pred_for, comp->v_chan,curr_vop_width/2,8); 
    
    break;

  case MBM_B_FWDFLD:
  case MBM_B_FWDFLD | MBM_B_FWDTOP:
  case MBM_B_FWDFLD | MBM_B_FWDBOT:
  case MBM_B_FWDFLD | MBM_B_FWDTOP | MBM_B_FWDBOT:
  
    yoff =  (col + edge) + (row + edge) *  ewidth;
    coff = ((col + edge) + (row + edge) * (ewidth >> 1)) >> 1;

    /* HYUNDAI 980507 : start */
    vx_top = subdim * mot_x[index];               /* Forward Top Motion *//* MW QPEL 06-JUL-1998 */
    vy_top = subdim * mot_y[index];
    
    vx_bot = subdim * mot_x[index+1];             /* Forward Bot Motion *//* MW QPEL 06-JUL-1998 */
    vy_bot = subdim * mot_y[index+1];
    
    /* MW QPEL 06-JUL-1998 */
    if(quarter_pel)
      {
	vx = vx_top;
	vy = vy_top;
	ClipMV(prev_x_ref_edge, prev_y_ref_edge, prev_width, prev_height , edge, &vx, &vy, 4);
	InterpolateBlock(prev_rec_padded + (Mode & MBM_B_FWDTOP ? prev_width : 0), prev_width , vx, (vy&~1)/*no LSB for vertical field vectors*/,
			 4 , 16 , 8 , pred_for , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
	if(GetVopShape(curr) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support >>*/
	  {
            for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
              InterpolateBlock(prev_rec_g_padded[n] + (Mode & MBM_B_FWDTOP ? prev_width : 0), prev_width ,
                               vx, (vy&~1)/*no LSB for vertical field vectors*/,
                               4 , 16 , 8 , pred_for_g[n] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
            }
	  }
	vx = vx_bot;
	vy = vy_bot;
	ClipMV(prev_x_ref_edge, prev_y_ref_edge, prev_width, prev_height, edge, &vx, &vy, 4);
	InterpolateBlock(prev_rec_padded + (Mode & MBM_B_FWDBOT ? prev_width : 0), prev_width , vx, (vy&~1)/*no LSB for vertical field vectors*/,
			 4 , 16 , 8 , &pred_for[16] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
	if(GetVopShape(curr) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support >>*/
	  {
            for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
              InterpolateBlock(prev_rec_g_padded[n] + (Mode & MBM_B_FWDBOT ? prev_width : 0), prev_width ,
                               vx, (vy&~1)/*no LSB for vertical field vectors*/,
                               4 , 16 , 8 , &pred_for_g[n][16] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
            }
	  }

	vx_top /=2; /* scale 1/4 pel vectors down to half pel for chroma compensation */
	vy_top /=2;
	vx_bot /=2; /* scale 1/4 pel vectors down to half pel for chroma compensation */
	vy_bot /=2;
      }
    else
      {
	
	halfpel_field_compensation (
	  (SInt*)GetImageData(GetVopY(prev_rec_vop_padded)),
	  vx_top,vy_top,
	  col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref,
	  row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref,
	  GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
	  16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_for,1, Mode&MBM_B_FWDTOP);
	
	halfpel_field_compensation (                               
	  (SInt*)GetImageData(GetVopY(prev_rec_vop_padded)),
	  vx_bot,vy_bot,
	  col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref,
	  row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref,
	  GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
	  16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_for,0, Mode&MBM_B_FWDBOT);
	if(GetVopShape(curr) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support >>*/
	{
          for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
            halfpel_field_compensation (
              (SInt*)GetImageData(GetVopG(n,prev_rec_vop_padded)),
              vx_top,vy_top,
              col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref,
              row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref,
              GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
              16,16,2,0,edge,pred_for_g[n],1, Mode&MBM_B_FWDTOP);

            halfpel_field_compensation (                               
              (SInt*)GetImageData(GetVopG(n,prev_rec_vop_padded)),
              vx_bot,vy_bot,
              col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref,
              row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref,
              GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
              16,16,2,0,edge,pred_for_g[n],0, Mode&MBM_B_FWDBOT);
          }
        }/* U. Benzler 981209 : added interlaced greyscale support <<*/
      }
	
    Putblock(col, row, pred_for, comp->y_chan,curr_vop_width,16);

    if(GetVopShape(curr) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support >>*/
      {
        for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
          Putblock(col, row, pred_for_g[n], comp->g_chan[n],curr_vop_width,16);
        }
      }
	
    halfpel_field_compensation (
				(SInt*)GetImageData(GetVopU(prev_rec_vop_padded)),
				vx_top, vy_top,
				(col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
				(row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
				GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
				8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for, 1, Mode & MBM_B_FWDTOP);
	
    halfpel_field_compensation (                                  
				(SInt*)GetImageData(GetVopU(prev_rec_vop_padded)),
				vx_bot, vy_bot,
				(col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
				(row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
				GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
				8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for, 0, Mode & MBM_B_FWDBOT);
	
    Putblock(col/2, row/2, pred_for, comp->u_chan,curr_vop_width/2,8);
	
    halfpel_field_compensation (                                       
				(SInt*)GetImageData(GetVopV(prev_rec_vop_padded)),
				vx_top, vy_top,
				(col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
				(row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
				GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
				8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for, 1, Mode & MBM_B_FWDTOP);
	
    halfpel_field_compensation (                                  
				(SInt*)GetImageData(GetVopV(prev_rec_vop_padded)),
				vx_bot, vy_bot,
				(col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
				(row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
				GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
				8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for, 0, Mode & MBM_B_FWDBOT);
    Putblock(col/2, row/2, pred_for, comp->v_chan,curr_vop_width/2,8);
    /*HYUNDAI 980507 : end */

    break;
        
  case MBM_B_BAKFLD:
  case MBM_B_BAKFLD | MBM_B_BAKTOP:
  case MBM_B_BAKFLD | MBM_B_BAKBOT:
  case MBM_B_BAKFLD | MBM_B_BAKTOP | MBM_B_BAKBOT:

    yoff =  (col + edge) + (row + edge) *  ewidth;
    coff = ((col + edge) + (row + edge) * (ewidth >> 1)) >> 1;

    index += 2*MB_num_x;

    /* HYUNDAI 980507 : start */
    vx_top = subdim * mot_x[index];               /* Backward Top Motion *//* MW QPEL 06-JUL-1998 */
    vy_top = subdim * mot_y[index];
	
    vx_bot = subdim * mot_x[index+1];             /* Backward Bot Motion *//* MW QPEL 06-JUL-1998 */
    vy_bot = subdim * mot_y[index+1];

    /* MW QPEL 06-JUL-1998 */
    if(quarter_pel)
      {
	vx = vx_top;
	vy = vy_top;
	ClipMV(next_x_ref_edge, next_y_ref_edge, next_width, next_height, edge, &vx, &vy, 4);
	InterpolateBlock(next_rec_padded + (Mode & MBM_B_BAKTOP ? next_width : 0), next_width , vx, (vy&~1)/*no LSB for vertical field vectors*/,
			 4 , 16 , 8 , pred_back , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
	if(GetVopShape(curr) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support >>*/
	  {
            for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
              InterpolateBlock(next_rec_g_padded[n] + (Mode & MBM_B_BAKTOP ? next_width : 0), next_width ,
                               vx, (vy&~1)/*no LSB for vertical field vectors*/,
                               4 , 16 , 8 , pred_back_g[n] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
            }
	  }
	vx = vx_bot;
	vy = vy_bot;
	ClipMV(next_x_ref_edge, next_y_ref_edge, next_width, next_height, edge, &vx, &vy, 4);
	InterpolateBlock(next_rec_padded + (Mode & MBM_B_BAKBOT ? next_width : 0), next_width , vx, (vy&~1)/*no LSB for vertical field vectors*/,
			 4 , 16 , 8 , &pred_back[16] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
	if(GetVopShape(curr) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support >>*/
	  {
            for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
              InterpolateBlock(next_rec_g_padded[n] + (Mode & MBM_B_BAKBOT ? next_width : 0), next_width , 
                               vx, (vy&~1)/*no LSB for vertical field vectors*/,
                               4 , 16 , 8 , &pred_back_g[n][16] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
            }

          }
	vx_top /=2; /* scale 1/4 pel vectors down to half pel for chroma compensation */
	vy_top /=2;
	vx_bot /=2; /* scale 1/4 pel vectors down to half pel for chroma compensation */
	vy_bot /=2;
      }
    else
      {
	
	halfpel_field_compensation (
	  (SInt*)GetImageData(GetVopY(next_rec_vop_padded)),
	  vx_top,vy_top,
	  col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref,
	  row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref,
	  GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
	  16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_back,1, Mode&MBM_B_BAKTOP);	
	halfpel_field_compensation (                                
	  (SInt*)GetImageData(GetVopY(next_rec_vop_padded)),
	  vx_bot,vy_bot,
	  col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref,
	  row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref,
	  GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
	  16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_back,0, Mode&MBM_B_BAKBOT);
	if(GetVopShape(curr) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support >>*/
	{
          for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
            halfpel_field_compensation (
              (SInt*)GetImageData(GetVopG(n,next_rec_vop_padded)),
              vx_top,vy_top,
              col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref,
              row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref,
              GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
              16,16,2,0,edge,pred_back_g[n],1, Mode&MBM_B_BAKTOP);

            halfpel_field_compensation (                               
              (SInt*)GetImageData(GetVopG(n,next_rec_vop_padded)),
              vx_bot,vy_bot,
              col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref,
              row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref,
              GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
              16,16,2,0,edge,pred_back_g[n],0, Mode&MBM_B_BAKBOT);
          }
	}/* U. Benzler 981209 : added interlaced greyscale support <<*/
      }

    Putblock(col, row, pred_back, comp->y_chan,curr_vop_width,16);
    if(GetVopShape(curr) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support >>*/
      for(n=0;n<GetVopAuxCompCount(comp);n++) 	/* MAC (SB) 12-Nov-99 */
        Putblock(col, row, pred_back_g[n], comp->g_chan[n],curr_vop_width,16);

    halfpel_field_compensation (                                   
				(SInt*)GetImageData(GetVopU(next_rec_vop_padded)),
				vx_top, vy_top,
				(col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
				(row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
				GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
				8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back, 1, Mode & MBM_B_BAKTOP);
    halfpel_field_compensation (
				(SInt*)GetImageData(GetVopU(next_rec_vop_padded)),
				vx_bot, vy_bot,
				(col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
				(row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
				GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
				8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back, 0, Mode & MBM_B_BAKBOT);
    Putblock(col/2, row/2, pred_back, comp->u_chan,curr_vop_width/2,8);
	
    halfpel_field_compensation (                                        
				(SInt*)GetImageData(GetVopV(next_rec_vop_padded)),
				vx_top, vy_top,
				(col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
				(row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
				GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
				8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back, 1, Mode & MBM_B_BAKTOP);
    halfpel_field_compensation (
				(SInt*)GetImageData(GetVopV(next_rec_vop_padded)),
				vx_bot, vy_bot,
				(col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
				(row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
				GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
				8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back, 0, Mode & MBM_B_BAKBOT);
    Putblock(col/2, row/2, pred_back, comp->v_chan,curr_vop_width/2,8);
    /*HYUNDAI 980507 : end */

    break;
    
  case MBM_B_AVEFLD+0x00: case MBM_B_AVEFLD+0x10: case MBM_B_AVEFLD+0x20: 
  case MBM_B_AVEFLD+0x30:
  case MBM_B_AVEFLD+0x40: case MBM_B_AVEFLD+0x50: case MBM_B_AVEFLD+0x60: 
  case MBM_B_AVEFLD+0x70:
  case MBM_B_AVEFLD+0x80: case MBM_B_AVEFLD+0x90: case MBM_B_AVEFLD+0xa0: 
  case MBM_B_AVEFLD+0xb0:
  case MBM_B_AVEFLD+0xc0: case MBM_B_AVEFLD+0xd0: case MBM_B_AVEFLD+0xe0: 
  case MBM_B_AVEFLD+0xf0:

    yoff =  (col + edge) + (row + edge) *  ewidth;
    coff = ((col + edge) + (row + edge) * (ewidth >> 1)) >> 1;

    vx_for_top = subdim * mot_x[index];           /* Forward Top Motion *//* MW QPEL 06-JUL-1998 */
    vy_for_top = subdim * mot_y[index];
    vx_for_bot = subdim * mot_x[index+1];         /* Forward Top Motion *//* MW QPEL 06-JUL-1998 */
    vy_for_bot = subdim * mot_y[index+1];
    index += 2*MB_num_x;
    vx_bak_top = subdim * mot_x[index];           /* Backward Top Motion *//* MW QPEL 06-JUL-1998 */
    vy_bak_top = subdim * mot_y[index];
    vx_bak_bot = subdim * mot_x[index+1];         /* Forward Top Motion *//* MW QPEL 06-JUL-1998 */
    vy_bak_bot = subdim * mot_y[index+1];

    /* MW QPEL 06-JUL-1998 */
    if(quarter_pel)
      {
	vx = vx_for_top;
	vy = vy_for_top;
	ClipMV(prev_x_ref_edge, prev_y_ref_edge, prev_width, prev_height, edge, &vx, &vy, 4);
	InterpolateBlock(prev_rec_padded + (Mode & MBM_B_FWDTOP ? prev_width : 0), prev_width , vx, (vy&~1)/*no LSB for vertical field vectors*/,
			 4 , 16 , 8 , pred_for , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
	if(GetVopShape(curr) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support >>*/
	  {
            for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
              InterpolateBlock(prev_rec_g_padded[n] + (Mode & MBM_B_FWDTOP ? prev_width : 0), prev_width ,
                               vx, (vy&~1)/*no LSB for vertical field vectors*/,
                               4 , 16 , 8 , pred_for_g[n] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
            }
	  }
	vx = vx_for_bot;
	vy = vy_for_bot;
	ClipMV(prev_x_ref_edge, prev_y_ref_edge, prev_width, prev_height, edge, &vx, &vy, 4);
	InterpolateBlock(prev_rec_padded + (Mode & MBM_B_FWDBOT ? prev_width : 0), prev_width , vx, (vy&~1)/*no LSB for vertical field vectors*/,
			 4 , 16 , 8 , &pred_for[16] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
	if(GetVopShape(curr) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support >>*/
	  {
            for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
              InterpolateBlock(prev_rec_g_padded[n] + (Mode & MBM_B_FWDBOT ? prev_width : 0), prev_width , 
                               vx, (vy&~1)/*no LSB for vertical field vectors*/,
                               4 , 16 , 8 , &pred_for_g[n][16] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
            }
	  }
	vx = vx_bak_top;
	vy = vy_bak_top;
	ClipMV(next_x_ref_edge, next_y_ref_edge, next_width, next_height, edge, &vx, &vy, 4);
	InterpolateBlock(next_rec_padded + (Mode & MBM_B_BAKTOP ? next_width : 0), next_width , vx, (vy&~1)/*no LSB for vertical field vectors*/,
			 4 , 16 , 8 , pred_back , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
	if(GetVopShape(curr) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support >>*/
	  {
            for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
              InterpolateBlock(next_rec_g_padded[n] + (Mode & MBM_B_BAKTOP ? next_width : 0), next_width , 
                               vx, (vy&~1)/*no LSB for vertical field vectors*/,
                               4 , 16 , 8 , pred_back_g[n] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
            }
	  }
	vx = vx_bak_bot;
	vy = vy_bak_bot;
	ClipMV(next_x_ref_edge, next_y_ref_edge, next_width, next_height, edge, &vx, &vy, 4);
	InterpolateBlock(next_rec_padded + (Mode & MBM_B_BAKBOT ? next_width : 0), next_width , vx, (vy&~1)/*no LSB for vertical field vectors*/,
			 4 , 16 , 8 , &pred_back[16] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
	if(GetVopShape(curr) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support >>*/
	  {
            for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
              InterpolateBlock(next_rec_g_padded[n] + (Mode & MBM_B_BAKBOT ? next_width : 0), next_width , 
                               vx, (vy&~1)/*no LSB for vertical field vectors*/,
                               4 , 16 , 8 , &pred_back_g[n][16] , 32, GetVopRoundingType(curr), GetVopBrightWhite(curr));
            }
	  }

	vx_for_top /=2; /* scale 1/4 pel vectors down to half pel for chroma compensation */
	vy_for_top /=2;
	vx_for_bot /=2; /* scale 1/4 pel vectors down to half pel for chroma compensation */
	vy_for_bot /=2;

	vx_bak_top /=2; /* scale 1/4 pel vectors down to half pel for chroma compensation */
	vy_bak_top /=2;
	vx_bak_bot /=2; /* scale 1/4 pel vectors down to half pel for chroma compensation */
	vy_bak_bot /=2;
      }
    else
      {
	/* HYUNDAI 980507 : start */

	/* Luminance Compensation..... */
	
        /* Forward Top */
	halfpel_field_compensation (
	  (SInt*)GetImageData(GetVopY(prev_rec_vop_padded)),
	  vx_for_top,vy_for_top,
	  col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref,
	  row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref,
	  GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
	  16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_for,1, Mode&MBM_B_FWDTOP);
	/* Backward Top */
	halfpel_field_compensation (
	  (SInt*)GetImageData(GetVopY(next_rec_vop_padded)),
	  vx_bak_top,vy_bak_top,
	  col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref,
	  row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref,
	  GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
	  16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_back,1, Mode&MBM_B_BAKTOP);
	/* Forward Bottom */
	halfpel_field_compensation (
	  (SInt*)GetImageData(GetVopY(prev_rec_vop_padded)),
	  vx_for_bot,vy_for_bot,
	  col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref,
	  row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref,
	  GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
	  16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_for,0, Mode&MBM_B_FWDBOT);
	/* Backward Bottom */
	halfpel_field_compensation (
	  (SInt*)GetImageData(GetVopY(next_rec_vop_padded)),
	  vx_bak_bot,vy_bak_bot,
	  col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref,
	  row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref,
	  GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
	  16,16,2,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge,pred_back,0, Mode&MBM_B_BAKBOT);
	if(GetVopShape(curr) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support >>*/
	{
          for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
            /* Forward Top */
            halfpel_field_compensation
              ((SInt*)GetImageData(GetVopG(n,prev_rec_vop_padded)),
               vx_for_top,vy_for_top,
               col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref,
               row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref,
               GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
               16,16,2,0,edge,pred_for_g[n],1, Mode&MBM_B_FWDTOP);
            /* Backward Top */
            halfpel_field_compensation
              ((SInt*)GetImageData(GetVopG(n,next_rec_vop_padded)),
               vx_bak_top,vy_bak_top,
               col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref,
               row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref,
               GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
               16,16,2,0,edge,pred_back_g[n],1, Mode&MBM_B_BAKTOP);
            /* Forward Bottom */
            halfpel_field_compensation
              ((SInt*)GetImageData(GetVopG(n,prev_rec_vop_padded)),
               vx_for_bot,vy_for_bot,
               col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref,
               row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref,
               GetVopWidth(prev_rec_vop_padded),GetVopHeight(prev_rec_vop_padded),
               16,16,2,0,edge,pred_for_g[n],0, Mode&MBM_B_FWDBOT);
            /* Backward Bottom */
            halfpel_field_compensation
              ((SInt*)GetImageData(GetVopG(n,next_rec_vop_padded)),
               vx_bak_bot,vy_bak_bot,
               col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref,
               row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref,
               GetVopWidth(next_rec_vop_padded),GetVopHeight(next_rec_vop_padded),
               16,16,2,0,edge,pred_back_g[n],0, Mode&MBM_B_BAKBOT);
          }
	}/* U. Benzler 981209 : added interlaced greyscale support <<*/
	
      }

    for (k=0;k<256;k++) 
      pred_for[k] = (pred_for[k]+pred_back[k]+1)>>1;
    Putblock(col, row, pred_for, comp->y_chan,curr_vop_width,16);
    if(GetVopShape(curr) == GREY_SCALE) /* U. Benzler 981209 : added interlaced greyscale support >>*/
      {
        for(n=0;n<GetVopAuxCompCount(comp);n++) {	/* MAC (SB) 12-Nov-99 */
          for (k=0;k<256;k++) pred_for_g[n][k] = (pred_for_g[n][k]+pred_back_g[n][k]+1)>>1;
          Putblock(col, row, pred_for_g[n], comp->g_chan[n],curr_vop_width,16);
        }
      }

    /* Chrominance Compensation..... */                                
    /* Forward Top */
    halfpel_field_compensation (
				(SInt*)GetImageData(GetVopU(prev_rec_vop_padded)),
				vx_for_top, vy_for_top,
				(col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
				(row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
				GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
				8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for, 1, Mode & MBM_B_FWDTOP);
    /* Backward Top */
    halfpel_field_compensation (
				(SInt*)GetImageData(GetVopU(next_rec_vop_padded)),
				vx_bak_top, vy_bak_top,
				(col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
				(row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
				GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
				8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back, 1, Mode & MBM_B_BAKTOP);
    /* Forward Bottom */
    halfpel_field_compensation (
				(SInt*)GetImageData(GetVopU(prev_rec_vop_padded)),
				vx_for_bot, vy_for_bot,
				(col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
				(row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
				GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
				8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for, 0, Mode & MBM_B_FWDBOT);
    /* Backward Bottom */
    halfpel_field_compensation (
				(SInt*)GetImageData(GetVopU(next_rec_vop_padded)),
				vx_bak_bot, vy_bak_bot,
				(col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
				(row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
				GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
				8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back, 0, Mode & MBM_B_BAKBOT);
	
    for (k=0;k<64;k++) 
      pred_for[k] = (pred_for[k]+pred_back[k]+1)>>1;
    Putblock(col/2, row/2, pred_for, comp->u_chan,curr_vop_width/2,8);
 
    /* Forward Top */
    halfpel_field_compensation (
				(SInt*)GetImageData(GetVopV(prev_rec_vop_padded)),
				vx_for_top, vy_for_top,
				(col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
				(row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
				GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
				8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for, 1, Mode & MBM_B_FWDTOP);
    /* Backward Top */
    halfpel_field_compensation (
				(SInt*)GetImageData(GetVopV(next_rec_vop_padded)),
				vx_bak_top, vy_bak_top,
				(col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
				(row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
				GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
				8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back, 1, Mode & MBM_B_BAKTOP);
    /* Forward Bottom */
    halfpel_field_compensation (
				(SInt*)GetImageData(GetVopV(prev_rec_vop_padded)),
				vx_for_bot, vy_for_bot,
				(col+comp->hor_spat_ref-prev_rec_vop_padded->hor_spat_ref)/2,
				(row+comp->ver_spat_ref-prev_rec_vop_padded->ver_spat_ref)/2,
				GetVopWidth(prev_rec_vop_padded)/2,GetVopHeight(prev_rec_vop_padded)/2,
				8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_for, 0, Mode & MBM_B_FWDBOT);
    /* Backward Bottom */
    halfpel_field_compensation (
				(SInt*)GetImageData(GetVopV(next_rec_vop_padded)),
				vx_bak_bot, vy_bak_bot,
				(col+comp->hor_spat_ref-next_rec_vop_padded->hor_spat_ref)/2,
				(row+comp->ver_spat_ref-next_rec_vop_padded->ver_spat_ref)/2,
				GetVopWidth(next_rec_vop_padded)/2,GetVopHeight(next_rec_vop_padded)/2,
				8,8,4,GetVopRoundingType(curr) /* MW 06-JUL-1998 */,edge/2,pred_back, 0, Mode & MBM_B_BAKBOT);
	
    for (k=0;k<64;k++) 
      pred_for[k] = (pred_for[k]+pred_back[k]+1)>>1;
    Putblock(col/2, row/2, pred_for, comp->v_chan,curr_vop_width/2,8);
    /* HYUNDAI 980507 : end */

    break;

    default: break;
  }

  return;
}


Void Putblock(Int x,
       Int y,
       SInt *pred,
       Image *comp_image,
       Int width,
       Int mb_size)
{
  Int m, n;

  for (m = 0; m < mb_size; m++)
    for (n = 0; n < mb_size; n++)
      comp_image->f[(y+m)*width+x+n] = (SInt) pred[m*mb_size+n];
}
          





/***********************************************************CommentBegin******
 *   --- halfpel_motion_compensation ---
 * -- Motion Compensation (forward/backward) for a block
 *
 * Author :
 *      HHI -- Minhua Zhou
 *
 * Created :
 *      05.03.97
 *
 * Purpose :
 *     block-based motion compensation
 *
 * Arguments in :
 *   SInt *ref,		padded reference picture (luminance/chrominance/alpha)
 *   SInt vx_hpel,	horizontal component of MV		
 *   SInt vy_hpel,	vertical component of MV
 *   Int offset_x,	horizontal spatial offset
 *   Int offset_y,	vertical spatial offset
 *   Int npix,		horizontal resolution of the reference picture
 *   Int bksize_x,	block size (horizontal)
 *   Int bksize_y,	block size (vertical)
 *   Int div,		vector accuarcy (2/4/8/12/16)
  * Arguments in/out :
 *
 *
 * Arguments out :
 *   SInt *pred_blk	prediction block
 *
 * Return values :
 *      none
 *
 * Side effects :
 *
 *
 * Description :
 *           
 *
 *
 * See also :
 *
 *
 * Modified :
 *	07.05.97 Jong Deuk Kim (HYUNDAI): reserved
 *
  ***********************************************************CommentEnd********/

 
Void halfpel_motion_compensation (
    SInt *ref,
    Int vx_hpel,
    Int vy_hpel,
    Int offset_x,
    Int offset_y,
    Int npix, Int nlin,
    Int bksize_x,
    Int bksize_y,
    Int div,
    Int rounding_control,
    Int edge,
    SInt *pred_blk,
    Int  interlaced /* HYUNDAI 980507 */
  ) {   
    Int k,l,vxmod2,vymod2,vx0,vy0,vx,vy;
    static Int pel_pos[4][16]={
                              {0,1,1,1},
                              {0,0,1,1,1,1,1,2},
                              {0,0,0,1,1,1,1,1,1,1,2,2},
                              {0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2}
                             };
    
    Int index,index1,offset;
    Int row0,col0,row1,col1,row2,col2,col3,out_of_reference_vop;
    Int nlin1,npix1;
    nlin1 = nlin-edge;
    npix1 = npix-edge;
    vx=vx_hpel;vy=vy_hpel;
    vxmod2=vx%div;vymod2=vy%div;
    vx0=vx/div;vy0=vy/div;
    if (vxmod2<0) {vx0--;vxmod2+=div;}
    if (vymod2<0) {vy0--;vymod2+=div;}
    
    if (div>2) {
       div=(div>>2)-1; 
       vxmod2=pel_pos[div][vxmod2];
       if (vxmod2==2) {vx0++;vxmod2=0;}
       vymod2=pel_pos[div][vymod2];
       if (vymod2==2) {vy0++;vymod2=0;}
     }

   


    row0 = offset_y+vy0; col0 = offset_x+vx0;

    out_of_reference_vop = (row0<edge)||(col0<edge)||(row0+bksize_y+vymod2>=nlin1)
                           ||(col0+bksize_x+vxmod2>=npix1);
   

   if (out_of_reference_vop ==0) {
    offset=row0*npix+col0;
    if ((vxmod2)&&(vymod2))
       for (k=0;k<bksize_y;k++)
         for (l=0;l<bksize_x;l++) {
            index=k*bksize_x+l;
            index1=k*npix+l+offset;
	    pred_blk[index]=(ref[index1]+ref[index1+1]+ref[index1+npix]+ref[index1+npix+1]+2
				-rounding_control)>>2;
        } else if (vxmod2)
       for (k=0;k<bksize_y;k++)
         for (l=0;l<bksize_x;l++) {
            index=k*bksize_x+l;
            index1=k*npix+l+offset;
            pred_blk[index]=(ref[index1]+ref[index1+1]+1-rounding_control)>>1;
        } else if (vymod2)
      for (k=0;k<bksize_y;k++)
         for (l=0;l<bksize_x;l++) {
            index=k*bksize_x+l;
            index1=k*npix+l+offset;
            
	    pred_blk[index]=(ref[index1]+ref[index1+npix]+1-rounding_control)>>1;
        } else 
           for (k=0;k<bksize_y;k++)
            for (l=0;l<bksize_x;l++) {
            index=k*bksize_x+l;
            index1=k*npix+l+offset;
            pred_blk[index]=ref[index1];
        }
    } else {
 if ((vxmod2)&&(vymod2))
       for (k=0;k<bksize_y;k++)
         for (l=0;l<bksize_x;l++) {
            index=k*bksize_x+l;
            row1 = row0+k;
            col1 = col0+l;
            row2 = row1;
            col2 = col1;
            row2 = field_unrestriced_row( row2,edge, nlin1,interlaced ); /* HYUNDAI 980507 */
            if (col2<edge) col2=edge;else if (col2>=npix1) col2=npix1-1;
            col3 =col2;
            pred_blk[index] = ref[row2*npix+col2];
            col2 = col1+1;
            if (col2<edge) col2=edge;else if (col2>=npix1) col2=npix1-1;
            pred_blk[index] += ref[row2*npix+col2];
            row2 = row1+1;
            row2 = field_unrestriced_row( row2,edge, nlin1,interlaced );/* HYUNDAI 980507 */
            pred_blk[index] += ref[row2*npix+col2]+ref[row2*npix+col3];
            pred_blk[index] = (pred_blk[index]+2-rounding_control)>>2;  
      } else if (vxmod2)
       for (k=0;k<bksize_y;k++)
         for (l=0;l<bksize_x;l++) {
            index=k*bksize_x+l;
            row2 = row0+k;
            col2=col1 = col0+l;
            row2 = field_unrestriced_row( row2,edge, nlin1,interlaced );/* HYUNDAI 980507 */
            if (col2<edge) col2=edge;else if (col2>=npix1) col2=npix1-1;
            pred_blk[index] = ref[row2*npix+col2];
            col2 = col1+1;
            if (col2<edge) col2=edge;else if (col2>=npix1) col2=npix1-1;
            pred_blk[index] += ref[row2*npix+col2];
            pred_blk[index]=(pred_blk[index]+1-rounding_control)>>1;

        } else if (vymod2)
      for (k=0;k<bksize_y;k++)
         for (l=0;l<bksize_x;l++) {
            index=k*bksize_x+l;
             row2=row1= row0+k;
             col2 = col0+l;
            row2 = field_unrestriced_row( row2,edge, nlin1,interlaced );/* HYUNDAI 980507 */
            if (col2<edge) col2=edge;else if (col2>=npix1) col2=npix1-1;
            pred_blk[index] = ref[row2*npix+col2];
            row2 = row1+1;
            row2 = field_unrestriced_row( row2,edge, nlin1,interlaced );/* HYUNDAI 980507 */
            pred_blk[index] += ref[row2*npix+col2];
            pred_blk[index]=(pred_blk[index]+1-rounding_control)>>1;
        } else 
           for (k=0;k<bksize_y;k++)
            for (l=0;l<bksize_x;l++) {
            index=k*bksize_x+l;
            row2 = row0 + k;
            col2 = col0 +l;
            row2 = field_unrestriced_row( row2,edge, nlin1,interlaced );/* HYUNDAI 980507 */
            if (col2<edge) col2=edge;else if (col2>=npix1) col2=npix1-1;
            pred_blk[index] = ref[row2*npix+col2];
        }
    }

   }

/***********************************************************CommentBegin******
 * --- serach_for_vectors_of_co_located_MB ---
 * -- Search for the motion vectors of the co-located MB 
      for the current MB of B-VOPs
 *
 * Author :
 *      HHI -- Minhua Zhou
 *
 * Created :
 *      05.03.97
 *
 * Purpose :
 *      produce the motion vectors of the co-located MB
 *
 * Arguments in :
 *         Float *mot_x_P,	vector field of the next P-VOP (horizontal components)
 *         Float *mot_y_P,	vector field of the next P-VOP (vertical components)
 *         Int col,		horizontal coordinate of the co-located MB
 *         Int row,		vertical coordinate of the co-located MB
 *         Int npix,		horizontal resolution of the next P-VOP (before padding)
 *         Int nlin,		vertical resolution of the next P-VOP (before padding)
 * Arguments in/out :
 *
 *
 * Arguments out :
 *        SInt *vx_P,		horizontal coordinates of MVs of the co-located MB
 *        SInt *vy_P,		vertical coordinates of MVs of the co-located MB
 
 * Return values :
 *      none
 *
 * Side effects :
 *
 *
 * Description :
 *
 *
 * See also :
 *
 *
 * Modified :
 *      06.07.98 U. Benzler (TUH) : added quarter pel support
 *
  ***********************************************************CommentEnd********/

 Int serach_for_vectors_of_co_located_MB(
          Float *mot_x_P,
          Float *mot_y_P,
          SInt  *mode_P,
          Int col,
          Int row,
          Int npix,
          Int nlin,
          SInt *vx_P,
          SInt *vy_P,
	  Float subdim	/* MW QPEL 06-JUL-1998 */
         )
     {
       Int k,mode,mbk_x,mbk_y,mbk_x0,mbk_y0;
       mbk_x = npix/16;
       mbk_y = nlin/16;   
       for (k=0;k<4;k++) vx_P[k]=vy_P[k]=0;
       if ((mot_y_P==NULL)||(mot_x_P==NULL))
        return MBM_TRANSPARENT;
        mbk_x0 = (col+8)>>4;
        mbk_y0 = (row+8)>>4;
       if ((mbk_x0<0)||(mbk_x0>=mbk_x)||(mbk_y0<0)||(mbk_y0>=mbk_y))
           return MBM_INTER16;
       mode = mode_P[mbk_y0*mbk_x + mbk_x0];
       if (mode==MBM_INTRA) return MBM_INTER16;
/* modified by NTT for GMC coding :start
         else if (mode==MBM_SKIPPED) return MBM_SKIPPED;
 modified by NTT for GMC coding : end */
          else if (mode==MBM_TRANSPARENT) return MBM_INTER16;
        
       /* MW QPEL 06-JUL-1998 */
       /* vx_P[0] = (SInt) (2.0*mot_x_P[2*mbk_y0*2*mbk_x+2*mbk_x0]); */
       /* vy_P[0] = (SInt) (2.0*mot_y_P[2*mbk_y0*2*mbk_x+2*mbk_x0]); */

       /* vx_P[1] = (SInt) (2.0*mot_x_P[2*mbk_y0*2*mbk_x+2*mbk_x0+1]); */
       /* vy_P[1] = (SInt) (2.0*mot_y_P[2*mbk_y0*2*mbk_x+2*mbk_x0+1]); */
 
       /* vx_P[2] = (SInt) (2.0*mot_x_P[(2*mbk_y0+1)*2*mbk_x+2*mbk_x0]); */
       /* vy_P[2] = (SInt) (2.0*mot_y_P[(2*mbk_y0+1)*2*mbk_x+2*mbk_x0]); */

       /* vx_P[3] = (SInt) (2.0*mot_x_P[(2*mbk_y0+1)*2*mbk_x+2*mbk_x0+1]); */
       /* vy_P[3] = (SInt) (2.0*mot_y_P[(2*mbk_y0+1)*2*mbk_x+2*mbk_x0+1]); */
       vx_P[0] = (SInt) (subdim*mot_x_P[2*mbk_y0*2*mbk_x+2*mbk_x0]);
       vy_P[0] = (SInt) (subdim*mot_y_P[2*mbk_y0*2*mbk_x+2*mbk_x0]);

       vx_P[1] = (SInt) (subdim*mot_x_P[2*mbk_y0*2*mbk_x+2*mbk_x0+1]);
       vy_P[1] = (SInt) (subdim*mot_y_P[2*mbk_y0*2*mbk_x+2*mbk_x0+1]);

       vx_P[2] = (SInt) (subdim*mot_x_P[(2*mbk_y0+1)*2*mbk_x+2*mbk_x0]);
       vy_P[2] = (SInt) (subdim*mot_y_P[(2*mbk_y0+1)*2*mbk_x+2*mbk_x0]);

       vx_P[3] = (SInt) (subdim*mot_x_P[(2*mbk_y0+1)*2*mbk_x+2*mbk_x0+1]);
       vy_P[3] = (SInt) (subdim*mot_y_P[(2*mbk_y0+1)*2*mbk_x+2*mbk_x0+1]);

       return mode;
   
     }                                   
 


   
Void reorgnization(SInt *mask16) {
             SInt i,j,k,l;
             SInt buf[256];
             for (i=0;i<8;i++)
               for (j=0;j<8;j++) {
                 k=i*16+j;
                 l = i*8+j;
                 buf[l] = mask16[k];
                 buf[l+64] = mask16[k+8];
                 buf[l+128] = mask16[k+128];
                 buf[l+192] = mask16[k+136];
              }
            for (i=0;i<256;i++)
            mask16[i]=buf[i];
         }      



/***********************************************************CommentBegin******
 *
 * -- halfpel_field_compendation -- Half pel field Motion Compensation
 *
 * Author :
 *     HYUNDAI - Jong Deuk Kim 
 *
 * Created :
 *     May 4 1998
 *
 * Purpose :
 *      Halfpel field motion compensation.
 *
 * Arguments in :
 *
 *
 * Arguments in/out :
 *
 *
 * Arguments out :
 *
 *
 * Return values :
 *
 *
 * Side effects :
 *
 *
 * Description :
 *
 *
 * See also :
 *
 *
 * Modified :
 *
 *
 ***********************************************************CommentEnd********/
Void halfpel_field_compensation (
    SInt *ref,
    Int vx_hpel,
    Int vy_hpel,
    Int offset_x,
    Int offset_y,
    Int npix, Int nlin,
    Int bksize_x,
    Int bksize_y,
    Int div,
    Int rounding_control,
    Int edge,
    SInt *pred_blk,
    Int top,
    Int field_ref
  )
{
    Int k,l,vxmod2,vymod2,vx0,vy0,vx,vy;

    Int index,index1,offset, cur_off, ref_off;
    Int row0=0,col0=0,row1,col1,row2,col2,col3,out_of_reference_vop;
    Int nlin1,npix1;
    nlin1 = nlin-edge;
    npix1 = npix-edge;
    vx=vx_hpel;vy=vy_hpel;

                                          
    cur_off = top ? 0 : 1;
    ref_off = field_ref ? 1 : 0;

    if( div == 2 )   /* Luminance.. */
    {
         vxmod2 = vx & 1;
         vymod2 = vy & 2;
 
         vx0 = vx >> 1;
         vy0 = (vy >> 1) & ~1;

         row0 = offset_y+vy0; col0 = offset_x+vx0;
    }
    else if( div == 4 )
    {
        vx = ((vx & 3) ? ((vx >> 1) | 1) : (vx >> 1));
        vy = ((vy & 6) ? ((vy >> 1) | 2) : (vy >> 1));

        vxmod2 = vx & 1;                               
        vymod2 = vy & 2;

        vx0 = vx >> 1;   
        vy0 = (vy >> 1) & ~1;

        row0 = offset_y+vy0 ; col0 = offset_x+vx0;
    }
    else
    {
        fprintf(stderr, " Error at halfpel_field_compensation. ");
        exit(-1);
    }
 
    out_of_reference_vop = (row0<edge)||(col0<edge)
                                ||(row0+bksize_y+vymod2>=nlin1)
                                ||(col0+bksize_x+vxmod2>=npix1);

                                                                 
  if (out_of_reference_vop ==0) {
    offset=row0*npix+col0;

    if ((vxmod2)&&(vymod2))
       for (k=0;k<bksize_y;k+=2)
         for (l=0;l<bksize_x;l++) {
            index=(k+cur_off)*bksize_x+l;
            index1=(k+ref_off)*npix+l+offset;

            pred_blk[index]=(ref[index1]+ref[index1+1]+ref[index1+2*npix]
                             +ref[index1+2*npix+1]+2-rounding_control)>>2;
        }
    else if (vxmod2)
       for (k=0;k<bksize_y;k+=2)
         for (l=0;l<bksize_x;l++) {
            index=(k+cur_off)*bksize_x+l;
            index1=(k+ref_off)*npix+l+offset;
            pred_blk[index]=(ref[index1]+ref[index1+1]+1-rounding_control)>>1;
        }
    else if (vymod2)
      for (k=0;k<bksize_y;k+=2)
         for (l=0;l<bksize_x;l++) {
            index=(k+cur_off)*bksize_x+l;
            index1=(k+ref_off)*npix+l+offset;
            pred_blk[index]=(ref[index1]+ref[index1+2*npix]+1-rounding_control)>>1;        }
    else
       for (k=0;k<bksize_y;k+=2)
         for (l=0;l<bksize_x;l++) {
            index=(k+cur_off)*bksize_x+l;
            index1=(k+ref_off)*npix+l+offset;
            pred_blk[index]=ref[index1];
        }
 }
 else
 {
    if ((vxmod2)&&(vymod2))
       for (k=0;k<bksize_y;k+=2)
         for (l=0;l<bksize_x;l++) {
            index=(k+cur_off)*bksize_x+l;
            row1 = row0+k+ref_off;
            col1 = col0+l;
            row2 = row1;
            col2 = col1;
/* HYUNDAI (jdkim) start - delete : 981020  
            if (row2<edge) row2=edge+ref_off;else if (row2>=nlin1) row2=nlin1-2+ref_off;
   HYUNDAI (jdkim) end : 981020 */
            if (row2<edge) row2=edge;else if (row2>=nlin1) row2=nlin1-1;  	/* HYUNDAI (jdkim) : 981020 */
            if (col2<edge) col2=edge;else if (col2>=npix1) col2=npix1-1;
            col3 =col2;
            pred_blk[index] = ref[row2*npix+col2];
            col2 = col1+1;
            if (col2<edge) col2=edge;else if (col2>=npix1) col2=npix1-1;
            pred_blk[index] += ref[row2*npix+col2];
            row2 = row1+2;
/* HYUNDAI (jdkim) start - deleted : 981020
            if (row2<edge) row2=edge+ref_off;else if (row2>=nlin1) row2=nlin1-2+ref_off;
*/
            if (row2<edge) row2=edge;else if (row2>=nlin1) row2=nlin1-1;	/* HYUNDAI (jdkim) : 981020 */
            pred_blk[index] += ref[row2*npix+col2]+ref[row2*npix+col3];
            pred_blk[index] = (pred_blk[index]+2-rounding_control)>>2;
      }
    else if (vxmod2)
       for (k=0;k<bksize_y;k+=2)
         for (l=0;l<bksize_x;l++) {
            index=(k+cur_off)*bksize_x+l;
            row2 = row0+k+ref_off;
            col2=col1 = col0+l;
/* HYUNDAI (jdkim) start - deleted : 981020
            if (row2<edge) row2=edge+ref_off;else if (row2>=nlin1) row2=nlin1-2+ref_off;
*/
            if (row2<edge) row2=edge;else if (row2>=nlin1) row2=nlin1-1;        /* HYUNDAI (jdkim) : 981020 */
            if (col2<edge) col2=edge;else if (col2>=npix1) col2=npix1-1;
            pred_blk[index] = ref[row2*npix+col2];
            col2 = col1+1;
            if (col2<edge) col2=edge;else if (col2>=npix1) col2=npix1-1;
            pred_blk[index] += ref[row2*npix+col2];
            pred_blk[index]=(pred_blk[index]+1-rounding_control)>>1;
 
        }   
     else if (vymod2)
      for (k=0;k<bksize_y;k+=2)
         for (l=0;l<bksize_x;l++) {
            index=(k+cur_off)*bksize_x+l;
             row2=row1= row0+k+ref_off;
             col2 = col0+l;
/* HYUNDAI (jdkim) start - deleted : 981020
            if (row2<edge) row2=edge+ref_off;else if (row2>=nlin1) row2=nlin1-2+ref_off;
*/
            if (row2<edge) row2=edge;else if (row2>=nlin1) row2=nlin1-1;        /* HYUNDAI (jdkim) : 981020 */
            if (col2<edge) col2=edge;else if (col2>=npix1) col2=npix1-1;
            pred_blk[index] = ref[row2*npix+col2];
            row2 = row1+2;
/* HYUNDAI (jdkim) start - deleted : 981020
            if (row2<edge) row2=edge+ref_off;else if (row2>=nlin1) row2=nlin1-2+ref_off;
*/
            if (row2<edge) row2=edge;else if (row2>=nlin1) row2=nlin1-1;        /* HYUNDAI (jdkim) : 981020 */
            pred_blk[index] += ref[row2*npix+col2];
            pred_blk[index]=(pred_blk[index]+1-rounding_control)>>1;
        }
    else
       for (k=0;k<bksize_y;k+=2)
          for (l=0;l<bksize_x;l++) {
            index=(k+cur_off)*bksize_x+l;
            row2 = row0 + k+ref_off;
            col2 = col0 +l;
/* HYUNDAI (jdkim) start - deleted : 981020
            if (row2<edge) row2=edge+ref_off;else if (row2>=nlin1) row2=nlin1-2+ref_off;
*/
            if (row2<edge) row2=edge;else if (row2>=nlin1) row2=nlin1-1;        /* HYUNDAI (jdkim) : 981020 */
            if (col2<edge) col2=edge;else if (col2>=npix1) col2=npix1-1;
            pred_blk[index] = ref[row2*npix+col2];
        }
    }
}


/***********************************************************CommentBegin******
 *
 * -- field_unrestriced_row --
 *
 * Author :
 *     HYUNDAI - Jong Deuk Kim 
 *
 * Created :
 *     May 12 1998
 *
 * Purpose :
 *      If motion compensation region is out of VOP, that value is
 *       copied to edge value regard to field.
 *
 * Arguments in :
 *
 *
 * Arguments in/out :
 *
 *
 * Arguments out :
 *
 *
 * Return values :
 *
 *
 * Side effects :
 *
 *
 * Description :
 *
 *
 * See also :
 *
 *
 * Modified :
 *
 *
 ***********************************************************CommentEnd********/
 
Int field_unrestriced_row( Int row,
                         Int edge,
                         Int nline,
                         Int interlaced )
{
/* HYUNDAI (jdkim) : start : 981020 */
#if 0
       if(interlaced)
       { 
           if (row<edge)
           {
               if( (edge-row)%2 )   /* bottom-field */
                   row=edge+1;
               else row=edge;       /* top-field */
           }
           else if (row>=nline)
           {
               if( (row-(nline-1))%2 )   /* top-field */
                   row=nline-2;
               else row=nline-1;       /* bottom-field */
           }
       }
       else
       {
           if (row<edge) row=edge;else if (row>=nline) row=nline-1;
       } 
#endif
/* HYUNDAI (jdkim) end : 981020 */

/* HYUNDAI (jdkim) start : 981020 */
           if (row<edge) row=edge;else if (row>=nline) row=nline-1;
/* HYUNDAI (jdkim) end : 981020 */
       return (row);
}       

