/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Michael Wollborn (TUH / ACTS-MoMuSyS)
 *
 * and edited by
 * 
 *   Robert Danielsen (Telenor / ACTS-MoMuSyS)
 *   Noel O'Connor (Teltec DCU / ACTS-MoMuSyS)
 *   Aasmund Sandvand (Telenor / ACTS-MoMuSyS)
 *   Regis J. Crinon (Sharp Laboratories of America Inc.)
 *   Frederic Dufaux (Digital Equipment Corp.)
 *   Ji Heon Kweon (HYUNDAI)
 *   Marc Mongenet (EPFL)
 *   Ulrich Benzler (Univ. of Hannover)
 *   Takefumi Nagumo (SONY)
 *   Oki Electric Industry Co., Ltd. (contact: Shigeru Fukunaga)                  	
 *   Fujitsu Laboratories Ltd. (contact: Eishi Morimatsu)
 *   Dae-Sung Cho (Samsung AIT)
 *   Massimo Ravasi (EPFL)
 *   Sven Brandau (HHI)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	mom_access.c
 *
 * Author:	Michael Wollborn
 * Created:	19-Feb-96
 *                                                                         
 * Description: 
 *
 * Notes: 	
 *
 * Modified:	21.04.96 Robert Danielsen: Reformatted. New headers.
 *		31.07.96 Noel O'Connor: Functions for Vol structure.
 *		15.08.96 M.Wollborn: Functions for new VOP elements.
 *		23.09.96 Noel O'Connor: Functions for VO structure
 *		02.02.92 Aasmund Sandvand: Functions for new VOP element.
 *		04.02.97 Noel O'Connor: functions for new VOP/VOL element.
 *		20.02.97 Cecile Dufour: functions for sprite parameters access.
 *					(from inputs of R. Crinon + F. Dufaux)
 *		26.02.97 Noel O'Connor: functions for new VOL elements
 *		22.04.97 Michael Wollborn: Added new access functions for 
 *					   MPEG quantizer matrices
 *              26.04.97 Luis Ducla-Soares: added new access functions for
 *                                          data partioning
 *		12.05.97 Minhua Zhou: added GetVolOBMCDisable
 *              26.05.97 Minhua Zhou: added GetVopAuv() and PutVopAuv(); 
 *              15.07.97 Ulrike Pestel-Schiller: added GetVolConfigScalType(),
 *                           GetVolScalType(),PutVolConfigScalTupe(),PutVolScalType(); 
 *              24.07.97 Minhua Zhou: added GetVopPrevTemp(),PutVopPrevTemp()
 *              04.08.97 Minhua Zhou: added GetVopSearchRangeFor(),PutVopSearchRangeFor()
 *                                          GetVopSearchRangeBack(),PutVopSearchRangeBack()
  *                                  removed PutVolFCodeFor(), PutVolFCodeBack() 
 *              12.08.97 Minhua Zhou: added GetVopTimeIncrementResolution()
 *					    PutVopTimeIncrementResolution()
 *					    GetVolTimeIncrementResolution()
 *					    PutVolTimeIncrementResolution()
 *              09.10.97 Minhua Zhou: added GetVopCoded(), PutVopCoded()
 *              17.04.97 Minhua Zhou: added GetVopShapeMode(), PutVopShapeMode()
 *              21.05.98 Ji Heon Kweon (HYUNDAI) : support for grayscale coding 
 *              09.06.98 Marc Mongenet (EPFL): added Complexity Estimation syntax support
 *              17.06.98 A. Sandvand (Telenor): added short video header syntax support
 *              06.07.98 U. Benzler (TUH) : added quarter pel support
 *              31.08.98 Guido Heising (HHI): non version 1 items deleted
 *              18.01.98 Takefumi Nagumo (SONY): added GetVolHierarchyType(),PutVolHierarchyType() 
 *		16.08.99 Shigeru Fukunaga (Oki): added GetVopNewpred{xxx}()
 *						       PutVopNewpred{xxx}()
 *						       GetVolNewpred{xxx}()
 *						       PutVolNewpred{xxx}()
 *	        06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 *		09.29.99 Dae-Sung Cho (Samsung AIT): added support for OBSS
 *    26.10.99 Massimo Ravasi (EPFL): added Complexity Estimation syntax support
 *                                    Update version 2
 *		11.11.99 Sven Brandau (HHI): added support for MAC
 *              11.11.99 U. Benzler (UoH) - added visual_object_type_indication to the VOL structure
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#include <stdio.h>
#include "mom_access.h"

/***********************************************************CommentBegin******
 *
 * -- GetImage{xxx} -- Access components of intermediate formats
 *
 *	Char *GetImageData(Image *image)
 *      UInt GetImageSize(Image *image)
 *      UInt GetImageSizeX(Image *image)
 *      UInt GetImageSizeY(Image *image)
 *      Int GetImageVersion(Image *image)
 *      ImageType GetImageType(Image *image)
 *
 * Author :		
 *	Michael Wollborn
 *
 * Created :		
 *	19-Feb-96
 *
 * Purpose :		
 *	These are common functions to access specific components
 *      of the common data structures which are used for the
 *      intermediate formats.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Access components of generic image structure
 *
 * See also :
 *	
 *
 * Modified :		
 *	
 *
 ***********************************************************CommentEnd********/

Char *
GetImageData(Image *image)
{
  switch(GetImageType(image))
    {
    case SHORT_TYPE:
      return((Char *)image->data->s);
      break;
    case FLOAT_TYPE:
      return((Char *)image->data->f);
      break;
    case UCHAR_TYPE:
      return((Char *)image->data->u);
      break;
    default:
      printf("Image type >>%d<< not supported\n",image->type);
      return(NULL);
    }
}

UInt
GetImageSize(Image *image)
{
  return(image->x * image->y);
}

UInt
GetImageSizeX(Image *image)
{
  return(image->x);
}

UInt
GetImageSizeY(Image *image)
{
  return(image->y);
}
  
Int
GetImageVersion(Image *image)
{
  return(image->version);
}

ImageType
GetImageType(Image *image)
{
  return(image->type);
}


/***********************************************************CommentBegin******
 *
 * -- GetImage{xxx} -- Access components of old intermediate formats
 *
 *	SInt *GetImageIData(ImageI *image)
 *      UInt GetImageISize(ImageI *image)
 *      UInt GetImageISizeX(ImageI *image)
 *      UInt GetImageISizeY(ImageI *image)
 *      Float *GetImageFData(ImageF *image)
 *      UInt GetImageFSize(ImageF *image)
 *      UInt GetImageFSizeX(ImageF *image)
 *      UInt GetImageFSizeY(ImageF *image)
 *
 * Author :		
 *	Michael Wollborn
 *
 * Created :		
 *	19-Feb-96
 *
 * Purpose :		
 *	These are common functions to access specific components
 *      of the common data structures which are used for the
 *      intermediate formats.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Access components of an "ImageI" and "ImageF"
 *      (for compatibility reasons with old source code)
 *
 * See also :
 *	
 *
 * Modified :		
 *	
 *
 ***********************************************************CommentEnd********/

SInt *
GetImageIData(ImageI *image)		/* ImageI */
{
  return(image->data->s);
}

UInt
GetImageISize(ImageI *image)
{
  return(image->x * image->y);
}

UInt
GetImageISizeX(ImageI *image)
{
  return(image->x);
}

UInt
GetImageISizeY(ImageI *image)
{
  return(image->y);
}

Float *
GetImageFData(ImageF *image)		/* Image F */
{
  return(image->data->f);
}

UInt
GetImageFSize(ImageF *image)
{
  return(image->x * image->y);
}

UInt
GetImageFSizeX(ImageF *image)
{
  return(image->x);
}

UInt
GetImageFSizeY(ImageF *image)
{
  return(image->y);
}



/***********************************************************CommentBegin******
 *
 * -- GetVop{xxx} -- Functions to access components of the Vop structure
 *
 *	Int GetVopModTimeBase(Vop *vop)
 *	Int GetVopTimeInc(Vop *vop)
 *      Int GetVopPredictionType(Vop *vop)
 *      Int GetVopWidth(Vop *vop)
 *      Int GetVopHeight(Vop *vop)
 *      Int GetVopHorSpatRef(Vop *vop)
 *      Int GetVopVerSpatRef(Vop *vop)
 *	Int GetVopBackComp(Vop *vop)
 *      Int GetVopQuantizer(Vop *vop)
 *
 *	Int GetVopLoadBackShape(Vop *vop)
 *	Int GetVopLoadForShape(Vop *vop)
 *	Int GetVopRefSelCode(Vop *vop)
 *	Int GetVopForTempRef(Vop *vop)
 *	Int GetVopBackTempRef(Vop *vop)
 *
 *	Int GetVopId(Vop *vop)
 *	Int GetVopVOId(Vop *vop)
 *      Int GetVopArbitraryShape(Vop *vop)
 *      Int GetVopShape(Vop *vop) (== GetVopArbitraryShape())
 *	Int GetVopQuantType(Vop *vop)
 *	Int GetVopLoadIntraQuantMat(Vop *vop)
 *	Int *GetVopIntraQuantMat(Vop *vop)
 *	Int GetVopLoadNonintraQuantMat(Vop *vop)
 *	Int *GetVopNonintraQuantMat(Vop *vop)
 *	Int GetVopLoadGrayIntraQuantMat(Vop *vop)
 *	Int *GetVopGrayIntraQuantMat(Vop *vop)
 *	Int GetVopLoadGrayNonintraQuantMat(Vop *vop)
 *	Int *GetVopGrayNonintraQuantMat(Vop *vop)
 *	Int GetVopIntraACDCPredDisable(Vop *vop)
 *      Int GetVopQuarterPel(Vop *vop)				*//* MW QPEL 06-JUL-1998 *//*
 *	Int GetVopFCodeFor(Vop *vop)
 *      Int GetVopFCodeBack(Vop *vop)
 *	Int GetVopScalability(Vop *vop)
 *
 *	Int GetVopRefId(Vop *vop)
 *	Int GetVopSampDir(Vop *vop)
 *	Int GetVopHorSampN(Vop *vop)
 *	Int GetVopHorSampM(Vop *vop)
 *	Int GetVopVerSampN(Vop *vop)
 *	Int GetVopVerSampM(Vop *vop)
 *	Int GetVopEnhanceType(Vop *vop)
 *
 *      Int GetVopScaling(Vop *vop)
 *      Int GetVopVisibility(Vop *vop)
 *      Int GetVopBinaryShape(Vop *vop)
 *      Int GetVopCompOrder(Vop *vop)
 *
 *	Int GetVopSpriteUsage(Vop *vop)
 *	Int GetVopNoOfSpritePoints (Vop *vop)
 *	TrajPoint * GetVopRefPointCoord(Vop *vop)
 *	TrajPoint * GetVopTrajPointCoord(Vop *vop)
 *	TrajPoint * GetVopDiffTrajPointCoord(Vop *vop)
 *	Int GetVopBrightnessChangeInSprite(Vop *vop)
 *	Int GetVopLowLatencySpriteEnable(Vop *vop)
 *	Int GetVopBlendFact(Vop *vop)
 *	Int GetVopSpriteHdim(Vop *vop)
 *	Int GetVopSpriteVdim(Vop *vop)
 *      Int GetVopSpriteLeftEdge(Vop *vop)
 *	Int GetVopSpriteTopEdge(Vop *vop)
 *	Int GetVopWarpingAccuracy(Vop *vop)
 *	Vop * GetVopSprite(Vop *vop);
 *	Sprite_motion * GetVopWarpParam(Vop *vop);
 *	Float GetVopBrightnessChangeFactor(Vop *vop)
 *	Int GetVopSpriteTransmitMode(Vop *vop)
 *	Int * GetVopSpriteTabTransmit(Vop *vop)
 *	Int * GetVopSpriteTabAmbType(Vop *vop)
 *	Int * GetVopSpriteTabMvda(Vop *vop)
 *	SInt * GetVopSpriteTabQPStore(Vop *vop)
 *	Int * GetVopSpriteTabDQUANTStore(Vop *vop)
 *	Int *** GetVopSpriteTabDCStore(Vop *vop)
 *
 *      Image *GetVopA(Vop *vop)
 *      Image *GetVopY(Vop *vop)
 *      Image *GetVopU(Vop *vop)
 *      Image *GetVopV(Vop *vop)
 *      Image *GetVopQP(Vop *vop)
 *      Vop *GetVopNextSpat(Vop *vop)
 *      Vop *GetVopNextTemp(Vop *vop)
 *      VopExtend *GetVopExtend(Vop *vop)
 *      Vop *GetVopById(Vop *vop, Int vop_id)
 *	Vop *GetVopByCompOrder(Vop *list, Int comp_order)
 *           Int GetVopShapeEffects(Vop *vop)
 *           Int GetVopReverseVlc(Vop *vop)
 *           Int GetVopDataPartEnable(Vop *vop)
 *	Int GetVopNewpredEnable(Vop *vop)		for NEWPRED (Oki)
 *	Int GetVopNewpredModeFlag(Vop *vop)		for NEWPRED (Oki)
 *	Int GetVopNewpredVopId(Vop *vop)		for NEWPRED (Oki)
 *	Int GetVopNewpredVopIdPred(Vop *vop, Int np_seg_id)	for NEWPRED (Oki)
 *	Int GetVopNewpredNumVps(Vop *vop)		for NEWPRED (Oki)
 *	Int GetVopNewpredMbaVp(Vop *vop, Int np_seg_id)	for NEWPRED (Oki)
 *	Int GetVopReducedResolution(Vop *vop)		for DRC
 *	Int GetVopDctCoefMask(Vop *vop)			for DRC
 *	Int GetVopSwitchingFlag(Vop *vop)		for DRC
 *	Float GetVopAverageQp(Vop *vop)			for DRC
 *	Int GetVopBitsUsed(Vop *vop)			for DRC
 *
 * Author :		
 *	Michael Wollborn 
 *
 * Created :		
 *	19-Feb-96
 *
 * Purpose :		
 *	These are common functions to access specific components
 *      of the Vop data structure.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Access components of a "Vop"
 *
 * See also :
 *	
 *
 * Modified :		
 *	04.02.97 Noel O'Connor: added  GetVopIntraQuantizer()
 *      26.02.97 Noel O'Connor: added GetVopReverseVlc() & GetVopShapeEffects()
 *     	22.04.97 Michael Wollborn: Added new access functions for 
 *					   MPEG quantizer matrices
 *      26.04.97 Luis Ducla-Soares: Added GetVopDataPartEnable().
 *			07.05.97 Noel Brady: Added GetVopChangeCrDisable()	
 *      09.07.97 Aasmund Sandvand: added GetVopVOId()
 *      04.08.97 Minhua Zhou : added GetVopOBMCDisable()
 *      04.08.97 Minhua Zhou : added GetVopIntraDCVlcThr()	
 *      04.06.98 Marc Mongenet (EPFL): added Complexity Estimation syntax support
 *      23.06.98 A. Sandvand: added support for short video header
 *      06.07.98 U. Benzler (TUH) : added quarter pel support
 *	29.06.98 K. Schueuer: added GetVopSADCTDisable()
 *      14.06.99 K. Suehring (HHI): added VOL Control Parameters
 *	16.08.99 Shigeru Fukunaga (Oki): added GetVopNewpred{xxx}()
 *	06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 *  26.10.99 Massimo Ravasi (EPFL): added Complexity Estimation syntax support
 *                                  Update version 2
 *
 ***********************************************************CommentEnd********/
Int GetVopIsObjectLayerIdentifier(Vop *vop) {
  return (vop->is_object_layer_identifier);
}

 

Int GetVopVisualObjectLayerVerid(Vop *vop) {
  return (vop->visual_object_layer_verid);
}



Int GetVopVisualObjectLayerPriority(Vop *vop) {
  return (vop->visual_object_layer_priority);
}


Int GetVopVolControlParameters(Vop *vop) {
  return (vop->vol_control_parameters);
}

Int GetVopChromaFormat(Vop *vop) {
  return (vop->chroma_format);
}

Int GetVopLowDelay(Vop *vop) {
  return (vop->low_delay);
}

Int GetVopVbvParameters(Vop *vop) {
  return (vop->vbv_parameters);
}

Int GetVopFirstHalfBitRate(Vop *vop) {
  return (vop->first_half_bit_rate);
}

Int GetVopLatterHalfBitRate(Vop *vop) {
  return (vop->latter_half_bit_rate);
}

Int GetVopFirstHalfVbvBufferSize(Vop *vop) {
  return (vop->first_half_vbv_buffer_size);
}

Int GetVopLatterHalfVbvBufferSize(Vop *vop) {
  return (vop->latter_half_vbv_buffer_size);
}

Int GetVopFirstHalfVbvOccupancy(Vop *vop) {
  return (vop->first_half_vbv_occupancy);
}

Int GetVopLatterHalfVbvOccupancy(Vop *vop) {
  return (vop->latter_half_vbv_occupancy);
}

Int GetVopFixedVopRate(Vop *vop) {
  return (vop->fixed_vop_rate);
}

Int GetVopNot8Bit(Vop *vop) {
  return (vop->bits_per_pixel != 8);
}

Int GetVopQuantPrecision(Vop *vop) {
  return (vop->quant_precision);
}

Int GetVopBitsPerPixel(Vop *vop) {
  return (vop->bits_per_pixel);
}

Int GetVopMidGrey(Vop *vop) {
  return (1 << (vop->bits_per_pixel - 1));
}
Int GetVopBrightWhite(Vop *vop) {
  return ((1 << vop->bits_per_pixel) - 1);
}


/* START: Complexity Estimation syntax support - Marc Mongenet (EPFL) - 4 Jun 1998 */

Int GetVopComplexityEstimationDisable (const Vop * vop) {
  return (vop->complexity_estimation_disable);
}

Int GetVopEstimationMethod (const Vop * vop) {
  return vop->estimation_method;
}

Int GetVopShapeComplexityEstimationDisable (const Vop * vop) {
  return vop->shape_complexity_estimation_disable;
}

Int GetVopOpaque (const Vop * vop) {
  return vop->opaque;
}

Int GetVopDCECSOpaque (const Vop * vop) {
  return vop->dcecs_opaque;
}

Int GetVopTransparent (const Vop * vop) {
  return vop->transparent;
}

Int GetVopDCECSTransparent (const Vop * vop) {
  return vop->dcecs_transparent;
}

Int GetVopIntraCAE (const Vop * vop) {
  return vop->intra_cae;
}

Int GetVopDCECSIntraCAE (const Vop * vop) {
  return vop->dcecs_intra_cae;
}

Int GetVopInterCAE (const Vop * vop) {
  return vop->inter_cae;
}

Int GetVopDCECSInterCAE (const Vop * vop) {
  return vop->dcecs_inter_cae;
}

Int GetVopNoUpdate (const Vop * vop) {
  return vop->no_update;
}

Int GetVopDCECSNoUpdate (const Vop * vop) {
  return vop->dcecs_no_update;
}

Int GetVopUpsampling (const Vop * vop) {
  return vop->upsampling;
}

Int GetVopDCECSUpsampling (const Vop * vop) {
  return vop->dcecs_upsampling;
}

Int GetVopTextureComplexityEstimationSet1Disable (const Vop * vop) {
  return vop->texture_complexity_estimation_set_1_disable;
}

Int GetVopIntraBlocks (const Vop * vop) {
  return vop->intra_blocks;
}

Int GetVopDCECSIntraBlocks (const Vop * vop) {
  return vop->dcecs_intra_blocks;
}

Int GetVopInterBlocks (const Vop * vop) {
  return vop->inter_blocks;
}

Int GetVopDCECSInterBlocks (const Vop * vop) {
  return vop->dcecs_inter_blocks;
}

Int GetVopInter4vBlocks (const Vop * vop) {
  return vop->inter4v_blocks;
}

Int GetVopDCECSInter4vBlocks (const Vop * vop) {
  return vop->dcecs_inter4v_blocks;
}

Int GetVopNotCodedBlocks (const Vop * vop) {
  return vop->not_coded_blocks;
}

Int GetVopDCECSNotCodedBlocks (const Vop * vop) {
  return vop->dcecs_not_coded_blocks;
}

Int GetVopTextureComplexityEstimationSet2Disable (const Vop * vop) {
  return vop->texture_complexity_estimation_set_2_disable;
}

Int GetVopDCTCoefs (const Vop * vop) {
  return vop->dct_coefs;
}

Int GetVopDCECSDCTCoefs (const Vop * vop) {
  return vop->dcecs_dct_coefs;
}

Int GetVopDCTLines (const Vop * vop) {
  return vop->dct_lines;
}

Int GetVopDCECSDCTLines (const Vop * vop) {
  return vop->dcecs_dct_lines;
}

Int GetVopVLCSymbols (const Vop * vop) {
  return vop->vlc_symbols;
}

Int GetVopDCECSVLCSymbols (const Vop * vop) {
  return vop->dcecs_vlc_symbols;
}

Int GetVopVLCBits (const Vop * vop) {
  return vop->vlc_bits;
}

Int GetVopDCECSVLCBits (const Vop * vop) {
  return vop->dcecs_vlc_bits;
}

Int GetVopMotionCompensationComplexityDisable (const Vop * vop) {
  return vop->motion_compensation_complexity_disable;
}

Int GetVopAPM (const Vop * vop) {
  return vop->apm;
}

Int GetVopDCECSAPM (const Vop * vop) {
  return vop->dcecs_apm;
}

Int GetVopNPM (const Vop * vop) {
  return vop->npm;
}

Int GetVopDCECSNPM (const Vop * vop) {
  return vop->dcecs_npm;
}

Int GetVopInterpolateMCQ (const Vop * vop) {
  return vop->interpolate_mc_q;
}

Int GetVopDCECSInterpolateMCQ (const Vop * vop) {
  return vop->dcecs_interpolate_mc_q;
}

Int GetVopForwBackMCQ (const Vop * vop) {
  return vop->forw_back_mc_q;
}

Int GetVopDCECSForwBackMCQ (const Vop * vop) {
  return vop->dcecs_forw_back_mc_q;
}

Int GetVopHalfpel2 (const Vop * vop) {
  return vop->halfpel2;
}

Int GetVopDCECSHalfpel2 (const Vop * vop) {
  return vop->dcecs_halfpel2;
}

Int GetVopHalfpel4 (const Vop * vop) {
  return vop->halfpel4;
}

Int GetVopDCECSHalfpel4 (const Vop * vop) {
  return vop->dcecs_halfpel4;
}

/* START: Complexity Estimation syntax support - Update version 2 - Massimo Ravasi (EPFL) - 26 Oct 1999 */

Int GetVopVersion2ComplexityEstimationDisable (const Vop * vop) {
  return vop->version_2_complexity_estimation_disable;
}

Int GetVopSadct(const Vop * vop) {
  return vop->sadct;
}

Int GetVopDCECSSadct(const Vop * vop) {
  return vop->dcecs_sadct;
}

Int GetVopQuarterpel(const Vop * vop) {
  return vop->quarterpel;
}

Int GetVopDCECSQuarterpel(const Vop * vop) {
  return vop->dcecs_quarterpel;
}

/* END: Complexity Estimation syntax support - Update Version 2 */

/* END: Complexity Estimation syntax support */


Int GetVopRandomAccessibleVol(Vop *vop) {
  return (vop->random_accessible_vol);
}


Int GetVopConstantAlpha(Vop *vop) {
  return (vop->constant_alpha);
}



Int GetVopConstantAlphaValue(Vop *vop) {
  return (vop->constant_alpha_value);
}


Int GetVopInterlaced(Vop *vop) {
  return (vop->interlaced);
}


Int GetVopTopFieldFirst(Vop *vop) {
  return (vop->top_field_first);
}


Int GetVopAlternateScan(Vop *vop) {
  return (vop->alternate_scan);
}


Int GetVopTimeIncrementResolution(Vop *vop) {
 return (vop->time_increment_resolution);
 }

Int GetVopCoded(Vop *vop) {
  return(vop->vop_coded);
} 

Int
GetVopModTimeBase(Vop *vop)
{
  return(vop->mod_time_base);
}

Int 
GetVopTimeInc(Vop *vop)
{
  return(vop->time_inc);
}

Int
GetVopPredictionType(Vop *vop)
{
  return(vop->prediction_type);
}

Int GetVopIntraDCVlcThr(Vop *vop) 
 {
  return (vop->intra_dc_vlc_thr);
 } 

Int
GetVopRoundingType(Vop *vop)
{
  return(vop->rounding_type);
}

Int
GetVopWidth(Vop *vop)
{
  return(vop->width);
}

Int
GetVopHeight(Vop *vop)
{
  return(vop->height);
}

Int
GetVopHorSpatRef(Vop *vop)
{
  return(vop->hor_spat_ref);
}

Int
GetVopVerSpatRef(Vop *vop)
{
  return(vop->ver_spat_ref);
}

Int
GetVopBackComp(Vop *vop)
{
  return(vop->back_comp);
}


Int
GetVopQuantizer(Vop *vop)
{
  return(vop->quantizer);
}

Int
GetVopBQuantizer(Vop *vop)
{
  return(vop->B_quantizer);
}

Int
GetVopGLQuantizer(Int aux, Vop *vop)
{
  return(vop->gl_quantizer[aux]);
}

/* HYUNDAI (Grayscale) */
Int
GetVopIntraGLQuantizer(Int aux, Vop *vop)
{
  return(vop->intra_gl_quantizer[aux]);
}

/* HYUNDAI (Grayscale) */
Int
GetVopBGLQuantizer(Int aux, Vop *vop)
{
  return(vop->B_gl_quantizer[aux]);
}

Int
GetVopLoadBackShape(Vop *vop)
{
  return(vop->load_back_shape);
}

Int
GetVopLoadForShape(Vop *vop)
{
  return(vop->load_for_shape);
}

Int
GetVopRefSelCode(Vop *vop)
{
  return(vop->ref_sel_code);
}

Int
GetVopForTempRef(Vop *vop)
{
  return(vop->for_temp_ref);
}

Int
GetVopBackTempRef(Vop *vop)
{
  return(vop->back_temp_ref);
}

Int
GetVopId(Vop *vop)
{
  return(vop->ident);
}

Int
GetVopVOId(Vop *vop)
{
  return(vop->vo_id);
}

Int
GetVopArbitraryShape(Vop *vop)
{
  return(vop->arbitrary_shape);
}

Int
GetVopShape(Vop *vop)
{
  return(vop->arbitrary_shape);
}

Int
GetVopShapeEffects(Vop *vop)
{
  return(vop->shape_effects);
}

Int GetVopChangeCRDisable(Vop *vop)
{
	return (vop->change_CR_disable);
}


Int
GetVopQuantType(Vop *vop)
{
  return(vop->quant_type);
}

Int
GetVopLoadIntraQuantMat(Vop *vop)
{
  return(vop->load_intra_quant_mat);
}

Int *
GetVopIntraQuantMat(Vop *vop)
{
  return(vop->intra_quant_mat);
}

Int
GetVopLoadNonintraQuantMat(Vop *vop)
{
  return(vop->load_nonintra_quant_mat);
}

Int *
GetVopNonintraQuantMat(Vop *vop)
{
  return(vop->nonintra_quant_mat);
}

Int
GetVopDisableGrayQuantUpdate(Vop *vop)
{
  return(vop->disable_gray_quant_update);
}

Int
GetVopLoadGrayIntraQuantMat(Int aux, Vop *vop)
{
  return(vop->load_gray_intra_quant_mat[aux]);
}

Int *
GetVopGrayIntraQuantMat(Int aux, Vop *vop)
{
  return(vop->gray_intra_quant_mat[aux]);
}

Int
GetVopLoadGrayNonintraQuantMat(Int aux, Vop *vop)
{
  return(vop->load_gray_nonintra_quant_mat[aux]);
}

Int *
GetVopGrayNonintraQuantMat(Int aux, Vop *vop)
{
  return(vop->gray_nonintra_quant_mat[aux]);
}

Int 
GetVopIntraQuantizer(Vop *vop)
{
	return(vop->intra_quantizer);
}

Int
GetVopErrorResDisable(Vop *vop)
{
	return(vop->error_res_disable);
}

Int
GetVopDataPartEnable(Vop *vop)
{
        return(vop->data_partitioning);
}

Int
GetVopReverseVlc(Vop *vop)
{
	return(vop->reverse_vlc && (vop->prediction_type!=2/*B_VOP*/)); /* MW 10-SEP 1998 : RVLCs not used in B-VOPs */
}

/** added for NEWPRED (Oki) 16-AUG-1999 **/
Int
GetVopNewpredEnable(Vop *vop)
{
  return(vop->newpred_enable);
}

Int
GetVopNewpredBackwardMessageType(Vop *vop)
{
  return(vop->newpred_backward_message_type);
}

/* 29.01.99 HHI Schueuer */
Int
GetVopSADCTDisable(Vop *vop)
{
	return(vop->sadct_disable);
}
/* end HHI */

Int
GetVopNewpredSegmentType(Vop *vop)
{
  return(vop->newpred_segment_type);
}

Int
GetVopNewpredVopId(Vop *vop)
{
  return(vop->np_vop_id);
}

Int
GetVopNewpredVopIdPred(Vop *vop, Int np_seg_id)
{
  return(vop->np_vop_id_pred[np_seg_id]);
}

Int
GetVopNewpredNumVps(Vop *vop)
{
  return(vop->np_num_segments);
}

Int
GetVopNewpredMbaVp(Vop *vop, Int np_seg_id)
{
  return(vop->np_mba_segment[np_seg_id]);
}
/** end of NEWPRED (Oki) 16-AUG-1999 **/

Int
GetVopIntraACDCPredDisable(Vop *vop)
{
  return(vop->intra_acdc_pred_disable);
}


/* MW QPEL 06-JUL-1998 >> */
Int
GetVopQuarterPel(Vop *vop)
{
  return(vop->quarter_pel);
}
/* << MW QPEL 06-JUL-1998 */

Int 
GetVopOBMCDisable(Vop *vop)
{
      return(vop->obmc_disable);
} 

Int
GetVopFCodeFor(Vop *vop)
{
  return(vop->fcode_for);
}

Int
GetVopFCodeBack(Vop *vop)
{
  return(vop->fcode_back);
}

Int
GetVopSearchRangeFor(Vop *vop)
{
  return(vop->sr_for);
}

Int
GetVopSearchRangeBack(Vop *vop)
{
  return(vop->sr_back);
}

Int GetVopShapeCodingType(Vop *vop)
{
	return(vop->shape_coding_type);
}



Int
GetVopScalability(Vop *vop)
{
  return(vop->scalability);
}

/* begin : added for OBSS by Samsung AIT (1999-09-29) */
Int
GetVopHierarchyType(Vop *vop)
{
  return(vop->hierarchy_type);
}
/* end : added for OBSS by Samsung AIT (1999-09-29) */

Int
GetVopRefId(Vop *vop)
{
  return(vop->ref_ident);
}

Int
GetVopRefSampDir(Vop *vop)
{
  return(vop->ref_samp_dir);
}

Int
GetVopHorSampN(Vop *vop)
{
  return(vop->hor_samp_n);
}

Int
GetVopHorSampM(Vop *vop)
{
  return(vop->hor_samp_m);
}

Int
GetVopVerSampN(Vop *vop)
{
  return(vop->ver_samp_n);
}

Int
GetVopVerSampM(Vop *vop)
{
  return(vop->ver_samp_m);
}

Int
GetVopEnhanceType(Vop *vop)
{
  return(vop->enhancement_type);
}

/* begin : added for OBSS by Samsung AIT (1999-09-29) */
Int
GetVopUseRefShape(Vop *vop)
{
  return(vop->use_ref_shape);
}
 
Int
GetVopUseRefTexture(Vop *vop)
{
  return(vop->use_ref_texture);
}
 
Int
GetVopShapeHorSampN(Vop *vop)
{
  return(vop->shape_hor_samp_n);
}
 
Int
GetVopShapeHorSampM(Vop *vop)
{
  return(vop->shape_hor_samp_m);
}
 
Int
GetVopShapeVerSampN(Vop *vop)
{
  return(vop->shape_ver_samp_n);
}
 
Int
GetVopShapeVerSampM(Vop *vop)
{
  return(vop->shape_ver_samp_m);
}
/* end : added for OBSS by Samsung AIT (1999-09-29) */

Int
GetVopScaling(Vop *vop)
{
  return(vop->scaling);
}

Int
GetVopVisibility(Vop *vop)
{
  return(vop->visibility);
}

Int
GetVopBinaryShape(Vop *vop)
{
  return(vop->binary_shape);
}

Int
GetVopCompOrder(Vop *vop)
{
  return(vop->comp_order);
}

Int     
GetVopSpriteUsage(Vop *vop)
{
  return(vop->sprite_usage);
}

Int     
GetVopNoOfSpritePoints(Vop *vop)
{
  return(vop->no_of_sprite_points);
}

TrajPoint *    
GetVopRefPointCoord(Vop *vop)
{
  return(vop->ref_point_coord);
}

TrajPoint *    
GetVopTrajPointCoord(Vop *vop)
{
  return(vop->traj_point_coord);
}

TrajPoint *    
GetVopDiffTrajPointCoord(Vop *vop)
{
  return(vop->difftraj_point_coord);
}

Int     
GetVopBrightnessChangeInSprite(Vop *vop)
{
  return(vop->brightness_change_in_sprite);
}

Int     
GetVopLowLatencySpriteEnable(Vop *vop)
{
  return(vop->low_latency_sprite_enable);
}

Int    
GetVopSpriteHdim(Vop *vop)
{
  return(vop->sprite_hdim);
}

Int    
GetVopSpriteVdim(Vop *vop)
{
  return(vop->sprite_vdim);
}

Int    
GetVopSpriteLeftEdge(Vop *vop)
{
  return(vop->sprite_left_edge);
}

Int    
GetVopSpriteTopEdge(Vop *vop)
{
  return(vop->sprite_top_edge);
}

Int    
GetVopWarpingAccuracy(Vop *vop)
{
  return(vop->warping_accuracy);
}

Vop *
GetVopSprite(Vop *vop)
{
  return(vop->rec_sprite);
}

Sprite_motion *
GetVopWarpParam(Vop *vop)
{
  return(vop->warp_param);
}

Float
GetVopBrightnessChangeFactor(Vop *vop)
{
  return(vop->brightness_change_factor);
}

Int
GetVopSpriteTransmitMode(Vop *vop)
{
	return(vop->sprite_transmit_mode);
}

Int *
GetVopSpriteTabTransmit(Vop *vop)
{
	return(vop->tab_transmit);
}

Int *
GetVopSpriteTabAmbType(Vop *vop)
{
	return(vop->tab_amb_type);
}

Int *
GetVopSpriteTabMvda(Vop *vop)
{
	return(vop->tab_mvda);
}

SInt *
GetVopSpriteTabQPStore(Vop *vop)
{
	return(vop->tab_QP_store);
}

Int *
GetVopSpriteTabDQUANTStore(Vop *vop)
{
	return(vop->tab_DQUANT_store);
}

Int ***
GetVopSpriteTabDCStore(Vop *vop)
{
	return(vop->tab_DC_store);
}

Image *
GetVopA(Vop *vop)
{
  return(vop->a_chan);
}

Image *
GetVopAuv(Vop *vop)
{
  return(vop->a_uv_chan);
}

Image *
GetVopShapeMode(Vop *vop)
{
  return(vop->shape_mode);
}

/* begin : added for OBSS by Samsung AIT (1999-09-29) */
Image *
GetVopAMotX(Vop *vop)
{
  return(vop->a_mot_x);
}

Image *
GetVopAMotY(Vop *vop)
{
  return(vop->a_mot_y);
}

Image *
GetVopASamplePos(Vop *vop)
{
  return(vop->a_sample_pos);
}
/* end : added for OBSS by Samsung AIT (1999-09-29) */

Image *
GetVopY(Vop *vop)
{
  return(vop->y_chan);
}

Image *
GetVopU(Vop *vop)
{
  return(vop->u_chan);
}

Image *
GetVopV(Vop *vop)
{
  return(vop->v_chan);
}

Image *
GetVopQP(Vop *vop)
{
  return(vop->QP_chan);
}

/* HYUNDAI (Grayscale) */
Image *
GetVopG(Int n, Vop *vop)
{
  return(vop->g_chan[n]);
}

/* HYUNDAI (Grayscale) */
Image *
GetVopGLQP(Int n, Vop *vop)
{
  return(vop->g_QP_chan[n]);
}
 
/* HYUNDAI (Grayscale) */
Void
PutVopG(Image *g_chan, Int n, Vop *vop)
{
  FreeImage(vop->g_chan[n]);
  vop->g_chan[n] = g_chan;
}
 
/* HYUNDAI (Grayscale) */
Void
PutVopGLQP(Image *g_QP_chan, Int n, Vop *vop)
{
  FreeImage(vop->g_QP_chan[n]);
  vop->g_QP_chan[n] = g_QP_chan;
}


Vop *
GetVopNextSpat(Vop *vop)
{
  return(vop->pnext_spat);
}

Vop *
GetVopNextTemp(Vop *vop)
{
  return(vop->pnext_temp);
}

Vop *
GetVopPrevTemp(Vop *vop)
{
  return(vop->pprev_temp);
}

/* 1197-3 SONY */
Vop *
GetVopBvopTemp(Vop *vop)
{
  return(vop->pbvop_temp);
}
/* 1197-3 */


VopExtend *
GetVopExtend(Vop *vop)
{
  return(vop->pextend);
}

Vop *
GetVopById(Vop *vop, Int vop_id)
{
  Vop *locvop;
  Int id;
  
  locvop = vop;
  
  while(locvop != NULL)
    {
      id = GetVopId(locvop);
      if(id != vop_id)
	locvop = GetVopNextSpat(locvop);
      else
	break;
    }
  
  return(locvop);
}


Vop *
GetVopByCompOrder(Vop *list, Int comp_order)
{
  Vop          *curr_vop;

  Int          vop_comp_order;

  curr_vop = list;

  while(curr_vop != NULL) 
    {   
   
      vop_comp_order = GetVopCompOrder(curr_vop);
   
      if(vop_comp_order == comp_order)
	{
	  return(curr_vop);
	}
      else
	{
	  curr_vop = GetVopNextSpat(curr_vop);
	}
    }

  return NULL;
}

Int 
GetVopNumMacroblocksInGob(Vop *vop)
{
  return(vop->num_macroblocks_in_gob);
}

Int 
GetVopNumGobsInVop(Vop *vop)
{
  return(vop->num_gobs_in_vop);
}

Int 
GetVopGobNumber(Vop *vop)
{
  return(vop->gob_number);
}

Int 
GetVopGobFrameId(Vop *vop)
{
  return(vop->gob_frame_id);
}

/* >>> added for DRC by Fujitsu (top)    <<< */
Int    
GetVopReducedResolution(Vop *vop)
{
  return(vop->reduced_resolution);
}

Int    
GetVopDctCoefMask(Vop *vop)
{
  return(vop->dct_coef_mask);
}

Int    
GetVopSwitchingFlag(Vop *vop)
{
  return(vop->switching_flag);
}

Float    
GetVopAverageQp(Vop *vop)
{
  return(vop->average_qp);
}

Int    
GetVopBitsUsed(Vop *vop)
{
  return(vop->bits_used);
}
/* >>> added for DRC by Fujitsu (bottom) <<< */

/***********************************************************CommentBegin******
 *
 * -- PutVop{xxx} -- Functions to write to components of the Vop structure
 *	
 *	Void PutVopModTimeBase(Int mod_time_base, Vop *vop)
 *	Void PutVopTimeInc(Int time_inc, Vop *vop)
 *      Void PutVopPredictionType(Int prediction_type, Vop *vop)
 *      Void PutVopWidth(Int width, Vop *vop)
 *      Void PutVopHeight(Int height, Vop *vop)
 *      Void PutVopHorSpatRef(Int hor_spat_ref, Vop *vop)
 *      Void PutVopVerSpatRef(Int ver_spat_ref, Vop *vop)
 *	Void PutVopBackComp(Int back_comp, Vop *vop)
 *      Void PutVopQuantizer(Int quantizer, Vop *vop)
 *
 *	Void PutVopLoadBackShape(Int load_back_shape, Vop *vop)
 *	Void PutVopLoadForShape(Int load_for_shape, Vop *vop)
 *	Void PutVopRefSelCode(Int ref_sel_code, Vop *vop)
 *	Void PutVopForTempRef(Int for_temp_ref, Vop *vop)
 *	Void PutVopBackTempRef(Int back_temp_ref, Vop *vop)
 *
 *	Void PutVopId(Int ident, Vop *vop)
 *	Void PutVopVOId(Int vo_id, Vop *vop)
 *      Void PutVopArbitraryShape(Int arbitrary_shape, Vop *vop)
 *      Void PutVopShape(Int arbitrary_shape, Vop *vop) (==...ArbitraryShape())
 *      Void PutVopQuantType(Int quant_type, Vop *vop)
 *      Void PutVopLoadIntraQuantMat(Int load_intra_quant_mat, Vop *vop)
 *      Void PutVopIntraQuantMat(Int *intra_quant_mat, Vop *vop)
 *      Void PutVopLoadNonintraQuantMat(Int load_nonintra_quant_mat, Vop *vop)
 *      Void PutVopNonintraQuantMat(Int *nonintra_quant_mat, Vop *vop)
 *      Void PutVopLoadGrayIntraQuantMat(Int load_gray_intra_quant_mat, Vop *vop)
 *      Void PutVopGrayIntraQuantMat(Int *gray_intra_quant_mat, Vop *vop)
 *      Void PutVopLoadGrayNonintraQuantMat(Int load_gray_nonintra_quant_mat, Vop *vop)
 *      Void PutVopGrayNonintraQuantMat(Int *gray_nonintra_quant_mat, Vop *vop)
 *	Void PutVopIntraACDCPredDisable(Int intra_dcpred_disable, Vop *vop)
 *      Void PutVopQuarterPel(Int quarter_pel, Vop *vop);	*//* MW QPEL 06-JUL-1998 *//*
 *	Void PutVopFCodeFor(Int fcode_for, Vop *vop);
 *      Void PutVopFCodeBack(Int fcode_back, Vop *vop);
 *      Void PutVopSepMotShapeText(Int sep_mot_text, Vop *vop) (==..SepMot..())
 *      Void PutVopScalability(Int scalability, Vop *vop)
 *
 *	Void PutVopRefId(Int ref_ident, Vop *vop)
 *	Void PutVopRefSampDir(Int ref_samp_dir, Vop *vop)
 *	Void PutVopHorSampN(Int hor_samp_n, Vop *vop)
 *	Void PutVopHorSampM(Int hor_samp_m, Vop *vop)
 *	Void PutVopVerSampN(Int ver_samp_n, Vop *vop)
 *	Void PutVopVerSampM(Int ver_samp_m, Vop *vop)
 *	Void PutVopEnhanceType(Int enhancement_type, Vop *vop)
 *
 *      Void PutVopScaling(Int scaling, Vop *vop)
 *      Void PutVopVisibility(Int visibility, Vop *vop)
 *      Void PutVopBinaryShape(Int binary_shape, Vop *vop)
 *      Void PutVopCompOrder(Int comp_order, Vop *vop)
 *
 *	Void PutVopSpriteUsage(Int sprite_usage, Vop *vop)
 *	Void PutVopNoOfSpritePoints(Int no_of_sprite_points, Vop *vop)
 *	Void PutVopRefPointCoord(TrajPoint *ref_point_coord, Vop *vop)
 * 	Void PutVopTrajPointCoord(TrajPoint *traj_point_coord, Vop *vop)
 * 	Void PutVopDiffTrajPointCoord(TrajPoint *traj_point_coord, Vop *vop)
 *	Void PutVopBrightnessChangeInSprite(Int brightness_change_in_sprite, Vop *vop)
 *	Void PutVopLowLatencySpriteEnable(Int low_latency_sprite_enable, Vop *vop)
 *	Void PutVopBlendFact(Int blend_fact, Vop *vop)
 *	Void PutVopSpriteHdim(Int sprite_hdim, Vop *vop)
 *	Void PutVopSpriteVdim(Int sprite_vdim, Vop *vop)
 *      Void PutVopSpriteLeftEdge(Int sprite_left_edge, Vop *vop)
 *	Void PutVopSpriteTopEdge(Int sprite_top_edge, Vop *vop)
 *	Void PutVopWarpingAccuracy(Int warping_accuracy, Vop *vop)
 *	Void PutVopSprite(Vop *rec_sprite, Vop *vop)
 *	Void PutVopWarpParam(Sprite_motion *warp_param, Vop *vop)
 *	Void PutVopBrightnessChangeFactor(Float lighintg_change_factor, Vop *vop)
 *	Void PutVopSpriteTransmitMode(Int sprite_transmit_mode, Vop *vop);
 *	Void PutVopSpriteTabTransmit(Int *tab_transmit, Vop *vop);
 *	Void PutVopSpriteTabAmbType(Int *tab_amb_type, Vop *vop);
 *	Void PutVopSpriteTabMvda(Int *tab_mvda, Vop *vop);
 *	Void PutVopSpriteTabQPStore(SInt *tab_QP_store, Vop *vop);
 *	Void PutVopSpriteTabDQUANTStore(Int *tab_DQUANT_store, Vop *vop);
 *	Void PutVopSpriteTabDCStore(Int ***tab_DC_store, Vop *vop);
 *
 *      Void PutVopA(Image *a_chan, Vop *vop)
 *      Void PutVopY(Image *y_chan, Vop *vop)
 *      Void PutVopU(Image *u_chan, Vop *vop)
 *      Void PutVopV(Image *v_chan, Vop *vop)
 *      Void PutVopQP(Image *QP_chan, Vop *vop)
 *      Void PutVopNextSpat(Vop *pnext_spat, Vop *vop)
 *      Void PutVopNextTemp(Vop *pnext_temp, Vop *vop)
 *      Void PutVopExtend(VopExtend *pextend, Vop *vop)
 *		  Void PutVopShapeEffects(Int shape_effects, Vop *vop)
 *		  Void PutVopReverseVlc(Int reverse_vlc, Vop *vop)
 *                Void PutVopDataPartEnable(Int data_partitioning, Vop *vop)
 *	Void PutVopNewpredEnable(Int flag,Vop *vop)				for NEWPRED (Oki)
 *	Void PutVopNewpredModeFlag(Int flag,Vop *vop)				for NEWPRED (Oki)
 *	Void PutVopNewpredVopId(Int vop_id,Vop *vop)				for NEWPRED (Oki)
 *	Void PutVopNewpredVopIdPred(Int vop_id_pred, Vop *vop, Int np_seg_id)	for NEWPRED (Oki)
 *	Void PutVopNewpredNumVps(Int num_segments, Vop *vop)			for NEWPRED (Oki)
 *	Void PutVopNewpredMbaVp(Int mba_segment, Vop *vop, Int np_seg_id)		for NEWPRED (Oki)
 *	Void PutVopReducedResolution(Int ReducedResolution, Vop *vop)		for DRC
 *	Void PutVopDctCoefMask(Int DctCoefMask, Vop *vop)			for DRC
 *	Void PutVopSwitchingFlag(Int SwitchingFlag, Vop *vop)			for DRC
 *	Void PutVopAverageQp(Float AverageQp, Vop *vop)				for DRC
 *	Void PutVopBitsUsed(Int BitsUsed, Vop *vop)				for DRC
 *
 * Author :		
 *	Michael Wollborn
 *
 * Created :		
 *	19-Feb-96
 *
 * Purpose :		
 *	These are common functions to write to specific components
 *      of the Vop structure.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Write access to the components of a "Vop" 
 *
 * See also :
 *	
 *
 * Modified :		
 *	04.02.97 Noel O'Connor: added PutVopIntraQuantizer()
 *	22.04.97 Michael Wollborn: Added new access functions for 
 *					   MPEG quantizer matrices
 *      26.04.97 Luis Ducla-Soares: Added PutVopDataPartEnable().
 *	07.07.97 Noel Brady: Add PutVopChangeCRDisable().   	
 *      09.07.97 Aasmund Sandvand: added PutVopVOId()
 *      04.08.97 Minhua Zhou : added PutVopOBMCDisable()
 *                             PutVopIntraDCVlcThr()	
 *	04.06.98 Marc Mongenet (EPFL): added Complexity Estimation syntax support
 *      23.06.98 A. Sandvand: added support for short video header
 *      06.07.98 U. Benzler (TUH) : added quarter pel support
 *	16.08.99 Shigeru Fukunaga (Oki): added PutVopNewpred{xxx}()
 *	06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 *  26.10.99 Massimo Ravasi (EPFL): added Complexity Estimation syntax support
 *                                  Update version 2
 *
 ***********************************************************CommentEnd********/


Void PutVopVolControlParameters(Int vol_control_parameters,Vop *vop) {
   vop->vol_control_parameters = vol_control_parameters;
} 

Void PutVopChromaFormat(Int chroma_format,Vop *vop) {
   vop->chroma_format = chroma_format;
} 

Void PutVopLowDelay(Int low_delay,Vop *vop) {
   vop->low_delay = low_delay;
} 

Void PutVopVbvParameters(Int vbv_parameters,Vop *vop) {
   vop->vbv_parameters = vbv_parameters;
} 

Void PutVopFirstHalfBitRate(Int first_half_bit_rate,Vop *vop) {
   vop->first_half_bit_rate = first_half_bit_rate;
} 

Void PutVopLatterHalfBitRate(Int latter_half_bit_rate,Vop *vop) {
   vop->latter_half_bit_rate = latter_half_bit_rate;
} 

Void PutVopFirstHalfVbvBufferSize(Int first_half_vbv_buffer_size,Vop *vop) {
   vop->first_half_vbv_buffer_size = first_half_vbv_buffer_size;
} 

Void PutVopLatterHalfVbvBufferSize(Int latter_half_vbv_buffer_size,Vop *vop) {
   vop->latter_half_vbv_buffer_size = latter_half_vbv_buffer_size;
} 

Void PutVopFirstHalfVbvOccupancy(Int first_half_vbv_occupancy,Vop *vop) {
   vop->first_half_vbv_occupancy = first_half_vbv_occupancy;
} 

Void PutVopLatterHalfVbvOccupancy(Int latter_half_vbv_occupancy,Vop *vop) {
   vop->latter_half_vbv_occupancy = latter_half_vbv_occupancy;
} 


Void PutVopQuantPrecision(Int quant_precision,Vop *vop) {
   vop->quant_precision = quant_precision;
} 


/* START: Complexity Estimation syntax support - Marc Mongenet (EPFL) - 4 Jun 1998 */

Void PutVopComplexityEstimationDisable (Int v, Vop * vop) {
  vop->complexity_estimation_disable = v;
}

Void PutVopEstimationMethod (Int v, Vop * vop) {
  vop->estimation_method = v;
}

Void PutVopShapeComplexityEstimationDisable (Int v, Vop * vop) {
  vop->shape_complexity_estimation_disable = v;
}

Void PutVopOpaque (Int v, Vop * vop) {
  vop->opaque = v;
}

Void PutVopDCECSOpaque (Int v, Vop * vop) {
  vop->dcecs_opaque = v;
}

Void PutVopTransparent (Int v, Vop * vop) {
  vop->transparent = v;
}

Void PutVopDCECSTransparent (Int v, Vop * vop) {
  vop->dcecs_transparent = v;
}

Void PutVopIntraCAE (Int v, Vop * vop) {
  vop->intra_cae = v;
}

Void PutVopDCECSIntraCAE (Int v, Vop * vop) {
  vop->dcecs_intra_cae = v;
}

Void PutVopInterCAE (Int v, Vop * vop) {
  vop->inter_cae = v;
}

Void PutVopDCECSInterCAE (Int v, Vop * vop) {
  vop->dcecs_inter_cae = v;
}

Void PutVopNoUpdate (Int v, Vop * vop) {
  vop->no_update = v;
}

Void PutVopDCECSNoUpdate (Int v, Vop * vop) {
  vop->dcecs_no_update = v;
}

Void PutVopUpsampling (Int v, Vop * vop) {
  vop->upsampling = v;
}

Void PutVopDCECSUpsampling (Int v, Vop * vop) {
  vop->dcecs_upsampling = v;
}

Void PutVopTextureComplexityEstimationSet1Disable (Int v, Vop * vop) {
  vop->texture_complexity_estimation_set_1_disable = v;
}

Void PutVopIntraBlocks (Int v, Vop * vop) {
  vop->intra_blocks = v;
}

Void PutVopDCECSIntraBlocks (Int v, Vop * vop) {
  vop->dcecs_intra_blocks = v;
}

Void PutVopInterBlocks (Int v, Vop * vop) {
  vop->inter_blocks = v;
}

Void PutVopDCECSInterBlocks (Int v, Vop * vop) {
  vop->dcecs_inter_blocks = v;
}

Void PutVopInter4vBlocks (Int v, Vop * vop) {
  vop->inter4v_blocks = v;
}

Void PutVopDCECSInter4vBlocks (Int v, Vop * vop) {
  vop->dcecs_inter4v_blocks = v;
}

Void PutVopNotCodedBlocks (Int v, Vop * vop) {
  vop->not_coded_blocks = v;
}

Void PutVopDCECSNotCodedBlocks (Int v, Vop * vop) {
  vop->dcecs_not_coded_blocks = v;
}

Void PutVopTextureComplexityEstimationSet2Disable (Int v, Vop * vop) {
  vop->texture_complexity_estimation_set_2_disable = v;
}

Void PutVopDCTCoefs (Int v, Vop * vop) {
  vop->dct_coefs = v;
}

Void PutVopDCECSDCTCoefs (Int v, Vop * vop) {
  vop->dcecs_dct_coefs = v;
}

Void PutVopDCTLines (Int v, Vop * vop) {
  vop->dct_lines = v;
}

Void PutVopDCECSDCTLines (Int v, Vop * vop) {
  vop->dcecs_dct_lines = v;
}

Void PutVopVLCSymbols (Int v, Vop * vop) {
  vop->vlc_symbols = v;
}

Void PutVopDCECSVLCSymbols (Int v, Vop * vop) {
  vop->dcecs_vlc_symbols = v;
}

Void PutVopVLCBits (Int v, Vop * vop) {
  vop->vlc_bits = v;
}

Void PutVopDCECSVLCBits (Int v, Vop * vop) {
  vop->dcecs_vlc_bits = v;
}

Void PutVopMotionCompensationComplexityDisable (Int v, Vop * vop) {
  vop->motion_compensation_complexity_disable = v;
}

Void PutVopAPM (Int v, Vop * vop) {
  vop->apm = v;
}

Void PutVopDCECSAPM (Int v, Vop * vop) {
  vop->dcecs_apm = v;
}

Void PutVopNPM (Int v, Vop * vop) {
  vop->npm = v;
}

Void PutVopDCECSNPM (Int v, Vop * vop) {
  vop->dcecs_npm = v;
}

Void PutVopInterpolateMCQ (Int v, Vop * vop) {
  vop->interpolate_mc_q = v;
}

Void PutVopDCECSInterpolateMCQ (Int v, Vop * vop) {
  vop->dcecs_interpolate_mc_q = v;
}

Void PutVopForwBackMCQ (Int v, Vop * vop) {
  vop->forw_back_mc_q = v;
}

Void PutVopDCECSForwBackMCQ (Int v, Vop * vop) {
  vop->dcecs_forw_back_mc_q = v;
}

Void PutVopHalfpel2 (Int v, Vop * vop) {
  vop->halfpel2 = v;
}

Void PutVopDCECSHalfpel2 (Int v, Vop * vop) {
  vop->dcecs_halfpel2 = v;
}

Void PutVopHalfpel4 (Int v, Vop * vop) {
  vop->halfpel4 = v;
}

Void PutVopDCECSHalfpel4 (Int v, Vop * vop) {
  vop->dcecs_halfpel4 = v;
}

/* START: Complexity Estimation syntax support - Update version 2 - Massimo Ravasi (EPFL) - 26 Oct 1999 */

Void PutVopVersion2ComplexityEstimationDisable (Int v, Vop * vop) {
  vop->version_2_complexity_estimation_disable = v;
}

Void PutVopSadct(Int v, Vop * vop) {
  vop->sadct = v;
}

Void PutVopDCECSSadct(Int v, Vop * vop) {
  vop->dcecs_sadct = v;
}

Void PutVopQuarterpel(Int v, Vop * vop) {
  vop->quarterpel = v;
}

Void PutVopDCECSQuarterpel(Int v, Vop * vop) {
  vop->dcecs_quarterpel = v;
}

/* END: Complexity Estimation syntax support - Update Version 2 */
/* END: Complexity Estimation syntax support */


Void PutVopRandomAccessibleVol(Int random_accessible_vol,Vop *vop) {
   vop->random_accessible_vol = random_accessible_vol;
}


Void PutVopIsObjectLayerIdentifier(Int is_object_layer_identifier,Vop *vop) {
   vop->is_object_layer_identifier = is_object_layer_identifier;
}

Void PutVopVisualObjectLayerVerid(Int visual_object_layer_verid,Vop *vop) {
   vop->visual_object_layer_verid = visual_object_layer_verid;
} 

Void PutVopVisualObjectLayerPriority(Int visual_object_layer_priority,Vop *vop) {
   vop->visual_object_layer_priority = visual_object_layer_priority;
} 

Void PutVopFixedVopRate(Int fixed_vop_rate,Vop *vop) {
   vop->fixed_vop_rate = fixed_vop_rate;
} 

Void PutVopBitsPerPixel(Int bits_per_pixel,Vop *vop) {
   vop->bits_per_pixel = bits_per_pixel;
} 

Void PutVopConstantAlpha(Int constant_alpha,Vop *vop) {
   vop->constant_alpha = constant_alpha;
}

Void PutVopConstantAlphaValue(Int constant_alpha_value,Vop *vop) {
   vop->constant_alpha_value = constant_alpha_value;
}

Void PutVopInterlaced(Int interlaced,Vop *vop) {
   vop->interlaced = interlaced;
}

Void PutVopTopFieldFirst(Int top_field_first,Vop *vop) {
   vop->top_field_first = top_field_first;
}

Void PutVopAlternateScan(Int alternate_scan,Vop *vop) {
   vop->alternate_scan = alternate_scan;
}

Void PutVopTimeIncrementResolution(Int time_incre_res, Vop *vop) {
  vop->time_increment_resolution=time_incre_res;
 }

Void 
PutVopCoded(Int vop_coded, Vop *vop) {
  vop->vop_coded = vop_coded;
}

Void
PutVopModTimeBase(Int mod_time_base, Vop *vop)
{
  vop->mod_time_base = mod_time_base;
}

Void
PutVopTimeInc(Int time_inc, Vop *vop)
{
  vop->time_inc = time_inc;
}

Void
PutVopPredictionType(Int prediction_type, Vop *vop)
{
  vop->prediction_type = prediction_type;
}

Void PutVopIntraDCVlcThr(Int intra_dc_vlc_thr,Vop *vop) 
 {
  vop->intra_dc_vlc_thr=intra_dc_vlc_thr;
 } 

Void
PutVopRoundingType(Int rounding_type, Vop *vop)
{
  vop->rounding_type = rounding_type;
}

Void
PutVopWidth(Int width, Vop *vop)
{
  vop->width = width;
}

Void
PutVopHeight(Int height, Vop *vop)
{
  vop->height = height;
}

Void
PutVopHorSpatRef(Int hor_spat_ref, Vop *vop)
{
  vop->hor_spat_ref = hor_spat_ref;
}

Void
PutVopVerSpatRef(Int ver_spat_ref, Vop *vop)
{
  vop->ver_spat_ref = ver_spat_ref;
}

Void
PutVopBackComp(Int back_comp, Vop *vop)
{
  vop->back_comp = back_comp;
}


Void
PutVopQuantizer(Int quantizer, Vop *vop)
{
  vop->quantizer = quantizer;
}

Void
PutVopBQuantizer(Int B_quantizer, Vop *vop)
{
  vop->B_quantizer = B_quantizer;
}

Void
PutVopGLQuantizer(Int gl_quant, Int aux, Vop *vop)
{
  vop->gl_quantizer[aux] = gl_quant;
}

/* HYUNDAI (Grayscale) */
Void
PutVopIntraGLQuantizer(Int intra_gl_quant, Int aux, Vop *vop)
{
  vop->intra_gl_quantizer[aux] = intra_gl_quant;
}

/* HYUNDAI (Grayscale) */
Void
PutVopBGLQuantizer(Int B_gl_quant, Int aux, Vop *vop)
{
  vop->B_gl_quantizer[aux] = B_gl_quant;
}
Void
PutVopLoadBackShape(Int load_back_shape, Vop *vop)
{
  vop->load_back_shape = load_back_shape;
}

Void
PutVopLoadForShape(Int load_for_shape, Vop *vop)
{
  vop->load_for_shape = load_for_shape;
}

Void
PutVopRefSelCode(Int ref_sel_code, Vop *vop)
{
  vop->ref_sel_code = ref_sel_code;
}

Void
PutVopForTempRef(Int for_temp_ref, Vop *vop)
{
  vop->for_temp_ref = for_temp_ref;
}

Void
PutVopBackTempRef(Int back_temp_ref, Vop *vop)
{
  vop->back_temp_ref = back_temp_ref;
}

Void
PutVopId(Int ident, Vop *vop)
{
  vop->ident = ident;
}

Void
PutVopVOId(Int vo_id, Vop *vop)
{
  vop->vo_id = vo_id;
}

Void
PutVopArbitraryShape(Int arbitrary_shape, Vop *vop)
{
  vop->arbitrary_shape = arbitrary_shape;
}

Void
PutVopShape(Int arbitrary_shape, Vop *vop)
{
  vop->arbitrary_shape = arbitrary_shape;
}

Void
PutVopShapeEffects(Int shape_effects, Vop *vop)
{
	vop->shape_effects = shape_effects;
}

Void
PutVopChangeCRDisable(Int change_CR_disable, Vop *vop)
{
	vop->change_CR_disable = change_CR_disable;
}


Void
PutVopQuantType(Int quant_type, Vop *vop)
{
  vop->quant_type = quant_type;
}

Void
PutVopLoadIntraQuantMat(Int load_intra_quant_mat, Vop *vop)
{
  vop->load_intra_quant_mat = load_intra_quant_mat;
}

Void
PutVopLoadNonintraQuantMat(Int load_nonintra_quant_mat, Vop *vop)
{
  vop->load_nonintra_quant_mat = load_nonintra_quant_mat;
}

Void
PutVopDisableGrayQuantUpdate(Int disable_gray_quant_update, Vop *vop)
{
  vop->disable_gray_quant_update = disable_gray_quant_update;
}

Void
PutVopLoadGrayIntraQuantMat(Int load_gray_intra_quant_mat, Int aux, Vop *vop)
{
  vop->load_gray_intra_quant_mat[aux] = load_gray_intra_quant_mat;
}

Void
PutVopLoadGrayNonintraQuantMat(Int load_gray_nonintra_quant_mat, Int aux, Vop *vop)
{
  vop->load_gray_nonintra_quant_mat[aux] = load_gray_nonintra_quant_mat;
}

Void
PutVopErrorResDisable(Int flag,Vop *vop)
{
	vop->error_res_disable = flag;
}

Void
PutVopDataPartEnable(Int flag, Vop *vop)
{
        vop->data_partitioning = flag;
}

Void
PutVopOBMCDisable(Int flag, Vop *vop)
{
        vop->obmc_disable = flag;
}

Void
PutVopReverseVlc(Int reverse_vlc,Vop *vop)
{
	vop->reverse_vlc = reverse_vlc;
}

/** added for NEWPRED (Oki) 16-AUG-1999 **/
Void
PutVopNewpredEnable(Int flag,Vop *vop)
{
  vop->newpred_enable = flag;
}

/* 29.01.99 HHI Schueuer */
Void
PutVopSADCTDisable(Int sadct_disable, Vop *vop)
{
	vop->sadct_disable = sadct_disable;
}
/* end HHI */

Void
PutVopNewpredBackwardMessageType(Int flag,Vop *vop)
{
  vop->newpred_backward_message_type = flag;
}

Void
PutVopNewpredSegmentType(Int flag,Vop *vop)
{
  vop->newpred_segment_type = flag;
}

Void
PutVopNewpredVopId(Int vop_id,Vop *vop)
{
  vop->np_vop_id = vop_id;
}

Void
PutVopNewpredVopIdPred(Int vop_id_pred, Vop *vop, Int np_seg_id)
{
  vop->np_vop_id_pred[np_seg_id] = vop_id_pred;
}

Void
PutVopNewpredNumVps(Int num_segments, Vop *vop)
{
  vop->np_num_segments = num_segments;
}

Void
PutVopNewpredMbaVp(Int mba_segment, Vop *vop, Int np_seg_id)
{
  vop->np_mba_segment[np_seg_id] = mba_segment;
}
/** end of NEWPRED (Oki) 16-AUG-1999 **/

Void
PutVopIntraACDCPredDisable(Int intra_acdc_pred_disable, Vop *vop)
{
  vop->intra_acdc_pred_disable = intra_acdc_pred_disable;
}

/* MW QPEL 06-JUL-1998 >> */
Void
PutVopQuarterPel(Int quarter_pel, Vop *vop)
{
  vop->quarter_pel = quarter_pel;
}
/* << MW QPEL 06-JUL-1998 */

Void
PutVopFCodeFor(Int fcode_for, Vop *vop)
{
  vop->fcode_for = fcode_for;
}

Void
PutVopFCodeBack(Int fcode_back, Vop *vop)
{
  vop->fcode_back = fcode_back;
}


Void
PutVopSearchRangeFor(Int sr_for, Vop *vop)
{
  vop->sr_for = sr_for;
}

Void
PutVopSearchRangeBack(Int sr_back, Vop *vop)
{
  vop->sr_back = sr_back;
}

Void
PutVopShapeCodingType(Int shape_coding_type, Vop *vop)
{
  vop->shape_coding_type = shape_coding_type;
}




Void
PutVopScalability(Int scalability, Vop *vop)
{
  vop->scalability = scalability;
}

/* begin : added for OBSS by Samsung AIT (1999-09-29) */
Void
PutVopHierarchyType(Int hierarchy_type,Vop *vop)
{
  vop->hierarchy_type = hierarchy_type;
}
/* end : added for OBSS by Samsung AIT (1999-09-29) */

Void
PutVopRefId(Int id,Vop *vop)
{
  vop->ref_ident = id;
}

Void
PutVopRefSampDir(Int dir,Vop *vop)
{
  vop->ref_samp_dir = dir;
}

Void
PutVopHorSampN(Int n,Vop *vop)
{
  vop->hor_samp_n = n;
}

Void
PutVopHorSampM(Int m,Vop *vop)
{
  vop->hor_samp_m = m;
}

Void
PutVopVerSampN(Int n,Vop *vop)
{
  vop->ver_samp_n = n;
}

Void
PutVopVerSampM(Int m,Vop *vop)
{
  vop->ver_samp_m = m;
}

Void
PutVopEnhanceType(Int type,Vop *vop)
{
  vop->enhancement_type = type;
}

/* begin : added for OBSS by Samsung AIT (1999-09-29) */
Void
PutVopUseRefShape(Int use_ref_shape,Vop *vop)
{
  vop->use_ref_shape = use_ref_shape;
}
 
Void
PutVopUseRefTexture(Int use_ref_texture,Vop *vop)
{
  vop->use_ref_texture = use_ref_texture;
}
 
Void
PutVopShapeHorSampN(Int n,Vop *vop)
{
  vop->shape_hor_samp_n = n;
}
 
Void
PutVopShapeHorSampM(Int m,Vop *vop)
{
  vop->shape_hor_samp_m = m;
}
 
Void
PutVopShapeVerSampN(Int n,Vop *vop)
{
  vop->shape_ver_samp_n = n;
}
 
Void
PutVopShapeVerSampM(Int m,Vop *vop)
{
  vop->shape_ver_samp_m = m;
}
/* end : added for OBSS by Samsung AIT (1999-09-29) */

Void
PutVopScaling(Int scaling, Vop *vop)
{
  vop->scaling = scaling;
}

Void
PutVopVisibility(Int visibility, Vop *vop)
{
  vop->visibility = visibility;
}

Void
PutVopBinaryShape(Int binary_shape, Vop *vop)
{
  vop->binary_shape = binary_shape;
}

Void
PutVopCompOrder(Int comp_order, Vop *vop)
{
  vop->comp_order = comp_order;
}

Void
PutVopSpriteUsage(Int sprite_usage, Vop *vop)
{
  vop->sprite_usage = sprite_usage;
}

Void
PutVopNoOfSpritePoints(Int no_of_sprite_points, Vop *vop)
{
  vop->no_of_sprite_points = no_of_sprite_points;
}

Void
PutVopRefPointCoord(TrajPoint *ref_point_coord, Vop *vop)
{
  vop->ref_point_coord = ref_point_coord;
}

Void
PutVopTrajPointCoord(TrajPoint *traj_point_coord, Vop *vop)
{
  vop->traj_point_coord = traj_point_coord;
}

Void
PutVopDiffTrajPointCoord(TrajPoint *difftraj_point_coord, Vop *vop)
{
  vop->difftraj_point_coord = difftraj_point_coord;
}

Void
PutVopBrightnessChangeInSprite(Int brightness_change_in_sprite, Vop *vop)
{
  vop->brightness_change_in_sprite = brightness_change_in_sprite;
}


Void
PutVopLowLatencySpriteEnable(Int low_latency_sprite_enable, Vop *vop)
{
  vop->low_latency_sprite_enable = low_latency_sprite_enable;
}

Void
PutVopSpriteHdim(Int sprite_hdim, Vop *vop)
{
  vop->sprite_hdim = sprite_hdim;
}

Void
PutVopSpriteVdim(Int sprite_vdim, Vop *vop)
{
  vop->sprite_vdim = sprite_vdim;
}

Void
PutVopSpriteLeftEdge(Int sprite_left_edge, Vop *vop)
{
  vop->sprite_left_edge = sprite_left_edge;
}

Void
PutVopSpriteTopEdge(Int sprite_top_edge, Vop *vop)
{
  vop->sprite_top_edge = sprite_top_edge;
}

Void
PutVopWarpingAccuracy(Int warping_accuracy, Vop *vop)
{
  vop->warping_accuracy = warping_accuracy;
}

Void
PutVopSprite(Vop *rec_sprite, Vop *vop)
{
  vop->rec_sprite = rec_sprite;
}

Void
PutVopWarpParam(Sprite_motion *warp_param, Vop *vop)
{
  vop->warp_param = warp_param;
}

Void
PutVopBrightnessChangeFactor(Float brightness_change_factor, Vop *vop)
{
  vop->brightness_change_factor = brightness_change_factor;
}

Void
PutVopSpriteTransmitMode(Int sprite_transmit_mode, Vop *vop)
{
  vop->sprite_transmit_mode = sprite_transmit_mode;
}

Void
PutVopSpriteTabTransmit(Int *tab_transmit, Vop *vop)
{
	vop->tab_transmit = tab_transmit;
}

Void
PutVopSpriteTabAmbType(Int *tab_amb_type, Vop *vop)
{
	vop->tab_amb_type = tab_amb_type;
}

Void
PutVopSpriteTabMvda(Int *tab_mvda, Vop *vop)
{
	vop->tab_mvda = tab_mvda;
}

Void
PutVopSpriteTabQPStore(SInt *tab_QP_store, Vop *vop)
{
	vop->tab_QP_store = tab_QP_store;
}

Void
PutVopSpriteTabDQUANTStore(Int *tab_DQUANT_store, Vop *vop)
{
	vop->tab_DQUANT_store = tab_DQUANT_store;
}

Void
PutVopSpriteTabDCStore(Int ***tab_DC_store, Vop *vop)
{
	vop->tab_DC_store = tab_DC_store;
}

Void
PutVopA(Image *a_chan, Vop *vop)
{
  FreeImage(vop->a_chan);
  vop->a_chan = a_chan;
}

Void 
PutVopAuv(Image *a_uv_chan, Vop *vop)
{
  FreeImage(vop->a_uv_chan);
  vop->a_uv_chan = a_uv_chan;
}

Void 
PutVopShapeMode(Image *shape_mode, Vop *vop)
{
  FreeImage(vop->shape_mode);
  vop->shape_mode = shape_mode;
}

/* begin : added for OBSS by Samsung AIT (1999-09-29) */
Void
PutVopAMotX(Image *a_mot_x, Vop *vop)
{
  FreeImage(vop->a_mot_x);
  vop->a_mot_x = a_mot_x;
}

Void
PutVopAMotY(Image *a_mot_y, Vop *vop)
{
  FreeImage(vop->a_mot_y);
  vop->a_mot_y = a_mot_y;
}

Void
PutVopASamplePos(Image *a_sample_pos, Vop *vop)
{
  FreeImage(vop->a_sample_pos);
  vop->a_sample_pos = a_sample_pos;
}
/* end : added for OBSS by Samsung AIT (1999-09-29) */

Void
PutVopY(Image *y_chan, Vop *vop)
{
  FreeImage(vop->y_chan);
  vop->y_chan = y_chan;
}

Void
PutVopU(Image *u_chan, Vop *vop)
{
  FreeImage(vop->u_chan);
  vop->u_chan = u_chan;
}

Void
PutVopV(Image *v_chan, Vop *vop)
{
  FreeImage(vop->v_chan);
  vop->v_chan = v_chan;
}

Void
PutVopQP(Image *QP_chan, Vop *vop)
{
  FreeImage(vop->QP_chan);
  vop->QP_chan = QP_chan;
}

Void
PutVopNextSpat(Vop *pnext_spat, Vop *vop)
{
  vop->pnext_spat = pnext_spat;
}

Void
PutVopNextTemp(Vop *pnext_temp, Vop *vop)
{
  vop->pnext_temp = pnext_temp;
}

Void
PutVopPrevTemp(Vop *pprev_temp, Vop *vop)
{
  vop->pprev_temp = pprev_temp;
}

/* 1197-3 SONY*/
Void
PutVopBvopTemp(Vop *pbvop_temp, Vop *vop)
{
  vop->pbvop_temp = pbvop_temp;
}
/* 1197-3 */

Void
PutVopExtend(VopExtend *pextend, Vop *vop)
{
  vop->pextend = pextend;
}

Void
PutVopIntraQuantizer(Int Q,Vop *vop)
{
	vop->intra_quantizer = Q;
}

Void
PutVopNumMacroblocksInGob(Int num_macroblocks_in_gob,Vop *vop)
{
	vop->num_macroblocks_in_gob = num_macroblocks_in_gob;
}

Void
PutVopNumGobsInVop(Int num_gobs_in_vop,Vop *vop)
{
	vop->num_gobs_in_vop = num_gobs_in_vop;
}

Void
PutVopGobNumber(Int gob_number,Vop *vop)
{
	vop->gob_number = gob_number;
}

Void
PutVopGobFrameId(Int gob_frame_id,Vop *vop)
{
	vop->gob_frame_id = gob_frame_id;
}

/* >>> added for DRC by Fujitsu (top)    <<< */
Void    
PutVopReducedResolution(Int ReducedResolution, Vop *vop)
{
  vop->reduced_resolution = ReducedResolution;
}

Void    
PutVopDctCoefMask(Int DctCoefMask, Vop *vop)
{
  vop->dct_coef_mask = DctCoefMask;
}

Void    
PutVopSwitchingFlag(Int SwitchingFlag, Vop *vop)
{
  vop->switching_flag = SwitchingFlag;
}

Void    
PutVopAverageQp(Float AverageQp, Vop *vop)
{
  vop->average_qp = AverageQp;
}

Void    
PutVopBitsUsed(Int BitsUsed, Vop *vop)
{
  vop->bits_used = BitsUsed;
}
/* >>> added for DRC by Fujitsu (bottom) <<< */

/***********************************************************CommentBegin******
 *
 * -- GetMotion{xxx} -- Access components of a "Motion" structure
 *
 *	Int GetMotionId(Motion *motion)
 *      Float *GetMotionAffine(Motion *motion)
 *      Image *GetMotionVectorFieldX(Motion *motion, Int num)
 *      Image *GetMotionVectorFieldY(Motion *motion, Int num)
 *      Int GetMotionUnderX(Motion *motion, Int num)
 *      Int GetMotionUnderY(Motion *motion, Int num)
 *      Int GetMotionResX(Motion *motion, Int num)
 *      Int GetMotionResY(Motion *motion, Int num)
 *
 * Author :		
 *	Michael Wollborn
 *
 * Created :		
 *	19-Feb-96
 *
 * Purpose :		
 *	These are common functions to access specific components
 *      of the Motion structure.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Access components of a "Motion" structure.
 *
 * See also :
 *	
 *
 * Modified :		
 *	
 *
 ***********************************************************CommentEnd********/

Int
GetMotionId(Motion *motion)
{
  return(motion->ident);
}

Float *
GetMotionAffine(Motion *motion)
{
  return(motion->affine_pars);
}

Image *
GetMotionVectorFieldX(Motion *motion, Int num)
{
  return(motion->dvf_x[num]);
}

Image *
GetMotionVectorFieldY(Motion *motion, Int num)
{
  return(motion->dvf_y[num]);
}

Int
GetMotionUnderX(Motion *motion, Int num)
{
  return(motion->under_x[num]);
}

Int
GetMotionUnderY(Motion *motion, Int num)
{
  return(motion->under_y[num]);
}

Int
GetMotionResX(Motion *motion, Int num)
{
  return(motion->resolution_x[num]);
}

Int
GetMotionResY(Motion *motion, Int num)
{
  return(motion->resolution_y[num]);
}


/***********************************************************CommentBegin******
 *
 * -- GetVol{xxx} -- Functions to access components of the Vol structure
 *
 *	Int GetVolId(Vol *vol)
 *	Int GetVolVOId(Vol *vol)
 *      Int GetVolVisualObjectTypeIndication(Vol *vol)
 *      Int GetVolShape(Vol *vol)
 *      Int GetVolWidth(Vol *vol)
 *      Int GetVolHeight(Vol *vol)
 *      Int GetVolQuantType(Vol *vol)
 *	Int GetVolLoadIntraQuantMat(Vol *vol)
 *	Int *GetVolIntraQuantMat(Vol *vol)
 *	Int GetVolLoadNonintraQuantMat(Vol *vol)
 *	Int *GetVolNonintraQuantMat(Vol *vol)
 *	Int GetVolLoadGrayIntraQuantMat(Vol *vol)
 *	Int *GetVolGrayIntraQuantMat(Vol *vol)
 *	Int GetVolLoadGrayNonintraQuantMat(Vol *vol)
 *	Int *GetVolGrayNonintraQuantMat(Vol *vol)
 *	Int GetVolErrorResDisable(vol *vol)
 *	Int GetVolBlockFilterDisable(vol *vol)
 *      Int GetVolACDCPredDisable(Vol *vol)
 *      Int GetVolQuarterPel(Vol *vol);		*//* MW QPEL 06-JUL-1998 *//*
 *	Int GetVolFCodeFor(Vol *vol);
 *      Int GetVolFCodeBack(Vol *vol);
 *      Int GetVolSepMotShapeText(Vol *vol)
 *	Int GetVolScalability(Vol *vol)
 *	Int GetVolScalType(Vol *vol)
 *	Int GetVolRefId(Vol *vol)
 *	Int GetVolHierarchyType(Vol *vol) 
 *	Int GetVolSampDir(Vol *vol)
 *	Int GetVolHorSampN(Vol *vol)
 *	Int GetVolHorSampM(Vol *vol)
 *	Int GetVolVerSampN(Vol *vol)
 *	Int GetVolVerSampM(Vol *vol)
 *	Int GetVolEnhanceType(Vol *vol)
 *	Int GetVolSpriteHdim(Vol *vol)
 *	Int GetVolSpriteVdim(Vol *vol)
 *	Int GetVolSpriteInitPieceWidth(Vol *vol)
 *	Int GetVolSpriteInitPieceHeight(Vol *vol)
 *	Int GetVolSpriteInitPieceHorRef(Vol *vol)
 *	Int GetVolSpriteInitPieceVerRef(Vol *vol)
 *      Int GetVolSpriteLeftEdge(Vol *vol)
 *	Int GetVolSpriteTopEdge(Vol *vol)
 *	Int GetVolWarpingAccuracy(Vol *vol)
 *	Int GetVolBlendFact(Vol *vol)
 *	Int GetVolSpriteUsage( Vol *vol)
 *	Int GetVolBrightnessChangeInSprite( Vol *vol )
 *	Int GetVolLowLatencySpriteEnable( Vol *vol )
 *	Int GetVolNoOfSpritePoints( Vol *vol )
 *	TrajPoint * GetVolRefPointCoord( Vol *vol )
 *	TrajPoint * GetVolTrajPointCoord( Vol *vol )
 *	Sprite_motion * GetVolPrevWarpParam( Vol *vol)
 *	Vop * GetVolSprite(Vol *vol)
 *	Int GetVolSpriteTransmitMode(Vol *vol)
 *	Int * GetVolSpriteTabTransmit(Vol *vol)
 *	Int * GetVolSpriteTabAmbType(Vol *vol)
 *	Int * GetVolSpriteTabMvda(Vol *vol)
 *	SInt * GetVolSpriteTabQPStore(Vol *vol)
 *	Int * GetVolSpriteTabDQUANTStore(Vol *vol)
 *	Int *** GetVolSpriteTabDCStore(Vol *vol)
 *      Vol *GetVolNext(Vol *vol)
 *      Vol *GetVolById(Vol *vol, Int vol_id)
 *      Int GetVolReverseVlc(Vol *vol)
 *      Int GetVolDataPartEnable(Vol *vol)
 *      Int GetVolAspectRatioInfo(Vol *vol)
 * 	Int GetVolAspectRatioInfoParWidth(Vol *vol)
 *      Int GetVolAspectRatioInfoParHeight(Vol *vol)
 *	Int GetVolNewpredEnable(Vol *vol)	for NEWPRED (Oki)
 *	Int GetVolNewpredModeFlag(Vol *vol)	for NEWPRED (Oki)
 *	Int GetVolReducedResolutionVopEnable( Vol *vol )	for DRC
 *
 *
 * Author :		
 *	Noel O'Connor 
 *
 * Created :		
 *	31-Aug-96
 *
 * Purpose :		
 *	These are common functions to access specific components
 *      of the Vol data structure.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Access components of a "Vol"
 *
 * See also :
 *	
 *
 * Modified :		
 *	22.04.97 Michael Wollborn: Added new access functions for 
 *					   MPEG quantizer matrices
 *      26.04.97 Luis Ducla-Soares: Added GetVolDataPartEnable().
 *      09.07.97 Aasmund Sandvand: added GetVolVOId()
 *	04.06.98 Marc Mongenet (EPFL): added Complexity Estimation syntax support
 *      12.08.98 Sven Brandau: added support for "pixel_aspect_ratio"
 *      18.01.98 Takefumi Nagumo: added GetVolHierarchyType()
 *      06.07.98 U. Benzler (TUH) : added quarter pel support
 *	04.06.99 Karsten Suehring (HHI): added VOL Control Parameters
 *	16.08.99 Shigeru Fukunaga (Oki): added GetVolNewpred{xxx}()
 *	06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 *  26.10.99 Massimo Ravasi (EPFL): added Complexity Estimation syntax support
 *                                  Update version 2
 *      11.11.99 U. Benzler (UoH) - added visual_object_type_indication to be able to create conformance bitstreams
 *
 ***********************************************************CommentEnd********/
Int GetVolIsObjectLayerIdentifier(Vol *vol) {
  return (vol->is_object_layer_identifier);
}



Int GetVolVisualObjectLayerVerid(Vol *vol) {
  return (vol->visual_object_layer_verid);
}


Int GetVolVisualObjectTypeIndication(Vol *vol) {
  return (vol->visual_object_type_indication);
}


Int GetVolVisualObjectLayerPriority(Vol *vol) {
  return (vol->visual_object_layer_priority);
}


Int GetVolVolControlParameters(Vol *vol) {
  return (vol->vol_control_parameters);
}


Int GetVolChromaFormat(Vol *vol) {
  return (vol->chroma_format);
}


Int GetVolLowDelay(Vol *vol) {
  return (vol->low_delay);
}


Int GetVolVbvParameters(Vol *vol) {
  return (vol->vbv_parameters);
}


Int GetVolFirstHalfBitRate(Vol *vol) {
  return (vol->first_half_bit_rate);
}


Int GetVolLatterHalfBitRate(Vol *vol) {
  return (vol->latter_half_bit_rate);
}


Int GetVolFirstHalfVbvBufferSize(Vol *vol) {
  return (vol->first_half_vbv_buffer_size);
}


Int GetVolLatterHalfVbvBufferSize(Vol *vol) {
  return (vol->latter_half_vbv_buffer_size);
}


Int GetVolFirstHalfVbvOccupancy(Vol *vol) {
  return (vol->first_half_vbv_occupancy);
}


Int GetVolLatterHalfVbvOccupancy(Vol *vol) {
  return (vol->latter_half_vbv_occupancy);
}



Int GetVolFixedVopRate(Vol *vol) {
  return (vol->fixed_vop_rate);
}


Int GetVolNot8Bit(Vol *vol) {
  return (vol->bits_per_pixel != 8);
}

Int GetVolQuantPrecision(Vol *vol) {
  return (vol->quant_precision);
}

Int GetVolBitsPerPixel(Vol *vol) {
  return (vol->bits_per_pixel);
}

 

/* START: Complexity Estimation syntax support - Marc Mongenet (EPFL) - 4 Jun 1998 */

Int GetVolComplexityEstimationDisable (const Vol * vol) {
  return vol->complexity_estimation_disable;
}

Int GetVolEstimationMethod (const Vol * vol) {
  return vol->estimation_method;
}

Int GetVolShapeComplexityEstimationDisable (const Vol * vol) {
  return vol->shape_complexity_estimation_disable;
}

Int GetVolOpaque (const Vol * vol) {
  return vol->opaque;
}

Int GetVolTransparent (const Vol * vol) {
  return vol->transparent;
}

Int GetVolIntraCAE (const Vol * vol) {
  return vol->intra_cae;
}

Int GetVolInterCAE (const Vol * vol) {
  return vol->inter_cae;
}

Int GetVolNoUpdate (const Vol * vol) {
  return vol->no_update;
}

Int GetVolUpsampling (const Vol * vol) {
  return vol->upsampling;
}

Int GetVolTextureComplexityEstimationSet1Disable (const Vol * vol) {
  return vol->texture_complexity_estimation_set_1_disable;
}

Int GetVolIntraBlocks (const Vol * vol) {
  return vol->intra_blocks;
}

Int GetVolInterBlocks (const Vol * vol) {
  return vol->inter_blocks;
}

Int GetVolInter4vBlocks (const Vol * vol) {
  return vol->inter4v_blocks;
}

Int GetVolNotCodedBlocks (const Vol * vol) {
  return vol->not_coded_blocks;
}

Int GetVolTextureComplexityEstimationSet2Disable (const Vol * vol) {
  return vol->texture_complexity_estimation_set_2_disable;
}

Int GetVolDCTCoefs (const Vol * vol) {
  return vol->dct_coefs;
}

Int GetVolDCTLines (const Vol * vol) {
  return vol->dct_lines;
}

Int GetVolVLCSymbols (const Vol * vol) {
  return vol->vlc_symbols;
}

Int GetVolVLCBits (const Vol * vol) {
  return vol->vlc_bits;
}

Int GetVolMotionCompensationComplexityDisable (const Vol * vol) {
  return vol->motion_compensation_complexity_disable;
}

Int GetVolAPM (const Vol * vol) {
  return vol->apm;
}

Int GetVolNPM (const Vol * vol) {
  return vol->npm;
}

Int GetVolInterpolateMCQ (const Vol * vol) {
  return vol->interpolate_mc_q;
}

Int GetVolForwBackMCQ (const Vol * vol) {
  return vol->forw_back_mc_q;
}

Int GetVolHalfpel2 (const Vol * vol) {
  return vol->halfpel2;
}

Int GetVolHalfpel4 (const Vol * vol) {
  return vol->halfpel4;
}

/* START: Complexity Estimation syntax support - Update version 2 - Massimo Ravasi (EPFL) - 26 Oct 1999 */

Int GetVolVersion2ComplexityEstimationDisable (const Vol * vol) {
  return vol->version_2_complexity_estimation_disable;
}

Int GetVolSadct(const Vol * vol) {
  return vol->sadct;
}

Int GetVolQuarterpel(const Vol * vol) {
  return vol->quarterpel;
}

/* END: Complexity Estimation syntax support - Update Version 2 */
/* END: Complexity Estimation syntax support */



Int GetVolRandomAccessibleVol(Vol *vol) {
  return (vol->random_accessible_vol);
}





Int GetVolTimeIncrementResolution(Vol *vol) {
  return vol->time_increment_resolution;
 }

Int
GetVolId(Vol *vol)
{
	return(vol->ident);
}

Int
GetVolVOId(Vol *vol)
{
	return(vol->vo_id);
}

Int
GetVolShape(Vol *vol)
{
	return(vol->shape);
}

Int
GetVolShapeEffects(Vol *vol)
{
	return(vol->shape_effects);
}

Int
GetVolOBMCDisable(Vol *vol)
{
	return(vol->obmc_disable);
}


Int
GetVolWidth(Vol *vol)
{
	return(vol->width);
}

Int
GetVolHeight(Vol *vol)
{
	return(vol->height);
}

Int
GetVolQuantType(Vol *vol)
{
	return(vol->quant_type);
}

Int
GetVolLoadIntraQuantMat(Vol *vol)
{
  return(vol->load_intra_quant_mat);
}

Int *
GetVolIntraQuantMat(Vol *vol)
{
  return(vol->intra_quant_mat);
}

Int
GetVolLoadNonintraQuantMat(Vol *vol)
{
  return(vol->load_nonintra_quant_mat);
}

Int *
GetVolNonintraQuantMat(Vol *vol)
{
  return(vol->nonintra_quant_mat);
}

Int
GetVolDisableGrayQuantUpdate(Vol *vol)
{
  return(vol->disable_gray_quant_update);
}

Int
GetVolLoadGrayIntraQuantMat(Int aux, Vol *vol)
{
  return(vol->load_gray_intra_quant_mat[aux]);
}

Int *
GetVolGrayIntraQuantMat(Int aux, Vol *vol)
{
  return(vol->gray_intra_quant_mat[aux]);
}

Int
GetVolLoadGrayNonintraQuantMat(Int aux, Vol *vol)
{
  return(vol->load_gray_nonintra_quant_mat[aux]);
}

Int *
GetVolGrayNonintraQuantMat(Int aux, Vol *vol)
{
  return(vol->gray_nonintra_quant_mat[aux]);
}

Int
GetVolErrorResDisable(Vol *vol)
{
	return(vol->error_res_disable);
}

Int
GetVolDataPartEnable(Vol *vol)
{
        return(vol->data_partitioning);
}

Int
GetVolReverseVlc(Vol *vol)
{
	return(vol->reverse_vlc);
}

/** added for NEWPRED (Oki) 16-AUG-1999 **/
Int
GetVolNewpredEnable(Vol *vol)
{
  return(vol->newpred_enable);
}

Int
GetVolNewpredBackwardMessageType(Vol *vol)
{
  return(vol->newpred_backward_message_type);
}

Int
GetVolNewpredSegmentType(Vol *vol)
{
  return(vol->newpred_segment_type);
}
/** end of NEWPRED (Oki) 16-AUG-1999 **/

Int
GetVolACDCPredDisable(Vol *vol)
{
	return(vol->intra_acdc_pred_disable);
}


/* 29.01.99 HHI Schueuer */
Int 
GetVolSADCTDisable(Vol *vol)
{
	return(vol->sadct_disable);
}
/* end HHI */

/* MW QPEL 06-JUL-1998 >> */
Int
GetVolQuarterPel(Vol *vol)
{
        return(vol->quarter_pel);
}
/* << MW QPEL 06-JUL-1998 */

Int
GetVolScalability(Vol *vol)
{
	return(vol->scalability);
}

Int
GetVolScalType(Vol *vol)
{
	return(vol->scal_type);
}

Int
GetVolHierarchyType(Vol *vol)
{
	return(vol->hierarchy_type);
}

Int
GetVolRefId(Vol *vol)
{
	return(vol->ref_ident);
}

Int
GetVolRefSampDir(Vol *vol)
{
	return(vol->ref_samp_dir);
}

Int
GetVolHorSampN(Vol *vol)
{
	return(vol->hor_samp_n);
}

Int
GetVolHorSampM(Vol *vol)
{
	return(vol->hor_samp_m);
}

Int
GetVolVerSampN(Vol *vol)
{
	return(vol->ver_samp_n);
}

Int
GetVolVerSampM(Vol *vol)
{
	return(vol->ver_samp_m);
}

Int
GetVolEnhanceType(Vol *vol)
{
	return(vol->enhancement_type);
}

/* begin : added for OBSS by Samsung AIT (1999-09-29) */
Int
GetVolUseRefShape(Vol *vol)
{
        return(vol->use_ref_shape);
}
 
Int
GetVolUseRefTexture(Vol *vol)
{
        return(vol->use_ref_texture);
}
 
Int
GetVolShapeHorSampN(Vol *vol)
{
        return(vol->shape_hor_samp_n);
}
 
Int
GetVolShapeHorSampM(Vol *vol)
{
        return(vol->shape_hor_samp_m);
}
 
Int
GetVolShapeVerSampN(Vol *vol)
{
        return(vol->shape_ver_samp_n);
}
 
Int
GetVolShapeVerSampM(Vol *vol)
{
        return(vol->shape_ver_samp_m);
}
/* end : added for OBSS by Samsung AIT (1999-09-29) */

Int 
GetVolSpriteHdim(Vol *vol)
{
	return(vol->sprite_hdim);
}

Int
GetVolSpriteVdim(Vol *vol)
{
	return(vol->sprite_vdim);
}

Int
GetVolSpriteLeftEdge(Vol *vol)
{
	return(vol->sprite_left_edge);
}

Int
GetVolSpriteTopEdge(Vol *vol)
{
	return(vol->sprite_top_edge);
}

Int
GetVolSpriteInitPieceWidth(Vol *vol)
{
	return(vol->init_piece_width);
}

Int
GetVolSpriteInitPieceHeight(Vol *vol)
{
	return(vol->init_piece_height);
}

Int
GetVolSpriteInitPieceHorRef(Vol *vol)
{
	return(vol->init_piece_hor_ref);
}

Int
GetVolSpriteInitPieceVerRef(Vol *vol)
{
	return(vol->init_piece_ver_ref);
}


Int 
GetVolSpriteUsage(Vol *vol)
{
	return(vol->sprite_usage);
}

Int 
GetVolWarpingAccuracy(Vol *vol)
{
	return(vol->warping_accuracy);
}

Int 
GetVolBrightnessChangeInSprite(Vol *vol)
{
	return(vol->brightness_change_in_sprite);
}

Int 
GetVolLowLatencySpriteEnable(Vol *vol)
{
	return(vol->low_latency_sprite_enable);
}

Int 
GetVolNoOfSpritePoints(Vol *vol)
{
	return(vol->no_of_sprite_points );
}

TrajPoint *
GetVolRefPointCoord(Vol *vol)
{
	return(vol->ref_point_coord );
}

TrajPoint *
GetVolTrajPointCoord(Vol *vol)
{
	return(vol->traj_point_coord );
}

Sprite_motion *
GetVolPrevWarpParam(Vol *vol)
{
	return(vol->prev_warp_param);
}

Vop *
GetVolSprite(Vol *vol)
{
	return(vol->psprite);
}

Int
GetVolSpriteTransmitMode(Vol *vol)
{
	return(vol->sprite_transmit_mode);
}

Int *
GetVolSpriteTabTransmit(Vol *vol)
{
	return(vol->tab_transmit);
}

Int *
GetVolSpriteTabAmbType(Vol *vol)
{
	return(vol->tab_amb_type);
}

Int *
GetVolSpriteTabMvda(Vol *vol)
{
	return(vol->tab_mvda);
}

SInt *
GetVolSpriteTabQPStore(Vol *vol)
{
	return(vol->tab_QP_store);
}

Int *
GetVolSpriteTabDQUANTStore(Vol *vol)
{
	return(vol->tab_DQUANT_store);
}

Int ***
GetVolSpriteTabDCStore(Vol *vol)
{
	return(vol->tab_DC_store);
}

Vop *
GetVolVop(Vol *vol)
{
	return(vol->pvop);
}

Vol *
GetVolNext(Vol *vol)
{
	return(vol->pnext);
}

/* 12.08.98 Sven Brandau: added support for "pixel_aspect_ratio" */
Int GetVolAspectRatioInfo( Vol *vol )
{
  	return (vol->aspect_ratio_info);
}

Int GetVolAspectRatioInfoParWidth( Vol *vol )
{
  	return (vol->par_width);
}

Int GetVolAspectRatioInfoParHeight( Vol *vol )
{
  	return (vol->par_heigth);
}

/* 19.08.98 Sven Brandau: "move interlaced bit from VOP to VOP" */
Int GetVolInterlaced( Vol *vol )
{
	return (vol->interlaced);
}

/* >>> added for DRC by Fujitsu (top)    <<< */
Int GetVolReducedResolutionVopEnable( Vol *vol )
{
	return (vol->reduced_resolution_vop_enable);
}
/* >>> added for DRC by Fujitsu (bottom)    <<< */

/***********************************************************CommentBegin******
 *
 * -- PutVol{xxx} -- Functions to write to components of the Vol structure
 *	
 *	Void PutVolId(Int ident, Vol *vol)
 *	Void PutVolVOId(Int vo_id, Vol *vol)
 *      Void PutVolVisualObjectTypeIndication(Int vo_type_indication, Vol *vol)
 *	Void PutVolShape(Int shape, Vol *vol)
 * 	Void PutVolShapeEffects(Int shape_effects,Vol *vol)
 *      Void PutVolWidth(Int width, Vol *vol)
 *      Void PutVolHeight(Int height, Vol *vol)
 *      Void PutVolQuantType(Int quant_type, Vol *vol)
 *      Void PutVolLoadIntraQuantMat(Int load_intra_quant_mat, Vol *vol)
 *      Void PutVolIntraQuantMat(Int *intra_quant_mat, Vol *vol)
 *      Void PutVolLoadNonintraQuantMat(Int load_nonintra_quant_mat, Vol *vol)
 *      Void PutVolNonintraQuantMat(Int *nonintra_quant_mat, Vol *vol)
 *      Void PutVolLoadGrayIntraQuantMat(Int load_gray_intra_quant_mat, Vol *vol)
 *      Void PutVolGrayIntraQuantMat(Int *gray_intra_quant_mat, Vol *vol)
 *      Void PutVolLoadGrayNonintraQuantMat(Int load_gray_nonintra_quant_mat, Vol *vol)
 *      Void PutVolGrayNonintraQuantMat(Int *gray_nonintra_quant_mat, Vol *vol)
 *	Void PutVolErrorResDisable(Int disable,Vol *vol)
 *      Void PutVolDataPartEnable(Int data_partitioning, Vol *vol)
 * 	Void PutVolReverseVLC(Int reverse_vlc,Vol *vol)
 *	Void PutVolBlockFilterDisable(Int disable,Vol *vol)
 *      Void PutVolNonintraQmatEl(Int nonintra_qmat_el, Int num, Vol *vol)
 *	Void PutVolACDCPredDisable(Int intra_dcpred_disable, Vol *vol)
 *      Void PutVolQuarterPel(Int quarter_pel, Vol *vol)		*//* MW QPEL 06-JUL-1998 *//*
 *      Void PutVolSepMotShapeText(Int sep_mot_shape_text, Vol *vol)
 *	Void PutVolScalability(Int scalability, Vol *vol)
 *	Void PutVolScal(Int scal_type, Vol *vol)
 *	Void PutVolHierarchyType(Int hierarchy_type, Vol *vol)
 *	Void PutVolRefId(Int ref_ident, Vol *vol)
 *	Void PutVolRefSampDir(Int ref_samp_dir, Vol *vol)
 *	Void PutVolHorSampN(Int hor_samp_n, Vol *vol)
 *	Void PutVolHorSampM(Int hor_samp_m, Vol *vol)
 *	Void PutVolVerSampN(Int ver_samp_n, Vol *vol)
 *	Void PutVolVerSampM(Int ver_samp_m, Vol *vol)
 *	Void PutVolEnhanceType(Int enhancement_type, Vol *vol)
 *	Void PutVolSpriteHdim(Int sprite_hdim,Vol *vol)
 *	Void PutVolSpriteVdim(Int sprite_vdim,Vol *vol)
 *      Void PutVolSpriteLeftEdge(Int sprite_left_edge,Vol *vol)
 *	Void PutVolSpriteTopEdge(Int sprite_top_edge,Vol *vol)
 *	Void PutVolSpriteInitPieceWidth(Int init_piece_width, Vol *vol)
 *	Void PutVolSpriteInitPieceHeight(Int init_piece_height, Vol *vol)
 *	Void PutVolSpriteInitPieceHorRef(Int init_piece_ver_ref, Vol *vol)
 *	Void PutVolSpriteInitPieceVerRef(Int init_piece_ver_ref, Vol *vol)
 *	Void PutVolBlendFact(Int blend_fact,Vol *vol)
 *	Void PutVolSpriteUsage(Int sprite_usage, Vol *vol )
 *	Void PutVolWarpingAccuracy(Int warping_accuracy, Vol *vol )
 *	Void PutVolNoOfSpritePoints(Int no_of_sprite_points, Vol *vol )
 *	Void PutVolRefPointCoord(TrajPoint *ref_point_coord, Vol *vol )
 *	Void PutVolTrajPointCoord(TrajPoint *traj_point_coord, Vol *vol )
 *	Void PutVolPrevWarpParam(Sprite_motion *prev_warp_param, Vol *vol)
 *	Void PutVolBrightnessChangeInSprite( Int brightness_change_in_sprite, Vol *vol )
 *	Void PutVolLowLatencySpriteEnable( Int low_latency_sprite_enable, Vol *vol )
 *	Void PutVolSprite(Vop *sprite,Vol *vol)
 *	Void PutVolSpriteTransmitMode(Int sprite_transmit_mode, Vol *vol)
 *	Void PutVolSpriteTabTransmit(Int *tab_transmit, Vol *vol)
 *	Void PutVolSpriteTabAmbType(Int *tab_amb_type, Vol *vol)
 *	Void PutVolSpriteTabMvda(Int *tab_mvda, Vol *vol)
 *	Void PutVolSpriteTabQPStore(SInt *tab_QP_store, Vol *vol)
 *	Void PutVolSpriteTabDQUANTStore(Int *tab_DQUANT_store, Vol *vol)
 *	Void PutVolSpriteTabDCStore(Int ***tab_DC_store, Vol *vol)
 *      Void PutVolVop(Vop *vop, Vol *vol)
 *      Void PutVolNext(Vol *pnext, Vol *vol)
 *	Void PutVolNewpredEnable(Int flag,Vol *vol)	for NEWPRED (Oki)
 *	Void PutVolNewpredModeFlag(Int flag,Vol *vol)	for NEWPRED (Oki)
 *	Void PutVolReducedResolutionVopEnable( Int reduced_resolution_vop_enable, Vol *vol ) for DRC
 *
 * Author :		
 *	Noel O'Connor
 *
 * Created :		
 *	31-Aug-96
 *
 * Purpose :		
 *	These are common functions to write to specific components
 *      of the Vol structure.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Write access to the components of a "Vol" 
 *
 * See also :
 *	
 *
 * Modified :		
 *	22.04.97 Michael Wollborn: Added new access functions for 
 *					   MPEG quantizer matrices
 *      26.04.97 Luis Ducla-Soares: added PutVolDataPartEnable()
 *      09.07.97 Aasmund Sandvand: added PutVolVOId()
 *      04.08.97 Minhua Zhou: added  PutVolOBMCDisable()
 *      09.06.98 Marc Mongenet (EPFL): added Complexity Estimation syntax support
 *      06.07.98 U. Benzler (TUH) : added quarter pel support
 *	04.06.99 Karsten Suehring (HHI): added VOL Control Parameters
 *	16.08.99 Shigeru Fukunaga (Oki): added PutVolNewpred{xxx}()
 *	06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC support
 *  26.10.99 Massimo Ravasi (EPFL): added Complexity Estimation syntax support
 *                                  Update version 2
 *      11.11.99 U. Benzler (UoH) - added visual_object_type_indication to be able to create conformance bitstreams
 *
 ***********************************************************CommentEnd********/

Void PutVolIsObjectLayerIdentifier(Int is_object_layer_identifier,Vol *vol) {
   vol->is_object_layer_identifier = is_object_layer_identifier;
} 

Void PutVolVisualObjectLayerVerid(Int visual_object_layer_verid,Vol *vol) {
   vol->visual_object_layer_verid = visual_object_layer_verid;
} 

Void PutVolVisualObjectLayerPriority(Int visual_object_layer_priority,Vol *vol) {
   vol->visual_object_layer_priority = visual_object_layer_priority;
} 

Void PutVolVisualObjectTypeIndication(Int visual_object_type_indication,Vol *vol
) {
   vol->visual_object_type_indication = visual_object_type_indication;
}

Void PutVolVolControlParameters(Int vol_control_parameters,Vol *vol) {
   vol->vol_control_parameters = vol_control_parameters;
} 

Void PutVolChromaFormat(Int chroma_format,Vol *vol) {
   vol->chroma_format = chroma_format;
} 

Void PutVolLowDelay(Int low_delay,Vol *vol) {
   vol->low_delay = low_delay;
} 

Void PutVolVbvParameters(Int vbv_parameters,Vol *vol) {
   vol->vbv_parameters = vbv_parameters;
} 

Void PutVolFirstHalfBitRate(Int first_half_bit_rate,Vol *vol) {
   vol->first_half_bit_rate = first_half_bit_rate;
} 

Void PutVolLatterHalfBitRate(Int latter_half_bit_rate,Vol *vol) {
   vol->latter_half_bit_rate = latter_half_bit_rate;
} 

Void PutVolFirstHalfVbvBufferSize(Int first_half_vbv_buffer_size,Vol *vol) {
   vol->first_half_vbv_buffer_size = first_half_vbv_buffer_size;
} 

Void PutVolLatterHalfVbvBufferSize(Int latter_half_vbv_buffer_size,Vol *vol) {
   vol->latter_half_vbv_buffer_size = latter_half_vbv_buffer_size;
} 

Void PutVolFirstHalfVbvOccupancy(Int first_half_vbv_occupancy,Vol *vol) {
   vol->first_half_vbv_occupancy = first_half_vbv_occupancy;
} 

Void PutVolLatterHalfVbvOccupancy(Int latter_half_vbv_occupancy,Vol *vol) {
   vol->latter_half_vbv_occupancy = latter_half_vbv_occupancy;
} 

Void PutVolFixedVopRate(Int fixed_vop_rate,Vol *vol) {
   vol->fixed_vop_rate = fixed_vop_rate;
} 

Void PutVolQuantPrecision(Int quant_precision,Vol *vol) {
   vol->quant_precision = quant_precision;
} 

Void PutVolBitsPerPixel(Int bits_per_pixel,Vol *vol) {
   vol->bits_per_pixel = bits_per_pixel;
}


/* START: Complexity Estimation syntax support - Marc Mongenet (EPFL) - 4 Jun 1998 */

Void PutVolComplexityEstimationDisable (Int v, Vol * vol) {
  vol->complexity_estimation_disable = v;
}

Void PutVolEstimationMethod (Int v, Vol * vol) {
  vol->estimation_method = v;
}

Void PutVolShapeComplexityEstimationDisable (Int v, Vol * vol) {
  vol->shape_complexity_estimation_disable = v;
}

Void PutVolOpaque (Int v, Vol * vol) {
  vol->opaque = v;
}

Void PutVolTransparent (Int v, Vol * vol) {
  vol->transparent = v;
}

Void PutVolIntraCAE (Int v, Vol * vol) {
  vol->intra_cae = v;
}

Void PutVolInterCAE (Int v, Vol * vol) {
  vol->inter_cae = v;
}

Void PutVolNoUpdate (Int v, Vol * vol) {
  vol->no_update = v;
}

Void PutVolUpsampling (Int v, Vol * vol) {
  vol->upsampling = v;
}

Void PutVolTextureComplexityEstimationSet1Disable (Int v, Vol * vol) {
  vol->texture_complexity_estimation_set_1_disable = v;
}

Void PutVolIntraBlocks (Int v, Vol * vol) {
  vol->intra_blocks = v;
}

Void PutVolInterBlocks (Int v, Vol * vol) {
  vol->inter_blocks = v;
}

Void PutVolInter4vBlocks (Int v, Vol * vol) {
  vol->inter4v_blocks = v;
}

Void PutVolNotCodedBlocks (Int v, Vol * vol) {
  vol->not_coded_blocks = v;
}

Void PutVolTextureComplexityEstimationSet2Disable (Int v, Vol * vol) {
  vol->texture_complexity_estimation_set_2_disable = v;
}

Void PutVolDCTCoefs (Int v, Vol * vol) {
  vol->dct_coefs = v;
}

Void PutVolDCTLines (Int v, Vol * vol) {
  vol->dct_lines = v;
}

Void PutVolVLCSymbols (Int v, Vol * vol) {
  vol->vlc_symbols = v;
}

Void PutVolVLCBits (Int v, Vol * vol) {
  vol->vlc_bits = v;
}

Void PutVolMotionCompensationComplexityDisable (Int v, Vol * vol) {
  vol->motion_compensation_complexity_disable = v;
}

Void PutVolAPM (Int v, Vol * vol) {
  vol->apm = v;
}

Void PutVolNPM (Int v, Vol * vol) {
  vol->npm = v;
}

Void PutVolInterpolateMCQ (Int v, Vol * vol) {
  vol->interpolate_mc_q = v;
}

Void PutVolForwBackMCQ (Int v, Vol * vol) {
  vol->forw_back_mc_q = v;
}

Void PutVolHalfpel2 (Int v, Vol * vol) {
  vol->halfpel2 = v;
}

Void PutVolHalfpel4 (Int v, Vol * vol) {
  vol->halfpel4 = v;
}

/* START: Complexity Estimation syntax support - Update version 2 - Massimo Ravasi (EPFL) - 26 Oct 1999 */

Void PutVolVersion2ComplexityEstimationDisable (Int v, Vol * vol) {
  vol->version_2_complexity_estimation_disable = v;
}

Void PutVolSadct(Int v, Vol * vol) {
  vol->sadct = v;
}

Void PutVolQuarterpel(Int v, Vol * vol) {
  vol->quarterpel = v;
}

/* END: Complexity Estimation syntax support - Update Version 2 */
/* END: Complexity Estimation syntax support */


Void PutVolRandomAccessibleVol(Int random_accessible_vol,Vol *vol) {
   vol->random_accessible_vol = random_accessible_vol;
}


Void PutVolTimeIncrementResolution(Int time_incre_res, Vol *vol) {
  vol->time_increment_resolution=time_incre_res;
 }

Void
PutVolId(Int id,Vol *vol)
{
	vol->ident = id;
}

Void
PutVolVOId(Int vo_id,Vol *vol)
{
	vol->vo_id = vo_id;
}

Void
PutVolShape(Int shape,Vol *vol)
{
	vol->shape = shape;
}

Void
PutVolShapeEffects(Int shape_effects,Vol *vol)
{
	vol->shape_effects = shape_effects;
}

Void
PutVolOBMCDisable(Int OBMCDisable,Vol *vol)
{
	vol->obmc_disable = OBMCDisable;
}


Void
PutVolWidth(Int width,Vol *vol)
{
	vol->width = width;
}

Void
PutVolHeight(Int height, Vol *vol)
{
	vol->height = height;
}

Void
PutVolQuantType(Int quant_type, Vol *vol)
{
  vol->quant_type = quant_type;
}

Void
PutVolLoadIntraQuantMat(Int load_intra_quant_mat, Vol *vol)
{
  vol->load_intra_quant_mat = load_intra_quant_mat;
}

Void
PutVolLoadNonintraQuantMat(Int load_nonintra_quant_mat, Vol *vol)
{
  vol->load_nonintra_quant_mat = load_nonintra_quant_mat;
}

Void
PutVolDisableGrayQuantUpdate(Int disable_gray_quant_update, Vol *vol)
{
  vol->disable_gray_quant_update = disable_gray_quant_update;
}

Void
PutVolLoadGrayIntraQuantMat(Int load_gray_intra_quant_mat, Int aux, Vol *vol)
{
  vol->load_gray_intra_quant_mat[aux] = load_gray_intra_quant_mat;
}

Void
PutVolLoadGrayNonintraQuantMat(Int load_gray_nonintra_quant_mat, Int aux, Vol *vol)
{
  vol->load_gray_nonintra_quant_mat[aux] = load_gray_nonintra_quant_mat;
}

Void
PutVolErrorResDisable(Int flag,Vol *vol)
{
	vol->error_res_disable = flag;
}

Void
PutVolDataPartEnable(Int flag,Vol *vol)
{
        vol->data_partitioning = flag;
}

Void
PutVolReverseVlc(Int reverse_vlc,Vol *vol)
{
	vol->reverse_vlc = reverse_vlc;
}

/** added for NEWPRED (Oki) 16-AUG-1999 **/
Void
PutVolNewpredEnable(Int flag,Vol *vol)
{
  vol->newpred_enable = flag;
}

Void
PutVolNewpredBackwardMessageType(Int flag,Vol *vol)
{
  vol->newpred_backward_message_type = flag;
}

Void
PutVolNewpredSegmentType(Int flag,Vol *vol)
{
  vol->newpred_segment_type = flag;
}
/** end of NEWPRED (Oki) 16-AUG-1999 **/

Void
PutVolACDCPredDisable(Int flag,Vol *vol)
{
	vol->intra_acdc_pred_disable = flag;
}

/* 29.01.99 HHI Schueuer */
Void
PutVolSADCTDisable(Int flag,Vol *vol)
{
	vol->sadct_disable = flag;
}
/* end HHI */

/* MW QPEL 06-JUL-1998 >> */
Void
PutVolQuarterPel(Int flag,Vol *vol)
{
        vol->quarter_pel = flag;
}
/* << MW QPEL 06-JUL-1998 */

Void
PutVolScalability(Int scale,Vol *vol)
{
	vol->scalability = scale;
}
Void
PutVolScalType(Int scale,Vol *vol)
{
	vol->scal_type = scale;
}

Void
PutVolHierarchyType(Int hierarchy_type, Vol *vol)
{
	vol->hierarchy_type = hierarchy_type;
}

Void
PutVolRefId(Int id,Vol *vol)
{
	vol->ref_ident = id;
}

Void
PutVolRefSampDir(Int dir,Vol *vol)
{
	vol->ref_samp_dir = dir;
}

Void
PutVolHorSampN(Int n,Vol *vol)
{
	vol->hor_samp_n = n;
}

Void
PutVolHorSampM(Int m,Vol *vol)
{
	vol->hor_samp_m = m;
}

Void
PutVolVerSampN(Int n,Vol *vol)
{
	vol->ver_samp_n = n;
}

Void
PutVolVerSampM(Int m,Vol *vol)
{
	vol->ver_samp_m = m;
}

Void
PutVolEnhanceType(Int type,Vol *vol)
{
	vol->enhancement_type = type;
}

/* begin : added for OBSS by Samsung AIT (1999-09-29) */
Void
PutVolUseRefShape(Int use_ref_shape, Vol *vol)
{
        vol->use_ref_shape = use_ref_shape;
}
 
Void
PutVolUseRefTexture(Int use_ref_texture, Vol *vol)
{
        vol->use_ref_texture = use_ref_texture;
}
 
Void
PutVolShapeHorSampN(Int n,Vol *vol)
{
        vol->shape_hor_samp_n = n;
}
 
Void
PutVolShapeHorSampM(Int m,Vol *vol)
{
        vol->shape_hor_samp_m = m;
}
 
Void
PutVolShapeVerSampN(Int n,Vol *vol)
{
        vol->shape_ver_samp_n = n;
}
 
Void
PutVolShapeVerSampM(Int m,Vol *vol)
{
        vol->shape_ver_samp_m = m;
}
/* end : added for OBSS by Samsung AIT (1999-09-29) */

Void
PutVolSpriteHdim(Int sprite_hdim,Vol *vol)
{
	vol->sprite_hdim = sprite_hdim;
}

Void
PutVolSpriteVdim(Int sprite_vdim,Vol *vol)
{
	vol->sprite_vdim = sprite_vdim;
}

Void
PutVolSpriteLeftEdge(Int sprite_left_edge, Vol *vol)
{
	vol->sprite_left_edge = sprite_left_edge;
}

Void
PutVolSpriteTopEdge(Int sprite_top_edge, Vol *vol)
{
	vol->sprite_top_edge = sprite_top_edge;
}

Void
PutVolSpriteInitPieceWidth( Int init_piece_width, Vol *vol)
{
	vol->init_piece_width = init_piece_width;
}

Void
PutVolSpriteInitPieceHeight( Int init_piece_height, Vol *vol)
{
	vol->init_piece_height = init_piece_height;
}

Void
PutVolSpriteInitPieceHorRef( Int init_piece_hor_ref, Vol *vol)
{
	vol->init_piece_hor_ref = init_piece_hor_ref;
}

Void
PutVolSpriteInitPieceVerRef( Int init_piece_ver_ref, Vol *vol)
{
	vol->init_piece_ver_ref = init_piece_ver_ref;
}


Void
PutVolSpriteUsage(Int sprite_usage, Vol *vol )
{
	vol->sprite_usage = sprite_usage;
}

Void
PutVolWarpingAccuracy(Int warping_accuracy, Vol *vol )
{
	vol->warping_accuracy = warping_accuracy;
}

Void
PutVolNoOfSpritePoints(Int no_of_sprite_points, Vol *vol )
{
	vol->no_of_sprite_points = no_of_sprite_points ;
}

Void
PutVolRefPointCoord(TrajPoint *ref_point_coord, Vol *vol )
{
	vol->ref_point_coord = ref_point_coord ;
}

Void
PutVolTrajPointCoord(TrajPoint *traj_point_coord, Vol *vol )
{
	vol->traj_point_coord = traj_point_coord ;
}

Void
PutVolPrevWarpParam(Sprite_motion *prev_warp_param, Vol *vol)
{
	vol->prev_warp_param = prev_warp_param;
}

Void
PutVolBrightnessChangeInSprite( Int brightness_change_in_sprite, Vol *vol )
{
	vol->brightness_change_in_sprite = brightness_change_in_sprite;
}

Void
PutVolLowLatencySpriteEnable( Int low_latency_sprite_enable, Vol *vol )
{
	vol->low_latency_sprite_enable = low_latency_sprite_enable;
}

Void
PutVolSprite(Vop *sprite,Vol *vol)
{
	vol->psprite = sprite;
}

Void
PutVolSpriteTransmitMode(Int sprite_transmit_mode, Vol *vol)
{
	vol->sprite_transmit_mode = sprite_transmit_mode;
}

Void
PutVolSpriteTabTransmit(Int *tab_transmit, Vol *vol)
{
	vol->tab_transmit = tab_transmit;
}

Void
PutVolSpriteTabAmbType(Int *tab_amb_type, Vol *vol)
{
	vol->tab_amb_type = tab_amb_type;
}

Void
PutVolSpriteTabMvda(Int *tab_mvda, Vol *vol)
{
	vol->tab_mvda = tab_mvda;
}

Void
PutVolSpriteTabQPStore(SInt *tab_QP_store, Vol *vol)
{
	vol->tab_QP_store = tab_QP_store;
}

Void
PutVolSpriteTabDQUANTStore(Int *tab_DQUANT_store, Vol *vol)
{
	vol->tab_DQUANT_store = tab_DQUANT_store;
}

Void
PutVolSpriteTabDCStore(Int ***tab_DC_store, Vol *vol)
{
	vol->tab_DC_store = tab_DC_store;
}

Void
PutVolVop(Vop *vop,Vol *vol)
{
	vol->pvop = vop;
}

Void
PutVolNext(Vol *next,Vol *vol)
{
	vol->pnext = next;
}

/* 12.08.98 Sven Brandau: added support for "pixel_aspect_ratio" */
Void PutVolAspectRatioInfo( Int aspect_ratio_info, Vol *vol )
{
  	vol->aspect_ratio_info = aspect_ratio_info;
}

Void PutVolAspectRatioInfoParWidth( Int par_width, Vol *vol )
{
  	vol->par_width = par_width;
}
     
Void PutVolAspectRatioInfoParHeight( Int par_heigth, Vol *vol )
{
  	vol->par_heigth = par_heigth;
}

/* 19.08.98 Sven Brandau: "move interlaced bit from VOP to VOL" */
Void PutVolInterlaced( Int interlaced, Vol *vol ) 
{
	vol->interlaced = interlaced;
}	   

/* >>> added for DRC by Fujitsu (top)    <<< */
Void PutVolReducedResolutionVopEnable( Int reduced_resolution_vop_enable, Vol *vol ) 

{
	vol->reduced_resolution_vop_enable = reduced_resolution_vop_enable;
}
/* >>> added for DRC by Fujitsu (bottom)    <<< */

/***********************************************************CommentBegin******
 *
 * -- PutVO{xxx} -- Functions to write to components of the VO structure
 *	
 *	Void PutVOId(Int id,VO *vo)
 *	Void PutVOLayers(Vol *layers,VO *vo)
 *	Void PutVONext(VO *next,VO *vo)
 *
 * Author :		
 *	Noel O'Connor
 *
 * Created :		
 *	23-Sep-96
 *
 * Purpose :		
 *	These are common functions to write to specific components
 *      of the Vol structure.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Write access to the components of a "Vol" 
 *
 * See also :
 *	
 *
 * Modified :		
 *	
 *
 ***********************************************************CommentEnd********/
Void
PutVOId(Int id,VO *vo)
{
	vo->id = id;
}

Void
PutVOLayers(Vol *layers,VO *vo)
{
	vo->layers = layers;
}

Void
PutVONext(VO *next,VO *vo)
{
	vo->pnext = next;
}

/***********************************************************CommentBegin******
 *
 * -- GetVO{xxx} -- Functions to access components of the VO structure
 *
 *	Int GetVOId(VO *vo)
 *	Vol *GetVOLayers(VO *vo)
 *	VO *GetVONext(VO *vo)
 *
 * Author :		
 *	Noel O'Connor 
 *
 * Created :		
 *	31-Aug-96
 *
 * Purpose :		
 *	These are common functions to access specific components
 *      of the VO data structure.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Access components of a "Vol"
 *
 * See also :
 *	
 *
 * Modified :		
 *	
 *
 ***********************************************************CommentEnd********/

Int
GetVOId(VO *vo)
{
	return(vo->id);
}

Vol *
GetVOLayers(VO *vo)
{
	return(vo->layers);
}

VO *
GetVONext(VO *vo)
{
	return(vo->pnext);
}


/***************************************************************/
/* MAC (SB) 11-Nov-99 */

Void PutVolAuxCompCount( Int aux_comp_count, Vol *vol )
{
  vol->aux_comp_count = aux_comp_count;
}

Void PutVopAuxCompCount( Int aux_comp_count, Vop *vop )
{
  vop->aux_comp_count = aux_comp_count;
}

Int GetVolAuxCompCount( Vol *vol )
{
  return vol->aux_comp_count;
}

Int GetVopAuxCompCount( Vop *vop )
{
  return vop->aux_comp_count;
}

Void PutVolShapeExtension( Int shape_extension, Vol *vol )
{
  vol->shape_extension = shape_extension;
}

Int GetVolShapeExtension( Vol *vol )
{
  return vol->shape_extension;
}

Int GetAuxCompCount( Int vol_shape_extension )
{
  switch (vol_shape_extension) {  /* see N2687, pg. 178, tab. V2-1 */
    case 0:  return 1;
    case 1:  return 1;
    case 2:  return 2;
    case 3:  return 2;      
    case 4:  return 3;
    case 5:  return 1;
    case 6:  return 2;
    case 7:  return 1;
    case 8:  return 1;
    case 9:  return 2;
    case 10: return 3;
    case 11: return 2;
    case 12: return 3;      
    default: fprintf( stderr, "Error: vol_shape_extension(%d) not defined!", vol_shape_extension );
             exit(-1);
  }
}
