/************************************************************************/
/*                                               			*/
/* This software module was originally developed by              	*/
/*                                                               	*/
/* Dae-Sung Cho (Samsung AIT)						*/
/*                                                               	*/
/* and edited by					              	*/
/*									*/
/* Dae-Sung Cho (Samsung AIT)						*/
/*                                                               	*/
/* in the course of development of the MPEG-4 Video(ISO/IEC 14496-2).  	*/
/* This software module is an implementation of a part of one or 	*/
/* more MPEG-4 Video tools as specified by the                	 	*/
/* MPEG-4 Video(ISO/IEC 14496-2). 					*/
/*									*/
/* ISO/IEC gives users of the MPEG-4 Video(ISO/IEC 14496-2)   	 	*/
/* free license to this software module or modifications thereof 	*/
/* for use in hardware or software products claiming conformance 	*/
/* to the MPEG-4 Video(ISO/IEC 14496-2). 				*/
/*									*/
/* Those intending to use this software  				*/
/* module in hardware or software products are advised that its  	*/
/* use may infringe existing patents. The original developer of  	*/
/* this software module and his/her company, the subsequent      	*/
/* editors and their companies, and ISO/IEC have no liability    	*/
/* for use of this software module or modifications thereof in   	*/
/* an implementation. Copyright is not released for non          	*/
/* MPEG-4 Video(ISO/IEC 14496-2) conforming products. 			*/
/*									*/
/* Samsung AIT (SAIT) retain full right to use the code for 		*/
/* their own purposes, assign or donate the code to a third party 	*/
/* and to inhibit third parties from using the code for non		*/
/* MPEG-4 Video(ISO/IEC 14496-2) conforming products. 			*/
/*									*/
/* This copyright notice must be included in all copies or 		*/
/* derivative works.                             			*/
/* Copyright (c)1997                                             	*/
/*                                                               	*/
/************************************************************************/


/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	alp_common_si.c
 *
 * Author:	Dae-Sung Cho (Samsung AIT)
 * Created:	09-Feb-98
 *                                                                         
 * Description: Contains functions used to implement scan interleaving
 *                               coding of spatial scalable binary alpha blocks.
 *
 *
 *                                 
 ***********************************************************HeaderEnd*********/

#include <math.h>
#include <assert.h>	
#include "momusys.h"
#include "mom_structs.h"
#include "mom_image.h"
#include "mom_vop.h"
#include "alp_common_si.h"


/* Computes a 7-bit scan interleaving (SI) context for vertical scanning (VS) */
Int GetContextSI_VS(SInt* pim, 
			Int x, Int y, 
				Int first_col,
				Int last_col,
				Int first_row,
				Int last_row,
			Int width)
{
  Int t = 0;
  SInt *p;

  p=pim + (y-2) * width + x-1;

  t <<= 1;
  t |= *p; p++;				/* c6 */
  t <<= 1;
  t |= *p; p++;				/* c5 */
  t <<= 1;
  t |= *p; p+= (2*width-2);		/* c4 */
	
  t <<= 1;
  t |= *p; p+= 2;			/* c3 */

  t <<= 1;
  t |= *p; p+= (2*width-2);		/* c2 */
	
  t <<= 1;

  /* if (y==last_row) { */	    /* DSCHO */
  if ((x>first_col) && (y==last_row)) { /* DSCHO */
	t |= (t>>2) & 1;		/* c1 = c3 */
  } else {
 	t |= *p; 			/* c1 */
  }
  p+= 2;				

  t <<= 1;

  if (y==last_row) {
	t |= (t>>2) & 1;		/* c0 = c2 */	
  } else {
 	t |= *p; 			/* c0 */
  }

  return t;
}

/* Computes a 7-bit scan interleaving (SI) context for horizontal scanning (HS) */
Int GetContextSI_HS(SInt* pim, 
			Int x, Int y, 
				Int first_col,
				Int last_col,
				Int first_row,
				Int last_row,
			Int width)
{
  Int t = 0;
  SInt *p;

  p=pim + (y-1) * width + x-1;

  t <<= 1;
  t |= *p; p++;				/* c6 */
  t <<= 1;
  t |= *p; p++;				/* c5 */
  t <<= 1;

  if ((y>first_row) && (x==last_col)) {
	t |= (t>>1) & 1;		/* c4 = c5 */
  } else {
 	t |= *p; 			/* c4 */
  }
  p+= (width-2);			
	
  t <<= 1;
  t |= *p; p+= width;			/* c3 */

  t <<= 1;
  t |= *p; p++;				/* c2 */
	
  t <<= 1;
  t |= *p; p++;				/* c1 */

  t <<= 1;

  if (x==last_col) {
	t |= (t>>1) & 1;		/* c0 = c1 */
  } else {
 	t |= *p; 			/* c0 */
  }

  return t;
}

/* Computes a 7-bit scan interleaving (SI) context for vertical scanning (VS) */
Int GetContextSI_VS_AR (SInt* pim, 
			Int x, 
			Int y, 
			Int right_skip,
			Int left_skip,
			Int upper_skip,
			Int bottom_skip,
			Int width)
{
  Int i, context = 0;
  Int index[7];
  SInt *p;

  p=pim + y * width + x;

  index[0] = bottom_skip * width + right_skip;
  index[1] = bottom_skip * width - left_skip;
  index[2] = right_skip;
  index[3] = -1*left_skip;
  index[4] = -1*upper_skip * width + right_skip;
  index[5] = -1*upper_skip * width;
  index[6] = -1*upper_skip * width - left_skip;
 
  for (i=0; i<7; i++) 
	context += (p[index[i]]<<i);	
   
  assert(context>=0 && context<128);

  return context; 
}

/* Computes a 7-bit scan interleaving (SI) context for horizontal scanning (HS) */
Int GetContextSI_HS_AR (SInt* pim, 
			Int x, 
			Int y, 
			Int upper_skip,
			Int bottom_skip,
			Int width)
{
  Int i, context = 0;
  Int index[7];
  SInt *p;

  p=pim + y * width + x;

  index[0] = bottom_skip * width + 1;
  index[1] = bottom_skip * width;
  index[2] = bottom_skip * width - 1;
  index[3] = -1;
  index[4] = -1*upper_skip * width + 1;
  index[5] = -1*upper_skip * width;
  index[6] = -1*upper_skip * width - 1;
  
  for (i=0; i<7; i++) 
	context += (p[index[i]]<<i);	
   
  assert(context>=0 && context<128);

  return context; 
}


Int DecideScanOrderSI(Image *bordered_alpha_data, Int mb_size)
{
  Int x,y,n_left,n_up,direction;
  Int width = GetImageSizeX(bordered_alpha_data);

  SInt *p = (SInt *) GetImageData(bordered_alpha_data) + 2 * width + 2;

  n_left = n_up = 0;
  for(y=1; y<mb_size; y+=2){
    for(x=1; x<mb_size; x+=2){
	if( *(p + y*width + x) != *(p + (y-2)*width + x) )	n_up++;
	if( *(p + y*width + x) != *(p + y*width + (x-2)) )	n_left++;
    }
  }

  if(n_up>n_left) direction=0;	/* vertical (transposed) */
  else		  direction=1;  /* horizontal */

  return direction;
}

Int GetBabType(Int i, Int j, Vop *vop)
{
  SInt *shape_mode = (SInt *)GetImageData(GetVopShapeMode(vop));
  Int  refi,refj;
  Int  curr_mode;
  Int  hsize_ref = GetImageSizeX(GetVopShapeMode(vop));
  Int  vsize_ref = GetImageSizeY(GetVopShapeMode(vop));

  if(i<vsize_ref) refi=i;
  else	   	  refi=vsize_ref-1;
  if(j<hsize_ref) refj=j;
  else	   	  refj=hsize_ref-1;

  curr_mode = shape_mode[refi*hsize_ref+refj];

/***
#ifdef  _DEBUG_OBSS_
 fprintf(stderr,">>>GetMBtype()==>\n");
 fprintf(stderr,">>>>>curr_mode[%d,%d]=%d\n", i,j,curr_mode);
#endif
**/

  return (curr_mode);
}

