/* $Id: ztscanUtil.h,v 1.8 1998/09/25 16:20:57 hatrack Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*                                                                          */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

#ifndef _ZTSCAN_UTIL_H_
#define _ZTSCAN_UTIL_H_

/* function prototype declarations */
#ifdef _DECLARE_PROTOTYPES_

Void probModelInitSQ(Int col);
Void probModelFreeSQ(Int col);
Void setProbModelsSQ(Int col);

Void probModelInitMQ(Int col);
Void probModelFreeMQ(Int col);
Void setProbModelsMQ(Int col);

Void init_acm_maxf_enc();
Void init_acm_maxf_dec();

Void clear_ZTR_D(COEFFINFO **coeffinfo, Int width, Int height);

/* begin: added by Rockwell (99/3/3) */

/* IM: VTC error res */ 
/* Void codeBlocks(Int y, Int x, Int n, Void (*pixelFunc)(Int, Int)); */
Void codeBlocks(Int y, Int x, Int n, Void (*pixelFunc)(Int, Int),Int color);

/* IM: VTC error res */ 
Void decodeBlocks(Int y, Int x, Int n, Void (*pixelFunc)(Int, Int),Int color);

/* error resilience routines, bbc, 11/6/98 */
Void get_TU_location(Int LTU);
Int need_check_segment_end(Int h,Int w,Int color);
void check_segment_size(Int col);
Int found_segment_error(Int col);

/* end: added by Rockwell (99/3/3) */

#else _DECLARE_PROTOTYPES_

#include "ztscanUtil.p"

#endif _DECLARE_PROTOTYPES_

#endif 
