/******************************************************************************
 *
 * This software module was originally developed by
 *
 *   J. Ignacio Ronda (UPM-GTI / ACTS-MoMuSyS)
 *   Angel Pacheco (UPM-GTI / ACTS-MoMuSyS)
 *
 * and edited by
 *
 *   Robert Danielsen (Telenor / ACTS-MoMuSyS)
 *   Bruno Loret (CNET / ACTS-MoMuSyS)
 *   Fernando Jaureguizar (UPM-GTI / ACTS-MoMuSyS)
 *   Bob Eifrig (NextLevel Systems)
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File:        mot_util.h
 *
 * Author:      J. Ignacio Ronda / Angel Pacheco, UPM-GTI
 *
 * Created:     02.02.96 
 *                                                                         
 * Description: 
 *
 * Notes: 
 *
 * Modified:
 *      21.04.96 Robert Danielsen: New header.
 *      23.04.96 Bruno Loret: Non reentrant ifndef
 *      23.07.96 Fernando Jaureguizar: DEFAULT_8_WIN define
 *      18.09.96 Fernando Jaureguizar: New B_TRANSP and MB_TRANSP defines
 *               put in this file.
 *      21.05.97 Angel Pacheco: BV macro moved from mot_decode.c
 *      11.12.97 Bob Eifrig:  Added MVLEN() macro
 *
 ***********************************************************HeaderEnd*********/

#ifndef _MOT_UTIL_H_
#define _MOT_UTIL_H_

#include<stdio.h>
#include<stdlib.h>
#include<limits.h>
#include<momusys.h>

/* Obtaining whether a block is transparent */
#define B_TRANSP(p,hdim,h,v,h2,v2,value)\
        ((p)[(2*(v)+(v2))*(hdim)+2*(h)+(h2)]==(value))

/* Obtaining whether a block is at the boundary */
#define B_BOUND(p,hdim,h,v,h2,v2,value)\
        ((p)[(2*(v)+(v2))*(hdim)+2*(h)+(h2)]==(value))


/* Obtaining whether a MB is transparent */
#define MB_TRANSP(p,hdim,h,v,value)\
        (B_TRANSP(p,hdim,h,v,0,0,value) &&\
         B_TRANSP(p,hdim,h,v,0,1,value) &&\
         B_TRANSP(p,hdim,h,v,1,0,value) &&\
         B_TRANSP(p,hdim,h,v,1,1,value))

/* Obtaining whether a MB is at the boundary */
#define MB_BOUND(p,hdim,h,v,value)\
        (B_BOUND(p,hdim,h,v,0,0,value) ||\
         B_BOUND(p,hdim,h,v,0,1,value) ||\
         B_BOUND(p,hdim,h,v,1,0,value) ||\
         B_BOUND(p,hdim,h,v,1,1,value))


/* search window for the 8x8 block MV; [-DEFAULT_8_WIN;DEFAULT_8_WIN] pixels
   arround the 16x16 motion vector */
#define DEFAULT_8_WIN    2.0

#define B_SIZE           8

/* big value, returned if the MV is not good enought (2^25) */
#define MV_MAX_ERROR    0x2000000

/* Point structure */

typedef struct pixpoint
  {
  Int x;
  Int y;
  } PixPoint;

#define EHUFF struct Modified_Encoder_Huffman

EHUFF
{
  Int n;
  Int *Hlen;
  Int *Hcode;
};

/* get 8x8 MV component */
#define BV(p,xdim,h,v,h2,v2) (p[(2*(v)+(v2))*(xdim)+2*(h)+(h2)])

#define  MVLEN(x,y)  (ABS(x) + ABS(y))

#include "mom_structs.h"
#include "vm_common_defs.h"
#include "mot_util.p"

#endif /* _MOT_UTIL_H_ */
