/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Bruno Loret (CNET / ACTS-MoMuSyS)
 *   Michael Wollborn (TUH / ACTS-MoMuSyS)
 *                                 
 * and edited by
 *                                               
 *   Robert Danielsen (Telenor / ACTS-MoMuSyS)
 *   Bruno Loret (CNET / ACTS-MoMuSyS)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	momusys.h
 *
 * Author:	Bruno Loret ; FRANCE TELECOM - CNET ; loret@issy.cnet.fr
 *             	Acknowledgement : Joel Mau et. al CCETT
 *		Michael Wollborn: Last part of the file
 * Created:	
 *                                                                         
 * Description: Header File to be included as a header file in the beginning
 *		of any source file.
 *		Provides the user with a lot or typedefs, macros,
 *		secured macros and a lot of tips to be more portable.
 * Notes: 	
 *
 * Modified:	version 0.1
 *		27-Feb-96 Michael Wollborn. Added part to the file
 * 		21.04.96 Robert Danielsen: New header.
 *		13.05.96 Bruno Loret: include of powerpc.h
 *              28.05.97 Cor Quist: changed 'int' data types
 *		18.11.97 M.Wollborn: changed powerpc.h into non_unix.h
 ***********************************************************HeaderEnd*********/


                                             /********************************/
#ifndef _MOMUSYS_H_                          /* TO AVOID REENTERING CODE     */
                                             /********************************/
                                             /********************************/
#	define _MOMUSYS_H_                   /* NOW IMPOSSIBLE TO REENTER    */
                                             /********************************/
#   include "non_unix.h"
                                             /********************************/
#   if defined(C_ANSI) || defined(__STDC__)  /* IF C ANSI MODE IS SUPPORTED  */
#      define  C_IS_ANSI                     /********************************/
#      define  _C_ANSI_ 
#   endif

                                             /********************************/
#   include <stdio.h>                        /* SURE ALL Def. ARE DEFINED !  */
#   include <stdlib.h>                       /* SURE ALL Def. ARE DEFINED !  */
#   include <math.h>                         /********************************/
#   include <sys/stat.h>

                                             /********************************/
#   if defined (SYSV) || defined (__STDC__) 
#      include <string.h>                    /********************************/
#      define bzero(s1, length)             memset(s1, '\0', length)
#      define bcopy(s1, s2, length)         memcpy(s1, s2  , length)
#      define bcmp(s1, s2, length)          memcmp(s1, s2, length)
#      define memzero(s1, length)           memset(s1, '\0', length)
#      define index(s1, c)                  strchr(s1, c)
#      define rindex(s1, c)                 strrchr(s1, c)
#   else
#      include <strings.h>
#      define strchr(s1, c)                 index(s1, c)
#      define strrchr(s1, c)                rindex(s1, c)
#      define memcpy(s1, s2 , length)       bcopy(s1, s2, length)
#      define memzero(s1, length)           bzero(s1, length)
#      define memcmp(s1, s2, length)        bcmp(s1, s2, length)
#   endif


                                             /********************************/
#   if !defined(FALSE) || ((FALSE)!= 0)      /* TO AVOID MULTIPLE DEFINE     */
#      define  FALSE           0             /* AND BE SURE FALSE = 0        */
#   endif                                    /********************************/
#   if !defined(TRUE)  || ((TRUE) != 1)      /* TO AVOID MULTIPLE DEFINE     */
#      define  TRUE            1             /* AND BE SURE TRUE = 1         */
#   endif                                    /********************************/

#   ifndef     NULL
#      define  NULL            0
#   endif

                     /**************************************/
                     /**** GENERAL TYPES DEFINITIONS *******/
                     /**************************************/
#define Const const

    typedef void                 Void       ;

    typedef char                 Char       ;
    typedef const    char        C_Char     ;

    typedef unsigned char        Byte       ;
    typedef Const    Byte        C_Byte     ;
    typedef unsigned char        UChar      ;
    typedef Const    UChar       C_UChar    ;
 
    typedef short    int         Short      ;
    typedef short    int         SInt       ;
    typedef unsigned short       UShort     ;
    typedef unsigned short       USInt      ;
    typedef Const    short       C_Short    ;
    typedef Const    short       C_SInt     ;
    typedef Const    UShort      C_UShort   ;
    typedef Const    UShort      C_USInt    ;

    typedef int                  Int        ;
    typedef long     int         LInt       ;
    typedef Const    int         C_Int      ;
    typedef unsigned int         U_Int      ;

    typedef unsigned int         UInt       ;
    typedef unsigned long int    ULInt      ;
    typedef Const    UInt        C_UInt     ;

    typedef float                Float      ;
    typedef Const    float       C_Float    ;

    typedef double               Double     ;
    typedef Const    double      C_Double   ;

    typedef FILE                 File       ;

/* Alternatibe type redefinition */
#if 0
    typedef long            INT32;
    typedef int             INT32;
    typedef short           INT16;
    typedef char            INT8;
    typedef unsigned int    UINT32;
    typedef unsigned short  UINT16;
    typedef unsigned char   UINT8;
 
 
#   if __STDC__ 
        typedef signed char INT8;
#   else
        typedef char        INT8;
#   endif

    typedef unsigned long   BITS32;
    typedef unsigned short  BITS16;
    typedef unsigned char   BYTE;
    
    typedef unsigned char   BOOL;
#endif


                     /**************************************/
                     /**** GENERAL MACRO DEFINITIONS *******/
                     /**************************************/
#   ifndef MAX
#   define  MAX(a,b)              (((a) > (b)) ? (a) : (b))
#   endif

#   ifndef MIN
#   define  MIN(a,b)              (((a) < (b)) ? (a) : (b))
#   endif

#   define  CLIP(a,i,s)           (((a) > (s)) ? (s) : MAX(a,i))
#   define  INT(a)                ((Int) (floor((Double) a)))
#	define MNINT(a)    			  ((a) < 0 ? (Int)(a - 0.5) : (Int)(a + 0.5))
#	define MAX3(x,y,z)      	  MAX(MAX(x,y),z)
#	define MIN3(x,y,z)      	  MIN(MIN(x,y),z)
#	define MEDIAN(x,y,z)   		  ((x)+(y)+(z)-MAX3(x,y,z)-MIN3(x,y,z))

#   define  POW2(a)               ((a)*(a))
#   define  SQUARE(a)             ((a)*(a))
#   define  POW3(a)               ((a)*(a)*(a))
#   define  CUBE(a)               ((a)*(a)*(a))

#   define  ABS(x)                (((x) < 0) ? -(x) : (x))
#   define  SIGN(x)               (((x) < 0) ? -1 : 1)
#   define  EVEN(a)               ((a) % 2) == 0)
#   define  ODD(a)                ((a) % 2) == 1)

#   define  STRLEN(P_string)      ((P_string==NULL) ? strlen(P_string) : -1)
#   define  TYPE_MALLOC(type,nb) ((type *) malloc(sizeof(type)*nb))
#   define  NEW(type)             ((type *) malloc(sizeof(type)   ))

#define MOMCHECK(a)	if ((a) == 0) fprintf(stdout, "MOMCHECK failed in file %s, line %i\n", __FILE__, __LINE__)

                                             /********************************/
#   ifdef C_IS_ANSI                          /* IF C ANSI MODE IS SUPPORTED  */
                                             /********************************/
#      define _ANSI_ARGS_(argv)   argv       /* MACRO FOR PROTOTYPING        */
#      define _P_(argv)           argv       /* <=> _ANSI_ARGS, BUT SHORTER! */
                                             /********************************/
#   else                                     /* IF C ANSI IS NOT SUPPORTED   */
                                             /********************************/
#      define _ANSI_ARGS_(argv)   ()         /* MACRO FOR PROTOTYPING        */
#      define _P_(argv)           ()         /* <=> _ANSI_ARGS, BUT SHORTER! */
                                             /********************************/
#   endif

#include "mom_structs.h"

#endif /* _MOMUSYS_H_ */                     /* End _MOMUSYS_H_              */
                                             /********************************/


/*****************************************************************************/
/* CREATED BY :  Michael Wollborn -- 27-Feb-96                               */
/*****************************************************************************/

/*****
*
*     TUH error checking macros
*
*****/


#ifndef _TUHDEF_ERROR_MACROS_H
#define _TUHDEF_ERROR_MACROS_H

   #   ifdef __cplusplus
       extern "C" {
   #   endif /* __cplusplus */

/*****
*
*     General ERROR printing macro
*
*****/
#define ERROR(a) \
  printf("Error in %s: %s\n",function_name,a);

/*****
*
*     Checks if image a and b have the same size
*
*****/
#define COMPARE_IMAGE_SIZE_EQL(a,b) \
  !(GetImageSizeX(a)==GetImageSizeX(b) && \
    GetImageSizeY(a)==GetImageSizeY(b))

#define ERROR_IMAGE_SIZE_EQL(a,b) \
  printf("Error in %s: wrong image dimensions\n",function_name); \
  printf("Image1: %ix%i unequal Image2: %ix%i\n",(Int)GetImageSizeX(a), \
	 (Int)GetImageSizeY(a),(Int)GetImageSizeX(b),(Int)GetImageSizeY(b));

/*****
*
*     Checks if image a has double size (both dimensions) of image b
*
*****/
#define COMPARE_IMAGE_SIZE_DBL(a,b) \
  !(GetImageSizeX(a)==2*GetImageSizeX(b) && \
    GetImageSizeY(a)==2*GetImageSizeY(b))

#define ERROR_IMAGE_SIZE_DBL(a,b) \
  printf("Error in %s: wrong image dimensions\n",function_name); \
  printf("Image1: %ix%i unequal 2*Image2: %ix%i\n",(Int)GetImageeSizeX(a), \
	 (Int)GetImageSizeY(a),(Int)GetImageSizeX(b),(Int)GetImageSizeY(b));

/*****
*
*     Checks if image a has half size (both dimensions) of image b
*
*****/
#define COMPARE_IMAGE_SIZE_HLF(a,b) \
  !(GetImageSizeX(a)==GetImageSizeX(b) && \
    GetImageSizeY(a)==GetImageSizeY(b))

#define ERROR_IMAGE_SIZE_HLF(a,b) \
  printf("Error in %s: wrong image dimensions\n",function_name); \
  printf("Image1: %ix%i unequal 1/2*Image2: %ix%i\n",(Int)GetImageSizeX(a), \
	 (Int)GetImageSizeY(a),(Int)GetImageSizeX(b),(Int)GetImageSizeY(b));

/*****
*
*     Checks if image is greater or equal (both dimensions) image b
*
*****/
#define COMPARE_IMAGE_SIZE_GOE(a,b) \
  !(GetImageSizeX(a)>=GetImageSizeX(b) && \
    GetImageSizeY(a)>=GetImageSizeY(b))

#define ERROR_IMAGE_SIZE_GOE(a,b) \
  printf("Error in %s: wrong image dimensions\n",function_name); \
  printf("Image1: %ix%i not >= *Image2: %ix%i\n",(Int)GetImageSizeX(a), \
	 (Int)GetImageSizeY(a),(Int)GetImageSizeX(b),(Int)GetImageSizeY(b));
  
/*****
*
*     Checks if image is lower or equal (both dimensions) image b
*
*****/
#define COMPARE_IMAGE_SIZE_LOE(a,b) \
  !(GetImageSizeX(a)<=GetImageSizeX(b) && \
    GetImageSizeY(a)<=GetImageSizeY(b))

#define ERROR_IMAGE_SIZE_LOE(a,b) \
  printf("Error in %s: wrong image dimensions\n",function_name); \
  printf("Image1: %ix%i not <= *Image2: %ix%i\n",(Int)GetImageSizeX(a), \
	 (Int)GetImageSizeY(a),(Int)GetImageSizeX(b),(Int)GetImageSizeY(b));
  
/*****
*
*     Checks if image a and b have the same type
*
*****/
#define COMPARE_IMAGE_TYPE_EQL(a,b) \
  !(GetImageType(a) == GetImageType(b))

#define ERROR_IMAGE_TYPE_EQL(a,b) \
  printf("Error in %s: wrong image types\n",function_name); \
  printf("Image1: %d unequal Image2: %d\n",(Int)GetImageType(a),(Int)GetImageSizeY(b));

   #   ifdef __cplusplus
       }
   #   endif /* __cplusplus  */ 

#endif  /* ifndef _TUHDEF_ERROR_MACROS_H */


