/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Bruno Loret (CNET / ACTS-MoMuSyS)
 *
 * and edited by
 * 
 *   Michael Wollborn (TUH / ACTS-MoMuSyS)                  
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996
 *
 *****************************************************************************/


/***********************************************************HeaderBegin*******
 *                                                                         
 * File :        mom_trace.h
 *
 * Author :	Bruno LORET  <Loret@issy.cnet.fr>
 *
 * Created :	22-May-1996
 *
 * Description : 
 *
 * Notes : 	
 *
 * Modified : 18.06.97 M.Wollborn: Adopted trace structures to VM7 syntax
 *
 ***********************************************************HeaderEnd*********/

/******************************************************************************/
#ifndef _MOM_TRACE_H_
#define _MOM_TRACE_H_

#include "momusys.h"


typedef struct {
  File  *fp_trace;

  Int	counter;
  Int	full_trace_start;
  Int   full_trace_end;
  Int   full_trace_period;
  Int   trace;

  /* Default trace level entries */
  /* Level 1 */
  Int   VO_header_def;
  Int   VOL_header_def;
  Int   VOP_header_def;

  /* Level 2 */
  Int	MB_header_def;
  Int	MB_motion_def;
  Int	MB_shape_def;
  Int	MB_texture_def;

  /* Level 3 */
  Int	MB_sdata_def;
  Int	MB_tdata_before_IQ_def;
  Int	MB_tdata_after_IQ_def;
  Int	MB_tdata_after_IDCT_def;
  Int	MB_tdata_predicted_def;
  Int	MB_tdata_reconstructed_def;

  /* Actual trace level entries */
  /* Level 1 */
  Int   VO_header;
  Int   VOL_header;
  Int   VOP_header;

  /* Level 2 */
  Int	MB_header;
  Int	MB_motion;
  Int	MB_shape;
  Int	MB_texture;

  /* Level 3 */
  Int	MB_sdata;
  Int	MB_tdata_before_IQ;
  Int	MB_tdata_after_IQ;
  Int	MB_tdata_after_IDCT;
  Int	MB_tdata_predicted;
  Int	MB_tdata_reconstructed;

} Trace;


/* Trace modes */
#define CODE 1
#define NUM  2
#define MARK 3
#define FLAG 4


#include "mom_trace.p"

#endif /* _MOM_TRACE_H_ */
