/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Michael Wollborn (TUH / ACTS-MoMuSyS)
 *
 * and edited by
 * 
 *   Robert Danielsen (Telenor / ACTS-MoMuSyS)
 *   Bruno Loret (CNET / ACTS-MoMuSyS)
 *   Noel O'Connor (Teltec DCU / ACTS-MoMuSyS)
 *   Regis J. Crinon (Sharp Laboratories of America Inc.)
 *   Frederic Dufaux (Digital Equipment Corp.)
 *   Aasmund Sandvand (Telenor / ACTS-MoMuSyS)
 *   Bob Eifrig (NextLevel Systems)
 *   Michael Frater (UNSW)
 *   Ji Heon Kweon (HYUNDAI)
 *   Marc Mongenet (EPFL)
 *   Takefumi Nagumo (SONY)
 *   Oki Electric Industry Co., Ltd. (contact: Shigeru Fukunaga)                  	
 *   Fujitsu Laboratories Ltd. (contact: Eishi Morimatsu)
 *   Dae-Sung Cho (Samsung AIT)
 *   Massimo Ravasi (EPFL)
 *   Sven Brandau (HHI)
 *
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996-1999
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	mom_structs.h
 *
 * Author:	Michael Wollborn
 * Created:	6-Feb-96 
 *                                                                         
 * Description: Common MoMuSys WP2.4 data structures for intermediate
 *     		formats, to be used whenever possible and obligatory
 *     		for interfacing modules
 *
 * Notes: 	
 *
 * Modified:	Version 2.00 / 19-FEB-1996 / TUH (M.Wollborn)
 *     		Version 2.01 / 20-FEB-1996 / TUH (M.Wollborn) (sec. VOP
 *			pointer)
 *     		Version 2.1  / 02-APR-1996 / TUH (M.Wollborn) (new typedefs)
 * 		21.04.96 Robert Danielsen: New header.
 *              23.04.96 Bruno Loret: Non reentrant ifndef
 *		15.08.96 M.Wollborn: Updated for VM3.0
 *		23.09.96 Noel O'Connor: Added VO data type
 *              31.01.97 Aasmund Sandvand: Removed deblock_filter_disable
 *		04.02.97 Noel O'Connor: Added SADCT disable flag to VOL
 *		20.02.97 Cecile Dufour: Added SPRITE utilities into VOL and VOP structure
 *					and trajPoint and trajPointF 
 *					(from an implementation of F. Dufaux)
 *		26.02.97 Noel O'Connor: reverse_vlc and shape_effects added to VOL/VOP
 *		22.04.97 Michael Wollborn: Added new entries for MPEG quant.
 *					   matrices (also for graylevel alpha)
 *              26.04.97 Luis Ducla-Soares: Added new entries for data
 *                                          partitioning in Vop and Vol.
 *		13.05.97 Minhua Zhou      : added advanced_prediction_disable
 *              09.07.97 Aasmund Sandvand: added vo_id to VOL and VOP
 *              15.07.97 Ulrike Pesel-Schiller: added scal_type-flag in Vol
 *		04.08.97 Minhua Zhou: rename advanced_prediction_disable to
 *				      obmc_disable
 *              04.08.97 Minhua zhou: added sr_for,sr_back in VOP definition
 *              12.08.97 Minhua Zhou: added time_increment_resolution in VOP
 *				      and VOL definition
 *		09.10.97 Minhua Zhou: added vop_coded
 *      11.12.97 Bob Eifrig: Added motion file variables, frame number and
 *              direct mode search radius to vop structure.
 *		21.05.98 Ji Heon Kweon (HYUNDAI) : support for grayscale coding 
 *		04.06.98 Marc Mongenet (EPFL): added Complexity Estimation syntax support
 *      17.06.98 A. Sandvand (Telenor): added VOP syntax elements for short video header
 *		31.08.98 Guido Heising (HHI): non version 1 items deleted             
 *              18.01.99 Takefumi Nagumo (SONY): added hierarchy_type in VOL definition
 *		04.06.99 Karsten Suehring (HHI): added VOL control parameters in Vol
 *		16.08.99 Shigeru Fukunaga (Oki): added NEWPRED entries to Vop and Vol
 *	        06.09.99 Eishi Morimatsu (Fujitsu Labs.): added DRC entries to Vop and Vol
 *		09.29.99 Dae-Sung Cho (Samsung AIT): added support for OBSS
 *    		26.10.99 Massimo Ravasi (EPFL): added Complexity Estimation syntax support
 *                                    Update version 2
 *		11.11.99 Sven Brandau (HHI): added support for MAC
 *      11.11.99 U. Benzler (UoH) - added visual_object_type_indication to be able to create conformance bitstreams
 *
 ***********************************************************HeaderEnd*********/


#ifndef _MOM_STRUCTS_H_
#define _MOM_STRUCTS_H_


#include "momusys.h"
#include "vm_common_defs.h"

/*****
*
*     User definable extensions (must not be used for interfacing to
*     modules from other partners)
*
*****/
#include "locdef_structs.h"

#define VERSION		1	/* Image Structure Version */

/*****
*
*     Basic and generic image structure
*
*****/
enum image_type {SHORT_TYPE,FLOAT_TYPE,UCHAR_TYPE};
typedef enum image_type ImageType;

union image_data
{
  SInt *s;		/* SHORT data */
  Float *f;		/* FLOAT data */
  UChar *u;		/* UCHAR data */
};
typedef union image_data ImageData;

struct image
{
  Int version;		/* Version number */
  UInt x,y;		/* Image size */
  Char upperodd;	/* Flag to tell if the top line is considered
			   as even or odd (used for hex grids) */
  Char grid;		/* Grid type: s = square, h = hexagonal */
  SInt *f;		/* Image data with short int values */
  ImageData *data;	/* NEW: pointer to image data */
  ImageType type;	/* NEW: type of the image */
};
typedef struct image Image;

typedef struct image ImageI;	/* For compatibility with old source code */
typedef struct image ImageF;	/* For compatibility with old source code */


struct trajpoint 
{
  Int x;
  Int y;
};

typedef struct trajpoint TrajPoint;

struct sprite_motion
{
	Double	a1;
	Double	a2;
	Double	a3;
	Double	a4;
	Double	a5;
	Double	a6;
	Double	a7;
	Double	a8;
};
typedef struct sprite_motion Sprite_motion; 

/*****
*
*     Recommended structures for VOPs, VOLs and VOs (now compliant with VM3.0)
*     (in the VOP structure *all* entries from the VOL syntax which
*     are necessary for decoding the VOP are duplicated. These entries
*     are marked as "VOL ...")
*
*****/
struct vop
{
  /* Actual syntax elements for VOP (standard) */
  Int prediction_type;		/* VOP prediction type */
  Int mod_time_base;		/* VOP modulo time base (absolute) */
  Float time_inc;		/* VOP time increment (relative to last mtb) */
  Int vop_coded;
  Int rounding_type;

  Int width;			/* VOP height (smallest rectangle) */
  Int height;			/* VOP width  (smallest rectangle) */
  Int hor_spat_ref;		/* VOP horizontal ref. (for composition) */
  Int ver_spat_ref;		/* VOP vertical ref.   (for composition) */
  Int back_comp;		/* VOP background composition */
  Int change_CR_disable;	/* VOP disable CR updating */
  Int constant_alpha;
  Int constant_alpha_value;
  
  Int intra_dc_vlc_thr;
  Int interlaced;
  Int top_field_first;
  Int alternate_scan; 
  Int sr_direct;        /* Direct mode seach radius (half-pels) */
  Int mvfileusage;      /* MV file usage: 0=notused, 1=read, 2=write */
  Char *mvfilename;	    /* ptr to MV file name */
  FILE *mvfile;         /* Open stdio MV file */
  Int *mvlinenop;       /* Pointer to current MV line number */
  Int frame;            /* frame number */

  Int quantizer;		/* VOP quantizer for P-VOPs */
  Int intra_quantizer;		/* VOP quantizer for I-VOPs */
  Int B_quantizer;		/* VOP quantizer for B-VOPs */

  Int gl_quantizer[MAX_MAC];		/* VOP quantizer fot GL alpha maps : I-VOPs*/
  Int intra_gl_quantizer[MAX_MAC];	/* VOP quantizer fot GL alpha maps : P-VOPs*/
  Int B_gl_quantizer[MAX_MAC];		/* VOP quantizer fot GL alpha maps : B-VOPs*/
 
  /* VOP syntax elements for Video Plane with Short Header */
  Int num_macroblocks_in_gob;
  Int num_gobs_in_vop;
  Int gob_number;
  Int gob_frame_id;

  /* Actual syntax elements for VOP (additional for scalability) */
  Int load_back_shape;		/* VOP load_backward_shape */
  Int load_for_shape;		/* VOP load_forward_shape */
  Int ref_sel_code;		/* VOP refereence for P- and B-VOPs */
  Int for_temp_ref;		/* VOP forward temporal reference */
  Int back_temp_ref;		/* VOP backward_temporal_reference */
  
  /* Syntax elements copied from VOL (standard) */
  Int vo_id;                    /* VO Id */
  Int ident;			/* VOL identifier (for tracking) */
  Int is_object_layer_identifier;
  Int visual_object_layer_verid;
  Int visual_object_layer_priority;
  Int vol_control_parameters;

  Int chroma_format;		/* 04.06.99 Karsten Suehring (HHI) */
  Int low_delay;
  Int vbv_parameters;
  Int first_half_bit_rate;
  Int latter_half_bit_rate;
  Int first_half_vbv_buffer_size;
  Int latter_half_vbv_buffer_size;
  Int first_half_vbv_occupancy;
  Int latter_half_vbv_occupancy;

  Int arbitrary_shape;		/* VOL shape: 0-rect., 1-bin., 2-greyl. */ 
  Int time_increment_resolution;
  Int fixed_vop_rate;

  Int obmc_disable;              /* VOL disable OBMC */

  Int quant_type;		/* VOL quant. type (0-H.263, 1-MPEG) */
  Int load_intra_quant_mat;	/* VOL load intra qmat. flag */
  Int intra_quant_mat[64];	    /* VOL values for intra qmat. */
  Int load_nonintra_quant_mat;	    /* VOL load nonintra qmat. flag */
  Int nonintra_quant_mat[64];	    /* VOL values for nonintra qmat. */
  Int disable_gray_quant_update;    /* VOL gray alpha map quant. update flag */
  Int load_gray_intra_quant_mat[MAX_MAC];    /* VOL load gray intra qmat. flag */
  Int gray_intra_quant_mat[MAX_MAC][64];     /* VOL values for gray intra qmat. */
  Int load_gray_nonintra_quant_mat[MAX_MAC]; /* VOL load nonintra qmat. flag */
  Int gray_nonintra_quant_mat[MAX_MAC][64];  /* VOL values for gray nonintra qmat. */
  Int error_res_disable;	/* VOL disable error resilence mode */
  Int intra_acdc_pred_disable;	/* VOL disable INTRA DC prediction */
  Int quarter_pel;              /* VOL quarter pel MC flag */		/* MW QPEL 07-JUL-1998 */
  Int sr_for;			/* VOP search range of motion vectors */
  Int sr_back;			/* VOP search range of motion vectors */
  Int fcode_for;		/* VOP dynamic range of motion vectors */
  Int fcode_back;		/* VOP dynamic range of motion vectors */
	Int shape_coding_type;	/* VOP shape prediction type */
  Int scalability;		/* VOL scalability (flag) */
  Int sadct_disable;		/* VOL SADCT_disable */
  Int shape_effects;		/* VOL shape effects */
  Int reverse_vlc;		/* VOL reversible VLCs */
  Int data_partitioning;        /* VOL data partitioning */
  Int quant_precision;
  Int bits_per_pixel;

  /* START: Complexity Estimation syntax support - Marc Mongenet (EPFL) - 4 Jun 1998 */
  Int complexity_estimation_disable;	/* VOL */
  Int estimation_method;		/* VOL */
  Int shape_complexity_estimation_disable;	/* VOL */
  Int opaque;			/* VOL */
  Int dcecs_opaque;
  Int transparent;		/* VOL */
  Int dcecs_transparent;
  Int intra_cae;		/* VOL */
  Int dcecs_intra_cae;
  Int inter_cae;		/* VOL */
  Int dcecs_inter_cae;
  Int no_update;		/* VOL */
  Int dcecs_no_update;
  Int upsampling;		/* VOL */
  Int dcecs_upsampling;
  Int texture_complexity_estimation_set_1_disable;	/* VOL */
  Int intra_blocks;		/* VOL */
  Int dcecs_intra_blocks;
  Int inter_blocks;		/* VOL */
  Int dcecs_inter_blocks;
  Int inter4v_blocks;		/* VOL */
  Int dcecs_inter4v_blocks;
  Int not_coded_blocks;		/* VOL */
  Int dcecs_not_coded_blocks;
  Int texture_complexity_estimation_set_2_disable;	/* VOL */
  Int dct_coefs;		/* VOL */
  Int dcecs_dct_coefs;
  Int dct_lines;		/* VOL */
  Int dcecs_dct_lines;
  Int vlc_symbols;		/* VOL */
  Int dcecs_vlc_symbols;
  Int vlc_bits;			/* VOL */
  Int dcecs_vlc_bits;
  Int motion_compensation_complexity_disable;	/* VOL */
  Int apm;			/* VOL */
  Int dcecs_apm;
  Int npm;			/* VOL */
  Int dcecs_npm;
  Int interpolate_mc_q;		/* VOL */
  Int dcecs_interpolate_mc_q;
  Int forw_back_mc_q;		/* VOL */
  Int dcecs_forw_back_mc_q;
  Int halfpel2;			/* VOL */
  Int dcecs_halfpel2;
  Int halfpel4;			/* VOL */
  Int dcecs_halfpel4;

	/* START: Complexity Estimation syntax support - Update version 2 - Massimo Ravasi (EPFL    ) - 26 Oct 1999 */

  Int version_2_complexity_estimation_disable;
  Int sadct;
  Int dcecs_sadct;      /* VOL */
  Int quarterpel;
  Int dcecs_quarterpel; /* VOL */

  /* END: Complexity Estimation syntax support - Update Version 2 */
  /* END: Complexity Estimation syntax support */

  Int random_accessible_vol;

  
  /* Syntax elements copied from VOL (additional for scalability) */
  Int hierarchy_type;     /* VOL hierarchy type */ /* added for OBSS by Samsung AIT (1999-09-29) */
  Int ref_ident;		/* VOL id of reference VOL */
  Int ref_samp_dir;		/* VOL resol. of ref. VOL */
  Int hor_samp_n;		/* VOL hor. resampling of ref. VOL given by */
  Int hor_samp_m;		/*     sampfac = hor_samp_n/hor_samp_m      */
  Int ver_samp_n;		/* VOL ver. resampling of ref. VOL given by */
  Int ver_samp_m;		/*     sampfac = ver_samp_n/ver_samp_m      */
  Int enhancement_type;		/* VOL type of enhancement layer */
/* begin: added for OBSS by Samsung AIT (1999-09-29) */
  Int use_ref_shape;            /* VOL flag which indicates the usage of lower layer shape without encoding */
  Int use_ref_texture;          /* VOL flag which indicates the usage of lower layer texture without encoding */
  Int shape_hor_samp_n;         /* VOL hor. resampling of ref. VOL given by             */
  Int shape_hor_samp_m;         /*     sampfac = shape_hor_samp_n/shape_hor_samp_m      */
  Int shape_ver_samp_n;         /* VOL ver. resampling of ref. VOL given by             */
  Int shape_ver_samp_m;         /*     sampfac = shape_ver_samp_n/shape_ver_samp_m      */
/* end: added for OBSS by Samsung AIT (1999-09-29) */
  
  /* Additional entries for sprite coding (at least partly copiedfrom VOL) */
  Int sprite_hdim;              /* VOL horiz. size of sprite */
  Int sprite_vdim;              /* VOL vert.  size of sprite */
  Int sprite_left_edge;         /* VOL horiz. ref of sprite */
  Int sprite_top_edge;          /* VOL horiz. ref of sprite */
  Int	warping_accuracy;	/* accuracy of the warping (2,4,8,16)*/
  Int sprite_usage;		/* 0:no; 1:static; */
  Int no_of_sprite_points;	/* 0:stationary, 1:translation, 2:rotation,scaling, 3:affine, 4:perspective */
  TrajPoint *ref_point_coord; /* position of reference points in the sprite */
  TrajPoint *traj_point_coord; 	/* position of reference points after motion compensation */
  TrajPoint *difftraj_point_coord; 	/* (dui,dvj) trajectory coordinates, to be transmitted */
  Int brightness_change_in_sprite; /* */
  Float	brightness_change_factor;
  Int low_latency_sprite_enable; /* 0: basic sprite, 1:low latency sprite */
  struct vop *rec_sprite;	/* pointer to the current decoded sprite */
  Sprite_motion *warp_param;	/* global motion vectors */
  Int	sprite_transmit_mode;
  Int	*tab_transmit;		/* STORE ARRAYS FOR SPRITE PIECES */
  Int	*tab_amb_type;		/* FOR LOW LATENCY TRANSMISSION */
  Int	*tab_mvda;
  SInt	*tab_QP_store;
  Int	*tab_DQUANT_store;
  Int	***tab_DC_store;

  /* Old entries maintained for old source code compatibility */
  Int scaling;			/* VOP scaling factor  (for composition) */
  Int visibility;		/* VOP visibility      (for composition) */
  Int binary_shape;		/* Key for alpha plane (1-binary,0-blending) */
  Int comp_order;       	/* VOP order           (for composition) */

  /** NEWPRED (Oki) 16-AUG-1999 **/
  /* Additional entries for NEWPRED */
  Int newpred_enable; 		/* VOL NEWPRED mode */
  Int newpred_backward_message_type;	/* VOL requested message type for NEWPRED */
  Int newpred_segment_type;	/* VOL segment type for NEWPRED */
  Int np_vop_id;		/* VOP vop_id for NEWPRED */
  Int np_vop_id_pred[18];	/* VOP vop_id_for_prediction for NEWPRED */
  Int np_num_segments;		/* VOP number of NEWPRED segments per VOP */
  Int np_mba_segment[18];	/* VOP first MBA of each NEWPRED segment */
  /** end of NEWPRED (Oki) 16-AUG-1999 **/

/* >>> added for DRC by Fujitsu (top)    <<< */
   /* Additional entries for DRC */
  Int reduced_resolution;       /* flag for reduced resolution mode of DRC */
  Int dct_coef_mask;		/* mask for DCT coef restriction for DRC encoding */
  Int switching_flag;		/* flag for indicating resolution swiched VOP for DRC encoding */
  Float average_qp;		/* Average QP value used for DRC encoding */
  Int bits_used;		/* Number of bits used for DRC encoding */
/* >>> added for DRC by Fujitsu (bottom) <<< */

  /* Pointers to the images (YUVA) and to related VOPs */
  Image *a_chan;		/* The alpha plane */
  Image *g_chan[MAX_MAC];	/* The Grayscale alpha plane */ /* HYUNDAI (Grayscale) */ /* SB 11.11.99*/
  Image *a_uv_chan;              /* The alpha  plane for uv */
  Image *shape_mode;		/* Shape mode for arbitrary-shaped VOP */
/* begin: added for OBSS by Samsung AIT (1999-09-29) */
  Image *a_mot_x; /* The x component of shape MV for spatial scalability of arbitrary-shaped VOP */
  Image *a_mot_y; /* The y component of shape MV for spatial scalability of arbitrary-shaped VOP */
  Image *a_sample_pos;	/* Sampling position of alpha data */
/* end: added for OBSS by Samsung AIT (1999-09-29) */
  Image *y_chan;		/* Y component of the VOP texture */
  Image *u_chan;		/* U component of the VOP texture */
  Image *v_chan;		/* V component of the VOP texture */
  struct vop *pnext_spat;	/* List of VOPs within same time instance */
  struct vop *pnext_temp;	/* List of VOPs with same ID along time-axis */
  struct vop *pprev_temp;       /* added by Minhua Zhou on 24.07.97 */
/* 1197-3 SONY */
  struct vop *pbvop_temp;
/* 1197-3 */
  struct vop_extend *pextend;   /* VOP extension pointer (user definable) */

  Image *QP_chan;               /* Storage of QP values */
  Image *g_QP_chan[MAX_MAC];    /* Storage of QP values for Grayscale */ /* HYUNDAI (Grayscale) */ /* SB 11.11.99*/

  /* MAC (SB) 11-Nov-99 */
  Int aux_comp_count;
  

};
typedef struct vop Vop;


struct vol
{
  Int vo_id;                   	/* VO Id */
  Int ident;			/* VOL identifier (for tracking) */
  Int is_object_layer_identifier;
  Int visual_object_layer_verid;
  Int visual_object_layer_priority;
  Int visual_object_type_indication; /* 991111 U. Benzler (UoH) - added to be able to create conformance bitstreams */

  Int aspect_ratio_info;	/* 12.08.98 Sven Brandau: added by */
  Int par_heigth;
  Int par_width;
  Int interlaced;

  Int vol_control_parameters;

  Int chroma_format;		/* 04.06.99 Karsten Suehring (HHI) */
  Int low_delay;
  Int vbv_parameters;
  Int first_half_bit_rate;
  Int latter_half_bit_rate;
  Int first_half_vbv_buffer_size;
  Int latter_half_vbv_buffer_size;
  Int first_half_vbv_occupancy;
  Int latter_half_vbv_occupancy;

  Int arbitrary_shape;		/* VOL shape: 0-rect., 1-bin., 2-greyl. */ 
  Int time_increment_resolution;
  Int fixed_vop_rate;

  Int obmc_disable;              /* VOL disable OBMC */

  Int quant_type;		/* VOL quant. type (0-H.263, 1-MPEG) */
  Int load_intra_quant_mat;	/* VOL load intra qmat. flag */
  Int intra_quant_mat[64];	    /* VOL values for intra qmat. */
  Int load_nonintra_quant_mat;	    /* VOL load nonintra qmat. flag */
  Int nonintra_quant_mat[64];	    /* VOL values for nonintra qmat. */
  Int disable_gray_quant_update;    /* VOL gray alpha map quant. update flag */
  Int load_gray_intra_quant_mat[MAX_MAC];    /* VOL load gray intra qmat. flag */
  Int gray_intra_quant_mat[MAX_MAC][64];     /* VOL values for gray intra qmat. */
  Int load_gray_nonintra_quant_mat[MAX_MAC]; /* VOL load nonintra qmat. flag */
  Int gray_nonintra_quant_mat[MAX_MAC][64];  /* VOL values for gray nonintra qmat. */
  Int error_res_disable;	/* VOL disable error resilence mode */
  Int intra_acdc_pred_disable;	/* VOL disable INTRA DC prediction */
  Int scalability;		/* VOL scalability (flag) */
  Int sadct_disable;		/* VOL SADCT_disable */
  Int quarter_pel;              /* VOL quarter pel MC flag */	/* MW QPEL 07-JUL-1998 */
  Int shape_effects;		/* VOL shape effects */
  Int reverse_vlc;		/* VOL reversible VLCs */
  Int data_partitioning;        /* VOL data partitioning */
  Int not_8_bit;
  Int quant_precision;
  Int bits_per_pixel;

  /* START: Complexity Estimation syntax support - Marc Mongenet (EPFL) - 4 Jun 1998 */
  Int complexity_estimation_disable;
  Int estimation_method;
  Int shape_complexity_estimation_disable;
  Int opaque;
  Int transparent;
  Int intra_cae;
  Int inter_cae;
  Int no_update;
  Int upsampling;
  Int texture_complexity_estimation_set_1_disable;
  Int intra_blocks;
  Int inter_blocks;
  Int inter4v_blocks;
  Int not_coded_blocks;
  Int texture_complexity_estimation_set_2_disable;
  Int dct_coefs;
  Int dct_lines;
  Int vlc_symbols;
  Int vlc_bits;
  Int motion_compensation_complexity_disable;
  Int apm;
  Int npm;
  Int interpolate_mc_q;
  Int forw_back_mc_q;
  Int halfpel2;
  Int halfpel4;
	/* START: Complexity Estimation syntax support - Update version 2 - Massimo Ravasi (EPFL    ) - 26 Oct 1999 */

  Int version_2_complexity_estimation_disable;
  Int sadct;
  Int quarterpel;

  /* END: Complexity Estimation syntax support - Update Version 2 */
  /* END: Complexity Estimation syntax support */

  Int random_accessible_vol;
  Int shape;
  Int width;
  Int height;

  Int scal_type;                /* VOL scalability type (temporal=0, spatial=1, both=2)*/
  Int hierarchy_type;
  Int ref_ident;		/* VOL id of reference VOL */
  Int ref_samp_dir;		/* VOL resol. of ref. VOL */	
  Int hor_samp_n;		/* VOL hor. resampling of ref. VOL given by */
  Int hor_samp_m;		/*     sampfac = hor_samp_n/hor_samp_m      */
  Int ver_samp_n;		/* VOL ver. resampling of ref. VOL given by */
  Int ver_samp_m;		/*     sampfac = ver_samp_n/ver_samp_m      */
  Int enhancement_type;		/* VOL type of enhancement layer */
/* begin: added for OBSS by Samsung AIT (1999-09-29) */
  Int use_ref_shape;            /* VOL flag which indicates the usage of lower layer shape without encoding */
  Int use_ref_texture;          /* VOL flag which indicates the usage of lower layer texture without encoding */
  Int shape_hor_samp_n;         /* VOL hor. resampling of ref. VOL given by             */
  Int shape_hor_samp_m;         /*     sampfac = shape_hor_samp_n/shape_hor_samp_m      */
  Int shape_ver_samp_n;         /* VOL ver. resampling of ref. VOL given by             */
  Int shape_ver_samp_m;         /*     sampfac = shape_ver_samp_n/shape_ver_samp_m      */
/* end: added for OBSS by Samsung AIT (1999-09-29) */
 
  Int sprite_hdim;              /* horiz. size of sprite */
  Int sprite_vdim;              /* vert. size of sprite */
  Int sprite_left_edge;         /* VOL horiz. ref of sprite */
  Int sprite_top_edge;          /* VOL horiz. ref of sprite */
  Int init_piece_width;         /* VOL horiz. size of sprite piece*/
  Int init_piece_height;        /* VOL vert.  size of sprite piece*/
  Int init_piece_hor_ref;       /* VOL horiz. ref of sprite piece*/
  Int init_piece_ver_ref;       /* VOL horiz. ref of sprite piece*/
  Vop *psprite;			/* pointer to list of Sprites of this VOL */
  Int no_of_sprites;		/* number of sprites for the VOL */
  Int sprite_usage;		/* 0:no; 1:static */
  Int no_of_sprite_points;	/* 0:stationary, 1:translation, 2:rotation,scaling, 3:affine, 4:perspective, >4 local affine (not handled) */
  TrajPoint *ref_point_coord;/* position of reference points in the sprite */
  TrajPoint *traj_point_coord;/* position of reference points in the sprite */
  Int brightness_change_in_sprite;/* 	*/
  Int low_latency_sprite_enable; /* 0: basic sprite, 1:low latency sprite */
  Sprite_motion *prev_warp_param;/*previous set of global motion parameters */
  Int	warping_accuracy;	/* accuracy of the warping (2,4,8,16)*/
  Int	sprite_transmit_mode;
  Int	*tab_transmit;		/* STORE ARRAYS FOR SPRITE PIECES */
  Int	*tab_amb_type;		/* FOR LOW LATENCY TRANSMISSION */
  Int	*tab_mvda;
  SInt	*tab_QP_store;
  Int	*tab_DQUANT_store;
  Int	***tab_DC_store;

  /** NEWPRED (Oki) 16-AUG-1999 **/
  /* Additional entries for NEWPRED */
  Int newpred_enable; 		/* VOL NEWPRED mode */
  Int newpred_backward_message_type;	/* VOL requested message type for NEWPRED */
  Int newpred_segment_type;	/* VOL segment type for NEWPRED */
  /** end of NEWPRED (Oki) 16-AUG-1999 **/

/* >>> added for DRC by Fujitsu (top)    <<< */
   /* Additional entries for DRC */
  Int reduced_resolution_vop_enable;           /* VOL reduced_resolution_vop_enable */
/* >>> added for DRC by Fujitsu (bottom)    <<< */

  /* MAC (SB) 11-Nov-99 */
  Int aux_comp_count;
  Int shape_extension;

  Vop *pvop;			/* VOL pointer to list of VOPs of this VOL */
  struct vol *pnext;		/* VOL pointer to next VOL */
  struct vol_extend *pextend;	/* VOL extension pointer (user definable) */
};
typedef struct vol Vol;

struct video_object
{
	Int	id;		    /* VO Id */
	Vol	*layers;	    /* Pointer to linked list of Vols */
	struct video_object *pnext; /* Pointer to next VO */
};
typedef struct video_object VO;

/*****
*
*     Recommended structure for motion set
*
*****/
struct motion
  {
  Int ident;		/* Motion set identifier */
  Float *affine_pars;	/* List of possible affine parameters */
  Image *dvf_x[3];	/* x-comp. of displ. vector field(s) */
  Image *dvf_y[3];	/* y-comp. of displ. vector field(s) */
  Int under_x[3];	/* undersampling factor(s) x-dir. */
  Int under_y[3];	/* undersampling factor(s) y-dir. */
  Int resolution_x[3];	/* resolution(s) of x-component */
  Int resolution_y[3];	/* resolution(s) of y-component */
  };
typedef struct motion Motion;
 

#include "mom_image.h"
#include "mom_access.h"
#include "mom_vop.h"


#endif /* _MOM_STRUCTS_H_ */
