/* $Id: dataStruct.h,v 1.34 1998/08/07 16:11:50 hatrack Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*                                                                          */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

#ifndef DATA_STRUCT_H
#define DATA_STRUCT_H

#include <stdlib.h>
#include <stdio.h>
#include "typedef.h"

#ifndef QUANT_H
#include "quant.h"
#endif QUANT_H



#define DATA        Int /* modified by Sharp (99/2/16)*/

/* FPDAM begin : added by SAIT (99/09/03) */
#define OPAQUE_TILE     1
#define BOUNDA_TILE     2
#define TRANSP_TILE     3
/* FPDAM end : added by SAIT (99/09/03) */

#define MAXLEV      12
#define NCOLOR      3

#define SINGLE_Q    1
#define MULTIPLE_Q  2
#define BILEVEL_Q   3
#define MULTBUF_Q   0

/* zero tree symbols - if changed please change MapTypeToText variable */
#define IZ       0  /* Isolated Zero */
#define VAL      1  /* Value */
#define ZTR      2  /* Zero-Tree Root */
#define VZTR     3  /* Valued Zero-Tree Root */
#define ZTR_D    4  /* Parent has type of ZTR, VZTR, or ZTR_D (not coded) */
#define VLEAF    5  /* Leaf coefficient with non-zero value (not coded) */
#define ZLEAF    6  /* Leaf coefficient with zero value (not coded) */
#define UNTYPED  7  /* so far only for clearing of ZTR_Ds */

#define MAXDECOMPLEV 10
#define INF_RES      1024


#define MONO 1

#define FULLSIZE 0
#define PROGRESSIVE 0
#define MASK_VAL (0xff)

/* QValArithModel field types - if changed please change mapArithModelToText
   variable */
#define ACM_NONE  0 /* When there's no value to code */
#define ACM_ROOT  1
#define ACM_VALZ  2
#define ACM_VALNZ 3
#define ACM_RESID 4 /* should have one for each set of coeffs arising in 
		       different initial spatial layers */
#define ACM_DC    5

typedef struct 
{
  /* not updated */
  DATA           wvt_coeff;        /* Original value in encoding.*/
  DATA           rec_coeff;        /* Reconstructed value in decoding 
				      Put here for comparing with originals
				      at decoder. Reconstructed values can
				      be put in original when memory is an
				      issue and we don't want stats to be
				      computed at decoder. */

  /* updated by quantization */
  DATA           quantized_value; /* quantized value                    */
  quantState     qState;          /* state of quantizer for coefficient */

  /* updated by marking */
  UChar          state;          /* state of coefficient                   */
  UChar          type;           /* MZTE tree types: ZTR, IZ, VZTR, or VAL */
  UChar          skip;  /* Skip coding of coefficient value (not type)     */

  /* updated by Shipeng */
  UChar         mask;

} COEFFINFO;


typedef struct {
  Int   num_ZTR;
  Int   num_VZTR;
  Int   num_VAL;
} STATINFO;


typedef struct  {
  Int    height;
  Int    width;
  UChar  *mask;
  Void   *data; 
} PICTURE;

typedef struct {
   Short         quant;
   UChar        allzero;
   Int          root_max;   /* three maximum values for AC magnitude coding */
   Int          valz_max;
   Int          valnz_max;
   Int          residual_max;
   Int          wvtDecompNumBitPlanes[MAXDECOMPLEV];
   Int          wvtDecompResNumBitPlanes;
   Int          wvtDecompMax[MAXDECOMPLEV]; /* for _NEW_CONTEXT_ */
   STATINFO     stat;
} SNR_IMAGE;

typedef struct {
   SNR_IMAGE  snr_image; 
} SNR_LAYER;

typedef struct {
   Short         height;
   Short         width;
   Short         SNR_scalability_levels;
   COEFFINFO    **coeffinfo;
   SNR_LAYER    SNRlayer;
} SPATIAL_LAYER;


typedef struct snr_param {
   Int SNR_scalability_levels;
   Int *Quant;
} SNR_PARAM;


typedef struct wvt_codec 
{
  Int   bit_depth; /* number bits per pixel (spatial) */
  Int   colors;    /* number of color components: 0 = mono, 3=yuv */
  Int   color_format;  /* 4:4:4, 4:2:2, or 4:2:0 ???? */
  Int   sa_dwt;

/* SAIT_V2 begin: added by Samsung AIT (99/02/23) */
  Int            STO_const_alpha;
  UChar          STO_const_alpha_value;
/* SAIT_V2 end */

  PICTURE         *Image; /* spatial source */
  PICTURE         *SegImage; /* spatial source */
  
  Int             wvtType;      /* Type of filter */
  Int             wvtDecompLev; 

  Int             mean[NCOLOR]; /* mean of wvt coeffs in DC band ???? */
  Int             Qdc[NCOLOR];  
  Int             offset_dc;
  Int             max_dc; /* max quantized DC coeff - pre-shifting */
  Int             dcWidth, dcHeight;
  
  Int             width, height; 
  Int             spatial_scalability_levels;

  /* Added for spatial layer flexability - ph 07/16 */
  Int             lastWvtDecompInSpaLayer[MAXDECOMPLEV][NCOLOR];
  Int             spaLayerWidth[MAXDECOMPLEV][NCOLOR];
  Int             spaLayerHeight[MAXDECOMPLEV][NCOLOR];
  UChar           defaultSpatialScale;

  UChar   quantization_type;
  UChar   scan_direction;
  UChar   scan_order;
  UChar   SNR_start_code_enable;
  SPATIAL_LAYER   SPlayer[NCOLOR];
  
  SNR_PARAM       *Qinfo[NCOLOR];

/* SAIT_V2 begin: added by Samsung AIT (99/02/23) */
  Int             target_shape_levels;
  Int             full_size_out;
/* SAIT_V2 end */
  Int             target_spatial_levels;
  Int             target_snr_levels;
  Int             target_bitrate;
  Int             deringWindowSize;
  Int             deringThreshold;
  
  Int             origin_x;
  Int             origin_y;
  Int             real_width;
  Int             real_height;

/* FPDAM begin : added by SAIT */
  Int             object_origin_x;
  Int             object_origin_y;
  Int             object_width;
  Int             object_height;
/* FPDAM end : added by SAIT */

  /*-----------------------*/
  Int curSpatialLev;
  Int curSNRLev;
  Int curColor;

/* begin: added by Rockwell (99/3/3) */
  /* IM: VTC error res */
  Int error_res_flag;
  UShort  segment_thresh;
/* end: added by Rockwell (99/3/3) */
  
  Int             acm_order;         /* 0 - zoro order, 1 - mix order */
  Int             acm_max_freq_chg;  /* 0 - default, 1 - used defined */
  Int             *acm_maxf;         /* array of user defined maximum freqs */
/*begin: added by Sharp (99/2/16)*/
  Int display_width, display_height;
  Int tiling_disable;
	Int tiling_jump_table_enable;
  Int tile_width;
  Int tile_height;
  Int extension_type;
  Int target_tile_id_from;
  Int target_tile_id_to;
  Int iNumOfTile;
/*end: added by Sharp (99/2/16)*/
	Int visual_object_verid; /* added by Sharp (99/4/7) */
	Int texture_tile_type; /* FPDAM: added by SAIT */
} WVT_CODEC;


/*-----------   VTC parameter -------------------*/


typedef struct sol_parameters {
  Int            id;
  Int            bit_depth;
  Int            colors;
  Int            sa_dwt;
  PICTURE       *Image;
  PICTURE       *SegImage;
  Char          *ImagePath;
  Char          *SegPath;
  Int            wvtType; /* Int or Float */
  Int            wvtDecompLev; 
  Int            wvtDownload; /*Default or download */
  Int            wvtUniform;  /* All layers using the same filter or not */
  Int           *wvtFilters; /* Wavetfilter numbers: 0-9 */
  Int            QdcY;
  Int            QdcUV;
  Int            spatial_scalability_levels;
  Int            quantization_type;
  Int            scan_direction;
  Int            SNR_start_code_enable;
  SNR_PARAM     *SPlayer[NCOLOR];
  UChar         *buffer;
  Int            target_bitrate;
/* SAIT_V2 begin: added by Samsung AIT (99/02/23) */
  Int            target_shape_levels;
  Int            full_size_out;
/* SAIT_V2 end */
  Int            target_spatial_levels;
  Int            target_snr_levels;
  Int            deringWindowSize;
  Int            deringThreshold;
  /* for shape coding */
  Int            alphaTH;
  Int            change_CR_disable;
  Int            STO_const_alpha;
  UChar          STO_const_alpha_value;
/* SAIT_V2 begin: added by Samsung AIT (99/02/23) */
  Int            STO_shape_scalable;
/* SAIT_V2 end */
  Int            singleBitFile;
  Char          *bitFile;
  Char          *bitFileAC;

  Int             acm_order;         /* 0 - zoro order, 1 - mix order */
  Int             acm_max_freq_chg;  /* 0 - default, 1 - used defined */
  Int             *acm_maxf;         /* array of user defined maximum freqs */

/* begin: added by Rockwell (99/3/3) */
  Int error_res_flag;
  Int packet_size;
  UShort  segment_thresh;
/* end: added by Rockwell (99/3/3) */

  /* Added for spatial layer flexability - ph 07/16 */
  Int             lastWvtDecompInSpaLayer[MAXDECOMPLEV];
  Int             defaultSpatialScale;
/*begin: added by Sharp (99/2/16)*/
  Int display_width, display_height;
  Int tiling_disable;
	Int tiling_jump_table_enable;
  Int tile_width;
  Int tile_height;
  Int extension_type;
  Int target_tile_id_from;
  Int target_tile_id_to;
  Int iNumOfTile;
/*end: added by Sharp (99/2/16)*/

} SOL_PARAMETERS;



/*-----------   VTC parameter for decoder -------------------*/


typedef struct sol_parameters_dec {
  Int            bit_depth;
  Int            colors;
  Int            sa_dwt;
  PICTURE       *SegImage;
  Char          *SegPath;
  Int            width;
  Int            height;
  Int            wvtType;
  Int            wvtDecompLev;
  Int            wvtDownload; /*Default or download */
  Int            wvtUniform;  /* All layers using the same filter or not */
  Int            target_bitrate;
/* SAIT_V2 begin: added by Samsung AIT (99/02/23) */
  Int            target_shape_levels;
  Int            full_size_out;
/* SAIT_V2 end */
  Int            target_spatial_levels;
  Int            target_snr_levels;
  Int            deringWindowSize;
  Int            deringThreshold;
  Int            singleBitFile;
  Char          *bitFile;
  Char          *bitFileAC;

  Int             acm_order;         /* 0 - zoro order, 1 - mix order */
  Int             acm_max_freq_chg;  /* 0 - default, 1 - used defined */
  Int             *acm_maxf;         /* array of user defined maximum freqs */

/*begin: added by Sharp (99/2/16)*/
  Int display_width, display_height;
  Int tiling_disable;
	Int tiling_jump_table_enable;
  Int tile_width;
  Int tile_height;
  Int extension_type;
  Int target_tile_id_from;
  Int target_tile_id_to;
  Int iNumOfTile;
/*end: added by Sharp (99/2/16)*/

} SOL_PARAMETERS_DEC;

#endif DATA_STRUCT_H

