/* $Id: context.h,v 1.6 1998/05/14 21:41:21 hjlee Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*                                                                          */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

#ifndef CONTEXT_H
#define CONTEXT_H

#ifndef AC_HEADER
#include "ac.h"
#endif

typedef struct
{
  ac_model *contextModelList;
  UShort numContexts;
  UShort nsym;
  UShort curContext;
}
 ac_context;


/* function prototype declarations */
#ifdef _DECLARE_PROTOTYPES_

Void initContext_Type(ac_context *acc, Int nsym);
Void freeContext_Type(ac_context *acc);
Void updateContext_Type(ac_context *acc, Int sym);
ac_model *contextToModel_Type(ac_context *acc);

#ifdef _IMPLIED_SKIP_IZ_
Void initContext_SkipType(ac_context *acc, Int nsym);
Void freeContext_SkipType(ac_context *acc);
Void updateContext_SkipType(ac_context *acc, Int sym);
ac_model *contextToModel_SkipType(ac_context *acc);
#endif

Void initContext_Root(ac_context *acc, Int nsym);
Void freeContext_Root(ac_context *acc);
Void updateContext_Root(ac_context *acc, Int sym);
ac_model *contextToModel_Root(ac_context *acc);

Void initContext_VZ(ac_context *acc, Int nsym);
Void freeContext_VZ(ac_context *acc);
Void updateContext_VZ(ac_context *acc, Int sym);
ac_model *contextToModel_VZ(ac_context *acc);

Void initContext_VNZ(ac_context *acc, Int nsym);
Void freeContext_VNZ(ac_context *acc);
Void updateContext_VNZ(ac_context *acc, Int sym);
ac_model *contextToModel_VNZ(ac_context *acc);

Void initContext_Res(ac_context *acc, Int nsym);
Void freeContext_Res(ac_context *acc);
Void updateContext_Res(ac_context *acc, Int sym);
ac_model *contextToModel_Res(ac_context *acc);

Void initContext_Sign(ac_context *acc, Int nsym);
Void freeContext_Sign(ac_context *acc);
Void updateContext_Sign(ac_context *acc, Int sym);
ac_model *contextToModel_Sign(ac_context *acc);


#else _DECLARE_PROTOTYPES_

#include "context.p"

#endif _DECLARE_PROTOTYPES_

#endif CONTEXT_H
