/*****************************************************************************
 "This software module was originally developed by Noboru Yamaguchi (TOSHIBA
  CORPORATION), Takashi Ida (TOSHIBA CORPORATION) and edited by Toshiaki
  Watanabe (TOSHIBA CORPORATION), Yoshihiro Kikuchi (TOSHIBA CORPORATION), in
  the course of development of the <MPEG-4 Video(ISO/IEC 14496-2)>. This
  software module is an implementation of a part of one or more <MPEG-4 Video
  (ISO/IEC 14496-2)> tools as specified by the <MPEG-4 Video(ISO/IEC 14496-2)
  >. ISO/IEC gives users of the <MPEG-4 Video(ISO/IEC 14496-2)> free license
  to this software module or modifications thereof for use in hardware or
  software products claiming conformance to the <MPEG-4 Video(ISO/IEC 14496-2
  )>. Those intending to use this software module in hardware or software
  products are advised that its use may infringe existing patents. The
  original developer of this software module and his/her company, the
  subsequent editors and their companies, and ISO/IEC have no liability for
  use of this software module or modifications thereof in an implementation.
  Copyright is not released for non <MPEG-4 Video(ISO/IEC 14496-2)>
  conforming products. TOSHIBA CORPORATION retains full right to use the code
  for his/her own purpose, assign or donate the code to a third party and to
  inhibit third parties from using the code for non <MPEG-4 Video(ISO/IEC
  14496-2)> conforming products. This copyright notice must be included in
  all copies or derivative works. Copyright (c)1996".
 *****************************************************************************/

/***************** M4R codec ***************
       shape encoder/decoder modules
      ( definition of simulation mode )
      ( VLC table and some definition )

********************************************/

  /*
   * SHAPEmethod         1:IntraMMR           3:IntraMMR/InterMMR
   * SHAPEmmr    0:VM3   1:MMR2(newVLC)  2:MMR3(MMR2 + H/V scan)
                 3:MMR4(MMR3 + Context)
   * SHAPEhead   0:VM3   2:utilizing the inter-frame correlation
   * SHAPEmv     0:VM3   1:Shape-mv is used
   * SHAPEinter  0:Intra shape 1:Inter shape
   */

#ifndef _ALP_M4R_DEF_H_
#define _ALP_M4R_DEF_H_

static short int SHAPEmethod=3;
static short int SHAPEmmr=3;
static short int SHAPEhead=2;
static short int SHAPEmv=1;
static short int SHAPEinter=1;


/************  VM4 (intra)  ***************
 *
 * SHAPEmethod=1;
 * SHAPEmmr=0;
 * SHAPEhead=0;
 * SHAPEmv=0;
 * SHAPEinter=0;
 *
 ******************************************/

/************  VM5 (intra)  ***************
 *
 * SHAPEmethod=3;
 * SHAPEmmr=3;
 * SHAPEhead=2;
 * SHAPEmv=1;
 * SHAPEinter=0;
 *
 ******************************************/

/************  VM5 (inter)  ***************
 *
 * SHAPEmethod=3;
 * SHAPEmmr=3;
 * SHAPEhead=2;
 * SHAPEmv=1;
 * SHAPEinter=1;
 *
 ******************************************/

/* ------------------------------------------------------------------ */

/********* header ********/

#define CV0 0
#define CVL1 1
#define CVL2 2
#define CVL3 3
#define CVL4 4
#define CVL5 5
#define CVR1 (-1)
#define CVR2 (-2)
#define CVR3 (-3)
#define CVR4 (-4)
#define CVR5 (-5)

#define OFFSET '0'
#define MB_SIZE 16
#define MAX_STREAM 512
#define GET_NEG_PAT(a) ((a) == 0 ? 1 : 0)
#define NO  0
#define YES 1
#define FALSE  0
#define TRUE 1
#define f1bit(x)  ( ((x)==0) ? 0 :  1 )
#define f8bit(x)  ( ((x)==0) ? 0 :  255 )
#define BINARY(a) (((a) >= 128) ? 255 : 0)
#define ABS(x)    (((x) < 0) ? -(x) : (x))
/*
 * MMR VLC Table
 */
                    /* CR = 1 , 1/2 , 1/4 */
static char *EndOfMb[3] = { "0011", "001", "001" };
static char *H_mode[3] = { "0010", "0001", "0001" };
static char *V0[3] = { "1", "1", "1" };
static char *VR1[3] = { "011", "011", "011" };
static char *VR2[3] = { "00011", "000011", "000011" };
static char *VR3[2] = { "000011", "0000011" };
static char *VR4 = "0000011";
static char *VR5 = "00000011";
static char *VL1[3] = { "010", "010", "010" };
static char *VL2[3] = { "00010", "000010", "000010" };
static char *VL3[2] = {"000010", "0000010" };
static char *VL4 = "0000010";
static char *VL5 = "00000010";

static char *vmEndOfMb = "0001";
static char *vmH_mode = "001";
static char *vmV0 = "1";
static char *vmVR1 = "011";
static char *vmVR2 = "000011";
static char *vmVR3 = "0000011";
static char *vmVR4 = "00000011";
static char *vmVR5 = "000000011";
static char *vmVL1 = "010";
static char *vmVL2 = "000010";
static char *vmVL3 = "0000010";
static char *vmVL4 = "00000010";
static char *vmVL5 = "000000010";

/*
 * MMR VLC Table (Context)
 */
static char *conV0[8]     ={
"110",      "1",       "1",        "1",
"1",        "1",       "110",      "1"};

static char *conVL1[8]    ={
"10",       "01",      "01",       "01",
"00001",    "00001",   "00000001", "010"};

static char *conVL2[8]    ={
"111",      "0010",    "00011",    "0000010",
"00000001", "00000100","00000010", "00010"};

static char *conVL3[8]    ={
"0001",     "00011",   "0000010",  "00000010",
"00000010", "00000101","000000001","000010"};

static char *conVL4[8]    ={
"00001",    "0000001", "0000011",  "000000010",
"000000110","00000110","000000110","0000010"};

static char *conVL5[8]    ={
"000001",   "00000001","000000001","000000001",
"000000111","00000111","000000111","00000010"};

static char *conVR1[8]    ={
"00000001", "00001",   "00001",    "001",
"01",       "01",      "10",       "011"};

static char *conVR2[8]    ={
"00000010", "00000100","00000001", "0000011",
"00011",    "0010",    "111",      "00011"};

static char *conVR3[8]    ={
"000000001","00000101","00000010", "00000011",
"0000010",  "00011",   "0001",     "000011"};

static char *conVR4[8]    ={
"000000110","00000110","000000110","000000011",
"0000011",  "0000001", "00001",    "0000011"};

static char *conVR5[8]    ={
"000000111","00000111","000000111","0000000001",
"000000001","00000001","000001",   "00000011"};

static char *conH_mode[8] ={
"001",      "00010",   "00010",    "00001",
"00010",    "00010",   "001",      "0010"};

static char *conEndOfMb[8]={
"01",       "0011",    "001",      "0001",
"001",      "0011",    "01",       "0011"};

/* FLC(CR=1/4) */
static char *mh_2[] ={"00","01","10","11"};

/* FLC(CR=1/2) */
static char *mh_3[] ={"000","001","010","011","100","101","110","111"};

/* FLC(CR=1) */
static char *mh_4[] ={"0000","0001","0010","0011","0100","0101","0110","0111",
               "1000","1001","1010","1011","1100","1101","1110","1111"};

/* FLC */
static char *mh_5[] ={"00000","00001","00010","00011","00100","00101","00110","00111",
       "01000","01001","01010","01011","01100","01101","01110","01111",
       "10000","10001","10010","10011","10100","10101","10110","10111",
       "11000","11001","11010","11011","11100","11101","11110","11111"};

static char *Cmvds[] = {"1","01","001","0001","00001","000001","0000001",
		  "00000001","000000001"};


static char *CMB_TYPE0[4] = {"1","10","01","01"};
static char *CMB_TYPE1[4] = {"000","0","000","000"};
static char *CMB_TYPE2[4] = {"01","110","1","001"};
static char *CMB_TYPE3[4] = {"001","111","001","1"};

#endif /* _ALP_M4R_DEF_H_ */

int ULB_Val[32];
int RLB_Val[32];
int Vpass;
int Vth;
int VRth, VLth, cr_type;
int Bits;
int tmp_skip_len, tmp_skip_min;
int CONTEXT;
