/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   Scalable shape coding is provided by Samsung AIT                       */
/*     Dae-Sung Cho (dscho@sait.samsung.co.kr)                              */
/*     Se-Hoon Son (shson@sait.samsung.co.kr)                               */
/*									    */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*                                                                          */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/

#ifndef _ShapeCommon_H
#define _ShapeCommon_H


typedef struct BitStreamStructure          BSS;

struct BitStreamStructure {
    UChar *bs;
    UChar *ptr;
    U_Int  cnt;
    U_Int  res;
};

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "dwt.h"	

/* function prototype declarations */	
#ifdef _DECLARE_PROTOTYPES_	

/* shape/src/ShapeCommon.c */
Void  	UpSampling_Still (Int x,
			Int y,
			Int blkn,
			Int object_width,
			Int object_height,
			Int cr,
			Int blkx,
			UChar **buff,
			UChar **data,
			UChar **shape
	);
Void  	AdaptiveUpSampling_Still (UChar **BABdown,
			UChar **BABresult,
			Int sub_size
	);
Void  	DownSampling_Still (UChar **buff,
			UChar **data,
			Int b_size,
			Int s_size
	);
Void  	AddBorderToBAB (Int blkx,
			Int blky,
			Int blksize,
			Int object_width,
			Int object_height,
			Int cr_size,
			Int MAX_blkx,
			UChar **BABinput,
			UChar **BABresult,
			UChar **shape,
			Int flag
	);
Int	GetTransitionalBabContext(UChar *curr_bab_data,
			Int x2,
			Int y2,
			Int width2,
			Int pixel_type
	);
Int	GetExceptionalBabContext_HalfHigher(UChar *lower_bab_data,
			UChar *half_bab_data,
			Int x2,
			Int y2,
			Int width,
			Int width2,
			Int pixel_type
	);
Int	GetExceptionalBabContext(UChar *half_bab_data,
			UChar *curr_bab_data,
			Int x2,
			Int y2,
			Int width,
			Int width2,
			Int pixel_type
	);
Int	DecideScanOrder(UChar *bordered_lower_bab, 
			Int mbsize
	);
Void	AddBorderToLowerBAB(UChar *low_shape,
			UChar *lower_bab,
			UChar *bordered_lower_bab,
			Int width,
			Int height,
			Int blkx,
			Int blky,
			Int blksize,
			Int max_blkx
	);
Void	AddBorderToHalfHigherBAB(UChar *low_shape,
			UChar *half_shape,
			UChar *half_bab,
			UChar *bordered_half_bab,
			Int object_width,
			Int object_height,
			Int blkx,
			Int blky,
			Int mblksize,
			Int max_blkx
	);
Void	AddBorderToEnhBAB(UChar *low_shape,
			UChar *cur_shape,
			UChar *curr_bab,
			UChar *bordered_curr_bab,
			Int object_width,
			Int object_height,
			Int blkx,
			Int blky,
			Int mblksize,
			Int max_blkx
	);

#else _DECLARE_PROTOTYPES_

#include "ShapeCommon.p"

#endif _DECLARE_PROTOTYPES_

#ifdef __cplusplus
}
#endif /* __cplusplus  */ 
#endif /* _ShapeCommon_H  */ 
