/* $Id: QM.h,v 1.18 1998/06/28 13:59:17 hatrack Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by the following participants:     */
/*                                                                          */
/*   Single-quant,  multi-quant and flow control                            */
/*   are provided by  Sarnoff Corporation                                   */
/*     Iraj Sodagar   (iraj@sarnoff.com)                                    */
/*     Hung-Ju Lee    (hjlee@sarnoff.com)                                   */
/*     Paul Hatrack   (hatrack@sarnoff.com)                                 */
/*     Shipeng Li     (shipeng@sarnoff.com)                                 */
/*     Bing-Bing Chai (bchai@sarnoff.com)                                   */
/*     B.S. Srinivas  (bsrinivas@sarnoff.com)                               */
/*                                                                          */
/*   Bi-level is provided by Texas Instruments                              */
/*     Jie Liang      (liang@ti.com)                                        */
/*                                                                          */
/*   Shape Coding is provided by  OKI Electric Industry Co., Ltd.           */
/*     Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                 */
/*     Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                               */
/*     Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                        */
/*                                                                          */
/*   OKI, Sharp, Sarnoff, TI and Microsoft contributed to bitstream         */
/*   exchange and bug fixing.                                               */
/*                                                                          */
/*                                                                          */
/* In the course of development of the MPEG-4 standard, this software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG members to use, copy, modify,              */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright 1995, 1996, 1997, 1998 ISO/IEC                                 */
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/


#ifndef QM_H
#define QM_H


/* function prototype declarations */
#ifdef _DECLARE_PROTOTYPES_

Int ztqInitDC(Int decode, Int c);    /* in QMInit.c */
Int ztqInitAC(Int decode, Int c);    /* in QMInit.c */
Int ztqQListInit();                  /* in QMInit.c */
Void ztqQListExit();                 /* in QMInit.c */

Int encQuantizeDC(Int c);         /* in encQM.c */
Int encQuantizeAndMarkAC(Int c);  /* in encQM.c */
Int encUpdateStateAC(Int c);      /* in encQM.c */

Int decIQuantizeDC(Int c);   /* in decQM.c */
Int decIQuantizeAC(Int c);   /* in decQM.c */
Int decIQuantizeAC_spa(Int spa_lev, Int c);   /* in decQM.c */
Int decUpdateStateAC(Int c); /* in decQM.c */
Int decUpdateStateAC_spa(Int c); /* in decQM.c */
Int decMarkAC(Int c);        /* in decQM.c */

Void spatialLayerChangeUpdate(Int c);

#else _DECLARE_PROTOTYPES_

#include "QMInit.p"
#include "encQM.p"
#include "decQM.p"

#endif _DECLARE_PROTOTYPES_

#endif QM_H
