#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef unsigned char	UChar;

#define pxlcObjColor	255
#define opaqueValue	255
#define transpValue	0

void copyright_statement();

void print_usage (char *name);

void get_parameter (char *pfile,
                char *srcFile,
                char *dstFile,
                int *image_format,
                int *widthSrc,
                int *heightSrc,
		int *widthDst,
		int *heightDst,
		int *iVerticalSamplingFactorM,
		int *iVerticalSamplingFactorN,
		int *iHorizontalSamplingFactorM,
		int *iHorizontalSamplingFactorN,
                int *frame_no);

void up_down_sample_texture (UChar *ppxlcColumnHeadSrc,
					UChar *ppxlcDst,
					int iVerticalSamplingFactorM,
					int iVerticalSamplingFactorN,
					int iHorizontalSamplingFactorM,
					int iHorizontalSamplingFactorN,
					int widthSrc,
					int heightSrc,
					int widthDst,
					int heightDst);

void main(int argc, char* argv[])
{
   int t,frame_no=0;
   int image_format;
   int heightSrc=0,widthSrc=0,heightDst=0,widthDst=0;
   int cheightSrc=0,cwidthSrc=0,cheightDst=0,cwidthDst=0;
   int iVerticalSamplingFactorM=0, 
	iVerticalSamplingFactorN=0, 
	iHorizontalSamplingFactorM=0, 
	iHorizontalSamplingFactorN=0; 
   char  srcFile[80], fnameY1[80], fnameU1[80], fnameV1[80];
   char  dstFile[80], fnameY2[80], fnameU2[80], fnameV2[80];
   UChar *imgY1, *imgU1, *imgV1;
   UChar *imgY2, *imgU2, *imgV2;
   FILE  *fpY1, *fpU1, *fpV1, *fpYUV1;
   FILE  *fpY2, *fpU2, *fpV2, *fpYUV2;

   if(argc!=2) {
      print_usage(argv[0]);
      exit(1);
   }

   get_parameter (argv[1], 
		srcFile, 
		dstFile, 
		&image_format,
                &widthSrc,
                &heightSrc,
		&widthDst,
		&heightDst,
		&iVerticalSamplingFactorM,
		&iVerticalSamplingFactorN,
		&iHorizontalSamplingFactorM,
		&iHorizontalSamplingFactorN,
                &frame_no);
   
   /* Memory allocation */
   imgY1 = (UChar *) calloc(widthSrc*heightSrc, sizeof(UChar));
   imgY2 = (UChar *) calloc(widthDst*heightDst, sizeof(UChar));
   if (imgY1==NULL || imgY2==NULL) {
        fprintf(stderr,"Error: Memoray allocation failure !!!\n");
        exit(1);
   }
 
   if (image_format>0) {
     cwidthSrc = widthSrc/2;
     cheightSrc = heightSrc/2;
     cwidthDst = widthDst/2;
     cheightDst = heightDst/2;

     imgU1 = (UChar *) calloc(cwidthSrc*cheightSrc, sizeof(UChar));
     imgV1 = (UChar *) calloc(cwidthSrc*cheightSrc, sizeof(UChar));
     if(imgU1==NULL || imgV1==NULL) {
        fprintf(stderr,"Error: Memoray allocation failure !!!\n");
        exit(1);
     }
     imgU2 = (UChar *) calloc(cwidthDst*cheightDst, sizeof(UChar));
     imgV2 = (UChar *) calloc(cwidthDst*cheightDst, sizeof(UChar));
     if(imgU2==NULL || imgV2==NULL) {
        fprintf(stderr,"Error: Memoray allocation failure !!!\n");
        exit(1);
     }
   }     

   /* File open */
   if (image_format==0) {
     fprintf(stderr," Src Seq. : %s\n", srcFile);
     fprintf(stderr," Dst Seq. : %s\n\n", dstFile);
     fpY1 = fopen(srcFile, "r");
     fpY2 = fopen(dstFile, "w");
     if (fpY1==NULL || fpY2==NULL) {
        fprintf(stderr,"Error: input files (%s or %s) does not exist !!!\n", srcFile, dstFile);
        exit(1);
     }
   } else if (image_format==1) {
     fprintf(stderr," Src Seq. : %s\n", srcFile);
     fprintf(stderr," Dst Seq. : %s\n\n", dstFile);
     fpYUV1 = fopen(srcFile, "r");
     fpYUV2 = fopen(dstFile, "w");
     if(fpYUV1==NULL || fpYUV2==NULL) {
        fprintf(stderr,"Error: input files (%s or %s) don't exist !\n", srcFile, dstFile);
        exit(1);
     }
   } else if (image_format==2) {
     sprintf(fnameY1, "%s.y", srcFile);
     sprintf(fnameU1, "%s.u", srcFile);
     sprintf(fnameV1, "%s.v", srcFile);
     sprintf(fnameY2, "%s.y", dstFile);
     sprintf(fnameU2, "%s.u", dstFile);
     sprintf(fnameV2, "%s.v", dstFile);

     fprintf(stderr," Src Seq. : %s %s %s\n", fnameY1, fnameU1, fnameV1);
     fprintf(stderr," Dest Seq. : %s %s %s\n\n", fnameY2, fnameU2, fnameV2);
     fpY1 = fopen(fnameY1, "r");
     fpU1 = fopen(fnameU1, "r");
     fpV1 = fopen(fnameV1, "r");
     if(fpY1==NULL || fpU1==NULL || fpV1==NULL) {
        fprintf(stderr,"Error: input files (%s, %s, or %s) don't exist !\n",fnameY1,fnameU1,fnameV1);
        exit(1);
     }
     fpY2 = fopen(fnameY2, "w");
     fpU2 = fopen(fnameU2, "w");
     fpV2 = fopen(fnameV2, "w");
     if(fpY2==NULL || fpU2==NULL || fpV2==NULL) {
        fprintf(stderr,"Error: input files (%s, %s, or %s) don't exist !\n",fnameY2,fnameU2,fnameV2);
        exit(1);
     }
   }

   for(t=0;t<frame_no;t++) {
     fprintf(stderr,"Frame:%d\r",t);

     /* Image reading */
     if(image_format==0) {
        fread((char *)imgY1, widthSrc*heightSrc, sizeof(UChar), fpY1);
     } else if(image_format==1) {
        fread((char *)imgY1, widthSrc*heightSrc, sizeof(UChar), fpYUV1);
        fread((char *)imgU1, cwidthSrc*cheightSrc, sizeof(UChar), fpYUV1);
        fread((char *)imgV1, cwidthSrc*cheightSrc, sizeof(UChar), fpYUV1);
     } else if(image_format==2) {
        fread((char *)imgY1, widthSrc*heightSrc, sizeof(UChar), fpY1);
        fread((char *)imgU1, cwidthSrc*cheightSrc, sizeof(UChar), fpU1);
        fread((char *)imgV1, cwidthSrc*cheightSrc, sizeof(UChar), fpV1);
     }
		
     up_down_sample_texture (imgY1, imgY2,
			iVerticalSamplingFactorM, 
			iVerticalSamplingFactorN, 
			iHorizontalSamplingFactorM, 
			iHorizontalSamplingFactorN,
			widthSrc,
			heightSrc,
			widthDst,
			heightDst
			);
	
     if (image_format>0) {
	up_down_sample_texture (imgU1, imgU2, 
			iVerticalSamplingFactorM, 
			iVerticalSamplingFactorN, 
			iHorizontalSamplingFactorM,
			iHorizontalSamplingFactorN, 
			cwidthSrc,
			cheightSrc,
			cwidthDst,
			cheightDst
  			);
		
	up_down_sample_texture (imgV1, imgV2, 
			iVerticalSamplingFactorM, 
			iVerticalSamplingFactorN, 
			iHorizontalSamplingFactorM, 
			iHorizontalSamplingFactorN, 
			cwidthSrc,
			cheightSrc,
			cwidthDst,
			cheightDst
			);
     }
     if(image_format==0) {
        fwrite((char *)imgY2, widthDst*heightDst, sizeof(UChar), fpY2);
     } else if(image_format==1) {
        fwrite((char *)imgY2, widthDst*heightDst, sizeof(UChar), fpYUV2);
        fwrite((char *)imgU2, cwidthDst*cheightDst, sizeof(UChar), fpYUV2);
        fwrite((char *)imgV2, cwidthDst*cheightDst, sizeof(UChar), fpYUV2);
     } else if(image_format==2) {
        fwrite((char *)imgY2, widthDst*heightDst, sizeof(UChar), fpY2);
        fwrite((char *)imgU2, cwidthDst*cheightDst, sizeof(UChar), fpU2);
        fwrite((char *)imgV2, cwidthDst*cheightDst, sizeof(UChar), fpV2);
     }
		
   }

   /* Memory free */
   free(imgY1);
   free(imgY2);
   if (image_format>0) {
     free(imgU1);
     free(imgV1);
     free(imgU2);
     free(imgV2);
   }
 
   /* File close */
   if (image_format==0) {
     fclose(fpY1);
     fclose(fpY2);
   } else if (image_format==1) {
     fclose(fpYUV1);
     fclose(fpYUV2);
   } else if (image_format==2) {
     fclose(fpY1);
     fclose(fpU1);
     fclose(fpV1);
     fclose(fpY2);
     fclose(fpU2);
     fclose(fpV2);
   }

   fprintf(stderr,"Processed Up-Down Sampling !\n");
}

void copyright_statement()
{
   fprintf(stderr," Copyright 1999 Samsung Advanced Institute of Technology (SAIT).\n");
   fprintf(stderr," All Rights Reserved.\n");
   fprintf(stderr," Originally Developed by Dae-Sung Cho (dscho@sait.samsung.co.kr).\n");
   fprintf(stderr,"\n");
}
 
void print_usage (char *name)
{
   copyright_statement();
 
   fprintf(stderr," %s <parameter file>\n\n", name);
   fprintf(stderr,"<input sequence file>\n");
   fprintf(stderr,"<output sequence file>\n");
   fprintf(stderr,"<image format>\n");
   fprintf(stderr,"          0 for Monochrome \n");
   fprintf(stderr,"          1 for Yuv 4:2:0 (Merged file)\n");
   fprintf(stderr,"          2 for Yuv 4:2:0 (Separated file, only prefix name)\n");
   fprintf(stderr,"          3 to other for reserved format\n");
   fprintf(stderr,"<width of input image>\n");
   fprintf(stderr,"<height of input image>\n");
   fprintf(stderr,"<width of output image>\n");
   fprintf(stderr,"<height of output image>\n");
   fprintf(stderr,"<frame number>\n");
   fprintf(stderr,"<Hor. sampling factor n (numerator of hor. sampling ratio)>\n");
   fprintf(stderr,"<Hor. sampling factor m (denominator of hor. sampling ratio)>\n");
   fprintf(stderr,"<Ver. sampling factor n (numerator of ver. sampling ratio)>\n");
   fprintf(stderr,"<Ver. sampling factor m (denominator of ver. sampling ratio)>\n");
   
   fprintf(stderr,"\n");
   return;
}

void get_parameter (char *pfile,
                char *srcFile,
                char *dstFile,
                int *image_format,
                int *widthSrc,
                int *heightSrc,
		int *widthDst,
		int *heightDst,
		int *iVerticalSamplingFactorM,
		int *iVerticalSamplingFactorN,
		int *iHorizontalSamplingFactorM,
		int *iHorizontalSamplingFactorN,
                int *frame_no)
{
  
   char garbage[201];
   FILE *fp;
 
   fp = fopen(pfile,"r");
   if(fp==NULL) {
        fprintf(stderr,"Error: %s file does not exist !!!\n", pfile);
        exit(1);
   }
  
   fscanf(fp, "%s", srcFile);
   fgets(garbage,201,fp);
   fscanf(fp, "%s", dstFile);
   fgets(garbage,201,fp);
   fscanf(fp, "%d", image_format);
   fgets(garbage,201,fp);
   fscanf(fp, "%d", widthSrc);
   fgets(garbage,201,fp);
   fscanf(fp, "%d", heightSrc);
   fgets(garbage,201,fp);
   fscanf(fp, "%d", widthDst);
   fgets(garbage,201,fp);
   fscanf(fp, "%d", heightDst);
   fgets(garbage,201,fp);
   fscanf(fp,"%d", frame_no);
   fgets(garbage,201,fp);
   fscanf(fp,"%d", iHorizontalSamplingFactorN);
   fgets(garbage,201,fp);
   fscanf(fp,"%d", iHorizontalSamplingFactorM);
   fgets(garbage,201,fp);
   fscanf(fp,"%d", iVerticalSamplingFactorN);
   fgets(garbage,201,fp);
   fscanf(fp,"%d", iVerticalSamplingFactorM);
   fgets(garbage,201,fp);

   fprintf(stderr,"input sequence file : %s\n", srcFile);
   fprintf(stderr,"output sequence file : %s\n", dstFile);
   fprintf(stderr,"image format: %d\n", *image_format);
   fprintf(stderr,"input width : %d\n", *widthSrc);
   fprintf(stderr,"input height: %d\n", *heightSrc);
   fprintf(stderr,"output width: %d\n", *widthDst);
   fprintf(stderr,"output height: %d\n", *heightDst);
   fprintf(stderr,"frame number : %d\n", *frame_no);
   fprintf(stderr,"Hor. sampling factor n: %d\n", *iHorizontalSamplingFactorN);
   fprintf(stderr,"Hor. sampling factor m: %d\n", *iHorizontalSamplingFactorM);
   fprintf(stderr,"Ver. sampling factor n: %d\n", *iVerticalSamplingFactorN);
   fprintf(stderr,"Ver. sampling factor m: %d\n", *iVerticalSamplingFactorM);
  
   fprintf(stderr,"\n");
}

void up_down_sample_texture (UChar *ppxlcColumnHeadSrc,
			UChar *ppxlcDst,
			int iVerticalSamplingFactorM,
			int iVerticalSamplingFactorN,
			int iHorizontalSamplingFactorM,
			int iHorizontalSamplingFactorN,
			int widthSrc,
			int heightSrc,
			int widthDst,
			int heightDst
		   ) 
{
   int rctDst_top = 0;
   int rctDst_left = 0;
   int rctDst_right = widthDst;
   int rctDst_bottom = heightDst;
   int iWidthSrc = widthSrc;
   int iHeightSrc = heightSrc;
   int iWidthDst = widthDst;	
   int iHeightDst = heightDst;	

   int	x,y,y1,y2,x1,x2;
   int	phase = 0;
   int	*pict_vert;
   UChar *pict= ppxlcColumnHeadSrc;
	
   pict_vert = (int *) malloc (sizeof(int)*(iWidthSrc*(iHeightDst)));
	
   for(x=0;x< iWidthSrc; x++) {
      for(y=0;y< rctDst_bottom; y++) {
	y1 = (y*iVerticalSamplingFactorM )/iVerticalSamplingFactorN;
	if(y1 < iHeightSrc - 1)
	   y2 = y1+1;
	else
	   y2 = y1;
	phase = (16*((y*iVerticalSamplingFactorM) %
		iVerticalSamplingFactorN) + iVerticalSamplingFactorN/2)
		/iVerticalSamplingFactorN;
	*(pict_vert+y*(iWidthSrc)+x) 
	  = (int)(16-phase)*(*(pict+y1*iWidthSrc+x)) + phase *(*(pict+y2*iWidthSrc+x));
      }
   }
	
   for(y=0;y< rctDst_bottom; y++) {
      for(x=0;x< rctDst_right; x++) {
	x1 = (x*iHorizontalSamplingFactorM )/iHorizontalSamplingFactorN;
	if(x1 < iWidthSrc - 1)
	   x2 = x1+1;
	else
	   x2 = x1;
	phase = (16*((x*iHorizontalSamplingFactorM) %
		iHorizontalSamplingFactorN) + iHorizontalSamplingFactorN/2)
		/ iHorizontalSamplingFactorN;
	*(ppxlcDst+x+y*rctDst_right)
	  =(UChar)(((16-phase)*(*(pict_vert+y*iWidthSrc+x1)) + phase *(*(pict_vert+y*iWidthSrc+x2)) +128 )>>8 );
      }
	
   }
 	
   free(pict_vert);  
	
   return;
}

